/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.subsystems;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.internal.core.RSECoreMessages;

public abstract class ServerLauncher
extends RSEModelObject
implements IServerLauncherProperties,
ILabeledObject {
    protected String _name;
    private String _label = null;
    protected IConnectorService _connectorService;

    protected ServerLauncher(String name, IConnectorService service) {
        this._name = name;
        this._connectorService = service;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        if (this._label != null) {
            return this._label;
        }
        return this._name;
    }

    public void setLabel(String label) {
        this._label = label;
        this.setDirty(true);
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_SERVERLAUNCHER_DESCRIPTION;
    }

    public IConnectorService getConnectorService() {
        return this._connectorService;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return this._connectorService;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        List<IPropertySet> children = Arrays.asList(this.getPropertySets());
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }

    public IServerLauncherProperties cloneServerLauncher(IServerLauncherProperties newOne) {
        newOne.addPropertySets(this.getPropertySets());
        return newOne;
    }

    public void setVendorAttribute(String vendorName, String attributeName, String attributeValue) {
        IPropertySet set = this.getPropertySet(vendorName);
        if (set == null) {
            set = this.createPropertySet(vendorName, "");
        }
        set.addProperty(attributeName, attributeValue);
    }

    public String getVendorAttribute(String vendor, String attributeName) {
        IPropertySet set = this.getPropertySet(vendor);
        if (set != null) {
            return set.getPropertyValue(attributeName);
        }
        return null;
    }

    public boolean commit() {
        return this.getConnectorService().getHost().commit();
    }
}

