/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.persistence.PFMetadataLocation;
import org.eclipse.rse.internal.persistence.PFMetatdataJob;
import org.eclipse.rse.internal.persistence.PFPersistenceAnchor;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

class PFMetadataAnchor
implements PFPersistenceAnchor {
    PFMetadataAnchor() {
    }

    public IStatus deleteProfileLocation(String profileName, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        File profileFolder = this.getProfileFolder(profileName);
        if (profileFolder.exists()) {
            this.delete(profileFolder);
        }
        return result;
    }

    public PFPersistenceLocation getProfileLocation(String profileLocationName) {
        File profileFolder = this.getProfileFolder(profileLocationName);
        PFMetadataLocation result = new PFMetadataLocation(profileFolder);
        return result;
    }

    public String[] getProfileLocationNames() {
        Vector<String> names = new Vector<String>(10);
        File providerFolder = this.getProviderFolder();
        File[] profileCandidates = providerFolder.listFiles();
        int i = 0;
        while (i < profileCandidates.length) {
            String candidateName;
            File profileCandidate = profileCandidates[i];
            if (profileCandidate.isDirectory() && (candidateName = profileCandidate.getName()).startsWith("PRF")) {
                names.add(candidateName);
            }
            ++i;
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public Job makeSaveJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        return new PFMetatdataJob(dom, provider);
    }

    private File getProviderFolder() {
        IPath statePath = RSECorePlugin.getDefault().getStateLocation();
        File stateFolder = new File(statePath.toOSString());
        File providerFolder = this.getFolder(stateFolder, "profiles");
        return providerFolder;
    }

    private File getProfileFolder(String profileLocationName) {
        File providerFolder = this.getProviderFolder();
        File profileFolder = this.getFolder(providerFolder, profileLocationName);
        return profileFolder;
    }

    private File getFolder(File parent, String name) {
        File folder = new File(parent, name);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    private void delete(File resource) {
        if (resource.isDirectory()) {
            File[] resources = resource.listFiles();
            int i = 0;
            while (i < resources.length) {
                File child = resources[i];
                this.delete(child);
                ++i;
            }
        }
        resource.delete();
    }
}

