/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator plugin;
    private static Boolean fTracingOn;

    static {
        fTracingOn = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void logException(Throwable t) {
        ILog log = this.getLog();
        String id = this.getBundle().getSymbolicName();
        String message = NLS.bind((String)SshServiceResources.SshPlugin_Unexpected_Exception, (Object)t.getClass().getName(), (Object)t.getLocalizedMessage());
        Status status = new Status(4, id, 0, message, t);
        log.log((IStatus)status);
    }

    public static boolean isTracingOn() {
        if (fTracingOn == null) {
            String id = plugin.getBundle().getSymbolicName();
            String val = Platform.getDebugOption((String)(String.valueOf(id) + "/debug"));
            fTracingOn = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        return fTracingOn;
    }

    public static String getTimestamp() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    public static void trace(String msg) {
        if (Activator.isTracingOn()) {
            String fullMsg = String.valueOf(Activator.getTimestamp()) + " | " + Thread.currentThread().getName() + " | " + msg;
            System.out.println(fullMsg);
            System.out.flush();
        }
    }
}

