/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.local.model;

import java.io.File;
import org.eclipse.rse.internal.services.local.files.LocalHostFile;
import org.eclipse.rse.internal.services.local.files.LocalVirtualHostFile;
import org.eclipse.rse.internal.subsystems.files.local.model.LocalFile;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;

public class LocalVirtualFile
extends LocalFile
implements IVirtualRemoteFile {
    protected File _parentArchive;
    protected LocalVirtualHostFile _node;
    protected String _absolutePath = null;

    public LocalVirtualFile(FileServiceSubSystem ss, IRemoteFileContext context, LocalVirtualHostFile node) {
        super(ss, context, context.getParentRemoteFile(), (LocalHostFile)node);
        this._node = node;
        this._parentArchive = this._node.getChild().getContainingArchive();
    }

    public String getAbsolutePath() {
        return String.valueOf(this._parentArchive.getAbsolutePath()) + "#virtual#/" + this.getVirtualFullName();
    }

    public File getParentArchive() {
        return this._parentArchive;
    }

    public VirtualChild getVirtualChild() {
        return this._node.getChild();
    }

    public boolean isVirtual() {
        return true;
    }

    public String getVirtualFullName() {
        return this._node.getChild().fullName;
    }

    public String getVirtualFullPath() {
        return this._node.getChild().path;
    }

    public String getVirtualName() {
        return this._node.getChild().name;
    }

    public void setVirtualFullName(String string) {
        this._node.getChild().renameTo(string);
    }

    public void setVirtualFullPath(String string) {
        if (string.equals("")) {
            this._node.getChild().renameTo(this._node.getChild().name);
        } else {
            this._node.getChild().renameTo(String.valueOf(string) + "/" + this._node.getChild().name);
        }
    }

    public void setVirtualName(String string) {
        if (this._node.getChild().path.equals("")) {
            this._node.getChild().renameTo(string);
        } else {
            this._node.getChild().renameTo(String.valueOf(this._node.getChild().path) + "/" + string);
        }
    }

    public File getFileWrapper() {
        return this._node.getFile();
    }

    public boolean canRead() {
        return this._parentArchive.canRead();
    }

    public boolean canWrite() {
        return this._parentArchive.canWrite();
    }

    public String getComment() {
        return this._node.getChild().getComment();
    }

    public long getCompressedSize() {
        return this._node.getChild().getCompressedSize();
    }

    public String getCompressionMethod() {
        return this._node.getChild().getCompressionMethod();
    }

    public double getCompressionRatio() {
        return this._node.getChild().getCompressionRatio();
    }

    public Object getFile(String srcEncoding, boolean isText) {
        return this._node.getChild().getExtractedFile(srcEncoding, isText);
    }

    public String getContainingArchiveFullName() {
        return this._node.getChild().getContainingArchive().getAbsolutePath();
    }

    public long getExpandedSize() {
        return this._node.getSize();
    }

    public boolean isVirtualFile() {
        return !this._node.getChild().isDirectory;
    }

    public boolean isVirtualFolder() {
        return this._node.getChild().isDirectory;
    }
}

