/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.ui.view.SystemAbstractAPIProvider;
import org.eclipse.rse.ui.internal.model.SystemNewConnectionPromptObject;

public class SystemViewConnectionSelectionInputProvider
extends SystemAbstractAPIProvider {
    private boolean showNew = true;
    private SystemNewConnectionPromptObject newConnPrompt;
    private Object[] newConnPromptArray;
    private IRSESystemType[] systemTypes;

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNew = show;
    }

    public boolean getShowNewConnectionPrompt() {
        return this.showNew;
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public IRSESystemType[] getSystemTypes() {
        return this.systemTypes;
    }

    public Object[] getSystemViewRoots() {
        Object[] conns = null;
        conns = this.systemTypes == null ? RSECorePlugin.getTheSystemRegistry().getHosts() : RSECorePlugin.getTheSystemRegistry().getHostsBySystemTypes(this.systemTypes);
        if (this.showNew) {
            if (conns == null || conns.length == 0) {
                return this.getNewConnectionPromptObjectAsArray();
            }
            Object[] allChildren = new Object[conns.length + 1];
            allChildren[0] = this.getNewConnectionPromptObject();
            int idx = 0;
            while (idx < conns.length) {
                allChildren[idx + 1] = conns[idx];
                ++idx;
            }
            return allChildren;
        }
        return conns;
    }

    private SystemNewConnectionPromptObject getNewConnectionPromptObject() {
        if (this.newConnPrompt == null) {
            this.newConnPrompt = new SystemNewConnectionPromptObject();
        }
        if (this.systemTypes != null) {
            this.newConnPrompt.setSystemTypes(this.systemTypes);
        }
        return this.newConnPrompt;
    }

    private Object[] getNewConnectionPromptObjectAsArray() {
        if (this.newConnPromptArray == null) {
            this.newConnPromptArray = new Object[1];
        }
        this.newConnPromptArray[0] = this.getNewConnectionPromptObject();
        return this.newConnPromptArray;
    }

    public boolean hasSystemViewRoots() {
        return true;
    }

    public boolean showingConnections() {
        return true;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return false;
    }
}

