/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class Mnemonics {
    public static final int EMBED_MNEMONICS = 1;
    public static final int APPEND_MNEMONICS = 2;
    public static final String APPEND_MNEMONICS_PATTERN_PREFERENCE = "APPEND_MNEMONICS_PATTERN";
    public static final String APPEND_MNEMONICS_PATTERN_DEFAULT = "zh.*|ja.*|ko.*";
    public static final String POLICY_PREFERENCE = "MNEMONICS_POLICY";
    public static final int POLICY_DEFAULT = 3;
    private static final char MNEMONIC_CHAR = '&';
    private static final String LC_GREEK = "el";
    private static final String LC_RUSSIAN = "ru";
    private static final String GREEK_MNEMONICS = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static final String RUSSIAN_MNEMONICS = "\u0410\u0411\u0412\u0413\u0414\u0145\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
    private static final String LATIN_MNEMONICS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Pattern TRANSPARENT_ENDING_PATTERN = Pattern.compile("(\\s|\\.\\.\\.|>|<|:|\uff0e\uff0e\uff0e|\uff1e|\uff1c|\uff1a|\\t.*)+$");
    private boolean applyMnemonicsToPrecedingLabels = true;
    private Map usedCharacters = new HashMap();

    public static char getMnemonic(String text) {
        int idx = text.indexOf(38);
        if (idx >= 0 && idx < text.length() - 1) {
            return text.charAt(idx + 1);
        }
        return ' ';
    }

    public static String applyMnemonic(String label, char mnemonicChar) {
        int labelLen = label.length();
        if (labelLen == 0) {
            return label;
        }
        StringBuffer newLabel = new StringBuffer(label);
        int mcharPos = label.indexOf(mnemonicChar);
        if (mcharPos != -1) {
            newLabel.insert(mcharPos, '&');
        } else {
            String addedMnemonic = new String("(&" + mnemonicChar + ")");
            int p = Mnemonics.getEndingPosition(label);
            newLabel.insert(p, addedMnemonic);
        }
        return newLabel.toString();
    }

    public static String removeMnemonic(String text) {
        String[] parts = text.split("\\(\\&.\\)", 2);
        if (parts.length == 1) {
            parts = text.split("\\&", 2);
        }
        if (parts.length == 2) {
            text = String.valueOf(parts[0]) + parts[1];
        }
        return text;
    }

    private static int getEndingPosition(String label) {
        Matcher m = TRANSPARENT_ENDING_PATTERN.matcher(label);
        int result = m.find() ? m.start() : label.length();
        return result;
    }

    public void clear() {
        this.usedCharacters.clear();
    }

    public void clear(String usedMnemonics) {
        this.clear();
        this.makeUsed(usedMnemonics);
    }

    public String setUniqueMnemonic(String label) {
        RSEUIPlugin plugin = RSEUIPlugin.getDefault();
        Preferences preferences = plugin.getPluginPreferences();
        int flags = preferences.getInt(POLICY_PREFERENCE);
        String localePattern = preferences.getString(APPEND_MNEMONICS_PATTERN_PREFERENCE);
        String result = this.setUniqueMnemonic(label, flags, localePattern, false);
        return result;
    }

    private String setUniqueMnemonic(String label, int flags, String localePattern, boolean allowDuplicates) {
        String candidates;
        String localeName;
        int p;
        int p2;
        if (flags == 0 || label == null || label.trim().length() == 0 || label.equals("?")) {
            return label;
        }
        StringBuffer buffer = new StringBuffer(label);
        char mn = Mnemonics.getMnemonic(label);
        if (mn == ' ' && (flags & 1) > 0 && (p2 = this.findUniqueMnemonic(label)) >= 0) {
            mn = label.charAt(p2);
            buffer.insert(p2, '&');
        }
        if (mn == ' ' && allowDuplicates) {
            int n = Mnemonics.getEndingPosition(label);
            int m = 999;
            p = -1;
            int i = 0;
            while (i < n) {
                char ch = label.charAt(i);
                if (this.isAcceptable(ch) && this.timesUsed(ch) < m) {
                    m = this.timesUsed(ch);
                    p = i;
                }
                ++i;
            }
            if (p >= 0) {
                mn = label.charAt(p);
                buffer.insert(p, '&');
            }
        }
        if (mn == ' ' && (flags & 2) > 0 && (localeName = ULocale.getDefault().getName()).matches(localePattern) && (p = this.findUniqueMnemonic(candidates = this.getCandidates())) >= 0) {
            mn = candidates.charAt(p);
            String mnemonicString = "(&" + mn + ")";
            p = Mnemonics.getEndingPosition(label);
            buffer.insert(p, mnemonicString);
        }
        this.makeUsed(mn);
        return buffer.toString();
    }

    public boolean isUniqueMnemonic(char ch) {
        return this.timesUsed(ch) == 0;
    }

    private Preferences getPreferences() {
        return RSEUIPlugin.getDefault().getPluginPreferences();
    }

    private String getLocalePattern() {
        return this.getPreferences().getString(APPEND_MNEMONICS_PATTERN_PREFERENCE);
    }

    private int getPolicy() {
        return this.getPreferences().getInt(POLICY_PREFERENCE);
    }

    private boolean isEmbedding() {
        return (this.getPolicy() & 1) > 0;
    }

    private boolean isAppending() {
        return (this.getPolicy() & 2) > 0;
    }

    private String getCandidates() {
        String language = ULocale.getDefault().getLanguage();
        if (language.equals(LC_GREEK)) {
            return GREEK_MNEMONICS;
        }
        if (language.equals(LC_RUSSIAN)) {
            return RUSSIAN_MNEMONICS;
        }
        return LATIN_MNEMONICS;
    }

    private int findUniqueMnemonic(String label) {
        int uniqueIndex = -1;
        char ch = label.charAt(0);
        int i = 0;
        while (i < label.length() && uniqueIndex == -1) {
            ch = label.charAt(i);
            if (ch == '\t') break;
            if (this.timesUsed(ch) == 0 && this.isAcceptable(ch)) {
                uniqueIndex = i;
            }
            ++i;
        }
        return uniqueIndex;
    }

    private boolean isAcceptable(char ch) {
        UCharacter.UnicodeBlock block = UCharacter.UnicodeBlock.of((int)ch);
        boolean result = this.isAcceptable(block) && UCharacter.isLetter((int)ch);
        return result;
    }

    private boolean isAcceptable(UCharacter.UnicodeBlock block) {
        if (block == UCharacter.UnicodeBlock.BASIC_LATIN) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.LATIN_1_SUPPLEMENT) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.LATIN_EXTENDED_A) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.LATIN_EXTENDED_B) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.LATIN_EXTENDED_C) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.LATIN_EXTENDED_D) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.GREEK) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.CYRILLIC) {
            return true;
        }
        if (block == UCharacter.UnicodeBlock.HEBREW) {
            return true;
        }
        return block == UCharacter.UnicodeBlock.ARABIC;
    }

    private int timesUsed(char ch) {
        int result = 0;
        Integer count = (Integer)this.usedCharacters.get(new Character(ch));
        if (count != null) {
            result = count;
        }
        return result;
    }

    private void makeUsed(char ch) {
        if (ch != ' ') {
            this.makeUsed(new Character(Character.toLowerCase(ch)));
            this.makeUsed(new Character(Character.toUpperCase(ch)));
        }
    }

    private void makeUsed(Character ch) {
        Integer count = (Integer)this.usedCharacters.get(ch);
        if (count == null) {
            count = new Integer(1);
        }
        this.usedCharacters.put(ch, count);
    }

    private void makeUsed(String s) {
        int i = 0;
        while (i < s.length()) {
            this.makeUsed(s.charAt(i));
            ++i;
        }
    }

    private String getMnemonicsFromStrings(String[] strings) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            int idx = strings[i].indexOf(38);
            if (idx != -1) {
                result.append(strings[i].charAt(idx + 1));
            }
            ++i;
        }
        return result.toString();
    }

    public Mnemonics setApplyMnemonicsToPrecedingLabels(boolean apply) {
        this.applyMnemonicsToPrecedingLabels = apply;
        return this;
    }

    public boolean setMnemonic(Button button) {
        String newText;
        boolean changed = false;
        String text = button.getText();
        if (text != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
            button.setText(newText);
            changed = true;
        }
        return changed;
    }

    public void setMnemonics(Menu menu) {
        TreeSet<MenuItem> embeddingItems = new TreeSet<MenuItem>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                String t1 = ((MenuItem)o1).getText();
                String t2 = ((MenuItem)o2).getText();
                int l1 = Mnemonics.getEndingPosition(t1);
                if (l1 < (l2 = Mnemonics.getEndingPosition(t2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
        ArrayList<MenuItem> appendingItems = new ArrayList<MenuItem>(10);
        MenuItem[] menuItems = menu.getItems();
        int i = 0;
        while (i < menuItems.length) {
            String text;
            MenuItem menuItem = menuItems[i];
            Menu cascade = menuItem.getMenu();
            if (cascade != null) {
                Mnemonics context = new Mnemonics();
                context.setMnemonics(cascade);
            }
            if ((text = menuItem.getText()).length() > 0) {
                char ch = Mnemonics.getMnemonic(text);
                if (ch == ' ') {
                    embeddingItems.add(menuItem);
                    appendingItems.add(menuItem);
                } else {
                    this.makeUsed(ch);
                }
            }
            ++i;
        }
        String localePattern = this.getLocalePattern();
        if (this.isEmbedding()) {
            this.processMenuItems(embeddingItems, 1, localePattern);
        }
        if (this.isAppending()) {
            this.processMenuItems(appendingItems, 2, localePattern);
        }
    }

    private void processMenuItems(Collection collection, int flags, String localePattern) {
        Iterator z = collection.iterator();
        while (z.hasNext()) {
            String newText;
            MenuItem menuItem = (MenuItem)z.next();
            String text = menuItem.getText();
            if (text.equals(newText = this.setUniqueMnemonic(text, flags, localePattern, true))) continue;
            Image image = menuItem.getImage();
            menuItem.setText(newText);
            if (image == null) continue;
            menuItem.setImage(image);
        }
    }

    public void setMnemonics(Composite parent) {
        this.setMnemonics(parent, new HashSet());
    }

    public void setMnemonics(Composite parent, Set ignoredControls) {
        this.gatherCompositeMnemonics(parent);
        boolean mustLayout = this.setCompositeMnemonics(parent, ignoredControls);
        if (mustLayout) {
            parent.layout(true);
        }
    }

    private boolean setCompositeMnemonics(Composite parent, Set ignoredControls) {
        Control[] children = parent.getChildren();
        Control currentChild = null;
        boolean mustLayout = false;
        int i = 0;
        while (i < children.length) {
            Control previousChild = currentChild;
            currentChild = children[i];
            if (!ignoredControls.contains(currentChild)) {
                if (currentChild instanceof Combo || currentChild instanceof InheritableEntryField) {
                    String newText;
                    Label label;
                    String text;
                    if (this.applyMnemonicsToPrecedingLabels && previousChild instanceof Label && (text = (label = (Label)previousChild).getText()) != null && text.trim().length() > 0 && !text.equals(newText = this.setUniqueMnemonic(text))) {
                        label.setText(this.setUniqueMnemonic(text));
                        mustLayout = true;
                    }
                } else if (currentChild instanceof Button) {
                    mustLayout |= this.setMnemonic((Button)currentChild);
                } else if (currentChild instanceof Composite) {
                    mustLayout |= this.setCompositeMnemonics((Composite)currentChild, ignoredControls);
                }
            }
            ++i;
        }
        return mustLayout;
    }

    private void gatherCompositeMnemonics(Composite parent) {
        Control[] children = parent.getChildren();
        Control currentChild = null;
        int i = 0;
        while (i < children.length) {
            Control previousChild = currentChild;
            currentChild = children[i];
            String childText = null;
            if (currentChild instanceof Combo || currentChild instanceof InheritableEntryField || currentChild instanceof Text) {
                if (this.applyMnemonicsToPrecedingLabels && previousChild instanceof Label) {
                    Label label = (Label)previousChild;
                    childText = label.getText();
                }
            } else if (currentChild instanceof Button) {
                childText = ((Button)currentChild).getText();
            } else if (currentChild instanceof Composite) {
                this.gatherCompositeMnemonics((Composite)currentChild);
            }
            if (childText != null) {
                char ch = Mnemonics.getMnemonic(childText);
                this.makeUsed(ch);
            }
            ++i;
        }
    }

    public Mnemonics setOnPreferencePage(boolean page) {
        if (page) {
            String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
            String used = this.getMnemonicsFromStrings(labels).toUpperCase();
            this.makeUsed(used);
        }
        return this;
    }

    public Mnemonics setOnWizardPage(boolean page) {
        if (page) {
            String[] labels = new String[]{IDialogConstants.BACK_LABEL, IDialogConstants.NEXT_LABEL, IDialogConstants.FINISH_LABEL};
            String used = this.getMnemonicsFromStrings(labels).toUpperCase();
            this.makeUsed(used);
        }
        return this;
    }
}

