/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.filters.ISystemFilterStringEditPaneListener;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterString;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterStringPropertyPage
extends SystemBasePropertyPage
implements ISystemFilterStringEditPaneListener {
    protected Label labelType;
    protected Label labelFilter;
    protected Label labelFilterPool;
    protected Label labelProfile;
    protected SystemFilterStringEditPane editPane;
    protected ISystemValidator filterStringValidator;
    protected SystemMessage dupeFilterStringMessage;
    protected boolean editable = true;
    protected Composite composite_prompts;
    protected SystemMessage errorMessage;
    protected ResourceBundle rb;
    protected boolean initDone = false;
    static /* synthetic */ Class class$0;

    public void setFilterStringEditPane(SystemFilterStringEditPane editPane) {
        this.editPane = editPane;
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.editPane.setSystemFilterPoolReferenceManagerProvider(provider);
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider provider) {
        this.editPane.setSystemFilterPoolManagerProvider(provider);
    }

    public void setFilterStringValidator(ISystemValidator v) {
        this.filterStringValidator = v;
    }

    public void setDuplicateFilterStringErrorMessage(SystemMessage msg) {
        this.dupeFilterStringMessage = msg;
    }

    public void setEditable(boolean editable) {
        editable = false;
    }

    protected Control createContentArea(Composite parent) {
        this.composite_prompts = SystemWidgetHelpers.createComposite(parent, 2);
        this.labelType = this.createLabeledLabel(this.composite_prompts, SystemResources.RESID_PP_PROPERTIES_TYPE_LABEL, SystemResources.RESID_PP_PROPERTIES_TYPE_TOOLTIP);
        this.labelType.setText(SystemResources.RESID_PP_FILTERSTRING_TYPE_VALUE);
        this.labelFilter = this.createLabeledLabel(this.composite_prompts, SystemResources.RESID_PP_FILTERSTRING_FILTER_LABEL, SystemResources.RESID_PP_FILTERSTRING_FILTER_TOOLTIP);
        this.labelFilterPool = this.createLabeledLabel(this.composite_prompts, SystemResources.RESID_PP_FILTERSTRING_FILTERPOOL_LABEL, SystemResources.RESID_PP_FILTERSTRING_FILTERPOOL_TOOLTIP);
        this.labelProfile = this.createLabeledLabel(this.composite_prompts, SystemResources.RESID_PP_FILTERSTRING_PROFILE_LABEL, SystemResources.RESID_PP_FILTERSTRING_PROFILE_TOOLTIP);
        if (!this.initDone) {
            this.doInitializeFields();
        }
        return this.composite_prompts;
    }

    protected boolean verifyPageContents() {
        boolean ok = false;
        this.clearErrorMessage();
        this.errorMessage = this.editPane.verify();
        if (this.errorMessage == null) {
            ok = true;
            String editedFilterString = this.editPane.getFilterString();
            if (this.filterStringValidator != null) {
                this.errorMessage = this.filterStringValidator.validate(editedFilterString);
            }
        }
        if (this.errorMessage != null) {
            ok = false;
            this.setErrorMessage(this.errorMessage);
        }
        return ok;
    }

    protected ISystemFilterString getFilterString() {
        IAdaptable element = this.getElement();
        return (ISystemFilterString)element;
    }

    protected void doInitializeFields() {
        this.initDone = true;
        ISystemFilterString filterstring = this.getFilterString();
        ISystemFilter filter = filterstring.getParentSystemFilter();
        this.labelFilter.setText(filter.getName());
        ISystemFilterPool pool = filter.getParentFilterPool();
        this.labelFilterPool.setText(pool.getName());
        ISubSystemConfiguration ssFactory = (ISubSystemConfiguration)pool.getProvider();
        String profileName = ssFactory.getSystemProfile(pool).getName();
        this.labelProfile.setText(profileName);
        ISubSystemConfiguration factory = (ISubSystemConfiguration)filter.getProvider();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)factory.getAdapter((Class)clazz);
        adapter.customizeFilterStringPropertyPage(factory, this, filterstring, this.getShell());
        if (this.editPane == null) {
            Shell shell = this.getShell();
            this.editPane = new SystemFilterStringEditPane(shell);
        }
        this.editPane.setSystemFilterPoolManagerProvider(filter.getProvider());
        this.editPane.setChangeFilterMode(true);
        this.editPane.addChangeListener(this);
        Control editPaneComposite = this.editPane.createContents(this.composite_prompts);
        ((GridData)editPaneComposite.getLayoutData()).horizontalSpan = 2;
        this.editPane.setFilterString(filterstring.getString(), 0);
        if (!this.editable || filter.isNonChangable()) {
            editPaneComposite.setEnabled(false);
        } else if (this.filterStringValidator == null) {
            Vector existingStrings = filter.getFilterStringsVector();
            existingStrings.remove(filterstring);
            this.filterStringValidator = new ValidatorFilterString(existingStrings, filter.isStringsCaseSensitive());
            if (this.dupeFilterStringMessage != null) {
                ((ValidatorFilterString)this.filterStringValidator).setDuplicateFilterStringErrorMessage(this.dupeFilterStringMessage);
            }
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (!ok) {
            return false;
        }
        ISystemFilterString filterstring = this.getFilterString();
        ISystemFilter filter = filterstring.getParentSystemFilter();
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISystemFilterPoolManager mgr = pool.getSystemFilterPoolManager();
        try {
            mgr.updateSystemFilterString(filterstring, this.editPane.getFilterString());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError("Error updating filter string from property page", e);
            e.printStackTrace();
            SystemMessageDialog.displayMessage(this.getShell(), e);
            ok = false;
        }
        catch (Exception e) {
            SystemBasePlugin.logError("Error updating filter string from property page", e);
            e.printStackTrace();
            SystemMessageDialog.displayExceptionMessage(this.getShell(), e);
            ok = false;
        }
        return ok;
    }

    public void filterStringChanged(SystemMessage message) {
        if (message == null) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessage(message);
        }
    }

    public void backupChangedState() {
    }

    public void restoreChangedState() {
    }
}

