/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import java.util.ArrayList;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.ui.widgets.services.PropertyElement;
import org.eclipse.rse.ui.widgets.services.PropertySetServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public abstract class RSEModelServiceElement
extends ServiceElement {
    protected IRSEModelObject _modelObject;
    protected IPropertySet[] _propertySets;
    protected PropertySetServiceElement[] _propertySetElements;
    protected ServiceElement[] _allChildren;

    public RSEModelServiceElement(IHost host, ServiceElement parent, IRSEModelObject modelObject) {
        super(host, parent);
        this._modelObject = modelObject;
        this._propertySets = this._modelObject.getPropertySets();
    }

    public boolean hasPropertySets() {
        return this._propertySets != null && this._propertySets.length > 0;
    }

    public PropertySetServiceElement[] getPropertySets() {
        if (this._propertySetElements == null) {
            this._propertySetElements = new PropertySetServiceElement[this._propertySets.length];
            int i = 0;
            while (i < this._propertySets.length) {
                this._propertySetElements[i] = new PropertySetServiceElement(this.getHost(), this, this._propertySets[i]);
                ++i;
            }
        }
        return this._propertySetElements;
    }

    public String getName() {
        return this._modelObject.getName();
    }

    public String getDescription() {
        return this._modelObject.getDescription();
    }

    public final boolean hasChildren() {
        return this.internalHasChildren() || this.hasPropertySets();
    }

    public final ServiceElement[] getChildren() {
        if (this._allChildren == null) {
            ArrayList<ServiceElement> all = new ArrayList<ServiceElement>();
            if (this.internalHasChildren()) {
                ServiceElement[] children = this.internalGetChildren();
                int i = 0;
                while (i < children.length) {
                    all.add(children[i]);
                    ++i;
                }
            }
            if (this.hasPropertySets()) {
                PropertySetServiceElement[] properties = this.getPropertySets();
                int p = 0;
                while (p < properties.length) {
                    all.add(properties[p]);
                    ++p;
                }
            }
            this._allChildren = all.toArray(new ServiceElement[all.size()]);
        }
        return this._allChildren;
    }

    public boolean hasProperties() {
        return false;
    }

    public PropertyElement[] getProperties() {
        return null;
    }

    public void commit() {
        PropertySetServiceElement[] sets = this.getPropertySets();
        int i = 0;
        while (i < sets.length) {
            sets[i].commit();
            ++i;
        }
    }

    public void revert() {
        PropertySetServiceElement[] sets = this.getPropertySets();
        int i = 0;
        while (i < sets.length) {
            IPropertySet newSet = sets[i].getPropertySet();
            IPropertySet originalSet = sets[i].getOriginalProperySet();
            this._modelObject.removePropertySet(newSet.getName());
            this._modelObject.addPropertySet(originalSet);
            ++i;
        }
    }

    public void refreshProperties() {
        PropertySetServiceElement[] propertySets = this.getPropertySets();
        int i = 0;
        while (i < propertySets.length) {
            propertySets[i].refreshProperties();
            ++i;
        }
    }

    protected abstract ServiceElement[] internalGetChildren();

    protected abstract boolean internalHasChildren();
}

