/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.DummyHost;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.IServiceSubSystem;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemPropertiesWizardPage;
import org.eclipse.rse.ui.widgets.services.ConnectorServiceElement;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.PropertySetServiceElement;
import org.eclipse.rse.ui.widgets.services.RootServiceElement;
import org.eclipse.rse.ui.widgets.services.ServerLauncherPropertiesServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServicesForm;
import org.eclipse.rse.ui.wizards.AbstractSystemNewConnectionWizardPage;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizardMainPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SubSystemServiceWizardPage
extends AbstractSystemNewConnectionWizardPage
implements ISubSystemPropertiesWizardPage {
    private ServicesForm _form;
    private IServiceSubSystemConfiguration _selectedConfiguration;
    private ServiceElement _root;
    private ServiceElement[] _serviceElements;

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory, String pageName, String pageTitle, String pageDescription) {
        super(wizard, parentFactory, pageName, pageTitle, pageDescription);
    }

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory, String pageDescription) {
        super(wizard, parentFactory, pageDescription);
    }

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory) {
        super(wizard, parentFactory);
    }

    public Control createContents(Composite parent) {
        this._form = new ServicesForm(parent.getShell(), this.getMessageLine());
        Control control = this._form.createContents(parent);
        ServiceElement[] elements = this.getServiceElements();
        this._root = new RootServiceElement(elements);
        this._form.init(this._root);
        return control;
    }

    protected ServiceElement[] getServiceElements() {
        if (this._serviceElements == null) {
            RSEDefaultNewConnectionWizard wizard;
            IServiceSubSystemConfiguration currentFactory = (IServiceSubSystemConfiguration)this.getSubSystemConfiguration();
            IRSESystemType systemType = this.getMainPage() != null && this.getMainPage().getWizard() instanceof RSEDefaultNewConnectionWizard ? ((RSEDefaultNewConnectionWizard)this.getMainPage().getWizard()).getSystemType() : null;
            IServiceSubSystemConfiguration[] factories = this.getServiceSubSystemConfigurations(systemType, currentFactory.getServiceType());
            DummyHost dummyHost = null;
            if (this.getWizard() instanceof RSEDefaultNewConnectionWizard && (wizard = (RSEDefaultNewConnectionWizard)this.getWizard()).getStartingPage() instanceof RSEDefaultNewConnectionWizardMainPage) {
                dummyHost = new DummyHost(((RSEDefaultNewConnectionWizardMainPage)wizard.getStartingPage()).getSystemConnectionForm().getHostName(), wizard.getSystemType());
            }
            this._serviceElements = new ServiceElement[factories.length];
            int i = 0;
            while (i < factories.length) {
                IServiceSubSystemConfiguration factory = factories[i];
                this._serviceElements[i] = new FactoryServiceElement((IHost)dummyHost, factory);
                if (factory == currentFactory) {
                    this._serviceElements[i].setSelected(true);
                }
                ++i;
            }
        }
        return this._serviceElements;
    }

    protected IServiceSubSystemConfiguration[] getServiceSubSystemConfigurations(IRSESystemType systemType, Class serviceType) {
        ArrayList<IServiceSubSystemConfiguration> results = new ArrayList<IServiceSubSystemConfiguration>();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] configs = sr.getSubSystemConfigurationsBySystemType(systemType, false);
        int i = 0;
        while (i < configs.length) {
            IServiceSubSystemConfiguration sconfig;
            ISubSystemConfiguration config = configs[i];
            if (config instanceof IServiceSubSystemConfiguration && (sconfig = (IServiceSubSystemConfiguration)config).getServiceType() == serviceType) {
                results.add(sconfig);
            }
            ++i;
        }
        return results.toArray(new IServiceSubSystemConfiguration[results.size()]);
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean performFinish() {
        if (this._root != null) {
            this._root.commit();
            this._selectedConfiguration = ((FactoryServiceElement)this._form.getSelectedService()).getFactory();
        }
        return true;
    }

    protected ServerLauncherPropertiesServiceElement[] getPropertiesServiceElement() {
        ArrayList<ServerLauncherPropertiesServiceElement> results = new ArrayList<ServerLauncherPropertiesServiceElement>();
        int i = 0;
        while (i < this._serviceElements.length) {
            ServiceElement[] children;
            ServiceElement el = this._serviceElements[i];
            if (el.isSelected() && (children = el.getChildren()) != null) {
                int c = 0;
                while (c < children.length) {
                    ServiceElement[] cch;
                    ServiceElement child = children[c];
                    if (child instanceof ConnectorServiceElement && (cch = child.getChildren()) != null && cch.length > 0 && cch[0] instanceof ServerLauncherPropertiesServiceElement) {
                        ServerLauncherPropertiesServiceElement result = (ServerLauncherPropertiesServiceElement)cch[0];
                        results.add(result);
                    }
                    ++c;
                }
            }
            ++i;
        }
        return results.toArray(new ServerLauncherPropertiesServiceElement[results.size()]);
    }

    public boolean applyValues(ISubSystem ss) {
        IServiceSubSystemConfiguration currentConfiguration;
        if (this._selectedConfiguration != null && (currentConfiguration = (IServiceSubSystemConfiguration)ss.getSubSystemConfiguration()) != null) {
            if (this._selectedConfiguration != currentConfiguration) {
                ((IServiceSubSystem)ss).switchServiceFactory(this._selectedConfiguration);
            }
            if (this._root != null) {
                ServerLauncherPropertiesServiceElement element;
                IConnectorService connectorService = ss.getConnectorService();
                ServerLauncherPropertiesServiceElement[] elements = this.getPropertiesServiceElement();
                if (elements.length > 0 && (element = elements[0]).userModified()) {
                    IServerLauncherProperties properties = element.getServerLauncherProperties();
                    properties.saveToProperties();
                    connectorService.setRemoteServerLauncherProperties(properties);
                }
                List connectorServiceElements = this.getConnectorServiceElements(this._root);
                Iterator z = connectorServiceElements.iterator();
                while (z.hasNext()) {
                    ConnectorServiceElement element2 = (ConnectorServiceElement)z.next();
                    PropertySetServiceElement[] psElements = element2.getPropertySets();
                    int i = 0;
                    while (i < psElements.length) {
                        PropertySetServiceElement psElement = psElements[i];
                        IPropertySet set = psElement.getPropertySet();
                        connectorService.addPropertySet(set);
                        ++i;
                    }
                }
            }
        }
        return true;
    }

    private List getConnectorServiceElements(ServiceElement root) {
        ArrayList<ServiceElement> result = new ArrayList<ServiceElement>(10);
        if (root.isSelected()) {
            ServiceElement[] children;
            if (root instanceof ConnectorServiceElement) {
                result.add(root);
            }
            if ((children = root.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    ServiceElement child = children[i];
                    result.addAll(this.getConnectorServiceElements(child));
                    ++i;
                }
            }
        }
        return result;
    }

    protected IConnectorService getCustomConnectorService(IServiceSubSystemConfiguration config) {
        ServiceElement[] children = this._root.getChildren();
        int i = 0;
        while (i < children.length) {
            FactoryServiceElement fchild;
            ServiceElement child = children[i];
            if (child instanceof FactoryServiceElement && (fchild = (FactoryServiceElement)child).getFactory() == config) {
                return fchild.getConnectorService();
            }
            ++i;
        }
        return null;
    }

    public void handleVerifyComplete() {
        boolean complete = this.isPageComplete();
        this.clearErrorMessage();
        this.setPageComplete(complete);
    }
}

