/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.processes.ui.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.processes.ui.SystemProcessesResources;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class RemoteProcessesDialog
extends SystemPromptDialog
implements KeyListener {
    private Text _nameFilterText;
    private SystemTableView _viewer;
    private IRemoteProcessSubSystem _subSystem;
    private String _executableFilter;
    private Table _table;
    private IHostProcess _selected;

    public RemoteProcessesDialog(Shell shell, String title, IRemoteProcessSubSystem subSystem, String executableFilter) {
        super(shell, title);
        this._subSystem = subSystem;
        this._executableFilter = executableFilter;
    }

    protected Control createInner(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this._nameFilterText = SystemWidgetHelpers.createLabeledTextField((Composite)parent, (Listener)this, (String)SystemProcessesResources.RESID_REMOTE_PROCESSES_EXECUTABLE_LABEL, (String)SystemProcessesResources.RESID_REMOTE_PROCESSES_EXECUTABLE_TOOLTIP);
        this._nameFilterText.addKeyListener((KeyListener)this);
        this._table = new Table(parent, 101122);
        this._viewer = new SystemTableView(this._table, (ISystemMessageLine)this);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        SystemWidgetHelpers.setHelp((Control)this._viewer.getControl(), (String)"org.eclipse.rse.ui.ucmd0000");
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(false);
        this._table.setLinesVisible(false);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 400;
        this._table.setLayoutData((Object)gridData);
        this.init();
        return this._table;
    }

    protected Control getInitialFocusControl() {
        return this._viewer.getControl();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        this.processOK();
        this.close();
    }

    protected boolean processOK() {
        StructuredSelection sel = (StructuredSelection)this._viewer.getSelection();
        IRemoteProcess proc = (IRemoteProcess)sel.getFirstElement();
        if (proc != null) {
            this._selected = proc;
        }
        return true;
    }

    public IHostProcess getSelected() {
        return this._selected;
    }

    protected void init() {
        this._nameFilterText.setText(this._executableFilter);
        Object[] filters = this._subSystem.getChildren();
        ISystemFilterReference ref = (ISystemFilterReference)filters[0];
        ref.markStale(true);
        this.updateViewFilter();
        this._viewer.setInput((Object)ref);
    }

    protected void updateViewFilter() {
        if (this._executableFilter.indexOf("*") == -1) {
            this._executableFilter = String.valueOf(this._executableFilter) + "*";
        }
        String[] viewFilters = new String[]{this._executableFilter};
        this._viewer.setViewFilters(viewFilters);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget == this._nameFilterText && !this._nameFilterText.getText().equals(this._executableFilter)) {
            this._executableFilter = this._nameFilterText.getText();
            this.updateViewFilter();
        }
    }
}

