/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;

public class FileClassifier
extends Thread {
    public static final String symbolicLinkStr = "symbolic link to";
    public static final String fileSep = System.getProperty("file.separator");
    public static final String defaultType = "file";
    public static final String STR_SYMBOLIC_LINK = "symbolic link";
    public static final String STR_SHARED_OBJECT = "shared object";
    public static final String STR_OBJECT_MODULE = "object module";
    public static final String STR_MODULE = "module";
    public static final String STR_ARCHIVE = "archive";
    public static final String STR_EXECUTABLE = "executable";
    public static final String STR_SCRIPT = "script";
    public static final String STR_EXECUTABLE_SCRIPT = "executable(script)";
    public static final String STR_EXECUTABLE_BINARY = "executable(binary)";
    public static final String STR_DOT_A = ".a";
    public static final String STR_DOT_SO = ".so";
    public static final String STR_DOT_SO_DOT = ".so.";
    public static final String STR_DIRECTORY = "diectory";
    private DataElement _subject;
    private DataStore _dataStore;
    private String _specialEncoding = null;
    protected String _systemShell = null;
    private List _fileMap;
    private boolean _classifyChildren = true;
    private boolean _classifyFilter = false;
    private boolean _canResolveLinks = false;
    private boolean _classifyVirtual = false;
    private boolean _systemSupportsClassify = true;
    private boolean _systemSupportsClassFilesOnly = false;
    private List _lines = new ArrayList();

    public FileClassifier(DataElement subject) {
        this._specialEncoding = System.getProperty("dstore.stdin.encoding");
        this._subject = subject;
        this._dataStore = subject.getDataStore();
        this._fileMap = new ArrayList();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            this._systemSupportsClassify = false;
        } else if (osName.equals("z/os")) {
            this._systemSupportsClassFilesOnly = true;
        }
        this._systemShell = "sh";
        this._canResolveLinks = osName.startsWith("linux");
    }

    private void init() {
        String objType = this._subject.getType();
        this._classifyVirtual = objType.equals("universal.ArchiveFileObject") || objType.equals("universal.VirtualFolderObject") || objType.equals("universal.VirtualFileObject");
        this._classifyFilter = objType.equals("universal.FilterObject");
        if (objType.equals("universal.FileObject") || objType.equals("universal.VirtualFileObject")) {
            this._classifyChildren = false;
        } else {
            int i = 0;
            while (i < this._subject.getNestedSize()) {
                DataElement child = this._subject.get(i);
                if (child != null && !child.isDeleted() && (child.getType().equals("universal.FileObject") || child.getType().equals("universal.VirtualFileObject") || child.getType().equals("universal.FolderObject"))) {
                    String name = child.getName();
                    String properties = child.getSource();
                    String[] tokens = properties.split("\\|");
                    if (tokens.length < 12) {
                        this.putElement(name, child);
                    }
                }
                ++i;
            }
            this._classifyChildren = true;
        }
    }

    private void putElement(String name, DataElement child) {
        this._fileMap.add(new Pair(name, child));
    }

    private List getElementsFor(String fileName) {
        boolean matchedCanonical = false;
        ArrayList<Pair> results = new ArrayList<Pair>();
        int i = 0;
        while (i < this._fileMap.size()) {
            Pair apair = (Pair)this._fileMap.get(i);
            String canonicalName = apair.getCanonicalName();
            if (canonicalName != null) {
                if (canonicalName.equals(fileName)) {
                    if (!matchedCanonical) {
                        results.clear();
                        matchedCanonical = true;
                    }
                    results.add(apair);
                }
            } else if (apair.getFileName().equals(fileName) && !matchedCanonical) {
                results.add(apair);
            }
            ++i;
        }
        return results;
    }

    public void run() {
        if (!this._systemSupportsClassify) {
            return;
        }
        this.init();
        String filePath = null;
        if (!this._classifyFilter) {
            StringBuffer fPathBuf = new StringBuffer(this._subject.getValue());
            fPathBuf.append(File.separatorChar);
            fPathBuf.append(this._subject.getName());
            filePath = fPathBuf.toString();
        } else {
            filePath = this._subject.getValue();
        }
        if (this._classifyChildren) {
            if (!this._classifyVirtual) {
                File parentFile = new File(filePath);
                if (parentFile.isDirectory() && parentFile.list().length > 0) {
                    this.classifyChildren(parentFile, "*", false);
                }
            } else {
                this.classifyVirtualChildren(filePath);
            }
            this._dataStore.refresh(this._subject);
        } else {
            File theFile = new File(filePath);
            if (theFile.exists()) {
                try {
                    String type = this.classifyFile(theFile.getCanonicalFile());
                    StringBuffer classifiedProperties = new StringBuffer(this._subject.getSource());
                    classifiedProperties.append('(');
                    classifiedProperties.append(type);
                    classifiedProperties.append(')');
                    this._subject.setAttribute(4, classifiedProperties.toString());
                }
                catch (Exception exception) {}
            }
        }
        this._dataStore.disconnectObject(this._subject);
        this._dataStore.refresh(this._subject);
    }

    protected String classify(File parentFile, String line, String specialEncoding, boolean resolveLink) {
        String type = defaultType;
        int colon = line.indexOf(58);
        String name = line.substring(0, colon);
        String fulltype = line.substring(colon + 1, line.length()).trim();
        if (name.endsWith(".class")) {
            String parentPath = parentFile.getAbsolutePath();
            if (!parentPath.endsWith(fileSep)) {
                parentPath = String.valueOf(parentPath) + fileSep;
            }
            String filePath = String.valueOf(parentPath) + name;
            FileInputStream stream = null;
            BasicClassFileParser parser = null;
            boolean isExecutable = false;
            try {
                stream = new FileInputStream(filePath);
                parser = new BasicClassFileParser((InputStream)stream);
                parser.parse();
                isExecutable = parser.isExecutable();
            }
            catch (IOException iOException) {
                isExecutable = false;
                return type;
            }
            if (isExecutable) {
                type = "executable(java";
                String qualifiedClassName = parser.getQualifiedClassName();
                if (qualifiedClassName != null) {
                    type = String.valueOf(type) + ":" + qualifiedClassName;
                }
                type = String.valueOf(type) + ")";
            }
            return type;
        }
        if (this._systemSupportsClassFilesOnly) {
            return type;
        }
        type = fulltype.startsWith(symbolicLinkStr) ? this.resolveSymbolicLink(parentFile, name, fulltype, symbolicLinkStr, resolveLink, specialEncoding) : fulltype;
        return type;
    }

    protected String resolveSymbolicLink(File parentFile, String originalName, String fulltype, String symbolicLinkStr, boolean resolveLink, String specialEncoding) {
        StringBuffer type = new StringBuffer(STR_SYMBOLIC_LINK);
        String referencedFile = fulltype.substring(symbolicLinkStr.length()).trim();
        File refFile = new File(referencedFile);
        if (refFile.isDirectory()) {
            type.append("(directory)");
            return type.toString();
        }
        try {
            if (resolveLink) {
                String[] args = new String[]{this._systemShell, "-c", "file " + PathUtility.enQuoteUnix((String)referencedFile)};
                Process childProcess = Runtime.getRuntime().exec(args, null, parentFile);
                BufferedReader childReader = null;
                childReader = specialEncoding != null && specialEncoding.length() > 0 ? new BufferedReader(new InputStreamReader(childProcess.getInputStream(), specialEncoding)) : new BufferedReader(new InputStreamReader(childProcess.getInputStream()));
                String childLine = childReader.readLine().trim();
                type.append('(');
                type.append(this.classify(parentFile, childLine, specialEncoding, resolveLink));
                type.append(')');
                childReader.close();
            }
        }
        catch (Exception exception) {}
        return type.toString();
    }

    public String classifyFile(File aFile) {
        String type = defaultType;
        try {
            String referencedFile = aFile.getCanonicalPath();
            String specialEncoding = null;
            String[] args = new String[]{"sh", "-c", "file " + PathUtility.enQuoteUnix((String)referencedFile)};
            Process childProcess = Runtime.getRuntime().exec(args);
            BufferedReader childReader = null;
            childReader = new BufferedReader(new InputStreamReader(childProcess.getInputStream()));
            String childLine = null;
            try {
                childLine = childReader.readLine().trim();
            }
            catch (Exception exception) {}
            type = this.classify(aFile.getParentFile(), childLine, specialEncoding, true);
            childReader.close();
        }
        catch (Exception exception) {}
        return type;
    }

    protected List readLines(DataInputStream stream, String encoding) throws Exception {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        try {
            byte[] readBytes = new byte[1024];
            int available = stream.available();
            while (available > -1) {
                int numRead = stream.read(readBytes, 0, 1024);
                if (numRead == -1) {
                    return this._lines;
                }
                try {
                    String fullOutput = new String(readBytes, 0, numRead, encoding);
                    String[] tokens = fullOutput.split("\n");
                    if (tokens.length > 0) {
                        if (this._lines.size() > 0) {
                            String lastLine = (String)this._lines.remove(this._lines.size() - 1);
                            tokens[0] = String.valueOf(lastLine) + tokens[0];
                        }
                        int i = 0;
                        while (i < tokens.length) {
                            this._lines.add(tokens[i]);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                available = stream.available();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._lines;
    }

    protected String readLine(DataInputStream stream, String encoding) throws Exception {
        if (this._lines.size() == 0) {
            this._lines = this.readLines(stream, encoding);
        }
        if (this._lines == null) {
            return null;
        }
        if (this._lines.size() > 0) {
            return (String)this._lines.remove(0);
        }
        return null;
    }

    protected void classifyChildren(File parentFile, String files, boolean resolveLinks) {
        try {
            String line;
            ArrayList<File> deferredQueries;
            DataInputStream stream;
            BufferedReader reader;
            boolean hasLinks;
            block28: {
                hasLinks = false;
                String[] args = new String[]{"sh", "-c", resolveLinks && this._canResolveLinks ? "file -L " + files : "file " + files};
                Process theProcess = Runtime.getRuntime().exec(args, null, parentFile);
                reader = null;
                stream = null;
                if (this._specialEncoding != null) {
                    stream = new DataInputStream(theProcess.getInputStream());
                    reader = new BufferedReader(new InputStreamReader((InputStream)stream, this._specialEncoding));
                } else {
                    stream = new DataInputStream(theProcess.getInputStream());
                }
                deferredQueries = new ArrayList<File>();
                line = null;
                try {
                    if (reader != null) {
                        line = reader.readLine();
                        break block28;
                    }
                    line = this.readLine(stream, this._specialEncoding);
                }
                catch (Exception exception) {}
            }
            while (line != null) {
                int colon;
                if (line.length() > 0 && (line = line.trim()).indexOf("cannot open ") <= 0 && (colon = line.indexOf(58)) != -1) {
                    String name = line.substring(0, colon);
                    String type = this.classify(parentFile, line, this._specialEncoding, false);
                    List pairs = this.getElementsFor(name);
                    int d = 0;
                    while (d < pairs.size()) {
                        Pair pair = (Pair)pairs.get(d);
                        DataElement element = pair.getElement();
                        if (element != null) {
                            String textToCheck;
                            int linkIndex;
                            StringBuffer path = new StringBuffer(element.getValue());
                            path.append(File.separatorChar);
                            path.append(element.getName());
                            File refFile = new File(path.toString());
                            String canonicalPath = null;
                            if (type.equals(STR_SYMBOLIC_LINK) && !resolveLinks) {
                                canonicalPath = refFile.getCanonicalPath();
                                if (!this._canResolveLinks) {
                                    File canFile = refFile.getCanonicalFile();
                                    pair.setCanonicalName(canonicalPath);
                                    File cP = canFile.getParentFile();
                                    if (!deferredQueries.contains(cP)) {
                                        deferredQueries.add(cP);
                                    }
                                }
                                hasLinks = true;
                            } else {
                                this._fileMap.remove(pair);
                                if (type.equals(STR_SYMBOLIC_LINK)) {
                                    canonicalPath = refFile.getCanonicalPath();
                                }
                            }
                            StringBuffer currentProperties = new StringBuffer(element.getAttribute(4));
                            StringBuffer textToWrite = new StringBuffer(type);
                            if (type.equals(STR_SYMBOLIC_LINK) && type.indexOf(":") == -1) {
                                textToWrite.append(':');
                                textToWrite.append(canonicalPath);
                            }
                            if ((linkIndex = currentProperties.lastIndexOf(textToCheck = STR_SYMBOLIC_LINK)) != -1) {
                                int cutOffIndex = linkIndex + textToCheck.length();
                                StringBuffer typeBuf = new StringBuffer();
                                typeBuf.append('(');
                                typeBuf.append(type);
                                typeBuf.append(')');
                                currentProperties.insert(cutOffIndex, typeBuf.toString());
                                element.setAttribute(4, currentProperties.toString());
                            } else {
                                currentProperties.append('|');
                                currentProperties.append(textToWrite);
                                element.setAttribute(4, currentProperties.toString());
                            }
                        }
                        ++d;
                    }
                }
                try {
                    if (reader != null) {
                        line = reader.readLine();
                        continue;
                    }
                    line = this.readLine(stream, this._specialEncoding);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            } else {
                stream.close();
            }
            if (hasLinks) {
                if (!resolveLinks && this._canResolveLinks) {
                    this.classifyChildren(parentFile, "*", true);
                } else {
                    int i = 0;
                    while (i < deferredQueries.size()) {
                        File aFile = (File)deferredQueries.get(i);
                        StringBuffer newPathBuf = new StringBuffer(PathUtility.enQuoteUnix((String)aFile.getAbsolutePath()));
                        newPathBuf.append(File.separatorChar);
                        newPathBuf.append('*');
                        this.classifyChildren(parentFile, newPathBuf.toString(), true);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void classifyVirtualChildren(String parentPath) {
        ArchiveHandlerManager mgr = ArchiveHandlerManager.getInstance();
        parentPath = String.valueOf('/') + ArchiveHandlerManager.cleanUpVirtualPath((String)parentPath);
        boolean isArchive = mgr.isRegisteredArchive(parentPath);
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)parentPath);
        VirtualChild[] children = null;
        try {
            File archiveFile = null;
            String virtualPath = null;
            if (isArchive && !isVirtual) {
                archiveFile = new File(parentPath);
                virtualPath = "";
            } else {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(parentPath);
                String archivePath = avp.getContainingArchiveString();
                virtualPath = avp.getVirtualPart();
                archiveFile = new File(archivePath);
            }
            children = mgr.getContents(archiveFile, virtualPath);
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                VirtualChild child = children[i];
                String type = defaultType;
                if (!child.isDirectory) {
                    String name = child.name;
                    type = mgr.getClassification(archiveFile, child.fullName);
                    List matches = this.getElementsFor(name);
                    int c = 0;
                    while (c < matches.size()) {
                        Pair pair = (Pair)matches.get(c);
                        DataElement element = pair.getElement();
                        if (element != null) {
                            this._fileMap.remove(pair);
                            StringBuffer currentProperties = new StringBuffer(element.getAttribute(4));
                            currentProperties.append('|');
                            currentProperties.append(type);
                            element.setAttribute(4, currentProperties.toString());
                        }
                        ++c;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    protected class Pair {
        private String _fileName;
        private String _canonicalName;
        private DataElement _element;

        public Pair(String fileName, DataElement element) {
            this._fileName = fileName;
            this._element = element;
        }

        public DataElement getElement() {
            return this._element;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getCanonicalName() {
            return this._canonicalName;
        }

        public void setCanonicalName(String canonicalName) {
            this._canonicalName = canonicalName;
        }
    }
}

