/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.dstore;

import java.util.ArrayList;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.internal.services.dstore.files.DStoreVirtualHostFile;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreFile;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreVirtualFile;
import org.eclipse.rse.internal.subsystems.files.dstore.RemoteFilePropertyChangeListener;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;

public class DStoreFileAdapter
implements IHostFileToRemoteFileAdapter {
    private RemoteFilePropertyChangeListener _listener;

    private void registerFilePropertyChangeListener(FileServiceSubSystem ss) {
        if (this._listener == null) {
            DStoreConnectorService connectorService = (DStoreConnectorService)ss.getConnectorService();
            Shell shell = SystemBasePlugin.getActiveWorkbenchShell();
            this._listener = new RemoteFilePropertyChangeListener(shell, (IConnectorService)connectorService, connectorService.getDataStore(), ss);
        }
    }

    public AbstractRemoteFile[] convertToRemoteFiles(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile[] nodes) {
        this.registerFilePropertyChangeListener(ss);
        ArrayList<DStoreFile> results = new ArrayList<DStoreFile>();
        int i = 0;
        while (i < nodes.length) {
            DStoreHostFile node = (DStoreHostFile)nodes[i];
            DStoreFile lfile = null;
            lfile = node instanceof DStoreVirtualHostFile ? new DStoreVirtualFile(ss, context, parent, (DStoreVirtualHostFile)node) : new DStoreFile(ss, context, parent, node);
            results.add(lfile);
            ss.cacheRemoteFile((IRemoteFile)lfile);
            ++i;
        }
        return results.toArray(new DStoreFile[results.size()]);
    }

    public AbstractRemoteFile convertToRemoteFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile node) {
        this.registerFilePropertyChangeListener(ss);
        DStoreFile file = null;
        file = node instanceof DStoreVirtualHostFile ? new DStoreVirtualFile(ss, context, parent, (DStoreVirtualHostFile)node) : new DStoreFile(ss, context, parent, (DStoreHostFile)node);
        ss.cacheRemoteFile((IRemoteFile)file);
        return file;
    }
}

