/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.wince.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.internal.services.wince.IRapiSessionProvider;
import org.eclipse.rse.internal.services.wince.IWinCEService;
import org.eclipse.rse.internal.services.wince.files.Messages;
import org.eclipse.rse.internal.services.wince.files.WinCEHostFile;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemUnexpectedErrorException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.tm.rapi.IRapiSession;
import org.eclipse.tm.rapi.RapiException;
import org.eclipse.tm.rapi.RapiFindData;

public class WinCEFileService
extends AbstractFileService
implements IWinCEService {
    IRapiSessionProvider sessionProvider;

    public WinCEFileService(IRapiSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    String concat(String parentDir, String fileName) {
        String result = parentDir;
        if (!result.endsWith("\\")) {
            result = String.valueOf(result) + "\\";
        }
        result = String.valueOf(result) + fileName;
        return result;
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher fileMatcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            fileMatcher = new FileTypeMatcher(types, true);
        } else {
            fileMatcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<WinCEHostFile> results = new ArrayList<WinCEHostFile>();
        try {
            IRapiSession session = this.sessionProvider.getSession();
            RapiFindData[] foundFiles = session.findAllFiles(this.concat(parentPath, "*"), 185);
            int i = 0;
            while (i < foundFiles.length) {
                WinCEHostFile hostFile;
                String fileName = foundFiles[i].fileName;
                if (fileMatcher.matches(fileName) && this.isRightType(fileType, hostFile = this.makeHostFile(parentPath, fileName, foundFiles[i]))) {
                    results.add(hostFile);
                }
                ++i;
            }
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private WinCEHostFile makeHostFile(String parentPath, String fileName, RapiFindData findData) {
        boolean isDirectory = (findData.fileAttributes & 0x10) != 0;
        boolean isWritable = (findData.fileAttributes & 1) == 0;
        boolean isRoot = "\\".equals(parentPath) && "\\".equals(fileName);
        long lastModified = findData.lastWriteTime / 10000L - 11644473600000L;
        long size = findData.fileSize;
        return new WinCEHostFile(parentPath, fileName, isDirectory, isRoot, isWritable, lastModified, size);
    }

    private boolean isDirectory(IRapiSession session, String fullPath) {
        int attr = session.getFileAttributes(fullPath);
        if (attr == -1) {
            return false;
        }
        return (attr & 0x10) != 0;
    }

    private boolean exist(IRapiSession session, String fileName) {
        return session.getFileAttributes(fileName) != -1;
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        String tgtFullPath;
        String srcFullPath = this.concat(srcParent, srcName);
        if (srcFullPath.equals(tgtFullPath = this.concat(tgtParent, tgtName))) {
            throw new SystemUnsupportedOperationException("org.eclipse.rse.subsystems.wince", "Cannot copy file or folder to itself");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRapiSession session = this.sessionProvider.getSession();
        try {
            if (this.isDirectory(session, srcFullPath)) {
                if (tgtFullPath.startsWith(String.valueOf(srcFullPath) + "\\")) {
                    throw new SystemUnsupportedOperationException("org.eclipse.rse.subsystems.wince", "Cannot copy folder to its subfolder");
                }
                if (!this.exist(session, tgtFullPath)) {
                    session.createDirectory(tgtFullPath);
                }
                RapiFindData[] allFiles = session.findAllFiles(this.concat(srcFullPath, "*"), 128);
                int i = 0;
                while (i < allFiles.length) {
                    String fileName = allFiles[i].fileName;
                    if (monitor.isCanceled()) {
                        throw new SystemOperationCancelledException();
                    }
                    this.copy(srcFullPath, fileName, tgtFullPath, fileName, monitor);
                    ++i;
                }
            } else {
                session.copyFile(srcFullPath, tgtFullPath);
                monitor.worked(1);
            }
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < srcParents.length) {
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = this.concat(remoteParent, fileName);
        IRapiSession session = this.sessionProvider.getSession();
        try {
            int handle = session.createFile(fullPath, 0x40000000, 1, 2, 128);
            session.closeHandle(handle);
            RapiFindData findData = new RapiFindData();
            handle = session.findFirstFile(fullPath, findData);
            session.findClose(handle);
            return this.makeHostFile(remoteParent, fileName, findData);
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = this.concat(remoteParent, folderName);
        IRapiSession session = this.sessionProvider.getSession();
        try {
            session.createDirectory(fullPath);
            RapiFindData findData = new RapiFindData();
            int handle = session.findFirstFile(fullPath, findData);
            session.findClose(handle);
            return this.makeHostFile(remoteParent, folderName, findData);
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = this.concat(remoteParent, fileName);
        IRapiSession session = this.sessionProvider.getSession();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (!this.exist(session, fullPath)) {
                throw new SystemElementNotFoundException(fullPath, "delete");
            }
            if (this.isDirectory(session, fullPath)) {
                RapiFindData[] allFiles = session.findAllFiles(this.concat(fullPath, "*"), 128);
                int i = 0;
                while (i < allFiles.length) {
                    if (monitor.isCanceled()) {
                        throw new SystemOperationCancelledException();
                    }
                    this.delete(fullPath, allFiles[i].fileName, monitor);
                    ++i;
                }
                session.removeDirectory(fullPath);
            } else {
                session.deleteFile(fullPath);
                monitor.worked(1);
            }
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        File localParentFile;
        if (!(localFile.exists() || (localParentFile = localFile.getParentFile()).exists() || localParentFile.mkdirs())) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.subsystems.wince");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String fullPath = this.concat(remoteParent, remoteFile);
        IRapiSession session = this.sessionProvider.getSession();
        int handle = -1;
        FilterOutputStream bos = null;
        try {
            try {
                int bytesRead;
                handle = session.createFile(fullPath, Integer.MIN_VALUE, 1, 3, 128);
                long fileSize = session.getFileSize(handle);
                monitor.beginTask(fullPath, (int)fileSize);
                bos = new BufferedOutputStream(new FileOutputStream(localFile));
                byte[] buffer = new byte[4096];
                while ((bytesRead = session.readFile(handle, buffer)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
                    if (monitor.isCanceled()) {
                        throw new SystemOperationCancelledException();
                    }
                    monitor.worked(bytesRead);
                }
                ((BufferedOutputStream)bos).flush();
                monitor.done();
            }
            catch (RapiException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            if (handle != -1) {
                try {
                    session.closeHandle(handle);
                }
                catch (RapiException rapiException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (handle != -1) {
            try {
                session.closeHandle(handle);
            }
            catch (RapiException rapiException) {}
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IHostFile getFile(String remoteParent, String name, IProgressMonitor monitor) throws SystemMessageException {
        IRapiSession session = this.sessionProvider.getSession();
        try {
            RapiFindData findData = new RapiFindData();
            int h = session.findFirstFile(this.concat(remoteParent, name), findData);
            session.findClose(h);
            return this.makeHostFile(remoteParent, name, findData);
        }
        catch (RapiException rapiException) {
            WinCEHostFile dummy = new WinCEHostFile(remoteParent, name, false, false, false, 0L, 0L);
            dummy.setExists(false);
            return dummy;
        }
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        return new WinCEHostFile[]{new WinCEHostFile("\\", "\\", true, true, true, 0L, 0L)};
    }

    public IHostFile getUserHome() {
        return new WinCEHostFile("\\", "My Documents", true, false, true, 0L, 0L);
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        this.copy(srcParent, srcName, tgtParent, tgtName, monitor);
        this.delete(srcParent, srcName, monitor);
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        String oldFullPath = this.concat(remoteParent, oldName);
        String newFullPath = this.concat(remoteParent, newName);
        IRapiSession session = this.sessionProvider.getSession();
        try {
            session.moveFile(oldFullPath, newFullPath);
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remoteParent, oldName, newName, monitor);
        String newFullPath = this.concat(remoteParent, newName);
        oldFile.renameTo(newFullPath);
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        IRapiSession session = this.sessionProvider.getSession();
        String fullPath = this.concat(parent, name);
        int handle = -1;
        try {
            try {
                handle = session.createFile(fullPath, 0x40000000, 1, 3, 128);
                session.setFileLastWriteTime(handle, timestamp);
            }
            catch (RapiException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            if (handle != -1) {
                try {
                    session.closeHandle(handle);
                }
                catch (RapiException rapiException) {}
            }
            throw throwable;
        }
        if (handle != -1) {
            try {
                session.closeHandle(handle);
            }
            catch (RapiException rapiException) {}
        }
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        IRapiSession session = this.sessionProvider.getSession();
        String fullPath = this.concat(parent, name);
        int attr = session.getFileAttributes(fullPath);
        attr = readOnly ? (attr |= 1) : (attr &= 0xFFFFFFFE);
        try {
            session.setFileAttributes(fullPath, attr);
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    private void internalUpload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, long fileSize, IProgressMonitor monitor) throws SystemMessageException {
        BufferedInputStream bis = new BufferedInputStream(stream);
        IRapiSession session = this.sessionProvider.getSession();
        String fullPath = this.concat(remoteParent, remoteFile);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (fileSize != -1L) {
            monitor.beginTask(fullPath, (int)fileSize);
        }
        int handle = -1;
        try {
            try {
                int bytesRead;
                handle = session.createFile(fullPath, 0x40000000, 1, 2, 128);
                byte[] buffer = new byte[4096];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    session.writeFile(handle, buffer, 0, bytesRead);
                    if (monitor.isCanceled()) {
                        throw new SystemOperationCancelledException();
                    }
                    monitor.worked(bytesRead);
                }
                monitor.done();
            }
            catch (RapiException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            if (handle != -1) {
                try {
                    session.closeHandle(handle);
                }
                catch (RapiException rapiException) {}
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (handle != -1) {
            try {
                session.closeHandle(handle);
            }
            catch (RapiException rapiException) {}
        }
        try {
            bis.close();
        }
        catch (IOException iOException) {}
    }

    public void upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        this.internalUpload(stream, remoteParent, remoteFile, isBinary, hostEncoding, -1L, monitor);
    }

    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        long fileSize = localFile.length();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(localFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.subsystems.wince");
        }
        this.internalUpload(fis, remoteParent, remoteFile, isBinary, hostEncoding, fileSize, monitor);
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = this.concat(remoteParent, remoteFile);
        IRapiSession session = this.sessionProvider.getSession();
        try {
            int handle = session.createFile(fullPath, Integer.MIN_VALUE, 1, 3, 128);
            return new BufferedInputStream(new WinCEInputStream(session, handle));
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = this.concat(remoteParent, remoteFile);
        IRapiSession session = this.sessionProvider.getSession();
        try {
            int cd = 2;
            cd = (options & 1) == 0 ? 2 : 3;
            int handle = session.createFile(fullPath, 0x40000000, 1, cd, 128);
            return new BufferedOutputStream(new WinCEOutputStream(session, handle));
        }
        catch (RapiException e) {
            throw new RemoteFileIOException((Exception)((Object)e));
        }
    }

    public String getDescription() {
        return Messages.WinCEFileService_0;
    }

    public String getName() {
        return Messages.WinCEFileService_1;
    }

    private static class WinCEInputStream
    extends InputStream {
        private int handle;
        private IRapiSession session;

        public WinCEInputStream(IRapiSession session, int handle) {
            this.handle = handle;
            this.session = session;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            try {
                int br = this.session.readFile(this.handle, b);
                return br == -1 ? -1 : b[0];
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.session.readFile(this.handle, b, off, len);
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.session.closeHandle(this.handle);
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private static class WinCEOutputStream
    extends OutputStream {
        private int handle;
        private IRapiSession session;

        public WinCEOutputStream(IRapiSession session, int handle) {
            this.session = session;
            this.handle = handle;
        }

        public void write(int b) throws IOException {
            try {
                this.session.writeFile(this.handle, new byte[]{(byte)b});
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.session.writeFile(this.handle, b, off, len);
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.session.closeHandle(this.handle);
            }
            catch (RapiException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

