/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SystemCompileMultipleSelectAction
extends SystemBaseAction {
    static /* synthetic */ Class class$0;

    public SystemCompileMultipleSelectAction(Shell shell) {
        super(UserActionsResources.ACTION_COMPILE_NOPROMPT_LABEL, UserActionsResources.ACTION_COMPILE_NOPROMPT_TOOLTIP, null, shell);
        this.allowOnMultipleSelection(true);
        this.setAccelerator(393315);
    }

    public void run() {
        if (this.checkDirtyEditors()) {
            Object element = this.getFirstSelection();
            boolean ok = true;
            while (ok && element != null) {
                ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)element);
                String srcType = null;
                srcType = rmtAdapter.getRemoteSourceType(element);
                if (srcType == null) {
                    srcType = "null";
                } else if (srcType.equals("")) {
                    srcType = "blank";
                }
                if (!ok) continue;
                element = this.getNextSelection();
            }
        }
    }

    protected List getDirtyEditors() {
        IStructuredSelection sel = this.getSelection();
        List selection = sel.toList();
        ArrayList<ISystemEditableRemoteObject> dirtyEditors = new ArrayList<ISystemEditableRemoteObject>();
        int i = 0;
        while (i < selection.size()) {
            ISystemEditableRemoteObject editable;
            Object selected = selection.get(i);
            if (selected instanceof IAdaptable && (editable = this.getEditableFor((IAdaptable)selected)) != null) {
                try {
                    if (editable.checkOpenInEditor() == 0) {
                        editable.openEditor();
                        if (editable.isDirty()) {
                            dirtyEditors.add(editable);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return dirtyEditors;
    }

    protected ISystemEditableRemoteObject getEditableFor(IAdaptable selected) {
        ISystemRemoteElementAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)selected.getAdapter((Class)clazz)).canEdit((Object)selected)) {
            ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)selected);
            try {
                editable.setLocalResourceProperties();
            }
            catch (Exception exception) {}
            return editable;
        }
        return null;
    }

    protected boolean checkDirtyEditors() {
        List dirtyEditors = this.getDirtyEditors();
        if (dirtyEditors.size() > 0) {
            AdaptableList input = new AdaptableList();
            int i = 0;
            while (i < dirtyEditors.size()) {
                ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)dirtyEditors.get(i);
                input.add(rmtObj.getRemoteObject());
                ++i;
            }
            WorkbenchContentProvider cprovider = new WorkbenchContentProvider();
            SystemTableViewProvider lprovider = new SystemTableViewProvider(null);
            ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)cprovider, (ILabelProvider)lprovider, SystemUDAResources.EditorManager_saveResourcesMessage);
            dlg.setInitialSelections(input.getChildren());
            dlg.setTitle(SystemUDAResources.EditorManager_saveResourcesTitle);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int s = 0;
            while (s < filesToSave.length) {
                IAdaptable rmtObj = (IAdaptable)filesToSave[s];
                ISystemEditableRemoteObject editable = this.getEditableFor(rmtObj);
                editable.doImmediateSaveAndUpload();
                ++s;
            }
        }
        return true;
    }
}

