/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.process;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcess;

public class LocalTerminalProcessRegistry
implements ILaunchesListener2 {
    private static final LocalTerminalProcessRegistry INSTANCE = new LocalTerminalProcessRegistry();
    private Map processes = new IdentityHashMap();

    private LocalTerminalProcessRegistry() {
    }

    public static LocalTerminalProcess getFromLaunch(ILaunch launch) {
        return (LocalTerminalProcess)((Object)LocalTerminalProcessRegistry.INSTANCE.processes.get(launch));
    }

    public static void addProcessBackToFinishedLaunch(ILaunch launch) {
        LocalTerminalProcess process = LocalTerminalProcessRegistry.getFromLaunch(launch);
        if (process == null) {
            return;
        }
        process.resetStreamsProxy();
        if (launch.getProcesses().length == 0) {
            launch.addProcess((IProcess)process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWithLaunch(ILaunch launch, LocalTerminalProcess process) {
        LocalTerminalProcessRegistry localTerminalProcessRegistry = INSTANCE;
        synchronized (localTerminalProcessRegistry) {
            if (LocalTerminalProcessRegistry.INSTANCE.processes.isEmpty()) {
                LocalTerminalUtilities.LAUNCH_MANAGER.addLaunchListener((ILaunchesListener)INSTANCE);
            }
            LocalTerminalProcessRegistry.INSTANCE.processes.put(launch, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchesTerminated(ILaunch[] terminated) {
        LocalTerminalProcessRegistry localTerminalProcessRegistry = INSTANCE;
        synchronized (localTerminalProcessRegistry) {
            int numberOfTerminatedLaunches = terminated.length;
            int launch = 0;
            while (launch < numberOfTerminatedLaunches) {
                LocalTerminalProcessRegistry.INSTANCE.processes.remove(terminated[launch]);
                ++launch;
            }
            if (LocalTerminalProcessRegistry.INSTANCE.processes.isEmpty()) {
                LocalTerminalUtilities.LAUNCH_MANAGER.removeLaunchListener((ILaunchesListener)INSTANCE);
            }
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }
}

