/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;

public class SystemViewAPIProviderForFilters
extends SystemAbstractAPIProvider {
    protected ISubSystem subsystem = null;
    protected ISystemFilterPool filterPool = null;
    protected ISystemFilterPoolReference filterPoolReference = null;
    protected ISystemFilterReference filterReference = null;
    protected ISystemFilter filter = null;

    public SystemViewAPIProviderForFilters(ISystemFilterReference filterReference) {
        this.setFilterReference(filterReference);
    }

    public ISubSystem getSubSystem() {
        return this.subsystem;
    }

    public ISystemFilterPoolReference getSystemFilterPoolReference() {
        return this.filterPoolReference;
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this.filterPool;
    }

    public ISystemFilterReference getSystemFilterReference() {
        return this.filterReference;
    }

    public ISystemFilter getSystemFilter() {
        return this.filter;
    }

    public void setFilterReference(ISystemFilterReference filterReference) {
        this.filterReference = filterReference;
        this.filter = filterReference.getReferencedFilter();
        this.filterPoolReference = filterReference.getParentSystemFilterReferencePool();
        this.filterPool = this.filterPoolReference.getReferencedFilterPool();
        this.subsystem = (ISubSystem)this.filterPoolReference.getProvider();
    }

    public Object[] getSystemViewRoots() {
        ISystemFilterReference fRef;
        Object[] children = null;
        ISystemFilterReference element = fRef = this.filterReference;
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)referencedFilter);
        boolean promptable = referencedFilter.isPromptable();
        if (promptable) {
            children = new SystemMessageObject[1];
            try {
                ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssf.getAdapter(ISubSystemConfigurationAdapter.class);
                ISystemFilter newFilter = adapter.createFilterByPrompting(ssf, fRef, RSEUIPlugin.getTheSystemRegistryUI().getShell());
                if (newFilter == null) {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, (Object)element);
                } else {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1102"), 4, (Object)element);
                    ISubSystem ss = fRef.getSubSystem();
                    ISystemFilterReference sfr = fRef.getParentSystemFilterReferencePool().getExistingSystemFilterReference(ss, newFilter);
                    SystemViewAPIProviderForFilters inputProvider = this;
                    if (sfr != null && inputProvider.getViewer() != null) {
                        SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)sfr, 105, null);
                        Viewer v = (Viewer)inputProvider.getViewer();
                        if (v instanceof ISystemResourceChangeListener) {
                            RSEUIPlugin.getTheSystemRegistryUI().postEvent((ISystemResourceChangeListener)v, (ISystemResourceChangeEvent)event);
                        }
                    }
                }
            }
            catch (Exception exc) {
                children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, (Object)element);
                SystemBasePlugin.logError("Exception prompting for filter ", exc);
            }
            return children;
        }
        ISubSystem ss = fRef.getSubSystem();
        Object[] nestedFilterReferences = fRef.getSystemFilterReferences(ss);
        int nbrFilterStrings = referencedFilter.getFilterStringCount();
        if (nbrFilterStrings == 0) {
            return nestedFilterReferences;
        }
        String[] filterStrings = referencedFilter.getFilterStrings();
        try {
            if (nestedFilterReferences != null) {
                Object[] allChildren = ss.resolveFilterStrings(filterStrings, (IProgressMonitor)new NullProgressMonitor());
                int nbrNestedFilters = nestedFilterReferences.length;
                children = new Object[nbrNestedFilters + allChildren.length];
                int idx = 0;
                idx = 0;
                while (idx < nbrNestedFilters) {
                    children[idx] = nestedFilterReferences[idx];
                    ++idx;
                }
                int jdx = 0;
                while (jdx < allChildren.length) {
                    children[idx++] = allChildren[jdx];
                    ++jdx;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, (Object)element)};
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Filter resolving cancelled by user.");
        }
        catch (Exception exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, (Object)element)};
            SystemBasePlugin.logError("Exception resolving filters' strings ", exc);
        }
        return this.checkForEmptyList(children, element, true);
    }

    public boolean hasSystemViewRoots() {
        int nbrNestedFilters = this.filter.getSystemFilterCount();
        int nbrFilterStrings = this.filter.getFilterStringCount();
        return nbrNestedFilters > 0 || nbrFilterStrings > 0;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return false;
    }
}

