/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.ConfigParser;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class BuildArgParser
extends Main {
    private static final String BUNDLE_NAME = "org.aspectj.ajdt.ajc.messages";
    private static boolean LOADED_BUNDLE = false;
    private final StringBuffer errorSink;
    private IMessageHandler handler;

    public static String getUsage() {
        return Main.bind((String)"misc.usage");
    }

    public BuildArgParser(PrintWriter writer, IMessageHandler handler) {
        super(writer, writer, false);
        this.errorSink = writer instanceof StringPrintWriter ? ((StringPrintWriter)writer).stringWriter.getBuffer() : null;
        this.handler = handler;
    }

    public BuildArgParser(IMessageHandler handler) {
        this(new StringPrintWriter(new StringWriter()), handler);
    }

    public AjBuildConfig genBuildConfig(String[] args) {
        return this.genBuildConfig(args, true, null);
    }

    public AjBuildConfig genBuildConfig(String[] args, boolean setClasspath, File configFile) {
        AjBuildConfig buildConfig = new AjBuildConfig();
        buildConfig.setConfigFile(configFile);
        try {
            IMessageHandler delegate;
            this.filenames = new String[]{""};
            AjcConfigParser parser = new AjcConfigParser(buildConfig, this.handler);
            parser.parseCommandLine(args);
            boolean swi = buildConfig.getShowWeavingInformation();
            if (this.handler instanceof CountingMessageHandler && (delegate = ((CountingMessageHandler)this.handler).delegate) instanceof MessageHandler) {
                if (swi) {
                    ((MessageHandler)delegate).dontIgnore(IMessage.WEAVEINFO);
                } else {
                    ((MessageHandler)delegate).ignore(IMessage.WEAVEINFO);
                }
            }
            boolean incrementalMode = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            ArrayList fileList = new ArrayList();
            List files = parser.getFiles();
            if (!LangUtil.isEmpty(files)) {
                if (incrementalMode) {
                    MessageUtil.error(this.handler, "incremental mode only handles source files using -sourceroots");
                } else {
                    fileList.addAll(files);
                }
            }
            ArrayList<String> javaArgList = new ArrayList<String>();
            javaArgList.add("-warn:none");
            javaArgList.add("-classpath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.add("-bootclasspath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.addAll(parser.getUnparsedArgs());
            super.configure(javaArgList.toArray(new String[javaArgList.size()]));
            if (!this.proceed) {
                buildConfig.doNotProceed();
                return buildConfig;
            }
            if (buildConfig.getSourceRoots() != null) {
                Iterator i = buildConfig.getSourceRoots().iterator();
                while (i.hasNext()) {
                    fileList.addAll(this.collectSourceRootFiles((File)i.next()));
                }
            }
            buildConfig.setFiles(fileList);
            if (this.destinationPath != null) {
                buildConfig.setOutputDir(new File(this.destinationPath));
            }
            if (setClasspath) {
                buildConfig.setClasspath(this.getClasspath(parser));
            }
            if (incrementalMode && 0 == buildConfig.getSourceRoots().size()) {
                MessageUtil.error(this.handler, "specify a source root when in incremental mode");
            }
            this.setDebugOptions();
            buildConfig.setJavaOptions(this.options);
        }
        catch (InvalidInputException iie) {
            SourceLocation location = null;
            if (buildConfig.getConfigFile() != null) {
                location = new SourceLocation(buildConfig.getConfigFile(), 0);
            }
            Message m = new Message(iie.getMessage(), IMessage.ERROR, null, location);
            this.handler.handleMessage(m);
        }
        return buildConfig;
    }

    public void printVersion() {
        System.err.println("AspectJ Compiler DEVELOPMENT built on Thursday Jul 15, 2004 at 11:40:31 GMT");
        System.err.flush();
    }

    public void printUsage() {
        System.out.println(Main.bind((String)"misc.usage"));
        System.out.flush();
    }

    public String getOtherMessages(boolean flush) {
        if (null == this.errorSink) {
            return null;
        }
        String result = this.errorSink.toString().trim();
        if (0 == result.length()) {
            result = null;
        }
        if (flush) {
            this.errorSink.setLength(0);
        }
        return result;
    }

    private void setDebugOptions() {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private Collection collectSourceRootFiles(File dir) {
        return Arrays.asList(FileUtil.listFiles(dir, FileUtil.aspectjSourceFileFilter));
    }

    public List getClasspath(AjcConfigParser parser) {
        ArrayList ret = new ArrayList();
        if (parser.bootclasspath == null) {
            this.addClasspath(System.getProperty("sun.boot.class.path", ""), ret);
        } else {
            this.addClasspath(parser.bootclasspath, ret);
        }
        String extdirs = parser.extdirs;
        if (extdirs == null) {
            extdirs = System.getProperty("java.ext.dirs", "");
        }
        this.addExtDirs(extdirs, ret);
        if (parser.classpath == null) {
            this.addClasspath(System.getProperty("java.class.path", ""), ret);
            ArrayList<String> fixedList = new ArrayList<String>();
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                String entry = (String)it.next();
                if (entry.endsWith("aspectjtools.jar")) continue;
                fixedList.add(entry);
            }
            ret = fixedList;
        } else {
            this.addClasspath(parser.classpath, ret);
        }
        return ret;
    }

    private void addExtDirs(String extdirs, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(extdirs, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File dirFile = new File(tokenizer.nextToken());
            if (!dirFile.canRead() || !dirFile.isDirectory()) continue;
            File[] files = dirFile.listFiles(FileUtil.ZIP_FILTER);
            for (int i = 0; i < files.length; ++i) {
                classpathCollector.add(files[i].getAbsolutePath());
            }
        }
    }

    private void addClasspath(String classpath, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            classpathCollector.add(tokenizer.nextToken());
        }
    }

    static {
        Main.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        if (!LOADED_BUNDLE) {
            LOADED_BUNDLE = true;
        }
    }

    private class AjcConfigParser
    extends ConfigParser {
        private String bootclasspath = null;
        private String classpath = null;
        private String extdirs = null;
        private List unparsedArgs = new ArrayList();
        private AjBuildConfig buildConfig;
        private IMessageHandler handler;

        public AjcConfigParser(AjBuildConfig buildConfig, IMessageHandler handler) {
            this.buildConfig = buildConfig;
            this.handler = handler;
        }

        public List getUnparsedArgs() {
            return this.unparsedArgs;
        }

        public void parseOption(String arg, LinkedList args) {
            int nextArgIndex = args.indexOf(arg) + 1;
            if (LangUtil.isEmpty(arg)) {
                this.showWarning("empty arg found");
            } else if (arg.equals("-inpath")) {
                if (args.size() > nextArgIndex) {
                    this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.inpath", "preserve");
                    List inPath = this.buildConfig.getInpath();
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File file = this.makeFile(filename);
                        if (file.exists() && FileUtil.hasZipSuffix(filename)) {
                            inPath.add(file);
                            continue;
                        }
                        if (file.isDirectory()) {
                            inPath.add(file);
                            continue;
                        }
                        this.showError("bad inpath component: " + filename);
                    }
                    this.buildConfig.setInPath(inPath);
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-injars")) {
                if (args.size() > nextArgIndex) {
                    this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.injars", "preserve");
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (jarFile.exists() && FileUtil.hasZipSuffix(filename)) {
                            this.buildConfig.getInJars().add(jarFile);
                            continue;
                        }
                        File dirFile = this.makeFile(filename);
                        if (dirFile.isDirectory()) {
                            this.buildConfig.getInJars().add(dirFile);
                            continue;
                        }
                        this.showError("bad injar: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-aspectpath")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (jarFile.exists() && FileUtil.hasZipSuffix(filename)) {
                            this.buildConfig.getAspectpath().add(jarFile);
                            continue;
                        }
                        this.showError("bad aspectpath: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-sourceroots")) {
                if (args.size() > nextArgIndex) {
                    ArrayList<File> sourceRoots = new ArrayList<File>();
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        File f = this.makeFile(st.nextToken());
                        if (f.isDirectory() && f.canRead()) {
                            sourceRoots.add(f);
                            continue;
                        }
                        this.showError("bad sourceroot: " + f);
                    }
                    if (0 < sourceRoots.size()) {
                        this.buildConfig.setSourceRoots(sourceRoots);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-sourceroots requires list of directories");
                }
            } else if (arg.equals("-outjar")) {
                if (args.size() > nextArgIndex) {
                    this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.outjar", "generate");
                    File jarFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (FileUtil.hasZipSuffix(jarFile)) {
                        try {
                            if (!jarFile.exists()) {
                                jarFile.createNewFile();
                            }
                            this.buildConfig.setOutputJar(jarFile);
                        }
                        catch (IOException ioe) {
                            this.showError("unable to create outjar file: " + jarFile);
                        }
                    } else {
                        this.showError("invalid -outjar file: " + jarFile);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outjar requires jar path argument");
                }
            } else if (arg.equals("-incremental")) {
                this.buildConfig.setIncrementalMode(true);
            } else if (arg.equals("-XincrementalFile")) {
                if (args.size() > nextArgIndex) {
                    File file = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    this.buildConfig.setIncrementalFile(file);
                    if (!file.canRead()) {
                        this.showError("bad -XincrementalFile : " + file);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-XincrementalFile requires file argument");
                }
            } else if (arg.equals("-emacssym")) {
                this.buildConfig.setEmacsSymMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.equals("-XjavadocsInModel")) {
                this.buildConfig.setGenerateModelMode(true);
                this.buildConfig.setGenerateJavadocsInModelMode(true);
            } else if (arg.equals("-noweave") || arg.equals("-XnoWeave")) {
                this.buildConfig.setNoWeave(true);
            } else if (arg.equals("-XserializableAspects")) {
                this.buildConfig.setXserializableAspects(true);
            } else if (arg.equals("-XlazyTjp")) {
                this.buildConfig.setXlazyTjp(true);
            } else if (arg.startsWith("-Xreweavable")) {
                this.buildConfig.setXreweavable(true);
                if (arg.endsWith(":compress")) {
                    this.buildConfig.setXreweavableCompressClasses(true);
                }
            } else if (arg.equals("-XnoInline")) {
                this.buildConfig.setXnoInline(true);
            } else if (arg.startsWith("-showWeaveInfo")) {
                this.buildConfig.setShowWeavingInformation(true);
            } else if (arg.equals("-Xlintfile")) {
                if (args.size() > nextArgIndex) {
                    File lintSpecFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (lintSpecFile.canRead() && lintSpecFile.getName().endsWith(".properties")) {
                        this.buildConfig.setLintSpecFile(lintSpecFile);
                    } else {
                        this.showError("bad -Xlintfile file: " + lintSpecFile);
                        this.buildConfig.setLintSpecFile(null);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-Xlintfile requires .properties file argument");
                }
            } else if (arg.equals("-Xlint")) {
                this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.Xlint", "generate");
                this.buildConfig.setLintMode("default");
            } else if (arg.startsWith("-Xlint:")) {
                if (7 < arg.length()) {
                    this.buildConfig.setLintMode(arg.substring(7));
                } else {
                    this.showError("invalid lint option " + arg);
                }
            } else if (arg.equals("-bootclasspath")) {
                if (args.size() > nextArgIndex) {
                    this.bootclasspath = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-bootclasspath requires classpath entries");
                }
            } else if (arg.equals("-classpath")) {
                if (args.size() > nextArgIndex) {
                    this.classpath = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-classpath requires classpath entries");
                }
            } else if (arg.equals("-extdirs")) {
                if (args.size() > nextArgIndex) {
                    this.extdirs = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-extdirs requires list of external directories");
                }
            } else if (arg.equals("-d")) {
                this.dirLookahead(arg, args, nextArgIndex);
            } else if (new File(arg).isDirectory()) {
                this.showError("dir arg not permitted: " + arg);
            } else {
                this.unparsedArgs.add(arg);
            }
        }

        protected void dirLookahead(String arg, LinkedList argList, int nextArgIndex) {
            this.unparsedArgs.add(arg);
            ConfigParser.Arg next = (ConfigParser.Arg)argList.get(nextArgIndex);
            String value = next.getValue();
            if (!LangUtil.isEmpty(value) && new File(value).isDirectory()) {
                this.unparsedArgs.add(value);
                argList.remove(next);
                return;
            }
        }

        public void showError(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(ConfigParser.CONFIG_MSG + message, IMessage.ERROR, null, location);
            this.handler.handleMessage(errorMessage);
        }

        protected void showWarning(String message) {
            SourceLocation location = null;
            if (this.buildConfig.getConfigFile() != null) {
                location = new SourceLocation(this.buildConfig.getConfigFile(), 0);
            }
            Message errorMessage = new Message(ConfigParser.CONFIG_MSG + message, IMessage.WARNING, null, location);
            this.handler.handleMessage(errorMessage);
        }

        protected File makeFile(File dir, String name) {
            name = name.replace('/', File.separatorChar);
            File ret = new File(name);
            if (dir == null || ret.isAbsolute()) {
                return ret;
            }
            try {
                dir = dir.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return new File(dir, name);
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        public final StringWriter stringWriter;

        StringPrintWriter(StringWriter sw) {
            super(sw);
            this.stringWriter = sw;
        }
    }
}

