/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class InterTypeConstructorDeclaration
extends InterTypeDeclaration {
    private MethodDeclaration preMethod;
    private ExplicitConstructorCall explicitConstructorCall = null;

    public InterTypeConstructorDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        parser.parse((MethodDeclaration)this, unit);
    }

    public void resolve(ClassScope upperScope) {
        if (this.munger == null || ((AbstractMethodDeclaration)this).binding == null) {
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
        }
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        this.explicitConstructorCall = null;
        if (((AbstractMethodDeclaration)this).statements != null && ((AbstractMethodDeclaration)this).statements.length > 0 && ((AbstractMethodDeclaration)this).statements[0] instanceof ExplicitConstructorCall) {
            this.explicitConstructorCall = (ExplicitConstructorCall)((AbstractMethodDeclaration)this).statements[0];
            ((AbstractMethodDeclaration)this).statements = AstUtil.remove(0, ((AbstractMethodDeclaration)this).statements);
        }
        this.preMethod = this.makePreMethod(upperScope, this.explicitConstructorCall);
        ((AbstractMethodDeclaration)this).binding.parameters = AstUtil.insert((TypeBinding)this.onTypeBinding, ((AbstractMethodDeclaration)this).binding.parameters);
        ((AbstractMethodDeclaration)this).arguments = AstUtil.insert(AstUtil.makeFinalArgument("ajc$this_".toCharArray(), (TypeBinding)this.onTypeBinding), ((AbstractMethodDeclaration)this).arguments);
        super.resolve(upperScope);
    }

    private MethodDeclaration makePreMethod(ClassScope scope, ExplicitConstructorCall explicitConstructorCall) {
        int i;
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)scope);
        TypeX aspectTypeX = EclipseFactory.fromBinding((TypeBinding)((AbstractMethodDeclaration)this).binding.declaringClass);
        TypeX targetTypeX = EclipseFactory.fromBinding((TypeBinding)this.onTypeBinding);
        ArrayBinding objectArrayBinding = scope.createArray((TypeBinding)scope.getJavaLangObject(), 1);
        MethodDeclaration pre = new MethodDeclaration(((AbstractMethodDeclaration)this).compilationResult);
        pre.modifiers = 9;
        pre.returnType = AstUtil.makeTypeReference((TypeBinding)objectArrayBinding);
        pre.selector = NameMangler.postIntroducedConstructor(aspectTypeX, targetTypeX).toCharArray();
        pre.arguments = AstUtil.copyArguments(((AbstractMethodDeclaration)this).arguments);
        pre.scope = new MethodScope(scope, (ReferenceContext)pre, true);
        pre.binding = world.makeMethodBinding(AjcMemberMaker.preIntroducedConstructor(aspectTypeX, targetTypeX, EclipseFactory.fromBindings(((AbstractMethodDeclaration)this).binding.parameters)));
        pre.bindArguments();
        pre.bindThrownExceptions();
        pre.statements = explicitConstructorCall == null ? new Statement[0] : new Statement[]{explicitConstructorCall};
        InterTypeScope newParent = new InterTypeScope((Scope)scope, this.onTypeBinding);
        pre.scope.parent = newParent;
        pre.resolveStatements();
        int nParams = pre.arguments.length;
        MethodBinding explicitConstructor = null;
        if (explicitConstructorCall != null && (explicitConstructor = explicitConstructorCall.binding).alwaysNeedsAccessMethod()) {
            explicitConstructor = explicitConstructor.getAccessMethod(true);
        }
        int nExprs = explicitConstructor == null ? 0 : explicitConstructor.parameters.length;
        ArrayInitializer init = new ArrayInitializer();
        init.expressions = new Expression[nExprs + nParams];
        int index = 0;
        for (i = 0; i < nExprs; ++i) {
            if (i >= explicitConstructorCall.arguments.length) {
                init.expressions[index++] = new NullLiteral(0, 0);
                continue;
            }
            Object arg = explicitConstructorCall.arguments[i];
            ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod(EclipseFactory.fromBinding(explicitConstructorCall.binding.parameters[i]));
            if (conversionMethod != null) {
                arg = new KnownMessageSend(world.makeMethodBindingForCall(conversionMethod), (Expression)new CastExpression((Expression)new NullLiteral(0, 0), (Expression)AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
            }
            init.expressions[index++] = arg;
        }
        for (i = 0; i < nParams; ++i) {
            LocalVariableBinding binding = pre.arguments[i].binding;
            Object arg = AstUtil.makeResolvedLocalVariableReference(binding);
            ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod(EclipseFactory.fromBinding(binding.type));
            if (conversionMethod != null) {
                arg = new KnownMessageSend(world.makeMethodBindingForCall(conversionMethod), (Expression)new CastExpression((Expression)new NullLiteral(0, 0), (Expression)AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
            }
            init.expressions[index++] = arg;
        }
        init.binding = objectArrayBinding;
        ArrayAllocationExpression newArray = new ArrayAllocationExpression();
        newArray.initializer = init;
        newArray.type = AstUtil.makeTypeReference((TypeBinding)scope.getJavaLangObject());
        newArray.dimensions = new Expression[1];
        newArray.constant = ASTNode.NotAConstant;
        pre.statements = new Statement[]{new ReturnStatement((Expression)newArray, 0, 0)};
        return pre;
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)classScope);
        this.resolveOnType(classScope);
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return null;
        }
        ((AbstractMethodDeclaration)this).binding = classScope.referenceContext.binding.resolveTypesFor(((AbstractMethodDeclaration)this).binding);
        if (this.onTypeBinding.isInterface()) {
            classScope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "can't define constructors on interfaces");
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
            return null;
        }
        if (this.onTypeBinding.isNestedType()) {
            classScope.problemReporter().signalError(((ASTNode)this).sourceStart, ((ASTNode)this).sourceEnd, "can't define constructors on nested types (compiler limitation)");
            ((AbstractMethodDeclaration)this).ignoreFurtherInvestigation = true;
            return null;
        }
        ResolvedTypeX declaringTypeX = world.fromEclipse(this.onTypeBinding);
        ResolvedTypeX aspectType = world.fromEclipse((ReferenceBinding)classScope.referenceContext.binding);
        ResolvedMember bindingAsMember = EclipseFactory.makeResolvedMember(((AbstractMethodDeclaration)this).binding);
        ResolvedMember signature = new ResolvedMember(Member.CONSTRUCTOR, declaringTypeX, this.declaredModifiers, ResolvedTypeX.VOID, "<init>", bindingAsMember.getParameterTypes(), world.fromEclipse(((AbstractMethodDeclaration)this).binding.thrownExceptions));
        ResolvedMember syntheticInterMember = AjcMemberMaker.interConstructor(declaringTypeX, signature, aspectType);
        NewConstructorTypeMunger myMunger = new NewConstructorTypeMunger(signature, syntheticInterMember, null, null);
        this.setMunger(myMunger);
        myMunger.check(world.getWorld());
        ((AbstractMethodDeclaration)this).binding.selector = NameMangler.postIntroducedConstructor(EclipseFactory.fromBinding((TypeBinding)((AbstractMethodDeclaration)this).binding.declaringClass), declaringTypeX).toCharArray();
        ((AbstractMethodDeclaration)this).selector = ((AbstractMethodDeclaration)this).binding.selector;
        return new EclipseTypeMunger(world, myMunger, aspectType, (AbstractMethodDeclaration)this);
    }

    private AjAttribute makeAttribute(EclipseFactory world) {
        if (this.explicitConstructorCall != null && !(this.explicitConstructorCall.binding instanceof ProblemMethodBinding)) {
            MethodBinding explicitConstructor = this.explicitConstructorCall.binding;
            if (explicitConstructor.alwaysNeedsAccessMethod()) {
                explicitConstructor = explicitConstructor.getAccessMethod(true);
            }
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor(EclipseFactory.makeResolvedMember(explicitConstructor));
        } else {
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor(new ResolvedMember(Member.CONSTRUCTOR, EclipseFactory.fromBinding((TypeBinding)this.onTypeBinding.superclass()), 0, ResolvedTypeX.VOID, "<init>", TypeX.NONE));
        }
        return new AjAttribute.TypeMunger(this.munger);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (((AbstractMethodDeclaration)this).ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment((Scope)classScope);
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute(world)));
        super.generateCode(classScope, classFile);
        this.preMethod.generateCode(classScope, classFile);
    }

    protected Shadow.Kind getShadowKindForBody() {
        return Shadow.ConstructorExecution;
    }
}

