/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.AspectJElementHierarchy;
import org.aspectj.asm.internal.RelationshipMap;
import org.aspectj.bridge.ISourceLocation;

public class AsmManager {
    private static AsmManager INSTANCE = new AsmManager();
    private boolean shouldSaveModel = true;
    protected IHierarchy hierarchy;
    private List structureListeners = new ArrayList();
    private IRelationshipMap mapper;
    private static boolean dumpModel = false;
    private static boolean dumpRelationships = false;
    private static boolean dumpDeltaProcessing = false;
    private static String dumpFilename = "";
    private CanonicalFilePathMap canonicalFilePathMap = new CanonicalFilePathMap();

    protected AsmManager() {
        this.hierarchy = new AspectJElementHierarchy();
        this.mapper = new RelationshipMap(this.hierarchy);
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public static AsmManager getDefault() {
        return INSTANCE;
    }

    public IRelationshipMap getRelationshipMap() {
        return this.mapper;
    }

    public void fireModelUpdated() {
        this.notifyListeners();
        if (this.hierarchy.getConfigFile() != null) {
            this.writeStructureModel(this.hierarchy.getConfigFile());
        }
    }

    public HashMap getInlineAnnotations(String sourceFile, boolean showSubMember, boolean showMemberAndType) {
        if (!this.hierarchy.isValid()) {
            return null;
        }
        HashMap annotations = new HashMap();
        IProgramElement node = this.hierarchy.findElementForSourceFile(sourceFile);
        if (node == IHierarchy.NO_STRUCTURE) {
            return null;
        }
        IProgramElement fileNode = node;
        ArrayList peNodes = new ArrayList();
        this.getAllStructureChildren(fileNode, peNodes, showSubMember, showMemberAndType);
        Iterator it = ((AbstractList)peNodes).iterator();
        while (it.hasNext()) {
            IProgramElement peNode = (IProgramElement)it.next();
            ArrayList<IProgramElement> entries = new ArrayList<IProgramElement>();
            entries.add(peNode);
            ISourceLocation sourceLoc = peNode.getSourceLocation();
            if (null == sourceLoc) continue;
            Integer hash = new Integer(sourceLoc.getLine());
            List existingEntry = (List)annotations.get(hash);
            if (existingEntry != null) {
                entries.addAll(existingEntry);
            }
            annotations.put(hash, entries);
        }
        return annotations;
    }

    private void getAllStructureChildren(IProgramElement node, List result, boolean showSubMember, boolean showMemberAndType) {
        List children = node.getChildren();
        if (node.getChildren() == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            IProgramElement next = (IProgramElement)it.next();
            List rels = AsmManager.getDefault().getRelationshipMap().get(next);
            if (next != null && (next.getKind() == IProgramElement.Kind.CODE && showSubMember || next.getKind() != IProgramElement.Kind.CODE && showMemberAndType) && rels != null && rels.size() > 0) {
                result.add(next);
            }
            this.getAllStructureChildren(next, result, showSubMember, showMemberAndType);
        }
    }

    public void addListener(IHierarchyListener listener) {
        this.structureListeners.add(listener);
    }

    public void removeStructureListener(IHierarchyListener listener) {
        this.structureListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.structureListeners.clear();
    }

    private void notifyListeners() {
        Iterator it = this.structureListeners.iterator();
        while (it.hasNext()) {
            ((IHierarchyListener)it.next()).elementsUpdated(this.hierarchy);
        }
    }

    public void writeStructureModel(String configFilePath) {
        try {
            String filePath = this.genExternFilePath(configFilePath);
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(filePath));
            s.writeObject(this.hierarchy);
            s.writeObject(this.mapper);
            s.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readStructureModel(String configFilePath) {
        boolean hierarchyReadOK = false;
        try {
            if (configFilePath == null) {
                this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
            } else {
                String filePath = this.genExternFilePath(configFilePath);
                FileInputStream in = new FileInputStream(filePath);
                ObjectInputStream s = new ObjectInputStream(in);
                this.hierarchy = (AspectJElementHierarchy)s.readObject();
                hierarchyReadOK = true;
                this.mapper = (RelationshipMap)s.readObject();
                ((RelationshipMap)this.mapper).setHierarchy(this.hierarchy);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
        }
        catch (EOFException eofe) {
            if (!hierarchyReadOK) {
                System.err.println("AsmManager: Unable to read structure model: " + configFilePath + " because of:");
                eofe.printStackTrace();
                this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
            }
        }
        catch (Exception e) {
            this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
        }
        finally {
            this.notifyListeners();
        }
    }

    private String genExternFilePath(String configFilePath) {
        return configFilePath.substring(0, configFilePath.lastIndexOf(".lst")) + ".ajsym";
    }

    public void setShouldSaveModel(boolean shouldSaveModel) {
        this.shouldSaveModel = shouldSaveModel;
    }

    public String getCanonicalFilePath(File f) {
        return this.canonicalFilePathMap.get(f);
    }

    public static void setReporting(String filename, boolean dModel, boolean dRels, boolean dDeltaProcessing, boolean deletefile) {
        dumpModel = dModel;
        dumpRelationships = dRels;
        dumpDeltaProcessing = dDeltaProcessing;
        if (deletefile) {
            new File(filename).delete();
        }
        dumpFilename = filename;
    }

    public void reportModelInfo(String reasonForReport) {
        if (!dumpModel && !dumpRelationships) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(dumpFilename, true);
            BufferedWriter bw = new BufferedWriter(fw);
            if (dumpModel) {
                bw.write("=== MODEL STATUS REPORT ========= " + reasonForReport + "\n");
                this.dumptree(bw, AsmManager.getDefault().getHierarchy().getRoot(), 0);
                bw.write("=== END OF MODEL REPORT =========\n");
            }
            if (dumpRelationships) {
                bw.write("=== RELATIONSHIPS REPORT ========= " + reasonForReport + "\n");
                this.dumprels(bw);
                bw.write("=== END OF RELATIONSHIPS REPORT ==\n");
            }
            Properties p = this.calculateModelStatistics();
            Enumeration pkeyenum = ((Hashtable)p).keys();
            bw.write("=== Properties of the model and relationships map =====\n");
            while (pkeyenum.hasMoreElements()) {
                String pkey = (String)pkeyenum.nextElement();
                bw.write(pkey + "=" + p.getProperty(pkey) + "\n");
            }
            bw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.err.println("InternalError: Unable to report model information:");
            e.printStackTrace();
        }
    }

    public Properties calculateModelStatistics() {
        ModelInfo mi = new ModelInfo();
        IHierarchy model = AsmManager.getDefault().getHierarchy();
        this.summarizeModelHelper(model.getRoot(), mi);
        mi.setStatistic("FileMapSize", new Integer(model.getFileMapEntrySet().size()).toString());
        mi.setStatistic("RelationshipMapSize", new Integer(AsmManager.getDefault().getRelationshipMap().getEntries().size()).toString());
        return mi.toProperties();
    }

    private void summarizeModelHelper(IProgramElement ipe, ModelInfo mi) {
        mi.countNode(ipe);
        List kids = ipe.getChildren();
        Iterator iter = kids.iterator();
        while (iter.hasNext()) {
            IProgramElement ipe2 = (IProgramElement)iter.next();
            this.summarizeModelHelper(ipe2, mi);
        }
    }

    private void dumptree(Writer w, IProgramElement node, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            w.write(" ");
        }
        w.write(node + "  [" + (node == null ? "null" : node.getKind().toString()) + "]\n");
        if (node != null) {
            Iterator i = node.getChildren().iterator();
            while (i.hasNext()) {
                this.dumptree(w, (IProgramElement)i.next(), indent + 2);
            }
        }
    }

    private void dumprels(Writer w) throws IOException {
        IRelationshipMap irm = AsmManager.getDefault().getRelationshipMap();
        int ctr = 1;
        Set entries = irm.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            String hid = (String)iter.next();
            List rels = irm.get(hid);
            Iterator iterator = rels.iterator();
            while (iterator.hasNext()) {
                IRelationship ir = (IRelationship)iterator.next();
                List targets = ir.getTargets();
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    String thid = (String)iterator2.next();
                    w.write("Hid:" + ctr++ + ":(targets=" + targets.size() + ") " + hid + " (" + ir.getName() + ") " + thid + "\n");
                }
            }
        }
    }

    public void processDelta(List filesToBeCompiled, Set files_added, Set files_deleted) {
        try {
            String hid;
            Writer fw = null;
            if (dumpDeltaProcessing) {
                FileWriter filew = new FileWriter(dumpFilename, true);
                fw = new BufferedWriter(filew);
            }
            long stime = System.currentTimeMillis();
            IHierarchy model = AsmManager.getDefault().getHierarchy();
            if (dumpDeltaProcessing) {
                fw.write("=== Processing delta changes for the model ===\n");
                fw.write("Files for compilation:#" + filesToBeCompiled.size() + ":" + filesToBeCompiled + "\n");
                fw.write("Files added          :#" + files_added.size() + ":" + files_added + "\n");
                fw.write("Files deleted        :#" + files_deleted.size() + ":" + files_deleted + "\n");
            }
            boolean modelModified = false;
            HashSet filesToRemoveFromStructureModel = new HashSet(filesToBeCompiled);
            filesToRemoveFromStructureModel.addAll(files_deleted);
            Iterator iter = filesToRemoveFromStructureModel.iterator();
            while (iter.hasNext()) {
                File fileForCompilation = (File)iter.next();
                String correctedPath = AsmManager.getDefault().getCanonicalFilePath(fileForCompilation);
                IProgramElement progElem = (IProgramElement)model.findInFileMap(correctedPath);
                if (progElem == null) continue;
                if (dumpDeltaProcessing) {
                    fw.write("Deleting " + progElem + " node for file " + fileForCompilation + "\n");
                }
                this.removeNode(progElem);
                AsmManager.localassert(model.removeFromFileMap(correctedPath.toString()), "Whilst repairing model, couldn't remove entry for file: " + correctedPath.toString() + " from the filemap");
                modelModified = true;
            }
            long etime1 = System.currentTimeMillis();
            if (modelModified) {
                model.flushTypeMap();
                model.flushHandleMap();
            }
            if (dumpDeltaProcessing) {
                fw.write("Repairing relationships map:\n");
            }
            IRelationshipMap irm = AsmManager.getDefault().getRelationshipMap();
            HashSet<String> sourcesToRemove = new HashSet<String>();
            HashSet<String> nonExistingHandles = new HashSet<String>();
            int srchandlecounter = 0;
            int tgthandlecounter = 0;
            Set keyset = irm.getEntries();
            Iterator keyiter = keyset.iterator();
            while (keyiter.hasNext()) {
                hid = (String)keyiter.next();
                ++srchandlecounter;
                if (nonExistingHandles.contains(hid)) {
                    sourcesToRemove.add(hid);
                    continue;
                }
                IProgramElement existingElement = model.getElement(hid);
                if (dumpDeltaProcessing) {
                    fw.write("Looking for handle [" + hid + "] in model, found: " + existingElement + "\n");
                }
                if (existingElement == null) {
                    sourcesToRemove.add(hid);
                    nonExistingHandles.add(hid);
                    continue;
                }
                List relationships = irm.get(hid);
                ArrayList<IRelationship> relationshipsToRemove = new ArrayList<IRelationship>();
                Iterator reliter = relationships.iterator();
                while (reliter.hasNext()) {
                    IRelationship rel = (IRelationship)reliter.next();
                    List targets = rel.getTargets();
                    ArrayList<String> targetsToRemove = new ArrayList<String>();
                    Iterator targetIter = targets.iterator();
                    while (targetIter.hasNext()) {
                        String targethid = (String)targetIter.next();
                        ++tgthandlecounter;
                        if (nonExistingHandles.contains(targethid)) {
                            if (dumpDeltaProcessing) {
                                fw.write("Target handle [" + targethid + "] for srchid[" + hid + "]rel[" + rel.getName() + "] does not exist\n");
                            }
                            targetsToRemove.add(targethid);
                            continue;
                        }
                        IProgramElement existingTarget = model.getElement(targethid);
                        if (existingTarget != null) continue;
                        if (dumpDeltaProcessing) {
                            fw.write("Target handle [" + targethid + "] for srchid[" + hid + "]rel[" + rel.getName() + "] does not exist\n");
                        }
                        targetsToRemove.add(targethid);
                        nonExistingHandles.add(targethid);
                    }
                    if (targetsToRemove.size() == 0) continue;
                    if (targetsToRemove.size() == targets.size()) {
                        if (dumpDeltaProcessing) {
                            fw.write("No targets remain for srchid[" + hid + "] rel[" + rel.getName() + "]: removing it\n");
                        }
                        relationshipsToRemove.add(rel);
                        continue;
                    }
                    Iterator targsIter = targetsToRemove.iterator();
                    while (targsIter.hasNext()) {
                        String togo = (String)targsIter.next();
                        targets.remove(togo);
                    }
                    if (targets.size() != 0) continue;
                    if (dumpDeltaProcessing) {
                        fw.write("No targets remain for srchid[" + hid + "] rel[" + rel.getName() + "]: removing it\n");
                    }
                    relationshipsToRemove.add(rel);
                }
                if (relationshipsToRemove.size() <= 0) continue;
                if (relationshipsToRemove.size() == relationships.size()) {
                    sourcesToRemove.add(hid);
                    continue;
                }
                for (int i = 0; i < relationshipsToRemove.size(); ++i) {
                    IRelationship irel = (IRelationship)relationshipsToRemove.get(i);
                    AsmManager.localassert(irm.remove(hid, irel), "Failed to remove relationship " + irel.getName() + " for shid " + hid);
                }
                List rels = irm.get(hid);
                if (rels != null && rels.size() != 0) continue;
                sourcesToRemove.add(hid);
            }
            Iterator srciter = sourcesToRemove.iterator();
            while (srciter.hasNext()) {
                hid = (String)srciter.next();
                irm.removeAll(hid);
                IProgramElement ipe = model.getElement(hid);
                if (ipe == null || !ipe.getKind().equals(IProgramElement.Kind.CODE)) continue;
                this.removeSingleNode(ipe);
            }
            long etime2 = System.currentTimeMillis();
            if (dumpDeltaProcessing) {
                fw.write("===== Delta Processing timing ==========\n");
                fw.write("Hierarchy=" + (etime1 - stime) + "ms   Relationshipmap=" + (etime2 - etime1) + "ms\n");
                fw.write("===== Traversal ========================\n");
                fw.write("Source handles processed=" + srchandlecounter + "\n");
                fw.write("Target handles processed=" + tgthandlecounter + "\n");
                fw.write("========================================\n");
                fw.flush();
                fw.close();
            }
            System.err.println("Maptime=" + (etime2 - etime1) + "ms\n");
            this.reportModelInfo("After delta processing");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void removeSingleNode(IProgramElement progElem) {
        AsmManager.localassert(progElem != null);
        boolean deleteOK = false;
        IProgramElement parent = progElem.getParent();
        List kids = parent.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            if (!kids.get(i).equals(progElem)) continue;
            kids.remove(i);
            deleteOK = true;
            break;
        }
        AsmManager.localassert(deleteOK);
    }

    private void removeNode(IProgramElement progElem) {
        StringBuffer inflightdata = new StringBuffer();
        try {
            inflightdata.append("In removeNode, about to chuck away: " + progElem + "\n");
            AsmManager.localassert(progElem != null);
            boolean deleteOK = false;
            IProgramElement parent = progElem.getParent();
            inflightdata.append("Parent of it is " + parent + "\n");
            List kids = parent.getChildren();
            inflightdata.append("Which has " + kids.size() + " kids\n");
            for (int i = 0; i < kids.size(); ++i) {
                inflightdata.append("Comparing with " + kids.get(i) + "\n");
                if (!kids.get(i).equals(progElem)) continue;
                kids.remove(i);
                inflightdata.append("Removing it\n");
                deleteOK = true;
                break;
            }
            AsmManager.localassert(deleteOK, inflightdata);
            if (parent.getChildren().size() == 0 && parent.getParent() != null && (parent.getKind().equals(IProgramElement.Kind.CODE) || parent.getKind().equals(IProgramElement.Kind.PACKAGE))) {
                this.removeNode(parent);
            }
        }
        catch (NullPointerException npe) {
            System.err.println(inflightdata.toString());
            npe.printStackTrace();
        }
    }

    public static void localassert(boolean b, StringBuffer info) {
        if (!b) {
            System.err.println("=========== ASSERTION IS NOT TRUE =========v");
            System.err.println(info);
            Thread.dumpStack();
            System.err.println("=========== ASSERTION IS NOT TRUE =========^");
            throw new RuntimeException("Assertion is false");
        }
    }

    public static void localassert(boolean b, String info) {
        if (!b) {
            System.err.println("=========== ASSERTION IS NOT TRUE =========v");
            System.err.println(info);
            Thread.dumpStack();
            System.err.println("=========== ASSERTION IS NOT TRUE =========^");
            throw new RuntimeException("Assertion is false");
        }
    }

    public static void localassert(boolean b) {
        if (!b) {
            Thread.dumpStack();
            throw new RuntimeException("Assertion is false");
        }
    }

    public static class ModelInfo {
        private Hashtable nodeTypeCount = new Hashtable();
        private Properties extraProperties = new Properties();

        public void countNode(IProgramElement ipe) {
            String node = ipe.getKind().toString();
            Integer ctr = (Integer)this.nodeTypeCount.get(node);
            if (ctr == null) {
                this.nodeTypeCount.put(node, new Integer(1));
            } else {
                ctr = new Integer(ctr + 1);
                this.nodeTypeCount.put(node, ctr);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Model node summary:\n");
            Enumeration nodeKeys = this.nodeTypeCount.keys();
            while (nodeKeys.hasMoreElements()) {
                String key = (String)nodeKeys.nextElement();
                Integer ct = (Integer)this.nodeTypeCount.get(key);
                sb.append(key + "=" + ct + "\n");
            }
            sb.append("Model stats:\n");
            Enumeration ks = ((Hashtable)this.extraProperties).keys();
            while (ks.hasMoreElements()) {
                String k = (String)ks.nextElement();
                String v = this.extraProperties.getProperty(k);
                sb.append(k + "=" + v + "\n");
            }
            return sb.toString();
        }

        public Properties toProperties() {
            Properties p = new Properties();
            Enumeration nodeKeys = this.nodeTypeCount.keys();
            while (nodeKeys.hasMoreElements()) {
                String key = (String)nodeKeys.nextElement();
                Integer ct = (Integer)this.nodeTypeCount.get(key);
                p.setProperty(key, ct.toString());
            }
            ((Hashtable)p).putAll(this.extraProperties);
            return p;
        }

        public void setStatistic(String string, String string2) {
            this.extraProperties.setProperty(string, string2);
        }
    }

    private static class CanonicalFilePathMap {
        private static final int MAX_SIZE = 4000;
        private Map pathMap = new HashMap(4000);

        private CanonicalFilePathMap() {
        }

        public String get(File f) {
            String ret = (String)this.pathMap.get(f.getPath());
            if (ret == null) {
                try {
                    ret = f.getCanonicalPath();
                }
                catch (IOException ioEx) {
                    ret = f.getPath();
                }
                this.pathMap.put(f.getPath(), ret);
                if (this.pathMap.size() > 4000) {
                    this.pathMap.clear();
                }
            }
            return ret;
        }
    }
}

