/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelFieldRef;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelRenderer;
import org.aspectj.weaver.bcel.BcelVar;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.ExceptionRange;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.LocalVariableTag;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.ShadowRange;
import org.aspectj.weaver.bcel.Utility;

public class BcelShadow
extends Shadow {
    private ShadowRange range;
    private final BcelWorld world;
    private final LazyMethodGen enclosingMethod;
    private boolean fallsThrough;
    private BcelVar thisVar = null;
    private BcelVar targetVar = null;
    private BcelVar[] argVars = null;
    private BcelVar thisJoinPointVar = null;
    private boolean isThisJoinPointLazy;
    private int lazyTjpConsumers = 0;
    private BcelVar thisJoinPointStaticPartVar = null;

    public BcelShadow(BcelWorld world, Shadow.Kind kind, Member signature, LazyMethodGen enclosingMethod, BcelShadow enclosingShadow) {
        super(kind, signature, enclosingShadow);
        this.world = world;
        this.enclosingMethod = enclosingMethod;
        this.fallsThrough = kind.argsOnStack();
    }

    public BcelShadow copyInto(LazyMethodGen recipient, BcelShadow enclosing) {
        BcelShadow s = new BcelShadow(this.world, this.getKind(), this.getSignature(), recipient, enclosing);
        List src = this.mungers;
        List dest = s.mungers;
        Iterator i = src.iterator();
        while (i.hasNext()) {
            dest.add(i.next());
        }
        return s;
    }

    public World getIWorld() {
        return this.world;
    }

    private void deleteNewAndDup() {
        ConstantPoolGen cpg = this.getEnclosingClass().getConstantPoolGen();
        int depth = 1;
        InstructionHandle ih = this.range.getStart();
        while (true) {
            Instruction inst;
            if ((inst = ih.getInstruction()) instanceof INVOKESPECIAL && ((INVOKESPECIAL)inst).getName(cpg).equals("<init>")) {
                ++depth;
            } else if (inst instanceof NEW && --depth == 0) break;
            ih = ih.getPrev();
        }
        InstructionHandle newHandle = ih;
        InstructionHandle endHandle = newHandle.getNext();
        if (endHandle.getInstruction() instanceof DUP) {
            InstructionHandle nextHandle = endHandle.getNext();
            this.retargetFrom(newHandle, nextHandle);
            this.retargetFrom(endHandle, nextHandle);
        } else if (endHandle.getInstruction() instanceof DUP_X1) {
            InstructionHandle dupHandle = endHandle;
            endHandle = endHandle.getNext();
            InstructionHandle nextHandle = endHandle.getNext();
            if (!(endHandle.getInstruction() instanceof SWAP)) {
                throw new RuntimeException("Unhandled kind of new " + endHandle);
            }
            this.retargetFrom(newHandle, nextHandle);
            this.retargetFrom(dupHandle, nextHandle);
            this.retargetFrom(endHandle, nextHandle);
        } else {
            endHandle = newHandle;
            InstructionHandle nextHandle = endHandle.getNext();
            this.retargetFrom(newHandle, nextHandle);
            this.getRange().insert((Instruction)InstructionConstants.POP, Range.OutsideAfter);
        }
        try {
            this.range.getBody().delete(newHandle, endHandle);
        }
        catch (TargetLostException e) {
            throw new BCException("shouldn't happen");
        }
    }

    private void retargetFrom(InstructionHandle old, InstructionHandle fresh) {
        InstructionTargeter[] sources = old.getTargeters();
        if (sources != null) {
            for (int i = sources.length - 1; i >= 0; --i) {
                sources[i].updateTarget(old, fresh);
            }
        }
    }

    protected void prepareForMungers() {
        if (this.getKind() == Shadow.ConstructorCall) {
            this.deleteNewAndDup();
            this.initializeArgVars();
        } else if (this.getKind() == Shadow.ExceptionHandler) {
            ShadowRange range = this.getRange();
            InstructionList body = range.getBody();
            InstructionHandle start = range.getStart();
            InstructionHandle freshIh = body.insert(start, InstructionConstants.NOP);
            InstructionTargeter[] targeters = start.getTargeters();
            for (int i = 0; i < targeters.length; ++i) {
                InstructionTargeter t = targeters[i];
                if (!(t instanceof ExceptionRange)) continue;
                ExceptionRange er = (ExceptionRange)t;
                er.updateTarget(start, freshIh, body);
            }
        }
        this.isThisJoinPointLazy = this.world.isXlazyTjp();
        Iterator iter = this.mungers.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            munger.specializeOn(this);
        }
        this.initializeThisJoinPoint();
        InstructionFactory fact = this.getFactory();
        if (this.getKind().argsOnStack() && this.argVars != null) {
            this.range.insert(BcelRenderer.renderExprs(fact, this.world, this.argVars), Range.InsideBefore);
            if (this.targetVar != null) {
                this.range.insert(BcelRenderer.renderExpr(fact, this.world, this.targetVar), Range.InsideBefore);
            }
            if (this.getKind() == Shadow.ConstructorCall) {
                this.range.insert((Instruction)InstructionFactory.createDup((int)1), Range.InsideBefore);
                this.range.insert((Instruction)fact.createNew((ObjectType)BcelWorld.makeBcelType(this.getSignature().getDeclaringType())), Range.InsideBefore);
            }
        }
    }

    public ShadowRange getRange() {
        return this.range;
    }

    public void setRange(ShadowRange range) {
        this.range = range;
    }

    public int getSourceLine() {
        if (this.range == null) {
            if (this.getEnclosingMethod().hasBody()) {
                return Utility.getSourceLine(this.getEnclosingMethod().getBody().getStart());
            }
            return 0;
        }
        int ret = Utility.getSourceLine(this.range.getStart());
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    public TypeX getEnclosingType() {
        return this.getEnclosingClass().getType();
    }

    public LazyClassGen getEnclosingClass() {
        return this.enclosingMethod.getEnclosingClass();
    }

    public BcelWorld getWorld() {
        return this.world;
    }

    public static BcelShadow makeConstructorExecution(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle justBeforeStart) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.ConstructorExecution, world.makeMethodSignature(enclosingMethod), enclosingMethod, null);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, justBeforeStart.getNext()), Range.genEnd(body));
        return s;
    }

    public static BcelShadow makeStaticInitialization(BcelWorld world, LazyMethodGen enclosingMethod) {
        InvokeInstruction ii;
        InstructionList body = enclosingMethod.getBody();
        InstructionHandle clinitStart = body.getStart();
        if (clinitStart.getInstruction() instanceof InvokeInstruction && (ii = (InvokeInstruction)clinitStart.getInstruction()).getName(enclosingMethod.getEnclosingClass().getConstantPoolGen()).equals("ajc$preClinit")) {
            clinitStart = clinitStart.getNext();
        }
        InstructionHandle clinitEnd = body.getEnd();
        BcelShadow s = new BcelShadow(world, Shadow.StaticInitialization, world.makeMethodSignature(enclosingMethod), enclosingMethod, null);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, clinitStart), Range.genEnd(body, clinitEnd));
        return s;
    }

    public static BcelShadow makeExceptionHandler(BcelWorld world, ExceptionRange exceptionRange, LazyMethodGen enclosingMethod, InstructionHandle startOfHandler, BcelShadow enclosingShadow) {
        InstructionList body = enclosingMethod.getBody();
        TypeX catchType = exceptionRange.getCatchType();
        ResolvedTypeX inType = enclosingMethod.getEnclosingClass().getType();
        ResolvedMember sig = Member.makeExceptionHandlerSignature(inType, catchType);
        sig.parameterNames = new String[]{BcelShadow.findHandlerParamName(startOfHandler)};
        BcelShadow s = new BcelShadow(world, Shadow.ExceptionHandler, sig, enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        InstructionHandle start = Range.genStart(body, startOfHandler);
        InstructionHandle end = Range.genEnd(body, start);
        r.associateWithTargets(start, end);
        exceptionRange.updateTarget(startOfHandler, start, body);
        return s;
    }

    private static String findHandlerParamName(InstructionHandle startOfHandler) {
        if (startOfHandler.getInstruction() instanceof StoreInstruction && startOfHandler.getNext() != null) {
            int slot = ((StoreInstruction)startOfHandler.getInstruction()).getIndex();
            InstructionTargeter[] targeters = startOfHandler.getNext().getTargeters();
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    LocalVariableTag t;
                    if (!(targeters[i] instanceof LocalVariableTag) || (t = (LocalVariableTag)targeters[i]).getSlot() != slot) continue;
                    return t.getName();
                }
            }
        }
        return "<missing>";
    }

    public static BcelShadow makeIfaceInitialization(BcelWorld world, LazyMethodGen constructor, Member interfaceConstructorSignature) {
        InstructionList body = constructor.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.Initialization, interfaceConstructorSignature, constructor, null);
        s.fallsThrough = true;
        return s;
    }

    public void initIfaceInitializer(InstructionHandle end) {
        InstructionList body = this.enclosingMethod.getBody();
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(this);
        InstructionHandle nop = body.insert(end, InstructionConstants.NOP);
        r.associateWithTargets(Range.genStart(body, nop), Range.genEnd(body, nop));
    }

    public static BcelShadow makeUnfinishedInitialization(BcelWorld world, LazyMethodGen constructor) {
        return new BcelShadow(world, Shadow.Initialization, world.makeMethodSignature(constructor), constructor, null);
    }

    public static BcelShadow makeUnfinishedPreinitialization(BcelWorld world, LazyMethodGen constructor) {
        BcelShadow ret = new BcelShadow(world, Shadow.PreInitialization, world.makeMethodSignature(constructor), constructor, null);
        ret.fallsThrough = true;
        return ret;
    }

    public static BcelShadow makeMethodExecution(BcelWorld world, LazyMethodGen enclosingMethod, boolean lazyInit) {
        if (!lazyInit) {
            return BcelShadow.makeMethodExecution(world, enclosingMethod);
        }
        BcelShadow s = new BcelShadow(world, Shadow.MethodExecution, enclosingMethod.getMemberView(), enclosingMethod, null);
        return s;
    }

    public void init() {
        if (this.range != null) {
            return;
        }
        InstructionList body = this.enclosingMethod.getBody();
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(this);
        r.associateWithTargets(Range.genStart(body), Range.genEnd(body));
    }

    public static BcelShadow makeMethodExecution(BcelWorld world, LazyMethodGen enclosingMethod) {
        return BcelShadow.makeShadowForMethod(world, enclosingMethod, Shadow.MethodExecution, enclosingMethod.getMemberView());
    }

    public static BcelShadow makeShadowForMethod(BcelWorld world, LazyMethodGen enclosingMethod, Shadow.Kind kind, Member sig) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, kind, sig, enclosingMethod, null);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body), Range.genEnd(body));
        return s;
    }

    public static BcelShadow makeAdviceExecution(BcelWorld world, LazyMethodGen enclosingMethod) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.AdviceExecution, world.makeMethodSignature(enclosingMethod, Member.ADVICE), enclosingMethod, null);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body), Range.genEnd(body));
        return s;
    }

    public static BcelShadow makeConstructorCall(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle callHandle, BcelShadow enclosingShadow) {
        InstructionList body = enclosingMethod.getBody();
        Member sig = BcelWorld.makeMethodSignature(enclosingMethod.getEnclosingClass(), (InvokeInstruction)callHandle.getInstruction());
        BcelShadow s = new BcelShadow(world, Shadow.ConstructorCall, sig, enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, callHandle), Range.genEnd(body, callHandle));
        BcelShadow.retargetAllBranches(callHandle, r.getStart());
        return s;
    }

    public static BcelShadow makeMethodCall(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle callHandle, BcelShadow enclosingShadow) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.MethodCall, BcelWorld.makeMethodSignature(enclosingMethod.getEnclosingClass(), (InvokeInstruction)callHandle.getInstruction()), enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, callHandle), Range.genEnd(body, callHandle));
        BcelShadow.retargetAllBranches(callHandle, r.getStart());
        return s;
    }

    public static BcelShadow makeShadowForMethodCall(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle callHandle, BcelShadow enclosingShadow, Shadow.Kind kind, ResolvedMember sig) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, kind, sig, enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, callHandle), Range.genEnd(body, callHandle));
        BcelShadow.retargetAllBranches(callHandle, r.getStart());
        return s;
    }

    public static BcelShadow makeFieldGet(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle getHandle, BcelShadow enclosingShadow) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.FieldGet, BcelWorld.makeFieldSignature(enclosingMethod.getEnclosingClass(), (FieldInstruction)getHandle.getInstruction()), enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, getHandle), Range.genEnd(body, getHandle));
        BcelShadow.retargetAllBranches(getHandle, r.getStart());
        return s;
    }

    public static BcelShadow makeFieldSet(BcelWorld world, LazyMethodGen enclosingMethod, InstructionHandle setHandle, BcelShadow enclosingShadow) {
        InstructionList body = enclosingMethod.getBody();
        BcelShadow s = new BcelShadow(world, Shadow.FieldSet, BcelWorld.makeFieldSignature(enclosingMethod.getEnclosingClass(), (FieldInstruction)setHandle.getInstruction()), enclosingMethod, enclosingShadow);
        ShadowRange r = new ShadowRange(body);
        r.associateWithShadow(s);
        r.associateWithTargets(Range.genStart(body, setHandle), Range.genEnd(body, setHandle));
        BcelShadow.retargetAllBranches(setHandle, r.getStart());
        return s;
    }

    public static void retargetAllBranches(InstructionHandle from, InstructionHandle to) {
        InstructionTargeter[] sources = from.getTargeters();
        if (sources != null) {
            for (int i = sources.length - 1; i >= 0; --i) {
                InstructionTargeter source = sources[i];
                if (!(source instanceof BranchInstruction)) continue;
                source.updateTarget(from, to);
            }
        }
    }

    public boolean terminatesWithReturn() {
        return this.getRange().getRealNext() == null;
    }

    public boolean arg0HoldsThis() {
        if (this.getKind().isEnclosingKind()) {
            return !this.getSignature().isStatic();
        }
        if (this.enclosingShadow == null) {
            return !this.enclosingMethod.isStatic();
        }
        return ((BcelShadow)this.enclosingShadow).arg0HoldsThis();
    }

    public Var getThisVar() {
        if (!this.hasThis()) {
            throw new IllegalStateException("no this");
        }
        this.initializeThisVar();
        return this.thisVar;
    }

    public Var getTargetVar() {
        if (!this.hasTarget()) {
            throw new IllegalStateException("no target");
        }
        this.initializeTargetVar();
        return this.targetVar;
    }

    public Var getArgVar(int i) {
        this.initializeArgVars();
        return this.argVars[i];
    }

    public final Var getThisJoinPointStaticPartVar() {
        return this.getThisJoinPointStaticPartBcelVar();
    }

    public final Var getThisEnclosingJoinPointStaticPartVar() {
        return this.getThisEnclosingJoinPointStaticPartBcelVar();
    }

    public void requireThisJoinPoint(boolean hasGuardTest) {
        if (!hasGuardTest) {
            this.isThisJoinPointLazy = false;
        } else {
            ++this.lazyTjpConsumers;
        }
        if (this.thisJoinPointVar == null) {
            this.thisJoinPointVar = this.genTempVar(TypeX.forName("org.aspectj.lang.JoinPoint"));
        }
    }

    public Var getThisJoinPointVar() {
        this.requireThisJoinPoint(false);
        return this.thisJoinPointVar;
    }

    void initializeThisJoinPoint() {
        if (this.thisJoinPointVar == null) {
            return;
        }
        if (this.isThisJoinPointLazy) {
            this.isThisJoinPointLazy = this.checkLazyTjp();
        }
        if (this.isThisJoinPointLazy) {
            this.createThisJoinPoint();
            if (this.lazyTjpConsumers == 1) {
                return;
            }
            InstructionFactory fact = this.getFactory();
            InstructionList il = new InstructionList();
            il.append(InstructionConstants.ACONST_NULL);
            il.append(this.thisJoinPointVar.createStore(fact));
            this.range.insert(il, Range.OutsideBefore);
        } else {
            InstructionFactory fact = this.getFactory();
            InstructionList il = this.createThisJoinPoint();
            il.append(this.thisJoinPointVar.createStore(fact));
            this.range.insert(il, Range.OutsideBefore);
        }
    }

    private boolean checkLazyTjp() {
        Iterator i = this.mungers.iterator();
        while (i.hasNext()) {
            ShadowMunger munger = (ShadowMunger)i.next();
            if (!(munger instanceof Advice) || ((Advice)munger).getKind() != AdviceKind.Around) continue;
            this.world.getLint().canNotImplementLazyTjp.signal(new String[]{this.toString()}, this.getSourceLocation(), new ISourceLocation[]{munger.getSourceLocation()});
            return false;
        }
        return true;
    }

    InstructionList loadThisJoinPoint() {
        InstructionFactory fact = this.getFactory();
        InstructionList il = new InstructionList();
        if (this.isThisJoinPointLazy) {
            il.append(this.createThisJoinPoint());
            if (this.lazyTjpConsumers > 1) {
                il.append(this.thisJoinPointVar.createStore(fact));
                InstructionHandle end = il.append(this.thisJoinPointVar.createLoad(fact));
                il.insert(InstructionFactory.createBranchInstruction((short)199, (InstructionHandle)end));
                il.insert(this.thisJoinPointVar.createLoad(fact));
            }
        } else {
            this.thisJoinPointVar.appendLoad(il, fact);
        }
        return il;
    }

    InstructionList createThisJoinPoint() {
        InstructionFactory fact = this.getFactory();
        InstructionList il = new InstructionList();
        BcelVar staticPart = this.getThisJoinPointStaticPartBcelVar();
        staticPart.appendLoad(il, fact);
        if (this.hasThis()) {
            ((BcelVar)this.getThisVar()).appendLoad(il, fact);
        } else {
            il.append((Instruction)new ACONST_NULL());
        }
        if (this.hasTarget()) {
            ((BcelVar)this.getTargetVar()).appendLoad(il, fact);
        } else {
            il.append((Instruction)new ACONST_NULL());
        }
        switch (this.getArgCount()) {
            case 0: {
                il.append((Instruction)fact.createInvoke("org.aspectj.runtime.reflect.Factory", "makeJP", (Type)LazyClassGen.tjpType, new Type[]{LazyClassGen.staticTjpType, Type.OBJECT, Type.OBJECT}, (short)184));
                break;
            }
            case 1: {
                ((BcelVar)this.getArgVar(0)).appendLoadAndConvert(il, fact, this.world.resolve(TypeX.OBJECT));
                il.append((Instruction)fact.createInvoke("org.aspectj.runtime.reflect.Factory", "makeJP", (Type)LazyClassGen.tjpType, new Type[]{LazyClassGen.staticTjpType, Type.OBJECT, Type.OBJECT, Type.OBJECT}, (short)184));
                break;
            }
            case 2: {
                ((BcelVar)this.getArgVar(0)).appendLoadAndConvert(il, fact, this.world.resolve(TypeX.OBJECT));
                ((BcelVar)this.getArgVar(1)).appendLoadAndConvert(il, fact, this.world.resolve(TypeX.OBJECT));
                il.append((Instruction)fact.createInvoke("org.aspectj.runtime.reflect.Factory", "makeJP", (Type)LazyClassGen.tjpType, new Type[]{LazyClassGen.staticTjpType, Type.OBJECT, Type.OBJECT, Type.OBJECT, Type.OBJECT}, (short)184));
                break;
            }
            default: {
                il.append(this.makeArgsObjectArray());
                il.append((Instruction)fact.createInvoke("org.aspectj.runtime.reflect.Factory", "makeJP", (Type)LazyClassGen.tjpType, new Type[]{LazyClassGen.staticTjpType, Type.OBJECT, Type.OBJECT, new ArrayType((Type)Type.OBJECT, 1)}, (short)184));
            }
        }
        return il;
    }

    public BcelVar getThisJoinPointStaticPartBcelVar() {
        if (this.thisJoinPointStaticPartVar == null) {
            Field field = this.getEnclosingClass().getTjpField(this);
            this.thisJoinPointStaticPartVar = new BcelFieldRef(this.world.resolve(TypeX.forName("org.aspectj.lang.JoinPoint$StaticPart")), this.getEnclosingClass().getClassName(), field.getName());
        }
        return this.thisJoinPointStaticPartVar;
    }

    public BcelVar getThisEnclosingJoinPointStaticPartBcelVar() {
        if (this.enclosingShadow == null) {
            return this.getThisJoinPointStaticPartBcelVar();
        }
        return ((BcelShadow)this.enclosingShadow).getThisJoinPointStaticPartBcelVar();
    }

    public Member getEnclosingCodeSignature() {
        if (this.getKind().isEnclosingKind()) {
            return this.getSignature();
        }
        if (this.enclosingShadow == null) {
            return this.getEnclosingMethod().getMemberView();
        }
        return this.enclosingShadow.getSignature();
    }

    private InstructionList makeArgsObjectArray() {
        InstructionFactory fact = this.getFactory();
        BcelVar arrayVar = this.genTempVar(TypeX.OBJECTARRAY);
        InstructionList il = new InstructionList();
        int alen = this.getArgCount();
        il.append(Utility.createConstant(fact, alen));
        il.append(fact.createNewArray((Type)Type.OBJECT, (short)1));
        arrayVar.appendStore(il, fact);
        int stateIndex = 0;
        int len = this.getArgCount();
        for (int i = 0; i < len; ++i) {
            arrayVar.appendConvertableArrayStore(il, fact, stateIndex, (BcelVar)this.getArgVar(i));
            ++stateIndex;
        }
        arrayVar.appendLoad(il, fact);
        return il;
    }

    private void initializeThisVar() {
        if (this.thisVar != null) {
            return;
        }
        this.thisVar = new BcelVar(this.getThisType().resolve(this.world), 0);
        this.thisVar.setPositionInAroundState(0);
    }

    public void initializeTargetVar() {
        InstructionFactory fact = this.getFactory();
        if (this.targetVar != null) {
            return;
        }
        if (this.getKind().isTargetSameAsThis()) {
            if (this.hasThis()) {
                this.initializeThisVar();
            }
            this.targetVar = this.thisVar;
        } else {
            this.initializeArgVars();
            TypeX type = this.getTargetType();
            this.targetVar = this.genTempVar(type, "ajc$target");
            this.range.insert(this.targetVar.createStore(fact), Range.OutsideBefore);
            this.targetVar.setPositionInAroundState(this.hasThis() ? 1 : 0);
        }
    }

    public void initializeArgVars() {
        if (this.argVars != null) {
            return;
        }
        InstructionFactory fact = this.getFactory();
        int len = this.getArgCount();
        this.argVars = new BcelVar[len];
        int positionOffset = (this.hasTarget() ? 1 : 0) + (this.hasThis() && !this.getKind().isTargetSameAsThis() ? 1 : 0);
        if (this.getKind().argsOnStack()) {
            for (int i = len - 1; i >= 0; --i) {
                TypeX type = this.getArgType(i);
                BcelVar tmp = this.genTempVar(type, "ajc$arg" + i);
                this.range.insert(tmp.createStore(this.getFactory()), Range.OutsideBefore);
                int position = i;
                tmp.setPositionInAroundState(position += positionOffset);
                this.argVars[i] = tmp;
            }
        } else {
            int index = 0;
            if (this.arg0HoldsThis()) {
                ++index;
            }
            for (int i = 0; i < len; ++i) {
                TypeX type = this.getArgType(i);
                BcelVar tmp = this.genTempVar(type, "ajc$arg" + i);
                this.range.insert(tmp.createCopyFrom(fact, index), Range.OutsideBefore);
                this.argVars[i] = tmp;
                int position = i;
                tmp.setPositionInAroundState(position += positionOffset);
                index += type.getSize();
            }
        }
    }

    public void initializeForAroundClosure() {
        this.initializeArgVars();
        if (this.hasTarget()) {
            this.initializeTargetVar();
        }
        if (this.hasThis()) {
            this.initializeThisVar();
        }
    }

    void weaveBefore(BcelAdvice munger) {
        this.range.insert(munger.getAdviceInstructions(this, null, this.range.getRealStart()), Range.InsideBefore);
    }

    public void weaveAfter(BcelAdvice munger) {
        this.weaveAfterThrowing(munger, TypeX.THROWABLE);
        this.weaveAfterReturning(munger);
    }

    public void weaveAfterReturning(BcelAdvice munger) {
        InstructionHandle afterAdvice;
        InstructionList retList;
        ArrayList<InstructionHandle> returns = new ArrayList<InstructionHandle>();
        Instruction ret = null;
        for (InstructionHandle ih = this.range.getStart(); ih != this.range.getEnd(); ih = ih.getNext()) {
            if (!(ih.getInstruction() instanceof ReturnInstruction)) continue;
            returns.add(ih);
            ret = Utility.copyInstruction(ih.getInstruction());
        }
        if (ret != null) {
            retList = new InstructionList(ret);
            afterAdvice = retList.getStart();
        } else {
            retList = new InstructionList(InstructionConstants.NOP);
            afterAdvice = retList.getStart();
        }
        InstructionList advice = new InstructionList();
        BcelVar tempVar = null;
        if (munger.hasExtraParameter()) {
            TypeX tempVarType = this.getReturnType();
            if (tempVarType.equals(ResolvedTypeX.VOID)) {
                tempVar = this.genTempVar(TypeX.OBJECT);
                advice.append(InstructionConstants.ACONST_NULL);
                tempVar.appendStore(advice, this.getFactory());
            } else {
                tempVar = this.genTempVar(tempVarType);
                advice.append((Instruction)InstructionFactory.createDup((int)tempVarType.getSize()));
                tempVar.appendStore(advice, this.getFactory());
            }
        }
        advice.append(munger.getAdviceInstructions(this, tempVar, afterAdvice));
        if (ret != null) {
            InstructionHandle gotoTarget = advice.getStart();
            Iterator i = returns.iterator();
            while (i.hasNext()) {
                InstructionHandle ih = (InstructionHandle)i.next();
                Utility.replaceInstruction(ih, InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)gotoTarget), this.enclosingMethod);
            }
            this.range.append(advice);
            this.range.append(retList);
        } else {
            this.range.append(advice);
            this.range.append(retList);
        }
    }

    public void weaveAfterThrowing(BcelAdvice munger, TypeX catchType) {
        if (this.getRange().getStart().getNext() == this.getRange().getEnd()) {
            return;
        }
        InstructionFactory fact = this.getFactory();
        InstructionList handler = new InstructionList();
        BcelVar exceptionVar = this.genTempVar(catchType);
        exceptionVar.appendStore(handler, fact);
        InstructionList endHandler = new InstructionList(exceptionVar.createLoad(fact));
        handler.append(munger.getAdviceInstructions(this, exceptionVar, endHandler.getStart()));
        handler.append(endHandler);
        handler.append(InstructionConstants.ATHROW);
        InstructionHandle handlerStart = handler.getStart();
        if (this.isFallsThrough()) {
            InstructionHandle jumpTarget = handler.append(InstructionConstants.NOP);
            handler.insert(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)jumpTarget));
        }
        InstructionHandle protectedEnd = handler.getStart();
        this.range.insert(handler, Range.InsideAfter);
        this.enclosingMethod.addExceptionHandler(this.range.getStart().getNext(), protectedEnd.getPrev(), handlerStart, (ObjectType)BcelWorld.makeBcelType(catchType), this.getKind().hasHighPriorityExceptions());
    }

    public void weaveSoftener(BcelAdvice munger, TypeX catchType) {
        if (this.getRange().getStart().getNext() == this.getRange().getEnd()) {
            return;
        }
        InstructionFactory fact = this.getFactory();
        InstructionList handler = new InstructionList();
        BcelVar exceptionVar = this.genTempVar(catchType);
        exceptionVar.appendStore(handler, fact);
        handler.append((Instruction)fact.createNew("org.aspectj.lang.SoftException"));
        handler.append((Instruction)InstructionFactory.createDup((int)1));
        handler.append(exceptionVar.createLoad(fact));
        handler.append((Instruction)fact.createInvoke("org.aspectj.lang.SoftException", "<init>", (Type)Type.VOID, new Type[]{Type.THROWABLE}, (short)183));
        handler.append(InstructionConstants.ATHROW);
        InstructionHandle handlerStart = handler.getStart();
        if (this.isFallsThrough()) {
            InstructionHandle jumpTarget = this.range.getEnd();
            handler.insert(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)jumpTarget));
        }
        InstructionHandle protectedEnd = handler.getStart();
        this.range.insert(handler, Range.InsideAfter);
        this.enclosingMethod.addExceptionHandler(this.range.getStart().getNext(), protectedEnd.getPrev(), handlerStart, (ObjectType)BcelWorld.makeBcelType(catchType), this.getKind().hasHighPriorityExceptions());
    }

    public void weavePerObjectEntry(BcelAdvice munger, BcelVar onVar) {
        InstructionFactory fact = this.getFactory();
        InstructionList entryInstructions = new InstructionList();
        InstructionList entrySuccessInstructions = new InstructionList();
        onVar.appendLoad(entrySuccessInstructions, fact);
        entrySuccessInstructions.append(Utility.createInvoke(fact, this.world, AjcMemberMaker.perObjectBind(munger.getConcreteAspect())));
        InstructionList testInstructions = munger.getTestInstructions(this, entrySuccessInstructions.getStart(), this.range.getRealStart(), entrySuccessInstructions.getStart());
        entryInstructions.append(testInstructions);
        entryInstructions.append(entrySuccessInstructions);
        this.range.insert(entryInstructions, Range.InsideBefore);
    }

    public void weaveCflowEntry(final BcelAdvice munger, final Member cflowStackField) {
        boolean isPer = munger.getKind() == AdviceKind.PerCflowBelowEntry || munger.getKind() == AdviceKind.PerCflowEntry;
        ArrayType objectArrayType = new ArrayType((Type)Type.OBJECT, 1);
        final InstructionFactory fact = this.getFactory();
        final BcelVar testResult = this.genTempVar(ResolvedTypeX.BOOLEAN);
        InstructionList entryInstructions = new InstructionList();
        InstructionList entrySuccessInstructions = new InstructionList();
        if (munger.hasDynamicTests()) {
            entryInstructions.append(Utility.createConstant(fact, 0));
            testResult.appendStore(entryInstructions, fact);
            entrySuccessInstructions.append(Utility.createConstant(fact, 1));
            testResult.appendStore(entrySuccessInstructions, fact);
        }
        if (isPer) {
            entrySuccessInstructions.append((Instruction)fact.createInvoke(munger.getConcreteAspect().getName(), "ajc$perCflowPush", (Type)Type.VOID, new Type[0], (short)184));
        } else {
            BcelVar[] cflowStateVars = munger.getExposedStateAsBcelVars();
            BcelVar arrayVar = this.genTempVar(TypeX.OBJECTARRAY);
            int alen = cflowStateVars.length;
            entrySuccessInstructions.append(Utility.createConstant(fact, alen));
            entrySuccessInstructions.append(fact.createNewArray((Type)Type.OBJECT, (short)1));
            arrayVar.appendStore(entrySuccessInstructions, fact);
            for (int i = 0; i < alen; ++i) {
                arrayVar.appendConvertableArrayStore(entrySuccessInstructions, fact, i, cflowStateVars[i]);
            }
            entrySuccessInstructions.append(Utility.createGet(fact, cflowStackField));
            arrayVar.appendLoad(entrySuccessInstructions, fact);
            entrySuccessInstructions.append((Instruction)fact.createInvoke("org.aspectj.runtime.internal.CFlowStack", "push", (Type)Type.VOID, new Type[]{objectArrayType}, (short)182));
        }
        InstructionList testInstructions = munger.getTestInstructions(this, entrySuccessInstructions.getStart(), this.range.getRealStart(), entrySuccessInstructions.getStart());
        entryInstructions.append(testInstructions);
        entryInstructions.append(entrySuccessInstructions);
        this.weaveAfter(new BcelAdvice(null, null, null, 0, 0, 0, null, null){

            public InstructionList getAdviceInstructions(BcelShadow s, BcelVar extraArgVar, InstructionHandle ifNoAdvice) {
                InstructionList exitInstructions = new InstructionList();
                if (munger.hasDynamicTests()) {
                    testResult.appendLoad(exitInstructions, fact);
                    exitInstructions.append(InstructionFactory.createBranchInstruction((short)153, (InstructionHandle)ifNoAdvice));
                }
                exitInstructions.append(Utility.createGet(fact, cflowStackField));
                exitInstructions.append((Instruction)fact.createInvoke("org.aspectj.runtime.internal.CFlowStack", "pop", (Type)Type.VOID, new Type[0], (short)182));
                return exitInstructions;
            }
        });
        this.range.insert(entryInstructions, Range.InsideBefore);
    }

    public void weaveAroundInline(BcelAdvice munger, boolean hasDynamicTest) {
        Member mungerSig = munger.getSignature();
        ResolvedTypeX declaringType = this.world.resolve(mungerSig.getDeclaringType());
        BcelObjectType ot = BcelWorld.getBcelObjectType(declaringType);
        LazyMethodGen adviceMethod = ot.getLazyClassGen().getLazyMethodGen(mungerSig);
        if (!adviceMethod.getCanInline()) {
            this.weaveAroundClosure(munger, hasDynamicTest);
            return;
        }
        this.enclosingMethod.setCanInline(false);
        InstructionFactory fact = this.getFactory();
        LazyMethodGen extractedMethod = this.extractMethod(NameMangler.aroundCallbackMethodName(this.getSignature(), this.getEnclosingClass()), 2, munger);
        String adviceMethodName = NameMangler.aroundCallbackMethodName(this.getSignature(), this.getEnclosingClass()) + "$advice";
        ArrayList<BcelVar> argVarList = new ArrayList<BcelVar>();
        ArrayList<BcelVar> proceedVarList = new ArrayList<BcelVar>();
        int extraParamOffset = 0;
        if (this.thisVar != null) {
            argVarList.add(this.thisVar);
            proceedVarList.add(new BcelVar(this.thisVar.getType(), extraParamOffset));
            extraParamOffset += this.thisVar.getType().getSize();
        }
        if (this.targetVar != null && this.targetVar != this.thisVar) {
            argVarList.add(this.targetVar);
            proceedVarList.add(new BcelVar(this.targetVar.getType(), extraParamOffset));
            extraParamOffset += this.targetVar.getType().getSize();
        }
        int len = this.getArgCount();
        for (int i = 0; i < len; ++i) {
            argVarList.add(this.argVars[i]);
            proceedVarList.add(new BcelVar(this.argVars[i].getType(), extraParamOffset));
            extraParamOffset += this.argVars[i].getType().getSize();
        }
        if (this.thisJoinPointVar != null) {
            argVarList.add(this.thisJoinPointVar);
            proceedVarList.add(new BcelVar(this.thisJoinPointVar.getType(), extraParamOffset));
            extraParamOffset += this.thisJoinPointVar.getType().getSize();
        }
        Type[] adviceParameterTypes = adviceMethod.getArgumentTypes();
        Type[] extractedMethodParameterTypes = extractedMethod.getArgumentTypes();
        Type[] parameterTypes = new Type[extractedMethodParameterTypes.length + adviceParameterTypes.length + 1];
        int parameterIndex = 0;
        System.arraycopy(extractedMethodParameterTypes, 0, parameterTypes, parameterIndex, extractedMethodParameterTypes.length);
        parameterIndex += extractedMethodParameterTypes.length;
        parameterTypes[parameterIndex++] = BcelWorld.makeBcelType(adviceMethod.getEnclosingClass().getType());
        System.arraycopy(adviceParameterTypes, 0, parameterTypes, parameterIndex, adviceParameterTypes.length);
        LazyMethodGen localAdviceMethod = new LazyMethodGen(26, adviceMethod.getReturnType(), adviceMethodName, parameterTypes, new String[0], this.getEnclosingClass());
        String donorFileName = adviceMethod.getEnclosingClass().getInternalFileName();
        String recipientFileName = this.getEnclosingClass().getInternalFileName();
        if (!donorFileName.equals(recipientFileName)) {
            localAdviceMethod.fromFilename = donorFileName;
            this.getEnclosingClass().addInlinedSourceFileInfo(donorFileName, adviceMethod.highestLineNumber);
        }
        this.getEnclosingClass().addMethodGen(localAdviceMethod);
        int nVars = adviceMethod.getMaxLocals() + extraParamOffset;
        IntMap varMap = IntMap.idMap(nVars);
        for (int i = extraParamOffset; i < nVars; ++i) {
            varMap.put(i - extraParamOffset, i);
        }
        localAdviceMethod.getBody().insert(BcelClassWeaver.genInlineInstructions(adviceMethod, localAdviceMethod, varMap, fact, true));
        localAdviceMethod.setMaxLocals(nVars);
        InstructionList advice = new InstructionList();
        Iterator i = argVarList.iterator();
        while (i.hasNext()) {
            BcelVar var = (BcelVar)i.next();
            var.appendLoad(advice, fact);
        }
        advice.append(munger.getAdviceArgSetup(this, null, new InstructionList(InstructionConstants.ACONST_NULL)));
        advice.append(Utility.createInvoke(fact, localAdviceMethod));
        advice.append(Utility.createConversion(this.getFactory(), BcelWorld.makeBcelType(munger.getSignature().getReturnType()), extractedMethod.getReturnType()));
        if (!this.isFallsThrough()) {
            advice.append((Instruction)InstructionFactory.createReturn((Type)extractedMethod.getReturnType()));
        }
        if (!hasDynamicTest) {
            this.range.append(advice);
        } else {
            InstructionList afterThingie = new InstructionList(InstructionConstants.NOP);
            InstructionList callback = this.makeCallToCallback(extractedMethod);
            if (this.terminatesWithReturn()) {
                callback.append((Instruction)InstructionFactory.createReturn((Type)extractedMethod.getReturnType()));
            } else {
                advice.append(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)afterThingie.getStart()));
            }
            this.range.append(munger.getTestInstructions(this, advice.getStart(), callback.getStart(), advice.getStart()));
            this.range.append(advice);
            this.range.append(callback);
            this.range.append(afterThingie);
        }
        String proceedName = NameMangler.proceedMethodName(munger.getSignature().getName());
        InstructionHandle curr = localAdviceMethod.getBody().getStart();
        InstructionHandle end = localAdviceMethod.getBody().getEnd();
        ConstantPoolGen cpg = localAdviceMethod.getEnclosingClass().getConstantPoolGen();
        while (curr != end) {
            InstructionHandle next = curr.getNext();
            Instruction inst = curr.getInstruction();
            if (inst instanceof INVOKESTATIC && proceedName.equals(((INVOKESTATIC)inst).getMethodName(cpg))) {
                localAdviceMethod.getBody().append(curr, this.getRedoneProceedCall(fact, extractedMethod, munger, localAdviceMethod, proceedVarList));
                Utility.deleteInstruction(curr, localAdviceMethod);
            }
            curr = next;
        }
    }

    private InstructionList getRedoneProceedCall(InstructionFactory fact, LazyMethodGen callbackMethod, BcelAdvice munger, LazyMethodGen localAdviceMethod, List argVarList) {
        InstructionList ret = new InstructionList();
        BcelVar[] adviceVars = munger.getExposedStateAsBcelVars();
        IntMap proceedMap = this.makeProceedArgumentMap(adviceVars);
        ResolvedTypeX[] proceedParamTypes = this.world.resolve(munger.getSignature().getParameterTypes());
        if (munger.getBaseParameterCount() + 1 < proceedParamTypes.length) {
            int len = munger.getBaseParameterCount() + 1;
            ResolvedTypeX[] newTypes = new ResolvedTypeX[len];
            System.arraycopy(proceedParamTypes, 0, newTypes, 0, len);
            proceedParamTypes = newTypes;
        }
        BcelVar[] proceedVars = Utility.pushAndReturnArrayOfVars(proceedParamTypes, ret, fact, localAdviceMethod);
        Type[] stateTypes = callbackMethod.getArgumentTypes();
        int len = stateTypes.length;
        for (int i = 0; i < len; ++i) {
            Type stateType = stateTypes[i];
            ResolvedTypeX stateTypeX = BcelWorld.fromBcel(stateType).resolve(this.world);
            if (proceedMap.hasKey(i)) {
                proceedVars[proceedMap.get(i)].appendLoadAndConvert(ret, fact, stateTypeX);
                continue;
            }
            ((BcelVar)argVarList.get(i)).appendLoad(ret, fact);
        }
        ret.append(Utility.createInvoke(fact, callbackMethod));
        ret.append(Utility.createConversion(fact, callbackMethod.getReturnType(), BcelWorld.makeBcelType(munger.getSignature().getReturnType())));
        return ret;
    }

    public void weaveAroundClosure(BcelAdvice munger, boolean hasDynamicTest) {
        InstructionList returnConversionCode;
        InstructionFactory fact = this.getFactory();
        this.enclosingMethod.setCanInline(false);
        LazyMethodGen callbackMethod = this.extractMethod(NameMangler.aroundCallbackMethodName(this.getSignature(), this.getEnclosingClass()), 0, munger);
        BcelVar[] adviceVars = munger.getExposedStateAsBcelVars();
        String closureClassName = NameMangler.makeClosureClassName(this.getEnclosingClass().getType(), this.getEnclosingClass().getNewGeneratedNameTag());
        Member constructorSig = new Member(Member.CONSTRUCTOR, TypeX.forName(closureClassName), 0, "<init>", "([Ljava/lang/Object;)V");
        BcelVar closureHolder = null;
        if (this.getKind() == Shadow.PreInitialization) {
            closureHolder = this.genTempVar(AjcMemberMaker.AROUND_CLOSURE_TYPE);
        }
        InstructionList closureInstantiation = this.makeClosureInstantiation(constructorSig, closureHolder);
        this.makeClosureClassAndReturnConstructor(closureClassName, callbackMethod, this.makeProceedArgumentMap(adviceVars));
        if (this.getKind() == Shadow.PreInitialization) {
            returnConversionCode = new InstructionList();
            BcelVar stateTempVar = this.genTempVar(TypeX.OBJECTARRAY);
            closureHolder.appendLoad(returnConversionCode, fact);
            returnConversionCode.append(Utility.createInvoke(fact, this.world, AjcMemberMaker.aroundClosurePreInitializationGetter()));
            stateTempVar.appendStore(returnConversionCode, fact);
            Type[] stateTypes = this.getSuperConstructorParameterTypes();
            returnConversionCode.append((Instruction)InstructionConstants.ALOAD_0);
            int len = stateTypes.length;
            for (int i = 0; i < len; ++i) {
                stateTempVar.appendConvertableArrayLoad(returnConversionCode, fact, i, this.world.resolve(BcelWorld.fromBcel(stateTypes[i])));
            }
        } else {
            returnConversionCode = Utility.createConversion(this.getFactory(), BcelWorld.makeBcelType(munger.getSignature().getReturnType()), callbackMethod.getReturnType());
            if (!this.isFallsThrough()) {
                returnConversionCode.append((Instruction)InstructionFactory.createReturn((Type)callbackMethod.getReturnType()));
            }
        }
        InstructionList advice = new InstructionList();
        advice.append(munger.getAdviceArgSetup(this, null, closureInstantiation));
        advice.append(munger.getNonTestAdviceInstructions(this));
        advice.append(returnConversionCode);
        if (!hasDynamicTest) {
            this.range.append(advice);
        } else {
            InstructionList callback = this.makeCallToCallback(callbackMethod);
            InstructionList postCallback = new InstructionList();
            if (this.terminatesWithReturn()) {
                callback.append((Instruction)InstructionFactory.createReturn((Type)callbackMethod.getReturnType()));
            } else {
                advice.append(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)postCallback.append(InstructionConstants.NOP)));
            }
            this.range.append(munger.getTestInstructions(this, advice.getStart(), callback.getStart(), advice.getStart()));
            this.range.append(advice);
            this.range.append(callback);
            this.range.append(postCallback);
        }
    }

    InstructionList makeCallToCallback(LazyMethodGen callbackMethod) {
        InstructionFactory fact = this.getFactory();
        InstructionList callback = new InstructionList();
        if (this.thisVar != null) {
            callback.append((Instruction)InstructionConstants.ALOAD_0);
        }
        if (this.targetVar != null && this.targetVar != this.thisVar) {
            callback.append(BcelRenderer.renderExpr(fact, this.world, this.targetVar));
        }
        callback.append(BcelRenderer.renderExprs(fact, this.world, this.argVars));
        if (this.thisJoinPointVar != null) {
            callback.append(BcelRenderer.renderExpr(fact, this.world, this.thisJoinPointVar));
        }
        callback.append(Utility.createInvoke(fact, callbackMethod));
        return callback;
    }

    private InstructionList makeClosureInstantiation(Member constructor, BcelVar holder) {
        InstructionFactory fact = this.getFactory();
        BcelVar arrayVar = this.genTempVar(TypeX.OBJECTARRAY);
        InstructionList il = new InstructionList();
        int alen = this.getArgCount() + (this.thisVar == null ? 0 : 1) + (this.targetVar != null && this.targetVar != this.thisVar ? 1 : 0) + (this.thisJoinPointVar == null ? 0 : 1);
        il.append(Utility.createConstant(fact, alen));
        il.append(fact.createNewArray((Type)Type.OBJECT, (short)1));
        arrayVar.appendStore(il, fact);
        int stateIndex = 0;
        if (this.thisVar != null) {
            arrayVar.appendConvertableArrayStore(il, fact, stateIndex, this.thisVar);
            this.thisVar.setPositionInAroundState(stateIndex);
            ++stateIndex;
        }
        if (this.targetVar != null && this.targetVar != this.thisVar) {
            arrayVar.appendConvertableArrayStore(il, fact, stateIndex, this.targetVar);
            this.targetVar.setPositionInAroundState(stateIndex);
            ++stateIndex;
        }
        int len = this.getArgCount();
        for (int i = 0; i < len; ++i) {
            arrayVar.appendConvertableArrayStore(il, fact, stateIndex, this.argVars[i]);
            this.argVars[i].setPositionInAroundState(stateIndex);
            ++stateIndex;
        }
        if (this.thisJoinPointVar != null) {
            arrayVar.appendConvertableArrayStore(il, fact, stateIndex, this.thisJoinPointVar);
            this.thisJoinPointVar.setPositionInAroundState(stateIndex);
            ++stateIndex;
        }
        il.append((Instruction)fact.createNew(new ObjectType(constructor.getDeclaringType().getName())));
        il.append((Instruction)new DUP());
        arrayVar.appendLoad(il, fact);
        il.append(Utility.createInvoke(fact, this.world, constructor));
        if (this.getKind() == Shadow.PreInitialization) {
            il.append((Instruction)InstructionConstants.DUP);
            holder.appendStore(il, fact);
        }
        return il;
    }

    private IntMap makeProceedArgumentMap(BcelVar[] adviceArgs) {
        IntMap ret = new IntMap();
        int len = adviceArgs.length;
        for (int i = 0; i < len; ++i) {
            int pos;
            BcelVar v = adviceArgs[i];
            if (v == null || (pos = v.getPositionInAroundState()) < 0) continue;
            ret.put(pos, i);
        }
        return ret;
    }

    private LazyMethodGen makeClosureClassAndReturnConstructor(String closureClassName, LazyMethodGen callbackMethod, IntMap proceedMap) {
        String superClassName = "org.aspectj.runtime.internal.AroundClosure";
        ArrayType objectArrayType = new ArrayType((Type)Type.OBJECT, 1);
        LazyClassGen closureClass = new LazyClassGen(closureClassName, superClassName, this.getEnclosingClass().getFileName(), 1, new String[0]);
        InstructionFactory fact = new InstructionFactory(closureClass.getConstantPoolGen());
        LazyMethodGen constructor = new LazyMethodGen(1, (Type)Type.VOID, "<init>", new Type[]{objectArrayType}, new String[0], closureClass);
        InstructionList cbody = constructor.getBody();
        cbody.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        cbody.append((Instruction)InstructionFactory.createLoad((Type)objectArrayType, (int)1));
        cbody.append((Instruction)fact.createInvoke(superClassName, "<init>", (Type)Type.VOID, new Type[]{objectArrayType}, (short)183));
        cbody.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        closureClass.addMethodGen(constructor);
        LazyMethodGen runMethod = new LazyMethodGen(1, (Type)Type.OBJECT, "run", new Type[]{objectArrayType}, new String[0], closureClass);
        InstructionList mbody = runMethod.getBody();
        BcelVar proceedVar = new BcelVar(TypeX.OBJECTARRAY.resolve(this.world), 1);
        BcelVar stateVar = new BcelVar(TypeX.OBJECTARRAY.resolve(this.world), runMethod.allocateLocal(1));
        mbody.append(InstructionFactory.createThis());
        mbody.append((Instruction)fact.createGetField(superClassName, "state", (Type)objectArrayType));
        mbody.append(stateVar.createStore(fact));
        Type[] stateTypes = callbackMethod.getArgumentTypes();
        int len = stateTypes.length;
        for (int i = 0; i < len; ++i) {
            Type stateType = stateTypes[i];
            ResolvedTypeX stateTypeX = BcelWorld.fromBcel(stateType).resolve(this.world);
            if (proceedMap.hasKey(i)) {
                mbody.append(proceedVar.createConvertableArrayLoad(fact, proceedMap.get(i), stateTypeX));
                continue;
            }
            mbody.append(stateVar.createConvertableArrayLoad(fact, i, stateTypeX));
        }
        mbody.append(Utility.createInvoke(fact, callbackMethod));
        if (this.getKind() == Shadow.PreInitialization) {
            mbody.append(Utility.createSet(fact, AjcMemberMaker.aroundClosurePreInitializationField()));
            mbody.append(InstructionConstants.ACONST_NULL);
        } else {
            mbody.append(Utility.createConversion(fact, callbackMethod.getReturnType(), (Type)Type.OBJECT));
        }
        mbody.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        closureClass.addMethodGen(runMethod);
        this.getEnclosingClass().addGeneratedInner(closureClass);
        return constructor;
    }

    public LazyMethodGen extractMethod(String newMethodName, int visibilityModifier, ShadowMunger munger) {
        LazyMethodGen.assertGoodBody(this.range.getBody(), newMethodName);
        if (!this.getKind().allowsExtraction()) {
            throw new BCException();
        }
        LazyMethodGen freshMethod = this.createMethodGen(newMethodName, visibilityModifier);
        this.range.extractInstructionsInto(freshMethod, this.makeRemap(), this.getKind() != Shadow.PreInitialization && this.isFallsThrough());
        if (this.getKind() == Shadow.PreInitialization) {
            this.addPreInitializationReturnCode(freshMethod, this.getSuperConstructorParameterTypes());
        }
        this.getEnclosingClass().addMethodGen(freshMethod, munger.getSourceLocation());
        return freshMethod;
    }

    private void addPreInitializationReturnCode(LazyMethodGen extractedMethod, Type[] superConstructorTypes) {
        InstructionList body = extractedMethod.getBody();
        InstructionFactory fact = this.getFactory();
        BcelVar arrayVar = new BcelVar(this.world.resolve(TypeX.OBJECTARRAY), extractedMethod.allocateLocal(1));
        int len = superConstructorTypes.length;
        body.append(Utility.createConstant(fact, len));
        body.append(fact.createNewArray((Type)Type.OBJECT, (short)1));
        arrayVar.appendStore(body, fact);
        for (int i = len - 1; i >= 0; ++i) {
            body.append(Utility.createConversion(fact, superConstructorTypes[i], (Type)Type.OBJECT));
            arrayVar.appendLoad(body, fact);
            body.append((Instruction)InstructionConstants.SWAP);
            body.append(Utility.createConstant(fact, i));
            body.append((Instruction)InstructionConstants.SWAP);
            body.append((Instruction)InstructionFactory.createArrayStore((Type)Type.OBJECT));
        }
        arrayVar.appendLoad(body, fact);
        body.append((Instruction)InstructionConstants.ARETURN);
    }

    private Type[] getSuperConstructorParameterTypes() {
        InstructionHandle superCallHandle = this.getRange().getEnd().getNext();
        InvokeInstruction superCallInstruction = (InvokeInstruction)superCallHandle.getInstruction();
        return superCallInstruction.getArgumentTypes(this.getEnclosingClass().getConstantPoolGen());
    }

    private IntMap makeRemap() {
        IntMap ret = new IntMap(5);
        int reti = 0;
        if (this.thisVar != null) {
            ret.put(0, reti++);
        }
        if (this.targetVar != null && this.targetVar != this.thisVar) {
            ret.put(this.targetVar.getSlot(), reti++);
        }
        int len = this.argVars.length;
        for (int i = 0; i < len; ++i) {
            ret.put(this.argVars[i].getSlot(), reti);
            reti += this.argVars[i].getType().getSize();
        }
        if (this.thisJoinPointVar != null) {
            ret.put(this.thisJoinPointVar.getSlot(), reti++);
        }
        if (!this.getKind().argsOnStack()) {
            int oldi = 0;
            int newi = 0;
            if (this.arg0HoldsThis()) {
                ret.put(0, 0);
                ++oldi;
                ++newi;
            }
            for (int i = 0; i < this.getArgCount(); ++i) {
                TypeX type = this.getArgType(i);
                ret.put(oldi, newi);
                oldi += type.getSize();
                newi += type.getSize();
            }
        }
        return ret;
    }

    private LazyMethodGen createMethodGen(String newMethodName, int visibilityModifier) {
        Type[] parameterTypes = BcelWorld.makeBcelTypes(this.getArgTypes());
        int modifiers = 0x10 | visibilityModifier;
        modifiers |= 8;
        if (this.targetVar != null && this.targetVar != this.thisVar) {
            TypeX targetType = this.getTargetType();
            ResolvedMember resolvedMember = this.getSignature().resolve(this.world);
            if (resolvedMember != null && Modifier.isProtected(resolvedMember.getModifiers()) && !this.samePackage(targetType.getPackageName(), this.getEnclosingType().getPackageName())) {
                if (!targetType.isAssignableFrom(this.getThisType(), this.world)) {
                    throw new BCException("bad bytecode");
                }
                targetType = this.getThisType();
            }
            parameterTypes = this.addType(BcelWorld.makeBcelType(targetType), parameterTypes);
        }
        if (this.thisVar != null) {
            TypeX thisType = this.getThisType();
            parameterTypes = this.addType(BcelWorld.makeBcelType(thisType), parameterTypes);
        }
        if (this.thisJoinPointVar != null) {
            parameterTypes = this.addTypeToEnd((Type)LazyClassGen.tjpType, parameterTypes);
        }
        TypeX returnType = this.getKind() == Shadow.PreInitialization ? TypeX.OBJECTARRAY : this.getReturnType();
        return new LazyMethodGen(modifiers, BcelWorld.makeBcelType(returnType), newMethodName, parameterTypes, new String[0], this.getEnclosingClass());
    }

    private boolean samePackage(String p1, String p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    private Type[] addType(Type type, Type[] types) {
        int len = types.length;
        Type[] ret = new Type[len + 1];
        ret[0] = type;
        System.arraycopy(types, 0, ret, 1, len);
        return ret;
    }

    private Type[] addTypeToEnd(Type type, Type[] types) {
        int len = types.length;
        Type[] ret = new Type[len + 1];
        ret[len] = type;
        System.arraycopy(types, 0, ret, 0, len);
        return ret;
    }

    public BcelVar genTempVar(TypeX typeX) {
        return new BcelVar(typeX.resolve(this.world), this.genTempVarIndex(typeX.getSize()));
    }

    public BcelVar genTempVar(TypeX typeX, String localName) {
        BcelVar tv = this.genTempVar(typeX);
        return tv;
    }

    private int genTempVarIndex(int size) {
        return this.enclosingMethod.allocateLocal(size);
    }

    public InstructionFactory getFactory() {
        return this.getEnclosingClass().getFactory();
    }

    public ISourceLocation getSourceLocation() {
        int sourceLine = this.getSourceLine();
        if (sourceLine == 0 || sourceLine == -1) {
            return this.getEnclosingClass().getType().getSourceLocation();
        }
        return this.getEnclosingClass().getType().getSourceContext().makeSourceLocation(sourceLine);
    }

    public Shadow getEnclosingShadow() {
        return this.enclosingShadow;
    }

    public LazyMethodGen getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public boolean isFallsThrough() {
        return !this.terminatesWithReturn();
    }
}

