/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.bridge.IMessage;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class CflowPointcut
extends Pointcut {
    private Pointcut entry;
    private boolean isBelow;
    private int[] freeVars;
    public static final ResolvedPointcutDefinition CFLOW_MARKER = new ResolvedPointcutDefinition(null, 0, null, TypeX.NONE, Pointcut.makeMatchesNothing(Pointcut.RESOLVED));

    public CflowPointcut(Pointcut entry, boolean isBelow, int[] freeVars) {
        this.entry = entry;
        this.isBelow = isBelow;
        this.freeVars = freeVars;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(10);
        this.entry.write(s);
        s.writeBoolean(this.isBelow);
        FileUtil.writeIntArray(this.freeVars, s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        CflowPointcut ret = new CflowPointcut(Pointcut.read(s, context), s.readBoolean(), FileUtil.readIntArray(s));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        if (bindings == null) {
            this.entry.resolveBindings(scope, null);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = new int[0];
        } else {
            Bindings entryBindings = new Bindings(bindings.size());
            this.entry.resolveBindings(scope, entryBindings);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = entryBindings.getUsedFormals();
            bindings.mergeIn(entryBindings, scope);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof CflowPointcut)) {
            return false;
        }
        CflowPointcut o = (CflowPointcut)other;
        return o.entry.equals(this.entry) && o.isBelow == this.isBelow;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entry.hashCode();
        result = 37 * result + (this.isBelow ? 0 : 1);
        return result;
    }

    public String toString() {
        return "cflow" + (this.isBelow ? "below" : "") + "(" + this.entry + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        throw new RuntimeException("unimplemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        Pointcut concreteEntry;
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, "cflow" + (this.isBelow ? "below" : "") + "() pointcut designator cannot be used in declare statement", bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        IntMap entryBindings = new IntMap();
        int len = this.freeVars.length;
        for (int i = 0; i < len; ++i) {
            int freeVar = this.freeVars[i];
            entryBindings.put(freeVar, i);
        }
        entryBindings.copyContext(bindings);
        World world = inAspect.getWorld();
        ResolvedTypeX concreteAspect = bindings.getConcreteAspect();
        CrosscuttingMembers xcut = concreteAspect.crosscuttingMembers;
        Collection previousCflowEntries = xcut.getCflowEntries();
        entryBindings.pushEnclosingDefinition(CFLOW_MARKER);
        try {
            concreteEntry = this.entry.concretize(inAspect, entryBindings);
        }
        finally {
            entryBindings.popEnclosingDefinitition();
        }
        ArrayList innerCflowEntries = new ArrayList(xcut.getCflowEntries());
        innerCflowEntries.removeAll(previousCflowEntries);
        ResolvedMember cflowField = new ResolvedMember(Member.FIELD, concreteAspect, 25, NameMangler.cflowStack(xcut), TypeX.forName("org.aspectj.runtime.internal.CFlowStack").getSignature());
        concreteAspect.crosscuttingMembers.addConcreteShadowMunger(Advice.makeCflowEntry(world, concreteEntry, this.isBelow, cflowField, this.freeVars.length, innerCflowEntries, inAspect));
        concreteAspect.crosscuttingMembers.addTypeMunger(world.makeCflowStackFieldAdder(cflowField));
        ArrayList<ConcreteCflowPointcut.Slot> slots = new ArrayList<ConcreteCflowPointcut.Slot>();
        int len2 = this.freeVars.length;
        for (int i = 0; i < len2; ++i) {
            int freeVar = this.freeVars[i];
            if (!bindings.hasKey(freeVar)) continue;
            int formalIndex = bindings.get(freeVar);
            ResolvedTypeX formalType = bindings.getAdviceSignature().getParameterTypes()[formalIndex].resolve(world);
            ConcreteCflowPointcut.Slot slot = new ConcreteCflowPointcut.Slot(formalIndex, formalType, i);
            slots.add(slot);
        }
        return new ConcreteCflowPointcut(cflowField, slots);
    }
}

