/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.TypePattern;

public class WildTypePattern
extends TypePattern {
    NamePattern[] namePatterns;
    int ellipsisCount;
    String[] importedPrefixes;
    String[] knownMatches;
    int dim;

    WildTypePattern(NamePattern[] namePatterns, boolean includeSubtypes, int dim) {
        super(includeSubtypes);
        this.namePatterns = namePatterns;
        this.dim = dim;
        this.ellipsisCount = 0;
        for (int i = 0; i < namePatterns.length; ++i) {
            if (namePatterns[i] != NamePattern.ELLIPSIS) continue;
            ++this.ellipsisCount;
        }
        this.setLocation(namePatterns[0].getSourceContext(), namePatterns[0].getStart(), namePatterns[namePatterns.length - 1].getEnd());
    }

    public WildTypePattern(List names, boolean includeSubtypes, int dim) {
        this(names.toArray(new NamePattern[names.size()]), includeSubtypes, dim);
    }

    public WildTypePattern(List names, boolean includeSubtypes, int dim, int endPos) {
        this(names, includeSubtypes, dim);
        this.end = endPos;
    }

    public static char[][] splitNames(String s) {
        ArrayList<char[]> ret = new ArrayList<char[]>();
        int startIndex = 0;
        while (true) {
            int breakIndex;
            if ((breakIndex = s.indexOf(46, startIndex)) == -1) {
                breakIndex = s.indexOf(36, startIndex);
            }
            if (breakIndex == -1) break;
            char[] name = s.substring(startIndex, breakIndex).toCharArray();
            ret.add(name);
            startIndex = breakIndex + 1;
        }
        ret.add(s.substring(startIndex).toCharArray());
        return (char[][])ret.toArray((T[])new char[ret.size()][]);
    }

    protected boolean matchesExactly(ResolvedTypeX type) {
        int i;
        int len;
        String targetTypeName = type.getName();
        if (this.knownMatches == null && this.importedPrefixes == null) {
            return this.innerMatchesExactly(targetTypeName);
        }
        if (this.namePatterns.length == 1) {
            len = this.knownMatches.length;
            for (i = 0; i < len; ++i) {
                if (!this.knownMatches[i].equals(targetTypeName)) continue;
                return true;
            }
        } else {
            len = this.knownMatches.length;
            for (i = 0; i < len; ++i) {
                int pos;
                String knownPrefix = this.knownMatches[i] + "$";
                if (!targetTypeName.startsWith(knownPrefix) || !this.innerMatchesExactly(targetTypeName.substring((pos = this.lastIndexOfDotOrDollar(this.knownMatches[i])) + 1))) continue;
                return true;
            }
        }
        len = this.importedPrefixes.length;
        for (i = 0; i < len; ++i) {
            String prefix = this.importedPrefixes[i];
            if (!targetTypeName.startsWith(prefix) || !this.innerMatchesExactly(targetTypeName.substring(prefix.length()))) continue;
            return true;
        }
        return this.innerMatchesExactly(targetTypeName);
    }

    private int lastIndexOfDotOrDollar(String string) {
        int dot = string.lastIndexOf(46);
        int dollar = string.lastIndexOf(36);
        return Math.max(dot, dollar);
    }

    private boolean innerMatchesExactly(String targetTypeName) {
        char[][] names = WildTypePattern.splitNames(targetTypeName);
        return this.innerMatchesExactly(names);
    }

    private boolean innerMatchesExactly(char[][] names) {
        int namesLength = names.length;
        int patternsLength = this.namePatterns.length;
        int namesIndex = 0;
        int patternsIndex = 0;
        if (this.ellipsisCount == 0) {
            if (namesLength != patternsLength) {
                return false;
            }
            while (patternsIndex < patternsLength) {
                if (this.namePatterns[patternsIndex++].matches(names[namesIndex++])) continue;
                return false;
            }
            return true;
        }
        if (this.ellipsisCount == 1) {
            if (namesLength < patternsLength - 1) {
                return false;
            }
            while (patternsIndex < patternsLength) {
                NamePattern p;
                if ((p = this.namePatterns[patternsIndex++]) == NamePattern.ELLIPSIS) {
                    namesIndex = namesLength - (patternsLength - patternsIndex);
                    continue;
                }
                if (p.matches(names[namesIndex++])) continue;
                return false;
            }
            return true;
        }
        boolean b = WildTypePattern.outOfStar(this.namePatterns, names, 0, 0, patternsLength - this.ellipsisCount, namesLength, this.ellipsisCount);
        return b;
    }

    private static boolean outOfStar(NamePattern[] pattern, char[][] target, int pi, int ti, int pLeft, int tLeft, int starsLeft) {
        if (pLeft > tLeft) {
            return false;
        }
        while (tLeft != 0) {
            if (pLeft == 0) {
                return starsLeft > 0;
            }
            if (pattern[pi] == NamePattern.ELLIPSIS) {
                return WildTypePattern.inStar(pattern, target, pi + 1, ti, pLeft, tLeft, starsLeft - 1);
            }
            if (!pattern[pi].matches(target[ti])) {
                return false;
            }
            ++pi;
            ++ti;
            --pLeft;
            --tLeft;
        }
        return true;
    }

    private static boolean inStar(NamePattern[] pattern, char[][] target, int pi, int ti, int pLeft, int tLeft, int starsLeft) {
        NamePattern patternChar = pattern[pi];
        while (patternChar == NamePattern.ELLIPSIS) {
            --starsLeft;
            patternChar = pattern[++pi];
        }
        while (pLeft <= tLeft) {
            if (patternChar.matches(target[ti]) && WildTypePattern.outOfStar(pattern, target, pi + 1, ti + 1, pLeft - 1, tLeft - 1, starsLeft)) {
                return true;
            }
            ++ti;
            --tLeft;
        }
        return false;
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX type) {
        if (this.maybeGetSimpleName() != null) {
            return FuzzyBoolean.NO;
        }
        type.getWorld().getMessageHandler().handleMessage(new Message("can't do instanceof matching on patterns with wildcards", IMessage.ERROR, null, this.getSourceLocation()));
        return FuzzyBoolean.NO;
    }

    public NamePattern extractName() {
        int len = this.namePatterns.length;
        NamePattern ret = this.namePatterns[len - 1];
        NamePattern[] newNames = new NamePattern[len - 1];
        System.arraycopy(this.namePatterns, 0, newNames, 0, len - 1);
        this.namePatterns = newNames;
        return ret;
    }

    public boolean maybeExtractName(String string) {
        int len = this.namePatterns.length;
        NamePattern ret = this.namePatterns[len - 1];
        String simple = ret.maybeGetSimpleName();
        if (simple != null && simple.equals(string)) {
            this.extractName();
            return true;
        }
        return false;
    }

    public String maybeGetSimpleName() {
        if (this.namePatterns.length == 1) {
            return this.namePatterns[0].maybeGetSimpleName();
        }
        return null;
    }

    public String maybeGetCleanName() {
        if (this.namePatterns.length == 0) {
            throw new RuntimeException("bad name: " + this.namePatterns);
        }
        StringBuffer buf = new StringBuffer();
        int len = this.namePatterns.length;
        for (int i = 0; i < len; ++i) {
            NamePattern p = this.namePatterns[i];
            String simpleName = p.maybeGetSimpleName();
            if (simpleName == null) {
                return null;
            }
            if (i > 0) {
                buf.append(".");
            }
            buf.append(simpleName);
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        FormalBinding formalBinding;
        if (this.isStar()) {
            return TypePattern.ANY;
        }
        String simpleName = this.maybeGetSimpleName();
        if (simpleName != null && (formalBinding = scope.lookupFormal(simpleName)) != null) {
            if (bindings == null) {
                scope.message(IMessage.ERROR, this, "negation doesn't allow binding");
                return this;
            }
            if (!allowBinding) {
                scope.message(IMessage.ERROR, this, "name binding only allowed in target, this, and args pcds");
                return this;
            }
            BindingTypePattern binding = new BindingTypePattern(formalBinding);
            binding.copyLocationFrom(this);
            bindings.register(binding, scope);
            return binding;
        }
        String cleanName = this.maybeGetCleanName();
        if (cleanName == null) {
            if (requireExactType) {
                scope.getWorld().getMessageHandler().handleMessage(MessageUtil.error("wildcard type pattern not allowed, must use type name", this.getSourceLocation()));
                return TypePattern.NO;
            }
        } else {
            int lastDot;
            TypeX type;
            while ((type = scope.lookupType(cleanName, this)) == ResolvedTypeX.MISSING && (lastDot = cleanName.lastIndexOf(46)) != -1) {
                cleanName = cleanName.substring(0, lastDot) + '$' + cleanName.substring(lastDot + 1);
            }
            if (type == ResolvedTypeX.MISSING) {
                if (requireExactType) {
                    if (!allowBinding) {
                        scope.getWorld().getMessageHandler().handleMessage(MessageUtil.error("can't bind type name '" + cleanName + "'", this.getSourceLocation()));
                        return TypePattern.NO;
                    }
                    if (!scope.getWorld().getLint().invalidAbsoluteTypeName.isEnabled()) return TypePattern.NO;
                    scope.getWorld().getLint().invalidAbsoluteTypeName.signal(cleanName, this.getSourceLocation());
                    return TypePattern.NO;
                }
                if (scope.getWorld().getLint().invalidAbsoluteTypeName.isEnabled()) {
                    scope.getWorld().getLint().invalidAbsoluteTypeName.signal(cleanName, this.getSourceLocation());
                }
            } else {
                if (this.dim != 0) {
                    type = TypeX.makeArray(type, this.dim);
                }
                ExactTypePattern ret = new ExactTypePattern(type, this.includeSubtypes);
                ret.copyLocationFrom(this);
                return ret;
            }
        }
        this.importedPrefixes = scope.getImportedPrefixes();
        this.knownMatches = this.preMatch(scope.getImportedNames());
        return this;
    }

    public boolean isStar() {
        return this.namePatterns.length == 1 && this.namePatterns[0].isAny();
    }

    private String[] preMatch(String[] possibleMatches) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = possibleMatches.length;
        for (int i = 0; i < len; ++i) {
            char[][] names = WildTypePattern.splitNames(possibleMatches[i]);
            if (!this.namePatterns[0].matches(names[names.length - 1])) continue;
            ret.add(possibleMatches[i]);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int len = this.namePatterns.length;
        for (int i = 0; i < len; ++i) {
            NamePattern name = this.namePatterns[i];
            if (name == null) {
                buf.append(".");
                continue;
            }
            if (i > 0) {
                buf.append(".");
            }
            buf.append(name.toString());
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof WildTypePattern)) {
            return false;
        }
        WildTypePattern o = (WildTypePattern)other;
        int len = o.namePatterns.length;
        if (len != this.namePatterns.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (o.namePatterns[i].equals(this.namePatterns[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        int len = this.namePatterns.length;
        for (int i = 0; i < len; ++i) {
            result = 37 * result + this.namePatterns[i].hashCode();
        }
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(1);
        s.writeShort(this.namePatterns.length);
        for (int i = 0; i < this.namePatterns.length; ++i) {
            this.namePatterns[i].write(s);
        }
        s.writeBoolean(this.includeSubtypes);
        s.writeInt(this.dim);
        FileUtil.writeStringArray(this.knownMatches, s);
        FileUtil.writeStringArray(this.importedPrefixes, s);
        this.writeLocation(s);
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        int len = s.readShort();
        NamePattern[] namePatterns = new NamePattern[len];
        for (int i = 0; i < len; ++i) {
            namePatterns[i] = NamePattern.read(s);
        }
        boolean includeSubtypes = s.readBoolean();
        int dim = s.readInt();
        WildTypePattern ret = new WildTypePattern(namePatterns, includeSubtypes, dim);
        ret.knownMatches = FileUtil.readStringArray(s);
        ret.importedPrefixes = FileUtil.readStringArray(s);
        ret.readLocation(context, s);
        return ret;
    }
}

