/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.NullMarkupProvider;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProviderManager {
    private static IContentProvider contentP = null;
    private static IMarkupProvider markupP = null;
    private static ProviderManager instance = new ProviderManager();
    private static List contentProviders;
    private static List markupProviders;
    private static ProviderDefinition currentPD;

    static {
        currentPD = null;
    }

    public static IContentProvider getContentProvider() {
        return contentP;
    }

    public static IMarkupProvider getMarkupProvider() {
        return markupP;
    }

    private ProviderManager() {
    }

    public static void initialise() {
        contentProviders = new ArrayList();
        markupProviders = new ArrayList();
        IExtensionPoint exP = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.contribution.visualiser.providers");
        IExtension[] exs = exP.getExtensions();
        int i = 0;
        while (i < exs.length) {
            IConfigurationElement[] ces = exs[i].getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    Object ext = ces[j].createExecutableExtension("class");
                    if (ext instanceof IContentProvider) {
                        String priorityString;
                        String title;
                        if (ces[j].getAttribute("markupclass") != null) {
                            markupP = (IMarkupProvider)ces[j].createExecutableExtension("markupclass");
                            markupP.initialise();
                        }
                        contentP = (IContentProvider)ext;
                        contentP.initialise();
                        ProviderDefinition cpdef = new ProviderDefinition(ces[j].getAttribute("name"), contentP, markupP);
                        contentProviders.add(cpdef);
                        String desc = ces[j].getAttribute("description");
                        if (desc != null) {
                            cpdef.setDescription(desc);
                        }
                        if ((title = ces[j].getAttribute("title")) != null) {
                            cpdef.setTitle(title);
                        }
                        if ((priorityString = ces[j].getAttribute("priority")) != null) {
                            try {
                                cpdef.setPriority(new Integer(priorityString));
                            }
                            catch (NumberFormatException e) {}
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex);
                    ex.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        if (markupP == null) {
            markupP = new NullMarkupProvider();
        }
        if (contentProviders.size() != 0) {
            Collections.sort(contentProviders, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ProviderDefinition)o2).getPriority() - ((ProviderDefinition)o1).getPriority();
                }
            });
            String provider = VisualiserPreferences.getProvider();
            boolean set = false;
            int i2 = 0;
            while (i2 < contentProviders.size()) {
                ProviderDefinition cp = (ProviderDefinition)contentProviders.get(i2);
                String name = cp.getName();
                if (provider.equals(name)) {
                    cp.setEnabled(true);
                    set = true;
                    break;
                }
                ++i2;
            }
            if (!set) {
                ProviderDefinition cp = (ProviderDefinition)contentProviders.get(0);
                cp.setEnabled(true);
            }
        }
        if (VisualiserPlugin.menu != null) {
            VisualiserPlugin.menu.reset();
        }
    }

    public static ProviderManager getProviderManager() {
        return instance;
    }

    public static ProviderDefinition[] getAllProviderDefinitions() {
        return contentProviders.toArray(new ProviderDefinition[0]);
    }

    public static ProviderDefinition getCurrent() {
        return currentPD;
    }

    public static void setCurrent(ProviderDefinition definition) {
        boolean needToUpdateVisualiser = false;
        currentPD = definition;
        if (!contentP.equals(definition.getContentProvider())) {
            needToUpdateVisualiser = true;
        }
        if (!markupP.equals(definition.getMarkupInstance())) {
            needToUpdateVisualiser = true;
        }
        contentP = definition.getContentProvider();
        markupP = definition.getMarkupInstance();
        if (needToUpdateVisualiser) {
            VisualiserPlugin.refresh();
            if (VisualiserPlugin.visualiser != null) {
                VisualiserPlugin.visualiser.setVisContentProvider(contentP);
                VisualiserPlugin.visualiser.setVisMarkupProvider(markupP);
            }
            if (VisualiserPlugin.menu != null) {
                VisualiserPlugin.menu.setVisMarkupProvider(markupP);
            }
        }
        String visTitle = definition.getTitle();
        Visualiser visualiser = VisualiserPlugin.visualiser;
        if (visualiser != null) {
            if (visTitle != null) {
                visualiser.refreshTitle(visTitle);
            } else {
                visualiser.refreshTitle(definition.getName());
            }
        }
    }
}

