/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleContentProvider;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleGroup;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class FileContentProvider
extends SimpleContentProvider {
    private static final boolean debugLoading = false;

    public void initialise() {
        URL url = VisualiserPlugin.getDefault().getDescriptor().getInstallURL();
        try {
            URL resolved = Platform.resolve((URL)url);
            URL fileURL = new URL(resolved, "Content.vis");
            String path = fileURL.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            File f = new File(path);
            if (this.numberOfGroupsDefined() == 0 && f.exists()) {
                FileContentProvider.loadVisContents(path);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error loading content file: " + ioe);
        }
    }

    public static void log(int msgType, String msg, Exception e) {
        VisualiserPlugin.getDefault().getLog().log((IStatus)new Status(msgType, "org.eclipse.contribution.visualiser", 0, msg, (Throwable)e));
    }

    public static void loadVisContents(String filename) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            SimpleGroup grp = null;
            while (line != null && line.length() != 0) {
                if (line.startsWith("Group:")) {
                    String grpname = FileContentProvider.retrieveKeyValue("Group:", line);
                    grp = new SimpleGroup(grpname);
                    SimpleContentProvider.addGroup(grp);
                } else if (line.startsWith("Member:")) {
                    String tipStr;
                    String memname = FileContentProvider.retrieveKeyValue("Member:", line);
                    SimpleMember mem = new SimpleMember(memname);
                    String sizeStr = FileContentProvider.retrieveKeyValue("Size:", line);
                    if (sizeStr != null) {
                        mem.setSize(Integer.parseInt(sizeStr));
                    }
                    if ((tipStr = FileContentProvider.retrieveKeyValue("Tip:", line)) != null) {
                        mem.setTooltip(tipStr);
                    }
                    grp.add(mem);
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", e);
        }
        catch (IOException e) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", e);
        }
    }

    private static String retrieveKeyValue(String what, String where) {
        if (where.indexOf(what) == -1) {
            return null;
        }
        String postWhat = where.substring(where.indexOf(what) + what.length());
        String result = postWhat;
        if (result.indexOf(" ") != -1) {
            result = postWhat.substring(0, postWhat.indexOf(" "));
        }
        result = result.replace('_', ' ');
        return result;
    }

    public String getEmptyMessage() {
        return VisualiserPlugin.getResourceString("FileContentProvider_EmptyMessage");
    }
}

