/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupProvider;
import org.eclipse.core.runtime.Platform;

public class FileMarkupProvider
extends SimpleMarkupProvider {
    private static final boolean debugLoading = false;

    public void initialise() {
        URL url = VisualiserPlugin.getDefault().getDescriptor().getInstallURL();
        try {
            URL resolved = Platform.resolve((URL)url);
            URL fileURL = new URL(resolved, "Markup.mvis");
            String path = fileURL.getPath();
            String protocol = fileURL.getProtocol();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            File f = new File(path);
            if (this.markups == null && f.exists()) {
                this.loadMarkups(path);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error loading markup file: " + ioe);
        }
    }

    public void loadMarkups(String filename) {
        int scount = 0;
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null && line.length() != 0) {
                if (line.startsWith("Stripe:")) {
                    String membername = null;
                    String kindStr = null;
                    int offset = 0;
                    int depth = 1;
                    membername = this.retrieveKeyValue("Stripe:", line);
                    kindStr = this.retrieveKeyValue("Kind:", line);
                    offset = Integer.parseInt(this.retrieveKeyValue("Offset:", line));
                    depth = Integer.parseInt(this.retrieveKeyValue("Depth:", line));
                    Stripe newstripe = new Stripe(kindStr, offset, depth);
                    this.addMarkup(membername, newstripe);
                    ++scount;
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Problem loading markup data");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Problem loading markup data");
            e.printStackTrace();
        }
        this.processMarkups();
    }

    private String retrieveKeyValue(String what, String where) {
        if (where.indexOf(what) == -1) {
            return null;
        }
        String postWhat = where.substring(where.indexOf(what) + what.length());
        String result = postWhat;
        if (result.indexOf(" ") != -1) {
            result = postWhat.substring(0, postWhat.indexOf(" "));
        }
        result = result.replace('_', ' ');
        return result;
    }
}

