/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.core.MarkupUtils;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.utils.ColorUtils;
import org.eclipse.swt.graphics.Color;

public class SimpleMarkupProvider
implements IMarkupProvider {
    private static Map colourMemory = new HashMap();
    private static Map availableColours = new HashMap();
    public Hashtable markups = null;
    public SortedSet markupKinds;

    public void initialise() {
    }

    public boolean changeMode() {
        return false;
    }

    public boolean hasMultipleModes() {
        return false;
    }

    public List getMemberMarkups(IMember member) {
        Object o;
        if (member != null && this.markups != null && (o = this.markups.get(member.getFullname())) != null && o instanceof List) {
            return (List)this.markups.get(member.getFullname());
        }
        return null;
    }

    public void addMarkup(String membername, Stripe s) {
        ArrayList<Stripe> stripes;
        if (this.markups == null) {
            this.markups = new Hashtable();
        }
        if ((stripes = (ArrayList<Stripe>)this.markups.get(membername)) == null) {
            stripes = new ArrayList<Stripe>();
            stripes.add(s);
            this.markups.put(membername, stripes);
        } else {
            stripes.add(s);
        }
    }

    public void processMarkups() {
        Enumeration memkeys = this.markups.keys();
        while (memkeys.hasMoreElements()) {
            String memberID = (String)memkeys.nextElement();
            List unprocessedListOfStripes = (List)this.markups.get(memberID);
            MarkupUtils.processStripes(unprocessedListOfStripes);
        }
    }

    public List getGroupMarkups(IGroup group) {
        ArrayList<Stripe> stripes = new ArrayList<Stripe>();
        List kids = group.getMembers();
        int accumulatedOffset = 0;
        Iterator iter = kids.iterator();
        while (iter.hasNext()) {
            IMember element = (IMember)iter.next();
            List l = this.getMemberMarkups(element);
            if (l != null) {
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    Stripe elem = (Stripe)iterator.next();
                    stripes.add(new Stripe(elem.getKinds(), elem.getOffset() + accumulatedOffset, elem.getDepth()));
                }
            }
            accumulatedOffset += element.getSize().intValue();
        }
        return stripes;
    }

    public SortedSet getAllMarkupKinds() {
        if (this.markups == null) {
            return null;
        }
        if (this.markupKinds != null) {
            return this.markupKinds;
        }
        this.markupKinds = new TreeSet();
        Enumeration stripeLists = this.markups.elements();
        while (stripeLists.hasMoreElements()) {
            List stripelist = (List)stripeLists.nextElement();
            Iterator iter = stripelist.iterator();
            while (iter.hasNext()) {
                Stripe element = (Stripe)iter.next();
                this.markupKinds.addAll(element.getKinds());
            }
        }
        return this.markupKinds;
    }

    public Color getColorFor(String id) {
        Color stripeColour = null;
        String p = "not unique";
        String key = new String(String.valueOf(p) + ":" + id);
        if (colourMemory.containsKey(key)) {
            stripeColour = (Color)colourMemory.get(key);
        } else {
            stripeColour = this.getNextColourFor(p);
            colourMemory.put(key, stripeColour);
        }
        return stripeColour;
    }

    public void setColorFor(String string, Color color) {
        colourMemory.put("not unique:" + string, color);
    }

    private Color getNextColourFor(String p) {
        Color c;
        List colours;
        if (!availableColours.containsKey(p.toString())) {
            ArrayList colourList = new ArrayList(ColorUtils.getColorList());
            availableColours.put(p.toString(), colourList);
        }
        if (!(colours = (List)availableColours.get(p.toString())).isEmpty()) {
            c = (Color)colours.get(0);
            colours.remove(0);
        } else {
            c = ColorUtils.getRandomColor();
        }
        return c;
    }

    public void resetColours() {
        availableColours = new HashMap();
        colourMemory = new HashMap();
    }

    public boolean processMouseclick(IMember member, Stripe stripe, String exactKind, int buttonClicked) {
        return true;
    }
}

