/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VisualiserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor stripeSizeSelector;
    private IntegerFieldEditor minBarSizeSelector;
    private IntegerFieldEditor maxBarSizeSelector;
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;
    private BooleanFieldEditor demarcationSelector;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Control providerControl = this.createProviderControl(folder);
        Control drawingOptionsControl = this.createDrawingOptionsControl(folder);
        TabItem item = new TabItem(folder, 0);
        item.setText("Providers");
        item.setControl(providerControl);
        item = new TabItem(folder, 0);
        item.setText("Drawing Options");
        item.setControl(drawingOptionsControl);
        this.populateProviders();
        return composite;
    }

    private Control createDrawingOptionsControl(TabFolder parent) {
        GridLayout layout = new GridLayout();
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)layout);
        this.createStripeSizeArea(composite);
        this.createMinBarWidthArea(composite);
        this.createMaxBarWidthArea(composite);
        this.createDemarcationArea(composite);
        return composite;
    }

    private Control createProviderControl(TabFolder parent) {
        GridLayout layout = new GridLayout();
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)layout);
        this.createProvidersArea(composite);
        this.createDescriptionArea(composite);
        return composite;
    }

    private void createMaxBarWidthArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite maxBarComposite = new Composite(mainComposite, 0);
        maxBarComposite.setLayoutData((Object)new GridData(1));
        GridLayout maxBarLayout = new GridLayout();
        maxBarComposite.setLayout((Layout)maxBarLayout);
        maxBarComposite.setFont(mainFont);
        this.maxBarSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.maxbarwidth", VisualiserPlugin.getResourceString("VisualiserPreferencePage.maxBarSize"), maxBarComposite, 3);
        this.maxBarSizeSelector.setValidRange(10, 500);
        this.maxBarSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.maxBarErrorMessage"));
        this.maxBarSizeSelector.setPreferencePage((PreferencePage)this);
        this.maxBarSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.maxBarSizeSelector.load();
    }

    private void createMinBarWidthArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite minBarComposite = new Composite(mainComposite, 0);
        minBarComposite.setLayoutData((Object)new GridData(1));
        GridLayout minBarLayout = new GridLayout();
        minBarComposite.setLayout((Layout)minBarLayout);
        minBarComposite.setFont(mainFont);
        this.minBarSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.minbarwidth", VisualiserPlugin.getResourceString("VisualiserPreferencePage.minBarSize"), minBarComposite, 3);
        this.minBarSizeSelector.setValidRange(1, 100);
        this.minBarSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.minBarErrorMessage"));
        this.minBarSizeSelector.setPreferencePage((PreferencePage)this);
        this.minBarSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.minBarSizeSelector.load();
    }

    private void createStripeSizeArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite stripeComposite = new Composite(mainComposite, 0);
        stripeComposite.setLayoutData((Object)new GridData(1));
        GridLayout stripeLayout = new GridLayout();
        stripeComposite.setLayout((Layout)stripeLayout);
        stripeComposite.setFont(mainFont);
        this.stripeSizeSelector = new IntegerFieldEditor("org.eclipse.contribution.visualiser.preferences.stripesize", VisualiserPlugin.getResourceString("VisualiserPreferencePage.stripeSize"), stripeComposite, 2);
        this.stripeSizeSelector.setValidRange(1, 20);
        this.stripeSizeSelector.setErrorMessage(VisualiserPlugin.getResourceString("VisualiserPreferencePage.stripeSizeErrorMessage"));
        this.stripeSizeSelector.setPreferencePage((PreferencePage)this);
        this.stripeSizeSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.stripeSizeSelector.load();
    }

    private void createDemarcationArea(Composite mainComposite) {
        this.demarcationSelector = new BooleanFieldEditor("org.eclipse.contribution.visualiser.preferences.demarcation", VisualiserPlugin.getResourceString("VisualiserPreferencePage.demarcation"), mainComposite);
        this.demarcationSelector.setPreferencePage((PreferencePage)this);
        this.demarcationSelector.setPreferenceStore(VisualiserPlugin.getDefault().getPreferenceStore());
        this.demarcationSelector.load();
    }

    private void createProvidersArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite providersComposite = new Composite(mainComposite, 0);
        providersComposite.setLayoutData((Object)new GridData(1808));
        GridLayout providersLayout = new GridLayout();
        providersLayout.marginWidth = 0;
        providersLayout.marginHeight = 0;
        providersComposite.setLayout((Layout)providersLayout);
        providersComposite.setFont(mainFont);
        Label providersLabel = new Label(providersComposite, 0);
        providersLabel.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.providersLabel"));
        providersLabel.setFont(mainFont);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)providersComposite, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(providersComposite.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProviderDefinition)element).getName();
            }
        });
        this.checkboxViewer.getTable().setFont(mainFont);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ProviderDefinition definition = (ProviderDefinition)sel.getFirstElement();
                    if (definition == null) {
                        VisualiserPreferencePage.this.clearDescription();
                    } else {
                        VisualiserPreferencePage.this.showDescription(definition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                VisualiserPreferencePage.this.checkboxViewer.setAllChecked(false);
                VisualiserPreferencePage.this.checkboxViewer.setChecked(event.getElement(), true);
                VisualiserPreferencePage.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(event.getElement()), true);
            }
        });
    }

    private void createDescriptionArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        textComposite.setFont(mainFont);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.description"));
        descriptionLabel.setFont(mainFont);
        this.descriptionText = new Text(textComposite, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(mainFont);
    }

    private void populateProviders() {
        ProviderDefinition[] definitions = this.getAllDefinitions();
        this.checkboxViewer.setInput((Object)definitions);
        int i = 0;
        while (i < definitions.length) {
            this.checkboxViewer.setChecked((Object)definitions[i], definitions[i].isEnabled());
            if (definitions[i].isEnabled()) {
                this.showDescription(definitions[i]);
            }
            ++i;
        }
    }

    private void showDescription(ProviderDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(VisualiserPlugin.getResourceString("VisualiserPreferencePage.noDescription"));
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        super.performDefaults();
        this.demarcationSelector.loadDefault();
        this.maxBarSizeSelector.loadDefault();
        this.minBarSizeSelector.loadDefault();
        this.stripeSizeSelector.loadDefault();
    }

    public boolean performOk() {
        if (super.performOk()) {
            ProviderDefinition[] definitions = ProviderManager.getAllProviderDefinitions();
            int i = 0;
            while (i < definitions.length) {
                boolean checked = this.checkboxViewer.getChecked((Object)definitions[i]);
                definitions[i].setEnabled(checked);
                ++i;
            }
            try {
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.stripesize", this.stripeSizeSelector.getIntValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.demarcation", this.demarcationSelector.getBooleanValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.minbarwidth", this.minBarSizeSelector.getIntValue());
                VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.maxbarwidth", this.maxBarSizeSelector.getIntValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (VisualiserPlugin.visualiser != null) {
                VisualiserPlugin.visualiser.updateSettingsFromPreferences();
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults() {
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.demarcation", true);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.provider", "");
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.stripesize", 3);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.minbarwidth", 20);
        VisualiserPlugin.getDefault().getPreferenceStore().setDefault("org.eclipse.contribution.visualiser.preferences.maxbarwidth", 60);
    }

    private ProviderDefinition[] getAllDefinitions() {
        return ProviderManager.getAllProviderDefinitions();
    }
}

