/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.views.BarButton;
import org.eclipse.contribution.visualiser.views.RectangleData;
import org.eclipse.contribution.visualiser.views.TraversableRectangleFigure;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class BarDrawing {
    private boolean absolute_proportions;
    private boolean continueWithAbsoluteProportions;
    private static int LOGLEVEL = 0;
    private MouseMotionListener locationListener;
    private boolean mouseInARectangle = false;
    private Shape mouseInThisRectangle;
    private Action onlyShowAction;
    private Menu rCMenu;
    private int spacing = 3;
    int maxBarWidth = 60;
    int minBarWidth = 20;
    int highlightDepth = 1;
    private int selectedColumn = -1;
    private int classNum = -1;
    private int lineNum = -1;
    private float zoom = 1.0f;
    private float max_zoom = 5.0f;
    private float scale;
    private boolean demarcation = true;
    private Shape[] rectangles;
    private Vector[] lineNums;
    private IFigure panel = new Figure();
    private MouseListener mouseListener = new MouseListener(){

        public void mousePressed(MouseEvent e) {
            if (e.button == 1) {
                if (e.getSource() instanceof TraversableRectangleFigure) {
                    TraversableRectangleFigure rectangle = (TraversableRectangleFigure)((Object)e.getSource());
                    rectangle.requestFocus();
                }
            } else if (e.getSource() instanceof Figure && !(e.getSource() instanceof RectangleFigure)) {
                BarDrawing.this.log(3, "Processing button3 click on Figure");
                VisualiserPlugin.visualiser.handleClick(null, null, null, e.button);
            } else if (e.getSource() instanceof RectangleFigure) {
                BarDrawing.this.log(3, "Processing button click on a rectangle");
                BarDrawing.this.selectedColumn = -1;
                RectangleFigure rectangle = (RectangleFigure)e.getSource();
                RectangleData rd = (RectangleData)BarDrawing.this.rectangleTable.get(rectangle);
                BarDrawing.this.log(3, "You clicked: " + rd.toString());
                VisualiserPlugin.visualiser.handleClick(rd.mem, rd.kind, rd.stripe, e.button);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDoubleClicked(MouseEvent e) {
            if (e.button == 1) {
                if (e.getSource() instanceof RectangleFigure) {
                    BarDrawing.this.log(3, "Processing button click on a rectangle");
                    BarDrawing.this.selectedColumn = -1;
                    RectangleFigure rectangle = (RectangleFigure)e.getSource();
                    RectangleData rd = (RectangleData)BarDrawing.this.rectangleTable.get(rectangle);
                    BarDrawing.this.log(3, "You clicked: " + rd.toString());
                    VisualiserPlugin.visualiser.handleClick(rd.mem, rd.kind, rd.stripe, e.button);
                } else {
                    VisualiserPlugin.visualiser.handleClick(null, null, null, e.button);
                }
            }
        }
    };
    private BarButton[] columnButtons;
    private boolean limit_mode = false;
    public Rectangle viewsize;
    private List whatToDisplay;
    public static Control canvas;
    private static BarDrawing singleton;
    boolean alreadyInDrawMethod = false;
    Hashtable rectangleTable;
    Map[] markups;

    public static BarDrawing getBarDrawing() {
        if (singleton == null) {
            singleton = new BarDrawing();
        }
        return singleton;
    }

    private BarDrawing() {
        this.locationListener = new MouseMotionListener(){

            public void mouseEntered(MouseEvent e) {
                BarDrawing.this.mouseInARectangle = true;
                BarDrawing.this.mouseInThisRectangle = (Shape)((RectangleFigure)e.getSource());
            }

            public void mouseExited(MouseEvent arg0) {
                BarDrawing.this.mouseInARectangle = false;
            }

            public void mouseHover(MouseEvent arg0) {
            }

            public void mouseMoved(MouseEvent arg0) {
            }

            public void mouseDragged(MouseEvent arg0) {
            }
        };
    }

    private void fillRightClickMenu(MenuManager menu) {
        this.onlyShowAction = new Action(){

            public void run() {
                VisualiserPlugin.visualiser.onlyShowColorsAffecting(((Label)BarDrawing.this.mouseInThisRectangle.getToolTip()).getText());
            }
        };
        this.onlyShowAction.setText(VisualiserPlugin.getResourceString("OnlyShow"));
        menu.add((IAction)this.onlyShowAction);
    }

    public void draw(List whatToDraw, Canvas canvas, boolean absolute_proportions) {
        if (this.alreadyInDrawMethod) {
            return;
        }
        if (canvas == null) {
            return;
        }
        Control[] children = canvas.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.setAbsoluteProportions(absolute_proportions);
        this.alreadyInDrawMethod = true;
        BarDrawing.canvas = canvas;
        this.clearPanel();
        this.whatToDisplay = whatToDraw;
        if (this.whatToDisplay == null) {
            this.whatToDisplay = Visualiser.contentP.getAllGroups();
        }
        int size = whatToDraw == null ? 0 : whatToDraw.size();
        this.rectangles = new Shape[size];
        if (this.rectangleTable != null) {
            this.rectangleTable.clear();
        } else {
            this.rectangleTable = new Hashtable();
        }
        this.lineNums = new Vector[size];
        if (this.panel != null) {
            this.panel.removeMouseListener(this.mouseListener);
        }
        this.panel = new Figure();
        this.panel.addMouseListener(this.mouseListener);
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)layout);
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        this.viewsize = canvas.getParent().getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom);
        }
        LightweightSystem lws = new LightweightSystem(canvas);
        lws.setContents(this.panel);
        if (size > 0) {
            if (absolute_proportions) {
                this.addShapesAndKeepProportions(size, this.viewsize, canvas.getParent().getClientArea());
            } else {
                this.addShapes(size, this.viewsize);
            }
        } else {
            Label label = new Label(Visualiser.contentP.getEmptyMessage());
            this.panel.add((IFigure)label);
        }
        org.eclipse.swt.graphics.Point canvasSize = canvas.getSize();
        org.eclipse.swt.graphics.Point preferredSize = this.zoom > 1.0f || this.absolute_proportions ? new org.eclipse.swt.graphics.Point(Math.max(this.panel.getPreferredSize().width, canvas.getParent().getClientArea().width), Math.max(canvas.getParent().getClientArea().height, this.panel.getPreferredSize().height)) : new org.eclipse.swt.graphics.Point(Math.max(this.panel.getPreferredSize().width, canvas.getParent().getClientArea().width), Math.min(canvas.getParent().getClientArea().height, this.panel.getPreferredSize().height));
        if (!canvasSize.equals((Object)preferredSize)) {
            canvas.setSize(preferredSize);
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        this.fillRightClickMenu(menuMgr);
        this.rCMenu = menuMgr.createContextMenu((Control)canvas);
        canvas.setMenu(this.rCMenu);
        this.rCMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                BarDrawing.this.onlyShowAction.setEnabled(BarDrawing.this.mouseInARectangle);
            }
        });
        this.alreadyInDrawMethod = false;
    }

    private void addShapes(int size, Rectangle viewsize) {
        this.columnButtons = new BarButton[size];
        boolean hScrollBar = false;
        int width = 0;
        int maximum = 0;
        int num = 0;
        int max_depth = viewsize.height - 30;
        int i = 0;
        while (i < size) {
            boolean beingShown = true;
            Object o = this.whatToDisplay.get(i);
            if (beingShown) {
                ++num;
                int sze = ((IMember)o).getSize();
                if (sze > maximum) {
                    maximum = sze;
                }
            }
            ++i;
        }
        if (!this.limit_mode) {
            num = size;
        }
        if (num * (this.minBarWidth + this.spacing) > viewsize.width - 10) {
            width = this.minBarWidth;
            hScrollBar = true;
        } else {
            width = num * (this.maxBarWidth + this.spacing) < viewsize.width - 10 ? this.maxBarWidth : (int)((float)viewsize.width - 10.0f) / num - this.spacing;
        }
        if (hScrollBar) {
            max_depth -= 20;
        }
        this.scale = (float)max_depth / (float)maximum;
        if (this.scale > (float)this.highlightDepth) {
            this.scale = (float)Math.floor(this.scale);
        }
        BarButton prevButton = null;
        int i2 = 0;
        while (i2 < size) {
            IMember member = (IMember)this.whatToDisplay.get(i2);
            this.rectangles[i2] = new RectangleFigure();
            this.rectangleTable.put(this.rectangles[i2], new RectangleData(member, null, null));
            this.rectangles[i2].addMouseListener(this.mouseListener);
            this.rectangles[i2].addMouseMotionListener(this.locationListener);
            this.lineNums[i2] = new Vector();
            int barHeight = (int)((float)member.getSize().intValue() * this.scale + 0.5f) + 20;
            this.rectangles[i2].setSize(width, barHeight);
            this.rectangles[i2].setToolTip((IFigure)new Label(member.getToolTip()));
            this.columnButtons[i2] = this.createButton(member.getName(), this.rectangles[i2].getSize().width);
            if (prevButton != null) {
                prevButton.setRightComponent((Figure)this.columnButtons[i2]);
                this.columnButtons[i2].setLeftComponent((Figure)prevButton);
            }
            prevButton = this.columnButtons[i2];
            this.rectangles[i2].add((IFigure)this.columnButtons[i2]);
            this.rectangles[i2].setBackgroundColor(ColorConstants.buttonDarkest);
            IMarkupProvider vmp = Visualiser.markupP;
            if (this.whatToDisplay.get(i2) instanceof IGroup && this.demarcation) {
                IGroup ig = (IGroup)this.whatToDisplay.get(i2);
                List mems = ig.getMembers();
                IMember[] memsArray = new IMember[mems.size()];
                float offset = 20.0f;
                mems.toArray(memsArray);
                int j = 0;
                while (j < memsArray.length) {
                    IMember member2 = memsArray[j];
                    RectangleFigure rec = new RectangleFigure();
                    rec.addMouseListener(this.mouseListener);
                    rec.addMouseMotionListener(this.locationListener);
                    this.rectangleTable.put(rec, new RectangleData(member2, null, null));
                    float barheight = (float)member2.getSize().intValue() * this.scale + 1.5f;
                    if (j == memsArray.length - 1) {
                        barheight = (float)this.rectangles[i2].getSize().height - offset;
                    }
                    rec.setSize(width, (int)barheight);
                    rec.setLocation(new Point(0, (int)offset));
                    rec.setToolTip((IFigure)new Label(member2.getToolTip()));
                    offset += (float)((int)(barheight - 1.0f));
                    rec.setBackgroundColor(ColorConstants.buttonDarkest);
                    this.rectangles[i2].add((IFigure)rec);
                    if (this.attachStripes(rec, vmp.getMemberMarkups(member2), vmp, width, true, member2, this.columnButtons[i2])) {
                        rec.setBackgroundColor(ColorConstants.white);
                    }
                    ++j;
                }
            } else if (this.whatToDisplay.get(i2) instanceof IGroup) {
                this.log(3, "Striping " + member.getFullname());
                this.attachStripes((RectangleFigure)this.rectangles[i2], vmp.getGroupMarkups((IGroup)member), vmp, width, false, member, this.columnButtons[i2]);
            } else {
                this.log(3, "Striping " + member.getFullname());
                this.attachStripes((RectangleFigure)this.rectangles[i2], vmp.getMemberMarkups(member), vmp, width, false, member, this.columnButtons[i2]);
            }
            if (this.limit_mode) {
                if (this.rectangles[i2].getBackgroundColor() == ColorConstants.white) {
                    this.panel.add((IFigure)this.rectangles[i2]);
                }
            } else {
                this.panel.add((IFigure)this.rectangles[i2]);
            }
            ++i2;
        }
    }

    private void addShapesAndKeepProportions(int size, Rectangle viewsize, Rectangle originalViewsize) {
        int max_member_size = 0;
        int i = 0;
        while (i < size) {
            IMember member = (IMember)this.whatToDisplay.get(i);
            if (member.getSize() > max_member_size) {
                max_member_size = member.getSize();
            }
            ++i;
        }
        int max_bar_height = max_member_size * this.highlightDepth + 20;
        int viewsize_height_required = max_bar_height + 30;
        if (viewsize.height < viewsize_height_required) {
            viewsize.height = viewsize_height_required;
        }
        int widthRequired = size * (this.minBarWidth + this.spacing);
        int area = widthRequired * viewsize.height;
        boolean cont = true;
        if (area > 5078745) {
            String title = "Absolute proportions view would consume too much area";
            String message = "If the visualise attempts to render your chosen resources in absolute proportions mode, you are likely to see a NoMoreHandles exception from SWT.  Do you want to continue?  (As a workaround, you could try reducing the stripe height in the visualiser configuration and trying again)";
            cont = MessageDialog.openQuestion((Shell)canvas.getParent().getShell(), (String)title, (String)message);
        }
        if (cont) {
            this.continueWithAbsoluteProportions = true;
            this.addShapes(size, viewsize);
        } else {
            this.continueWithAbsoluteProportions = false;
            this.absolute_proportions = false;
            VisualiserPlugin.visualiser.resetAbsoluteProportions();
            this.addShapes(size, originalViewsize);
        }
    }

    private boolean attachStripes(RectangleFigure rec, List markups, IMarkupProvider vmp, int width, boolean ingroupview, IMember mem, Button button) {
        Stripe s = null;
        boolean striped = false;
        int numStripes = 0;
        if (markups != null && markups.size() > 0) {
            TreeSet<Stripe> sortedSet = new TreeSet<Stripe>();
            int j = 0;
            while (j < markups.size()) {
                s = (Stripe)markups.get(j);
                if (s != null) {
                    sortedSet.add(s);
                }
                ++j;
            }
            ArrayList<TraversableRectangleFigure> aboveRowList = null;
            Iterator iter = sortedSet.iterator();
            while (iter.hasNext()) {
                TraversableRectangleFigure lf;
                ++numStripes;
                s = (Stripe)iter.next();
                int activeKinds = 0;
                int i = 0;
                while (i < s.getKinds().size()) {
                    if (VisualiserPlugin.menu == null) {
                        ++activeKinds;
                    } else if (VisualiserPlugin.menu.getActive((String)s.getKinds().get(i))) {
                        ++activeKinds;
                    }
                    ++i;
                }
                int across = 0;
                TraversableRectangleFigure leftF = null;
                ArrayList<TraversableRectangleFigure> thisRowList = new ArrayList<TraversableRectangleFigure>();
                int i2 = 0;
                while (i2 < s.getKinds().size()) {
                    if (VisualiserPlugin.menu == null || VisualiserPlugin.menu.getActive((String)s.getKinds().get(i2))) {
                        striped = true;
                        TraversableRectangleFigure f = new TraversableRectangleFigure(this.rectangleTable);
                        if (leftF != null) {
                            f.setLeftComponent((Figure)leftF);
                            leftF.setRightComponent((Figure)f);
                        }
                        leftF = f;
                        thisRowList.add(f);
                        this.rectangleTable.put(f, new RectangleData(mem, s, (String)s.getKinds().get(i2)));
                        this.addStripe((Figure)f, rec, s, width, across++, activeKinds, ingroupview, vmp, i2);
                    }
                    ++i2;
                }
                if (thisRowList.size() <= 0) continue;
                if (aboveRowList != null) {
                    TraversableRectangleFigure ref;
                    i2 = 0;
                    while (i2 < aboveRowList.size()) {
                        lf = (TraversableRectangleFigure)((Object)aboveRowList.get(i2));
                        ref = (TraversableRectangleFigure)((Object)thisRowList.get(i2 * thisRowList.size() / aboveRowList.size()));
                        lf.setDownComponent((Figure)ref);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < thisRowList.size()) {
                        lf = (TraversableRectangleFigure)((Object)thisRowList.get(i2));
                        ref = (TraversableRectangleFigure)((Object)aboveRowList.get(i2 * aboveRowList.size() / thisRowList.size()));
                        lf.setUpComponent((Figure)ref);
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < thisRowList.size()) {
                        lf = (TraversableRectangleFigure)((Object)thisRowList.get(i2));
                        lf.setUpComponent((Figure)button);
                        if (i2 == 0 && button instanceof BarButton) {
                            ((BarButton)button).setDownComponent((Figure)lf);
                        }
                        ++i2;
                    }
                }
                aboveRowList = thisRowList;
            }
        }
        return striped;
    }

    private void addStripe(Figure f, RectangleFigure rec, Stripe s, int width, int across, int activeKinds, boolean ingroupview, IMarkupProvider vmp, int i) {
        int offsetY;
        if (rec.getBackgroundColor() != ColorConstants.white) {
            rec.setBackgroundColor(ColorConstants.white);
        }
        if ((offsetY = s.getOffset() - 1) < 0) {
            offsetY = 0;
        }
        int depth = s.getDepth();
        this.log(3, "Adding stripe to resource " + offsetY + " depth " + depth);
        float xloc = 1.5f + ((float)width - 1.0f) / (float)activeKinds * (float)across;
        float yloc = (float)offsetY * this.scale;
        if (ingroupview) {
            Point point = rec.getLocation();
            yloc += (float)point.y;
        } else {
            yloc += 20.0f;
        }
        if (offsetY == 0) {
            yloc += 1.0f;
        }
        f.setLocation(new Point((double)xloc, (double)yloc));
        int drawheight = 0;
        drawheight = depth == 1 ? (int)Math.max((double)this.highlightDepth, Math.floor(this.scale)) : (int)(Math.max((float)this.highlightDepth, this.scale) * (float)depth);
        int drawwidth = (int)((float)((width - 2) / activeKinds) + 1.5f);
        int widthwidth = rec.getBounds().width;
        int heightheight = rec.getLocation().y + rec.getBounds().height;
        while (yloc + (float)drawheight >= (float)heightheight) {
            --drawheight;
        }
        while (xloc + (float)drawwidth >= (float)widthwidth) {
            --drawwidth;
        }
        if (drawheight > 0) {
            f.setSize(drawwidth, drawheight);
            f.setBackgroundColor(vmp.getColorFor((String)s.getKinds().get(i)));
            f.addMouseListener(this.mouseListener);
            f.setToolTip((IFigure)new Label(" " + s.getKinds().get(i) + " "));
            rec.add((IFigure)f);
        }
    }

    private void clearPanel() {
        List children = this.panel.getChildren();
        if (children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                IFigure figure = (IFigure)children.get(i);
                this.panel.remove(figure);
                figure.erase();
            }
        }
    }

    private void setAbsoluteProportions(boolean absolute_proportions) {
        this.absolute_proportions = absolute_proportions;
        if (absolute_proportions) {
            this.zoom = 1.0f;
        }
    }

    public boolean zoomIn(Canvas canvas) {
        if (this.zoom + 0.5f <= this.max_zoom) {
            this.zoom += 0.5f;
            this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        }
        return this.zoom + 0.5f <= this.max_zoom;
    }

    public boolean zoomOut(Canvas canvas) {
        this.zoom = this.zoom - 0.5f <= 1.0f ? 1.0f : (this.zoom -= 0.5f);
        this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        return this.zoom > 1.0f;
    }

    protected List getDisplayedData() {
        return this.whatToDisplay;
    }

    public void setDemarcation(boolean set, Canvas canvas) {
        if (this.demarcation != set) {
            this.demarcation = set;
            this.draw(this.whatToDisplay, canvas, this.absolute_proportions);
        }
    }

    public BarButton createButton(String n, int width) {
        BarButton b = new BarButton(n);
        b.setBackgroundColor(ColorConstants.buttonDarker);
        b.setSize(width, 20);
        b.setStyle(Clickable.STYLE_TOGGLE);
        return b;
    }

    private void log(int level, String msg) {
        if (level <= LOGLEVEL) {
            System.err.println(msg);
        }
    }
}

