/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.views.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class Menu
extends ViewPart {
    private IAction selectNoneAction;
    private IAction selectAllAction;
    private static String markerTypes = "cmesearchmarker";
    Button[] buttons;
    Button[] checkboxes;
    Label[] labels;
    Shell[] shells;
    ColorDialog[] colorDialogs;
    Image[] images;
    Color[] colors;
    SelectionAdapter selectionListener;
    MouseListener mouseListener;
    Composite canvas;
    ScrolledComposite scrollpane;
    GridLayout layout = new GridLayout(3, false);
    VisualiserPlugin plugin = VisualiserPlugin.getDefault();
    private static IMarkupProvider vmp;
    private static Hashtable kindActive;
    private boolean uptodate = false;
    private static Action groupByRel_Action;
    private static Action groupByQuery_Action;
    private static Action psychedelic_Action;

    static {
        kindActive = null;
    }

    public Menu() {
        this.plugin.setMenu(this);
        this.reset();
    }

    public void setVisMarkupProvider(IMarkupProvider vmp) {
        Menu.vmp = vmp;
    }

    private void drawImage(Image image, Color color) {
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
    }

    public void createPartControl(Composite parent) {
        this.reset();
        this.scrollpane = new ScrolledComposite(parent, 2816);
        this.canvas = new Composite((Composite)this.scrollpane, 0);
        this.scrollpane.setContent((Control)this.canvas);
        this.canvas.setLayout((Layout)this.layout);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button button = (Button)e.getSource();
                    int location = 0;
                    int j = 0;
                    while (j < Menu.this.buttons.length) {
                        if (Menu.this.buttons[j].equals(button)) {
                            location = j;
                        }
                        ++j;
                    }
                    RGB rgb = Menu.this.colorDialogs[location].open();
                    if (rgb == null) {
                        return;
                    }
                    Menu.this.colors[location] = new Color((Device)Menu.this.buttons[location].getDisplay(), rgb);
                    Image image = Menu.this.buttons[location].getImage();
                    Menu.this.drawImage(image, Menu.this.colors[location]);
                    Menu.this.buttons[location].setImage(image);
                    if (VisualiserPlugin.visualiser != null) {
                        vmp.setColorFor(Menu.this.labels[location].getText(), Menu.this.colors[location]);
                        VisualiserPlugin.visualiser.draw();
                    }
                }
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (VisualiserPlugin.visualiser != null) {
                    int i = 0;
                    while (i < Menu.this.colors.length) {
                        kindActive.put((String)Menu.this.labels[i].getData(), new Boolean(Menu.this.checkboxes[i].getSelection()));
                        ++i;
                    }
                    VisualiserPlugin.visualiser.updateDisplay(false);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.makePullDownActions();
        this.contributeToActionBars();
    }

    private void makePullDownActions() {
        this.selectAllAction = new Action(){

            public int getStyle() {
                return 1;
            }

            public void run() {
                Menu.this.showAll();
            }
        };
        this.selectAllAction.setText(Messages.getString("Select_All_20"));
        this.selectAllAction.setToolTipText(Messages.getString("Select_All_20"));
        this.selectNoneAction = new Action(){

            public int getStyle() {
                return 1;
            }

            public void run() {
                Menu.this.showNone();
            }
        };
        this.selectNoneAction.setText(Messages.getString("Select_None_21"));
        this.selectNoneAction.setToolTipText(Messages.getString("Select_None_21"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.selectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.selectNoneAction);
    }

    private void showAll() {
        if (this.checkboxes != null) {
            int i = 0;
            while (i < this.checkboxes.length) {
                this.checkboxes[i].setSelection(true);
                kindActive.put((String)this.labels[i].getData(), new Boolean(this.checkboxes[i].getSelection()));
                ++i;
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    private void showNone() {
        if (this.checkboxes != null) {
            int i = 0;
            while (i < this.checkboxes.length) {
                this.checkboxes[i].setSelection(false);
                kindActive.put((String)this.labels[i].getData(), new Boolean(false));
                ++i;
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    protected void onlyShow(List names) {
        if (names == null) {
            this.showNone();
        } else if (names.size() == 0) {
            this.showNone();
        } else if (names.size() == this.checkboxes.length) {
            this.showAll();
        } else {
            int i = 0;
            while (i < this.labels.length) {
                if (names.contains(this.labels[i].getText())) {
                    this.checkboxes[i].setSelection(true);
                    kindActive.put((String)this.labels[i].getData(), new Boolean(true));
                } else {
                    this.checkboxes[i].setSelection(false);
                    kindActive.put((String)this.labels[i].getData(), new Boolean(false));
                }
                ++i;
            }
            VisualiserPlugin.visualiser.draw();
        }
    }

    public boolean getActive(String name) {
        if (kindActive == null) {
            return false;
        }
        if (kindActive.get(name) == null) {
            return false;
        }
        return (Boolean)kindActive.get(name);
    }

    public void reset() {
        this.uptodate = false;
    }

    public void ensureUptodate() {
        if (this.uptodate) {
            return;
        }
        this.clear();
        SortedSet markupCategories = vmp.getAllMarkupKinds();
        if (markupCategories == null) {
            return;
        }
        this.buttons = new Button[markupCategories.size()];
        this.checkboxes = new Button[markupCategories.size()];
        this.labels = new Label[markupCategories.size()];
        this.shells = new Shell[markupCategories.size()];
        this.images = new Image[markupCategories.size()];
        this.colorDialogs = new ColorDialog[markupCategories.size()];
        this.colors = new Color[markupCategories.size()];
        kindActive = new Hashtable();
        int i = 0;
        Iterator iter = markupCategories.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            int imageSize = 12;
            this.colors[i] = vmp.getColorFor(element);
            this.buttons[i] = new Button(this.canvas, 8);
            this.shells[i] = this.buttons[i].getShell();
            this.colorDialogs[i] = new ColorDialog(this.shells[i]);
            Display display = this.shells[i].getDisplay();
            this.images[i] = new Image((Device)display, imageSize, imageSize);
            this.buttons[i].setImage(this.images[i]);
            this.buttons[i].addSelectionListener((SelectionListener)this.selectionListener);
            Image image = this.buttons[i].getImage();
            this.drawImage(image, this.colors[i]);
            this.buttons[i].setImage(image);
            this.checkboxes[i] = new Button(this.canvas, 32);
            this.checkboxes[i].addMouseListener(this.mouseListener);
            this.checkboxes[i].setSelection(true);
            this.labels[i] = new Label(this.canvas, 0);
            this.labels[i].setText(element);
            this.labels[i].setData((Object)element);
            kindActive.put(element, new Boolean(true));
            ++i;
        }
        this.canvas.layout();
        this.canvas.setSize(this.canvas.computeSize(-1, -1, true));
        this.uptodate = true;
    }

    private void clear() {
        Control[] children;
        if (this.canvas != null && (children = this.canvas.getChildren()).length > 0) {
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
    }

    public void setFocus() {
        if (this.scrollpane != null) {
            this.scrollpane.setFocus();
        }
    }

    public void dispose() {
        this.plugin.removeMenu();
    }

    private void makeActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        Action Taction = new Action(){

            public void run() {
                Menu.this.markerTypesDialog();
            }
        };
        Taction.setText("Markers...");
        Taction.setToolTipText("Choose displayed markers");
        manager.add((IAction)Taction);
        groupByRel_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByQuery_Action.setChecked(false);
                    psychedelic_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        groupByRel_Action.setText("Group by relationship");
        groupByRel_Action.setChecked(true);
        groupByRel_Action.setToolTipText("Have one color per relationship type");
        manager.add((IAction)groupByRel_Action);
        groupByQuery_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByRel_Action.setChecked(false);
                    psychedelic_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        groupByQuery_Action.setText("Group by query");
        groupByQuery_Action.setChecked(false);
        groupByQuery_Action.setToolTipText("Have one color per query");
        manager.add((IAction)groupByQuery_Action);
        psychedelic_Action = new Action(){

            public void run() {
                if (this.isChecked()) {
                    groupByRel_Action.setChecked(false);
                    groupByQuery_Action.setChecked(false);
                }
                VisualiserPlugin.visualiser.updateDisplay(false);
            }
        };
        psychedelic_Action.setText("Psychedelic");
        psychedelic_Action.setChecked(false);
        psychedelic_Action.setToolTipText("Press it, you know you want to...");
        manager.add((IAction)psychedelic_Action);
    }

    public static boolean isPsychedelic() {
        return psychedelic_Action.isChecked();
    }

    public static boolean isColorPerRelationship() {
        return groupByRel_Action.isChecked();
    }

    public static boolean isColorPerQuery() {
        return groupByQuery_Action.isChecked();
    }

    public static String getMarkersToDisplay() {
        return markerTypes;
    }

    private void markerTypesDialog() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Displayed Markers", "Comma separated list of marker types (e.g. 'cmesearchmarker')", markerTypes, null);
        dlg.open();
        if (dlg.getReturnCode() == 0) {
            markerTypes = dlg.getValue();
            VisualiserPlugin.visualiser.updateDisplay(false);
        }
    }
}

