/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.Hashtable;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.views.BarDrawing;
import org.eclipse.contribution.visualiser.views.RectangleData;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.swt.graphics.Point;

public class TraversableRectangleFigure
extends RectangleFigure {
    private Hashtable rectangleTable;
    private Figure upComponent;
    private Figure downComponent;
    private Figure leftComponent;
    private Figure rightComponent;
    private ToolTipHelper helper;

    public TraversableRectangleFigure(Hashtable rectangleTable) {
        this.rectangleTable = rectangleTable;
        this.setForegroundColor(ColorConstants.black);
        this.addKeyListener(new KeyHandler());
        this.setFocusTraversable(true);
        this.setRequestFocusEnabled(true);
        this.setOutline(false);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
        this.setOutline(true);
        this.repaint();
    }

    public void handleFocusLost(FocusEvent event) {
        super.handleFocusLost(event);
        this.setOutline(false);
        this.removeToolTip();
        this.repaint();
    }

    public boolean isToolTipShowing() {
        return this.helper != null && this.helper.isShowing();
    }

    public void showToolTip() {
        if (this.helper != null && this.helper.isShowing()) {
            this.removeToolTip();
        }
        Point absolute = BarDrawing.canvas.toDisplay(new Point(this.getLocation().x, this.getLocation().y));
        this.helper = new ToolTipHelper(BarDrawing.canvas);
        this.helper.displayToolTipNear((IFigure)this, this.getToolTip(), absolute.x, absolute.y);
    }

    private void removeToolTip() {
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
    }

    public Figure getUpComponent() {
        return this.upComponent;
    }

    public void setUpComponent(Figure upComponent) {
        this.upComponent = upComponent;
    }

    public Figure getDownComponent() {
        return this.downComponent;
    }

    public void setDownComponent(Figure downComponent) {
        this.downComponent = downComponent;
    }

    public Figure getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(Figure leftComponent) {
        this.leftComponent = leftComponent;
    }

    public Figure getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(Figure rightComponent) {
        this.rightComponent = rightComponent;
    }

    class KeyHandler
    implements KeyListener {
        KeyHandler() {
        }

        private void traverseToFigure(TraversableRectangleFigure source, Figure dest) {
            if (dest instanceof TraversableRectangleFigure) {
                TraversableRectangleFigure f = (TraversableRectangleFigure)dest;
                if (source.isToolTipShowing()) {
                    f.showToolTip();
                }
            }
            dest.requestFocus();
        }

        public void keyPressed(KeyEvent ke) {
            Object obj = ke.getSource();
            if (!(obj instanceof TraversableRectangleFigure)) {
                return;
            }
            TraversableRectangleFigure fig = (TraversableRectangleFigure)((Object)obj);
            if (ke.character == ' ') {
                RectangleFigure rectangle = (RectangleFigure)ke.getSource();
                RectangleData rd = (RectangleData)fig.rectangleTable.get(rectangle);
                VisualiserPlugin.visualiser.handleClick(rd.mem, rd.kind, rd.stripe, 1);
            } else if (ke.keycode == 0x1000001) {
                if (fig.getUpComponent() != null) {
                    this.traverseToFigure(fig, fig.getUpComponent());
                }
            } else if (ke.keycode == 0x1000002) {
                if (fig.getDownComponent() != null) {
                    this.traverseToFigure(fig, fig.getDownComponent());
                }
            } else if (ke.keycode == 0x1000003) {
                if (fig.leftComponent != null) {
                    this.traverseToFigure(fig, fig.getLeftComponent());
                }
            } else if (ke.keycode == 0x1000004) {
                if (fig.rightComponent != null) {
                    this.traverseToFigure(fig, fig.getRightComponent());
                }
            } else if (ke.keycode == 0x100000B) {
                fig.showToolTip();
            }
        }

        public void keyReleased(KeyEvent ke) {
        }
    }
}

