/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencesDialog;
import org.eclipse.contribution.visualiser.views.BarDrawing;
import org.eclipse.contribution.visualiser.views.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class Visualiser
extends ViewPart {
    private Action lockAction;
    private static VisualiserPlugin plugin = VisualiserPlugin.getDefault();
    private static BarDrawing barDrawing = BarDrawing.getBarDrawing();
    private static Action groupViewAction;
    private static Action memberViewAction;
    private Action absoluteProportionsAction;
    private Action doubleClickAction;
    private Action limitAction;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action changeStripeModeAction;
    private Action preferencesAction;
    private static ImageDescriptor groupViewImage;
    private static ImageDescriptor memberViewImage;
    public boolean justOpenedFile = false;
    private static int viewMode;
    private static final int VIEWMODE_GROUPS = 0;
    private static final int VIEWMODE_GROUP = 1;
    private static final int VIEWMODE_MEMBERS = 2;
    protected static IContentProvider contentP;
    protected static IMarkupProvider markupP;
    private static List data;
    private static boolean inGroupView;
    private static boolean inLimitMode;
    private static boolean absoluteProportions;
    private static boolean locked;
    private static Canvas canvas;
    private static ScrolledComposite container;
    private Vector selectedElements;
    private Vector annotations;
    private Color[] colors;
    private Rectangle viewsize;
    private static Point containerSize;
    private static Stack context;

    static {
        groupViewImage = VisualiserImages.GROUP_VIEW;
        memberViewImage = VisualiserImages.MEMBER_VIEW;
        viewMode = 0;
        data = null;
        inGroupView = false;
        inLimitMode = false;
        absoluteProportions = false;
        locked = false;
        context = new Stack();
    }

    public Visualiser() {
        plugin.setVisualiser(this);
        this.updateSettingsFromPreferences();
    }

    public void createPartControl(Composite parent) {
        try {
            this.getSite().getPage().showView("org.eclipse.contribution.visualiser.views.Menu");
        }
        catch (PartInitException pie) {
            System.err.println("Error initialising Visualiser Menu");
        }
        container = new ScrolledComposite(parent, 768);
        container.setAlwaysShowScrollBars(false);
        container.setLayoutData((Object)new GridData(1808));
        containerSize = container.getSize();
        canvas = new Canvas((Composite)container, 0);
        canvas.setLayoutData((Object)new GridData(1808));
        container.setContent((Control)canvas);
        this.selectedElements = new Vector();
        this.annotations = new Vector();
        this.makeActions();
        memberViewAction.setChecked(true);
        this.zoomOutAction.setEnabled(false);
        this.contributeToActionBars();
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Visualiser.updateVisUI();
            }
        });
        String title = ProviderManager.getCurrent().getTitle();
        this.refreshTitle(title);
        data = contentP.getAllMembers();
        this.updateDisplay(true);
    }

    public void draw() {
        Visualiser.updateVisUI();
    }

    public void updateSettingsFromPreferences() {
        this.setDemarcation(VisualiserPreferences.isDemarcationEnabled());
        this.setMinStripeSize(VisualiserPreferences.getStripeSize());
        this.setMaxBarSize(VisualiserPreferences.getMaxBarSize());
        this.setMinBarSize(VisualiserPreferences.getMinBarSize());
    }

    public void refreshTitle(String title) {
        this.setTitle(String.valueOf(Messages.getString("Visualiser")) + " - " + title);
    }

    public void setDemarcation(boolean demarcation) {
        barDrawing.setDemarcation(demarcation, canvas);
    }

    public void setMinStripeSize(int size) {
        Visualiser.barDrawing.highlightDepth = size;
        if (canvas != null) {
            this.draw();
        }
    }

    public void setMaxBarSize(int size) {
        Visualiser.barDrawing.maxBarWidth = size;
        this.draw();
    }

    public void setMinBarSize(int size) {
        Visualiser.barDrawing.minBarWidth = size;
        this.draw();
    }

    public void updateDisplay(boolean updateMenu) {
        Visualiser.log(3, "Entering updateDisplay");
        if (!locked) {
            if (inGroupView) {
                if (viewMode == 1) {
                    data = contentP.getAllGroups();
                } else if (viewMode == 0) {
                    data = contentP.getAllGroups();
                } else if (viewMode == 2) {
                    data = contentP.getAllGroups();
                }
            } else if (!inGroupView) {
                if (viewMode == 1) {
                    data = contentP.getAllMembers();
                } else if (viewMode == 0) {
                    data = contentP.getAllMembers();
                } else if (viewMode == 2) {
                    data = contentP.getAllMembers();
                }
            }
        }
        if (VisualiserPlugin.menu != null && updateMenu) {
            VisualiserPlugin.menu.reset();
            VisualiserPlugin.menu.ensureUptodate();
        }
        Visualiser.updateVisUI();
    }

    private static List limitData(List data) {
        if (data == null) {
            return null;
        }
        Visualiser.log(3, "In limit processing: Input size: " + data.size());
        ArrayList activeBars = new ArrayList();
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            List stripes;
            Object element = iter.next();
            if (element instanceof IGroup) {
                IGroup aGroup = (IGroup)element;
                stripes = markupP.getGroupMarkups(aGroup);
                if (!Visualiser.containsActiveStripe(stripes)) continue;
                activeBars.add(element);
                continue;
            }
            IMember aMember = (IMember)element;
            stripes = markupP.getMemberMarkups(aMember);
            if (!Visualiser.containsActiveStripe(stripes)) continue;
            activeBars.add(element);
        }
        Visualiser.log(3, "Finished limit processing: Output size: " + activeBars.size());
        return activeBars;
    }

    private static boolean containsActiveStripe(List stripes) {
        if (stripes == null) {
            return false;
        }
        Iterator iter = stripes.iterator();
        while (iter.hasNext()) {
            Stripe element = (Stripe)iter.next();
            List kinds = element.getKinds();
            Iterator iterator = kinds.iterator();
            while (iterator.hasNext()) {
                String kind = (String)iterator.next();
                if (VisualiserPlugin.menu == null) {
                    return true;
                }
                if (!VisualiserPlugin.menu.getActive(kind)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateVisUI() {
        if (inLimitMode) {
            barDrawing.draw(Visualiser.limitData(data), canvas, absoluteProportions);
        } else {
            barDrawing.draw(data, canvas, absoluteProportions);
        }
    }

    private static void log(int level, String string) {
        if (level <= VisualiserPlugin.LOGLEVEL) {
            System.err.println(string);
        }
    }

    private IMarker getMarker(int location) {
        IResource ir;
        IMarker marker = null;
        if (this.selectedElements.elementAt(location) instanceof IResource && (ir = (IResource)this.selectedElements.elementAt(location)) != null) {
            try {
                marker = ir.createMarker("org.eclipse.core.resources.marker");
            }
            catch (CoreException coreEx) {
                System.err.println((Object)coreEx);
            }
        }
        return marker;
    }

    private IMarker getMarker(int location, int lineNum) {
        IResource ir;
        IMarker marker = null;
        if (this.selectedElements.elementAt(location) instanceof IResource && (ir = (IResource)this.selectedElements.elementAt(location)) != null) {
            try {
                marker = ir.createMarker("org.eclipse.core.resources.marker");
                marker.setAttribute("lineNumber", lineNum);
            }
            catch (CoreException coreEx) {
                System.err.println((Object)coreEx);
            }
        }
        return marker;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        boolean includeChangeStripeModeAction = false;
        if (markupP != null) {
            includeChangeStripeModeAction = markupP.hasMultipleModes();
        }
        this.fillLocalToolBar(bars.getToolBarManager(), includeChangeStripeModeAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.preferencesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.limitAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)groupViewAction);
        manager.add((IAction)memberViewAction);
    }

    private void fillLocalToolBar(IToolBarManager manager, boolean includeChangeStripeMode) {
        manager.add((IAction)this.zoomInAction);
        manager.add((IAction)this.zoomOutAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.lockAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.absoluteProportionsAction);
        manager.add((IContributionItem)new Separator());
        if (includeChangeStripeMode) {
            manager.add((IAction)this.changeStripeModeAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.limitAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)groupViewAction);
        manager.add((IAction)memberViewAction);
    }

    private void makeActions() {
        this.makeActionPreferences();
        this.makeActionChangeStripeMode();
        this.makeActionZoomin();
        this.makeActionZoomout();
        this.makeActionLimitvis();
        this.makeActionGroupView();
        this.makeActionMemberView();
        this.makeActionAbsoluteProportions();
        this.makeActionLock();
    }

    private void makeActionPreferences() {
        this.preferencesAction = new Action(){

            public void run() {
                VisualiserPreferencesDialog vpd = new VisualiserPreferencesDialog(new Shell());
                vpd.create();
                vpd.open();
            }
        };
        this.preferencesAction.setText(Messages.getString("Preferences_24"));
        this.preferencesAction.setToolTipText(Messages.getString("Preferences_Tip_25"));
        this.preferencesAction.setImageDescriptor(VisualiserImages.PREFERENCES);
    }

    private void makeActionAbsoluteProportions() {
        this.absoluteProportionsAction = new Action(){

            public void run() {
                absoluteProportions = !absoluteProportions;
                Visualiser.updateVisUI();
                Visualiser.this.zoomInAction.setEnabled(!absoluteProportions);
                Visualiser.this.zoomOutAction.setEnabled(!absoluteProportions);
            }

            public int getStyle() {
                return 2;
            }
        };
        this.absoluteProportionsAction.setText(Messages.getString("Absolute_Proportions"));
        this.absoluteProportionsAction.setToolTipText(Messages.getString("Absolute_Proportions"));
        this.absoluteProportionsAction.setImageDescriptor(VisualiserImages.ABSOLUTE_PROPORTIONS);
    }

    private void makeActionChangeStripeMode() {
        this.changeStripeModeAction = new Action(){

            public void run() {
                if (markupP.changeMode()) {
                    Visualiser.this.updateDisplay(true);
                }
            }
        };
        this.changeStripeModeAction.setText(Messages.getString("Change_Mode_22"));
        this.changeStripeModeAction.setToolTipText(Messages.getString("Change_Mode_23"));
        ImageDescriptor changeID = VisualiserImages.CHANGE_STRIPE_MODE;
        this.changeStripeModeAction.setImageDescriptor(changeID);
    }

    private void makeActionMemberView() {
        memberViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                Visualiser.activateMemberView();
                Visualiser.this.updateDisplay(false);
            }
        };
        memberViewAction.setText(Messages.getString("Class_View_15"));
        memberViewAction.setToolTipText(Messages.getString("Changes_to_member_view_16"));
        memberViewAction.setImageDescriptor(memberViewImage);
    }

    private void makeActionGroupView() {
        groupViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inGroupView) {
                    this.setChecked(true);
                    memberViewAction.setChecked(false);
                    inGroupView = true;
                } else {
                    this.setChecked(true);
                }
                Visualiser.activateGroupView();
                Visualiser.this.updateDisplay(false);
            }
        };
        groupViewAction.setText(Messages.getString("Package_View_12"));
        groupViewAction.setToolTipText(Messages.getString("Changes_to_group_view_13"));
        groupViewAction.setImageDescriptor(groupViewImage);
    }

    private void makeActionLimitvis() {
        this.limitAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inLimitMode) {
                    inLimitMode = true;
                } else {
                    inLimitMode = false;
                }
                this.setChecked(inLimitMode);
                Visualiser.this.updateDisplay(false);
            }
        };
        this.limitAction.setText(Messages.getString("Limit_view_9"));
        this.limitAction.setToolTipText(Messages.getString("Limits_visualisation_to_affected_bars_only_10"));
        this.limitAction.setImageDescriptor(VisualiserImages.LIMIT_MODE);
    }

    private void makeActionZoomout() {
        this.zoomOutAction = new Action(){

            public void run() {
                boolean zoom = barDrawing.zoomOut(canvas);
                this.setEnabled(zoom);
                Visualiser.this.zoomInAction.setEnabled(true);
            }
        };
        this.zoomOutAction.setText(Messages.getString("Zoom_Out_6"));
        this.zoomOutAction.setToolTipText(Messages.getString("Zooms_out_7"));
        this.zoomOutAction.setImageDescriptor(VisualiserImages.ZOOM_OUT);
    }

    private void makeActionZoomin() {
        this.zoomInAction = new Action(){

            public void run() {
                Visualiser.this.zoomOutAction.setEnabled(true);
                boolean zoom = barDrawing.zoomIn(canvas);
                this.setEnabled(zoom);
            }
        };
        this.zoomInAction.setText(Messages.getString("Zoom_In_3"));
        this.zoomInAction.setToolTipText(Messages.getString("Zooms_in_on_visualisation_4"));
        this.zoomInAction.setImageDescriptor(VisualiserImages.ZOOM_IN);
    }

    private void makeActionLock() {
        this.lockAction = new Action(){

            public void run() {
                locked = !locked;
                groupViewAction.setEnabled(!locked);
                memberViewAction.setEnabled(!locked);
                if (!locked) {
                    Visualiser.this.updateDisplay(true);
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this.lockAction.setText(Messages.getString("Lock"));
        this.lockAction.setToolTipText(Messages.getString("Lock_Tooltip"));
        this.lockAction.setImageDescriptor(VisualiserImages.LOCK);
    }

    public void setFocus() {
        if (container != null) {
            container.setFocus();
        }
    }

    public void dispose() {
        plugin.removeVisualiser();
        canvas = null;
    }

    public void setVisContentProvider(IContentProvider vcp) {
        contentP = vcp;
        memberViewImage = vcp.getMemberViewIcon() == null ? VisualiserImages.MEMBER_VIEW : vcp.getMemberViewIcon();
        ImageDescriptor imageDescriptor = groupViewImage = vcp.getGroupViewIcon() == null ? VisualiserImages.GROUP_VIEW : vcp.getGroupViewIcon();
        if (groupViewAction != null) {
            groupViewAction.setImageDescriptor(groupViewImage);
        }
        if (memberViewAction != null) {
            memberViewAction.setImageDescriptor(memberViewImage);
        }
    }

    public void setVisMarkupProvider(IMarkupProvider vmp) {
        markupP = vmp;
        if (markupP.hasMultipleModes()) {
            if (this.changeStripeModeAction == null) {
                this.makeActionChangeStripeMode();
                if (this.getViewSite() != null) {
                    IActionBars bars = this.getViewSite().getActionBars();
                    bars.getToolBarManager().removeAll();
                    this.fillLocalToolBar(bars.getToolBarManager(), true);
                    bars.updateActionBars();
                }
            }
        } else if (this.changeStripeModeAction != null) {
            IActionBars bars = this.getViewSite().getActionBars();
            bars.getToolBarManager().removeAll();
            this.fillLocalToolBar(bars.getToolBarManager(), false);
            bars.updateActionBars();
            this.changeStripeModeAction = null;
        }
    }

    private static void activateMemberView() {
        inGroupView = false;
        memberViewAction.setChecked(true);
        groupViewAction.setChecked(false);
    }

    private static void activateGroupView() {
        inGroupView = true;
        memberViewAction.setChecked(false);
        groupViewAction.setChecked(true);
    }

    protected void onlyShowColorsAffecting(String name) {
        ArrayList<String> names = new ArrayList<String>();
        List members = contentP.getAllMembers();
        boolean found = false;
        Iterator it = members.iterator();
        while (it.hasNext()) {
            IMember member = (IMember)it.next();
            if (!member.getToolTip().equals(name)) continue;
            found = true;
            List markups = markupP.getMemberMarkups(member);
            if (markups == null) {
                VisualiserPlugin.menu.onlyShow(null);
                return;
            }
            Iterator it2 = markups.iterator();
            while (it2.hasNext()) {
                Stripe stripe = (Stripe)it2.next();
                List kinds = stripe.getKinds();
                Iterator it3 = kinds.iterator();
                while (it3.hasNext()) {
                    String kind = (String)it3.next();
                    if (names.contains(kind)) continue;
                    names.add(kind);
                }
            }
        }
        if (!found) {
            List groups = contentP.getAllGroups();
            Iterator it2 = groups.iterator();
            while (it2.hasNext()) {
                IGroup group = (IGroup)it2.next();
                if (!group.getToolTip().equals(name)) continue;
                List markups = markupP.getGroupMarkups(group);
                if (markups == null) {
                    VisualiserPlugin.menu.onlyShow(null);
                    return;
                }
                Iterator it22 = markups.iterator();
                while (it22.hasNext()) {
                    Stripe stripe = (Stripe)it22.next();
                    List kinds = stripe.getKinds();
                    Iterator it3 = kinds.iterator();
                    while (it3.hasNext()) {
                        String kind = (String)it3.next();
                        if (names.contains(kind)) continue;
                        names.add(kind);
                    }
                }
            }
        }
        VisualiserPlugin.menu.onlyShow(names);
    }

    protected void handleClick(IMember member, String kind, Stripe stripe, int buttonClicked) {
        boolean proceed = contentP.processMouseclick(member != null ? member : null, stripe != null, buttonClicked);
        if (stripe != null) {
            boolean bl = proceed = markupP.processMouseclick(member != null ? member : null, stripe, kind, buttonClicked) && proceed;
        }
        if (proceed) {
            if (buttonClicked != 3) {
                Visualiser.stackContext();
                if (inGroupView) {
                    IGroup grp = member.getContainingGroup();
                    Visualiser.activateMemberView();
                }
                this.updateDisplay(false);
            } else {
                Visualiser.unstackContext();
            }
        }
    }

    private static void stackContext() {
        ViewContext vctx = new ViewContext();
        vctx.setGroupView(inGroupView);
        vctx.setLimitmode(inLimitMode);
        vctx.setData(data);
        if (context.size() == 0) {
            context.push(vctx);
        } else if (!vctx.equals((ViewContext)context.peek())) {
            context.push(vctx);
        }
    }

    private static void unstackContext() {
        if (context.size() == 0) {
            return;
        }
        ViewContext vctx = (ViewContext)context.pop();
        inGroupView = vctx.getGroupView();
        inLimitMode = vctx.getLimitMode();
        data = vctx.getData();
    }

    public void resetAbsoluteProportions() {
        absoluteProportions = false;
        this.absoluteProportionsAction.setChecked(false);
        this.zoomInAction.setEnabled(true);
        this.zoomOutAction.setEnabled(true);
    }

    private static class ViewContext {
        private boolean groupview;
        private boolean subselect;
        private boolean limitmode;
        private List subselection;
        private List data;

        ViewContext() {
        }

        public boolean equals(ViewContext that) {
            int i;
            if (this.groupview != that.groupview) {
                return false;
            }
            if (this.limitmode != that.limitmode) {
                return false;
            }
            if (this.subselection == null && that.subselection != null) {
                return false;
            }
            if (that.subselection == null && this.subselection != null) {
                return false;
            }
            if (this.subselection != null) {
                if (this.subselection.size() != that.subselection.size()) {
                    return false;
                }
                i = 0;
                while (i < this.subselection.size()) {
                    if (!this.subselection.get(i).equals(that.subselection.get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            if (this.data == null && that.data != null) {
                return false;
            }
            if (that.data == null && this.data != null) {
                return false;
            }
            if (this.data != null) {
                if (this.data.size() != that.data.size()) {
                    return false;
                }
                i = 0;
                while (i < this.data.size()) {
                    if (!this.data.get(i).equals(that.data.get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public void setGroupView(boolean in_group_view) {
            this.groupview = in_group_view;
        }

        public boolean getGroupView() {
            return this.groupview;
        }

        public void setSubselect(boolean in_sub_select_mode) {
            this.subselect = in_sub_select_mode;
        }

        public boolean getSubselect() {
            return this.subselect;
        }

        public void setSubselection(List subsel) {
            this.subselection = subsel;
        }

        public List getSubselection() {
            return this.subselection;
        }

        public void setData(List dta) {
            this.data = dta;
        }

        public List getData() {
            return this.data;
        }

        public void setLimitmode(boolean limit_mode) {
            this.limitmode = limit_mode;
        }

        public boolean getLimitMode() {
            return inLimitMode;
        }
    }
}

