/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.StringSet;

public class AjState {
    AjBuildManager buildManager;
    long lastSuccessfulBuildTime = -1L;
    long currentBuildTime = -1L;
    AjBuildConfig buildConfig;
    AjBuildConfig newBuildConfig;
    Map resultsFromFile = new HashMap();
    Map references = new HashMap();
    Map binarySourceFiles = new HashMap();
    Map classesFromName = new HashMap();
    List compiledSourceFiles = new ArrayList();
    List resources = new ArrayList();
    ArrayList qualifiedStrings;
    ArrayList simpleStrings;
    Set addedFiles;
    Set deletedFiles;
    Set addedBinaryFiles;
    Set deletedBinaryFiles;
    List addedClassFiles;

    public AjState(AjBuildManager buildManager) {
        this.buildManager = buildManager;
    }

    void successfulCompile(AjBuildConfig config) {
        this.buildConfig = config;
        this.lastSuccessfulBuildTime = this.currentBuildTime;
    }

    boolean prepareForNextBuild(AjBuildConfig newBuildConfig) {
        this.currentBuildTime = System.currentTimeMillis();
        this.addedClassFiles = new ArrayList();
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            return false;
        }
        if (newBuildConfig.getOutputJar() != null) {
            return false;
        }
        if (this.pathChange(this.buildConfig, newBuildConfig)) {
            return false;
        }
        this.simpleStrings = new ArrayList();
        this.qualifiedStrings = new ArrayList();
        HashSet oldFiles = new HashSet(this.buildConfig.getFiles());
        HashSet newFiles = new HashSet(newBuildConfig.getFiles());
        this.addedFiles = new HashSet(newFiles);
        this.addedFiles.removeAll(oldFiles);
        this.deletedFiles = new HashSet(oldFiles);
        this.deletedFiles.removeAll(newFiles);
        HashSet oldBinaryFiles = new HashSet(this.buildConfig.getBinaryFiles());
        HashSet newBinaryFiles = new HashSet(newBuildConfig.getBinaryFiles());
        this.addedBinaryFiles = new HashSet(newBinaryFiles);
        this.addedBinaryFiles.removeAll(oldBinaryFiles);
        this.deletedBinaryFiles = new HashSet(oldBinaryFiles);
        this.deletedBinaryFiles.removeAll(newBinaryFiles);
        this.newBuildConfig = newBuildConfig;
        return true;
    }

    private Collection getModifiedFiles() {
        return this.getModifiedFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedFiles(long lastBuildTime) {
        ArrayList<File> ret = new ArrayList<File>();
        Iterator i = this.buildConfig.getFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            File file = (File)i.next();
            if (!file.exists() || (modTime = file.lastModified()) < lastBuildTime) continue;
            ret.add(file);
        }
        return ret;
    }

    private Collection getModifiedBinaryFiles() {
        return this.getModifiedBinaryFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedBinaryFiles(long lastBuildTime) {
        ArrayList<AjBuildConfig.BinarySourceFile> ret = new ArrayList<AjBuildConfig.BinarySourceFile>();
        Iterator i = this.buildConfig.getBinaryFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            AjBuildConfig.BinarySourceFile bsfile = (AjBuildConfig.BinarySourceFile)i.next();
            File file = bsfile.binSrc;
            if (!file.exists() || (modTime = file.lastModified()) + 1000L < lastBuildTime) continue;
            ret.add(bsfile);
        }
        return ret;
    }

    private boolean pathChange(AjBuildConfig oldConfig, AjBuildConfig newConfig) {
        List newInPath;
        List newInJars;
        List newAspectpath;
        List newClasspath;
        boolean changed = false;
        List oldClasspath = oldConfig.getClasspath();
        if (this.changed(oldClasspath, newClasspath = newConfig.getClasspath())) {
            return true;
        }
        List oldAspectpath = oldConfig.getAspectpath();
        if (this.changed(oldAspectpath, newAspectpath = newConfig.getAspectpath())) {
            return true;
        }
        List oldInJars = oldConfig.getInJars();
        if (this.changed(oldInJars, newInJars = newConfig.getInJars())) {
            return true;
        }
        List oldInPath = oldConfig.getInpath();
        if (this.changed(oldInPath, newInPath = newConfig.getInpath())) {
            return true;
        }
        return changed;
    }

    private boolean changed(List oldPath, List newPath) {
        if (oldPath == null) {
            oldPath = new ArrayList();
        }
        if (newPath == null) {
            newPath = new ArrayList();
        }
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            Object o = oldPath.get(i);
            File f = null;
            f = o instanceof String ? new File((String)o) : (File)o;
            if (!f.exists() || f.isDirectory() || f.lastModified() < this.lastSuccessfulBuildTime) continue;
            return true;
        }
        return false;
    }

    public List getFilesToCompile(boolean firstPass) {
        ArrayList thisTime = new ArrayList();
        if (firstPass) {
            this.compiledSourceFiles = new ArrayList();
            Collection modifiedFiles = this.getModifiedFiles();
            thisTime.addAll(modifiedFiles);
            thisTime.addAll(this.addedFiles);
            this.deleteClassFiles();
            this.deleteResources();
            this.addAffectedSourceFiles(thisTime, thisTime);
        } else {
            this.addAffectedSourceFiles(thisTime, this.compiledSourceFiles);
        }
        this.compiledSourceFiles = thisTime;
        return thisTime;
    }

    public Map getBinaryFilesToCompile(boolean firstTime) {
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            return this.binarySourceFiles;
        }
        HashMap toWeave = new HashMap();
        if (firstTime) {
            ArrayList addedOrModified = new ArrayList();
            addedOrModified.addAll(this.addedBinaryFiles);
            addedOrModified.addAll(this.getModifiedBinaryFiles());
            Iterator iter = addedOrModified.iterator();
            while (iter.hasNext()) {
                AjBuildConfig.BinarySourceFile bsf = (AjBuildConfig.BinarySourceFile)iter.next();
                UnwovenClassFile ucf = this.createUnwovenClassFile(bsf);
                if (ucf == null) continue;
                ArrayList<UnwovenClassFile> ucfs = new ArrayList<UnwovenClassFile>();
                ucfs.add(ucf);
                this.addDependentsOf(ucf.getClassName());
                this.binarySourceFiles.put(bsf.binSrc.getPath(), ucfs);
                toWeave.put(bsf.binSrc.getPath(), ucfs);
            }
            this.deleteBinaryClassFiles();
        }
        return toWeave;
    }

    private void deleteClassFiles() {
        Iterator i = this.deletedFiles.iterator();
        while (i.hasNext()) {
            File deletedFile = (File)i.next();
            this.addDependentsOf(deletedFile);
            InterimCompilationResult intRes = (InterimCompilationResult)this.resultsFromFile.get(deletedFile);
            this.resultsFromFile.remove(deletedFile);
            if (intRes == null) continue;
            for (int j = 0; j < intRes.unwovenClassFiles().length; ++j) {
                this.deleteClassFile(intRes.unwovenClassFiles()[j]);
            }
        }
    }

    private void deleteBinaryClassFiles() {
        Iterator iter = this.deletedBinaryFiles.iterator();
        while (iter.hasNext()) {
            AjBuildConfig.BinarySourceFile deletedFile = (AjBuildConfig.BinarySourceFile)iter.next();
            List ucfs = (List)this.binarySourceFiles.get(deletedFile.binSrc.getPath());
            this.binarySourceFiles.remove(deletedFile.binSrc.getPath());
            this.deleteClassFile((UnwovenClassFile)ucfs.get(0));
        }
    }

    private void deleteResources() {
        ArrayList oldResources = new ArrayList();
        oldResources.addAll(this.resources);
        Iterator<Object> i = this.buildConfig.getInpath().iterator();
        while (i.hasNext()) {
            File inPathElement = (File)i.next();
            if (!inPathElement.isDirectory()) continue;
        }
        if (this.buildConfig.getSourcePathResources() != null) {
            i = this.buildConfig.getSourcePathResources().keySet().iterator();
            while (i.hasNext()) {
                String resource = (String)i.next();
                this.maybeDeleteResource(resource, oldResources);
            }
        }
        Iterator iter = oldResources.iterator();
        while (iter.hasNext()) {
            String victim = (String)iter.next();
            File f = new File(this.buildConfig.getOutputDir(), victim);
            if (f.exists()) {
                f.delete();
            }
            this.resources.remove(victim);
        }
    }

    private void maybeDeleteResource(String resName, List oldResources) {
        if (this.resources.contains(resName)) {
            oldResources.remove(resName);
            File source = new File(this.buildConfig.getOutputDir(), resName);
            if (source != null && source.exists() && source.lastModified() >= this.lastSuccessfulBuildTime) {
                this.resources.remove(resName);
            }
        }
    }

    private void deleteResourcesFromDirectory(File dir, List oldResources) {
        File[] files = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory() && !f.getName().endsWith(".class");
                return accept;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
            this.maybeDeleteResource(filename, oldResources);
        }
    }

    private void deleteClassFile(UnwovenClassFile classFile) {
        this.classesFromName.remove(classFile.getClassName());
        this.buildManager.bcelWeaver.deleteClassFile(classFile.getClassName());
        try {
            classFile.deleteRealFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private UnwovenClassFile createUnwovenClassFile(AjBuildConfig.BinarySourceFile bsf) {
        UnwovenClassFile ucf = null;
        try {
            ucf = this.buildManager.bcelWeaver.addClassFile(bsf.binSrc, bsf.fromInPathDirectory, this.buildConfig.getOutputDir());
        }
        catch (IOException ex) {
            Message msg = new Message("can't read class file " + bsf.binSrc.getPath(), new SourceLocation(bsf.binSrc, 0), false);
            this.buildManager.handler.handleMessage(msg);
        }
        return ucf;
    }

    public void noteResult(InterimCompilationResult result) {
        int i;
        File sourceFile = new File(result.fileName());
        CompilationResult cr = result.result();
        if (result != null) {
            this.references.put(sourceFile, new ReferenceCollection(cr.qualifiedReferences, cr.simpleNameReferences));
        }
        InterimCompilationResult previous = (InterimCompilationResult)this.resultsFromFile.get(sourceFile);
        UnwovenClassFile[] unwovenClassFiles = result.unwovenClassFiles();
        for (i = 0; i < unwovenClassFiles.length; ++i) {
            UnwovenClassFile lastTimeRound = this.removeFromPreviousIfPresent(unwovenClassFiles[i], previous);
            this.recordClassFile(unwovenClassFiles[i], lastTimeRound);
            this.classesFromName.put(unwovenClassFiles[i].getClassName(), unwovenClassFiles[i]);
        }
        if (previous != null) {
            for (i = 0; i < previous.unwovenClassFiles().length; ++i) {
                if (previous.unwovenClassFiles()[i] == null) continue;
                this.deleteClassFile(previous.unwovenClassFiles()[i]);
            }
        }
        this.resultsFromFile.put(sourceFile, result);
    }

    private UnwovenClassFile removeFromPreviousIfPresent(UnwovenClassFile cf, InterimCompilationResult previous) {
        if (previous == null) {
            return null;
        }
        UnwovenClassFile[] unwovenClassFiles = previous.unwovenClassFiles();
        for (int i = 0; i < unwovenClassFiles.length; ++i) {
            UnwovenClassFile candidate = unwovenClassFiles[i];
            if (candidate == null || !candidate.getFilename().equals(cf.getFilename())) continue;
            unwovenClassFiles[i] = null;
            return candidate;
        }
        return null;
    }

    private void recordClassFile(UnwovenClassFile thisTime, UnwovenClassFile lastTime) {
        byte[] oldBytes;
        if (this.simpleStrings == null) {
            return;
        }
        if (lastTime == null) {
            this.addDependentsOf(thisTime.getClassName());
            return;
        }
        byte[] newBytes = thisTime.getBytes();
        boolean bytesEqual = newBytes.length == (oldBytes = lastTime.getBytes()).length;
        for (int i = 0; i < oldBytes.length && bytesEqual; ++i) {
            if (newBytes[i] == oldBytes[i]) continue;
            bytesEqual = false;
        }
        if (!bytesEqual) {
            try {
                ClassFileReader reader = new ClassFileReader(oldBytes, lastTime.getFilename().toCharArray());
                if (!reader.isLocal() && !reader.isAnonymous() && reader.hasStructuralChanges(newBytes)) {
                    this.addDependentsOf(lastTime.getClassName());
                }
            }
            catch (ClassFormatException e) {
                this.addDependentsOf(lastTime.getClassName());
            }
        }
    }

    private static StringSet makeStringSet(List strings) {
        StringSet ret = new StringSet(strings.size());
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            ret.add(element);
        }
        return ret;
    }

    protected void addAffectedSourceFiles(List addTo, List lastTimeSources) {
        char[][] simpleNames;
        if (this.qualifiedStrings.isEmpty() && this.simpleStrings.isEmpty()) {
            return;
        }
        char[][][] qualifiedNames = ReferenceCollection.internQualifiedNames(AjState.makeStringSet(this.qualifiedStrings));
        if (qualifiedNames.length < this.qualifiedStrings.size()) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(AjState.makeStringSet(this.simpleStrings))).length < this.simpleStrings.size()) {
            simpleNames = null;
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            File file;
            Map.Entry entry = i.next();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = (File)entry.getKey()).exists() || lastTimeSources.contains(file)) continue;
            addTo.add(file);
        }
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
    }

    protected void addDependentsOf(String qualifiedTypeName) {
        String typeName;
        int lastDot = qualifiedTypeName.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = qualifiedTypeName.substring(0, lastDot).replace('.', '/');
            if (!this.qualifiedStrings.contains(packageName)) {
                this.qualifiedStrings.add(packageName);
            }
            typeName = qualifiedTypeName.substring(lastDot + 1);
        } else {
            this.qualifiedStrings.add("");
            typeName = qualifiedTypeName;
        }
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (!this.simpleStrings.contains(typeName)) {
            this.simpleStrings.add(typeName);
        }
    }

    protected void addDependentsOf(File sourceFile) {
        InterimCompilationResult intRes = (InterimCompilationResult)this.resultsFromFile.get(sourceFile);
        if (intRes == null) {
            return;
        }
        for (int i = 0; i < intRes.unwovenClassFiles().length; ++i) {
            this.addDependentsOf(intRes.unwovenClassFiles()[i].getClassName());
        }
    }
}

