/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.patterns.FastMatchInfo;

public class Metrics {
    public static int fastMatchAttempted = 0;
    public static int fastMatchTrue = 0;
    public static int fastMatchFalse = 0;
    public static int fastMatchOnTypeAttempted = 0;
    public static int fastMatchOnTypeTrue = 0;
    public static int fastMatchOnTypeFalse = 0;
    public static int matchTrue = 0;
    public static int matchAttempted = 0;

    public static void recordFastMatchResult(String string, FuzzyBoolean fb) {
        ++fastMatchAttempted;
        if (fb.alwaysTrue()) {
            ++fastMatchTrue;
        }
        if (fb.alwaysFalse()) {
            ++fastMatchFalse;
        }
    }

    public static void dumpInfo() {
        System.err.println("Match summary:");
        int fastMatchOnTypeMaybe = fastMatchOnTypeAttempted - fastMatchOnTypeTrue - fastMatchOnTypeFalse;
        System.err.print("At the type level, we attempted #" + fastMatchOnTypeAttempted + " fast matches:");
        System.err.println("   YES/NO/MAYBE = " + fastMatchOnTypeTrue + "/" + fastMatchOnTypeFalse + "/" + fastMatchOnTypeMaybe);
        int fastMatchMaybe = fastMatchAttempted - fastMatchFalse - fastMatchTrue;
        System.err.print("Within those #" + (fastMatchOnTypeTrue + fastMatchOnTypeMaybe) + " possible types, ");
        System.err.print("we fast matched on #" + fastMatchAttempted + " shadows:");
        System.err.println("   YES/NO/MAYBE = " + fastMatchTrue + "/" + fastMatchFalse + "/" + fastMatchMaybe);
        System.err.println("Shadow (non-fast) matches attempted #" + matchAttempted + " of which " + matchTrue + " successful");
    }

    public static void reset() {
        fastMatchAttempted = 0;
        fastMatchTrue = 0;
        fastMatchFalse = 0;
        fastMatchOnTypeAttempted = 0;
        fastMatchOnTypeTrue = 0;
        fastMatchOnTypeFalse = 0;
        matchTrue = 0;
        matchAttempted = 0;
    }

    public static void recordMatchResult(ShadowMunger munger, boolean b) {
        ++matchAttempted;
        if (b) {
            ++matchTrue;
        }
    }

    public static void recordFastMatchTypeResult(String string, FastMatchInfo info, FuzzyBoolean fb) {
        ++fastMatchOnTypeAttempted;
        if (fb.alwaysTrue()) {
            ++fastMatchOnTypeTrue;
        }
        if (fb.alwaysFalse()) {
            ++fastMatchOnTypeFalse;
        }
    }
}

