/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Iterators;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.Position;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;

public abstract class ResolvedTypeX
extends TypeX {
    protected World world;
    public CrosscuttingMembers crosscuttingMembers;
    private List shadowMungers = new ArrayList(0);
    public static final ResolvedTypeX[] NONE = new ResolvedTypeX[0];
    public static final Primitive BYTE = new Primitive("B", 1, 0);
    public static final Primitive CHAR = new Primitive("C", 1, 1);
    public static final Primitive DOUBLE = new Primitive("D", 2, 2);
    public static final Primitive FLOAT = new Primitive("F", 1, 3);
    public static final Primitive INT = new Primitive("I", 1, 4);
    public static final Primitive LONG = new Primitive("J", 2, 5);
    public static final Primitive SHORT = new Primitive("S", 1, 6);
    public static final Primitive VOID = new Primitive("V", 0, 8);
    public static final Primitive BOOLEAN = new Primitive("Z", 1, 7);
    public static final Missing MISSING = new Missing();
    protected List interTypeMungers = new ArrayList(0);

    ResolvedTypeX(String signature, World world) {
        super(signature);
        this.world = world;
    }

    public final Iterator getDirectSupertypes() {
        Iterator ifacesIterator = Iterators.array(this.getDeclaredInterfaces());
        ResolvedTypeX superclass = this.getSuperclass();
        if (superclass == null) {
            return ifacesIterator;
        }
        return Iterators.snoc(ifacesIterator, superclass);
    }

    public abstract ResolvedMember[] getDeclaredFields();

    public abstract ResolvedMember[] getDeclaredMethods();

    public abstract ResolvedTypeX[] getDeclaredInterfaces();

    public abstract ResolvedMember[] getDeclaredPointcuts();

    public abstract ResolvedTypeX getSuperclass();

    public abstract int getModifiers();

    public abstract boolean needsNoConversionFrom(TypeX var1);

    public abstract boolean isCoerceableFrom(TypeX var1);

    public abstract boolean isAssignableFrom(TypeX var1);

    public final Iterator getDirectSupertypes(World world) {
        return this.getDirectSupertypes();
    }

    public final ResolvedMember[] getDeclaredFields(World world) {
        return this.getDeclaredFields();
    }

    public final ResolvedMember[] getDeclaredMethods(World world) {
        return this.getDeclaredMethods();
    }

    public final TypeX[] getDeclaredInterfaces(World world) {
        return this.getDeclaredInterfaces();
    }

    public final ResolvedMember[] getDeclaredPointcuts(World world) {
        return this.getDeclaredPointcuts();
    }

    public final int getModifiers(World world) {
        return this.getModifiers();
    }

    public final TypeX getSuperclass(World world) {
        return this.getSuperclass();
    }

    public final boolean isAssignableFrom(TypeX other, World world) {
        return this.isAssignableFrom(other);
    }

    public final boolean isCoerceableFrom(TypeX other, World world) {
        return this.isCoerceableFrom(other);
    }

    public boolean needsNoConversionFrom(TypeX other, World world) {
        return this.needsNoConversionFrom(other);
    }

    public final boolean isConvertableFrom(TypeX other) {
        if (this.equals(TypeX.OBJECT) || other.equals(TypeX.OBJECT)) {
            return true;
        }
        return this.isCoerceableFrom(other);
    }

    public ResolvedTypeX getResolvedComponentType() {
        return null;
    }

    public ResolvedTypeX resolve(World world) {
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public final boolean equals(Object other) {
        if (other instanceof ResolvedTypeX) {
            return this == other;
        }
        return super.equals(other);
    }

    public Iterator getFields() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedTypeX)o).getDirectSupertypes());
            }
        };
        Iterators.Getter fieldGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedTypeX)o).getDeclaredFields());
            }
        };
        return Iterators.mapOver(Iterators.recur(this, typeGetter), fieldGetter);
    }

    public Iterator getMethods() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter ifaceGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(Iterators.array(((ResolvedTypeX)o).getDeclaredInterfaces()));
            }
        };
        Iterators.Getter methodGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedTypeX)o).getDeclaredMethods());
            }
        };
        return Iterators.mapOver(Iterators.append(new Iterator(this){
            ResolvedTypeX curr;
            private final /* synthetic */ ResolvedTypeX this$0;
            {
                this.curr = this.this$0 = this$0;
            }

            public boolean hasNext() {
                return this.curr != null;
            }

            public Object next() {
                ResolvedTypeX ret = this.curr;
                this.curr = this.curr.getSuperclass();
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, Iterators.recur(this, ifaceGetter)), methodGetter);
    }

    public ResolvedMember lookupField(Member m) {
        return this.lookupMember(m, this.getFields());
    }

    public ResolvedMember lookupMethod(Member m) {
        return this.lookupMember(m, this.getMethods());
    }

    private ResolvedMember lookupMember(Member m, Iterator i) {
        while (i.hasNext()) {
            ResolvedMember f = (ResolvedMember)i.next();
            if (!ResolvedTypeX.matches(f, m)) continue;
            return f;
        }
        return null;
    }

    private ResolvedMember lookupMember(Member m, ResolvedMember[] a) {
        for (int i = 0; i < a.length; ++i) {
            ResolvedMember f = a[i];
            if (!ResolvedTypeX.matches(f, m)) continue;
            return f;
        }
        return null;
    }

    public static boolean matches(Member m1, Member m2) {
        if (m1 == null) {
            return m2 == null;
        }
        if (m2 == null) {
            return false;
        }
        return m1.getName().equals(m2.getName()) && m1.getSignature().equals(m2.getSignature());
    }

    public static boolean conflictingSignature(Member m1, Member m2) {
        TypeX[] p2;
        if (m1 == null || m2 == null) {
            return false;
        }
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (m1.getKind() != m2.getKind()) {
            return false;
        }
        if (m1.getKind() == Member.FIELD) {
            return m1.getDeclaringType().equals(m2.getDeclaringType());
        }
        if (m1.getKind() == Member.POINTCUT) {
            return true;
        }
        TypeX[] p1 = m1.getParameterTypes();
        int n = p1.length;
        if (n != (p2 = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (p1[i].equals(p2[i])) continue;
            return false;
        }
        return true;
    }

    public Iterator getPointcuts() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedTypeX)o).getDirectSupertypes());
            }
        };
        Iterators.Getter pointcutGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedTypeX)o).getDeclaredPointcuts());
            }
        };
        return Iterators.mapOver(Iterators.recur(this, typeGetter), pointcutGetter);
    }

    public ResolvedPointcutDefinition findPointcut(String name) {
        Iterator i = this.getPointcuts();
        while (i.hasNext()) {
            ResolvedPointcutDefinition f = (ResolvedPointcutDefinition)i.next();
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public CrosscuttingMembers collectCrosscuttingMembers() {
        this.crosscuttingMembers = new CrosscuttingMembers(this);
        this.crosscuttingMembers.setPerClause(this.getPerClause());
        this.crosscuttingMembers.addShadowMungers(this.collectShadowMungers());
        this.crosscuttingMembers.addTypeMungers(this.getTypeMungers());
        this.crosscuttingMembers.addDeclares(this.collectDeclares(!this.doesNotExposeShadowMungers()));
        this.crosscuttingMembers.addPrivilegedAccesses(this.getPrivilegedAccesses());
        return this.crosscuttingMembers;
    }

    public final Collection collectDeclares(boolean includeAdviceLike) {
        if (!this.isAspect()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Declare> ret = new ArrayList<Declare>();
        Iterator i = this.getDeclares().iterator();
        while (i.hasNext()) {
            Declare dec = (Declare)i.next();
            if (dec.isAdviceLike()) continue;
            ret.add(dec);
        }
        if (!includeAdviceLike) {
            return ret;
        }
        if (!this.isAbstract()) {
            final Iterators.Filter dupFilter = Iterators.dupFilter();
            Iterators.Getter typeGetter = new Iterators.Getter(){

                public Iterator get(Object o) {
                    return dupFilter.filter(((ResolvedTypeX)o).getDirectSupertypes());
                }
            };
            Iterator typeIterator = Iterators.recur(this, typeGetter);
            while (typeIterator.hasNext()) {
                ResolvedTypeX ty = (ResolvedTypeX)typeIterator.next();
                Iterator i2 = ty.getDeclares().iterator();
                while (i2.hasNext()) {
                    Declare dec = (Declare)i2.next();
                    if (!dec.isAdviceLike()) continue;
                    ret.add(dec);
                }
            }
        }
        return ret;
    }

    private final Collection collectShadowMungers() {
        if (!this.isAspect() || this.isAbstract() || this.doesNotExposeShadowMungers()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList acc = new ArrayList();
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedTypeX)o).getDirectSupertypes());
            }
        };
        Iterator typeIterator = Iterators.recur(this, typeGetter);
        while (typeIterator.hasNext()) {
            ResolvedTypeX ty = (ResolvedTypeX)typeIterator.next();
            acc.addAll(ty.getDeclaredShadowMungers());
        }
        return acc;
    }

    protected boolean doesNotExposeShadowMungers() {
        return false;
    }

    public PerClause getPerClause() {
        return null;
    }

    protected Collection getDeclares() {
        return Collections.EMPTY_LIST;
    }

    protected Collection getTypeMungers() {
        return Collections.EMPTY_LIST;
    }

    protected Collection getPrivilegedAccesses() {
        return Collections.EMPTY_LIST;
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isClass() {
        return false;
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isSynthetic() {
        return this.signature.indexOf("$ajc") != -1;
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public Collection getDeclaredAdvice() {
        ArrayList<ShadowMunger> l = new ArrayList<ShadowMunger>();
        ResolvedMember[] methods = this.getDeclaredMethods();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            ShadowMunger munger = methods[i].getAssociatedShadowMunger();
            if (munger == null) continue;
            l.add(munger);
        }
        return l;
    }

    public Collection getDeclaredShadowMungers() {
        Collection c = this.getDeclaredAdvice();
        c.addAll(this.shadowMungers);
        return c;
    }

    public void addShadowMunger(ShadowMunger munger) {
        this.shadowMungers.add(munger);
    }

    public ResolvedMember[] getDeclaredJavaFields() {
        return this.filterInJavaVisible(this.getDeclaredFields());
    }

    public ResolvedMember[] getDeclaredJavaMethods() {
        return this.filterInJavaVisible(this.getDeclaredMethods());
    }

    public ShadowMunger[] getDeclaredShadowMungersArray() {
        List l = (List)this.getDeclaredShadowMungers();
        return l.toArray(new ShadowMunger[l.size()]);
    }

    private ResolvedMember[] filterInJavaVisible(ResolvedMember[] ms) {
        ArrayList<ResolvedMember> l = new ArrayList<ResolvedMember>();
        int len = ms.length;
        for (int i = 0; i < len; ++i) {
            if (ms[i].isAjSynthetic() || ms[i].getAssociatedShadowMunger() != null) continue;
            l.add(ms[i]);
        }
        return l.toArray(new ResolvedMember[l.size()]);
    }

    public abstract ISourceContext getSourceContext();

    public ResolvedMember lookupMemberNoSupers(Member member) {
        ResolvedMember ret = member.getKind() == Member.FIELD ? this.lookupMember(member, this.getDeclaredFields()) : this.lookupMember(member, this.getDeclaredMethods());
        if (ret == null && this.interTypeMungers != null) {
            Iterator i = this.interTypeMungers.iterator();
            while (i.hasNext()) {
                ConcreteTypeMunger tm = (ConcreteTypeMunger)i.next();
                if (!ResolvedTypeX.matches(tm.getSignature(), member)) continue;
                return tm.getSignature();
            }
        }
        return ret;
    }

    public List getInterTypeMungers() {
        return this.interTypeMungers;
    }

    public List getInterTypeMungersIncludingSupers() {
        ArrayList ret = new ArrayList();
        this.collectInterTypeMungers(ret);
        return ret;
    }

    private void collectInterTypeMungers(List collector) {
        Iterator iter = this.getDirectSupertypes();
        while (iter.hasNext()) {
            ResolvedTypeX superType = (ResolvedTypeX)iter.next();
            superType.collectInterTypeMungers(collector);
        }
        Iterator iter1 = collector.iterator();
        block1: while (iter1.hasNext()) {
            ConcreteTypeMunger superMunger = (ConcreteTypeMunger)iter1.next();
            if (superMunger.getSignature() == null || !superMunger.getSignature().isAbstract()) continue;
            Iterator iter2 = this.getInterTypeMungers().iterator();
            while (iter2.hasNext()) {
                ConcreteTypeMunger myMunger = (ConcreteTypeMunger)iter2.next();
                if (!ResolvedTypeX.conflictingSignature(myMunger.getSignature(), superMunger.getSignature())) continue;
                iter1.remove();
                continue block1;
            }
            if (!superMunger.getSignature().isPublic()) continue;
            iter2 = this.getMethods();
            while (iter2.hasNext()) {
                ResolvedMember method = (ResolvedMember)iter2.next();
                if (!ResolvedTypeX.conflictingSignature(method, superMunger.getSignature())) continue;
                iter1.remove();
                continue block1;
            }
        }
        collector.addAll(this.getInterTypeMungers());
    }

    public void checkInterTypeMungers() {
        if (this.isAbstract()) {
            return;
        }
        Iterator iter = this.getInterTypeMungersIncludingSupers().iterator();
        while (iter.hasNext()) {
            ConcreteTypeMunger element = (ConcreteTypeMunger)iter.next();
            if (element.getSignature() == null || !element.getSignature().isAbstract()) continue;
            this.world.getMessageHandler().handleMessage(new Message("must implement abstract inter-type declaration: " + element.getSignature(), "", IMessage.ERROR, this.getSourceLocation(), null, new ISourceLocation[]{element.getSourceLocation()}));
        }
    }

    public ResolvedTypeX getDeclaringType() {
        if (this.isArray()) {
            return null;
        }
        String name = this.getName();
        int lastDollar = name.lastIndexOf(36);
        while (lastDollar != -1) {
            ResolvedTypeX ret = this.world.resolve(TypeX.forName(name.substring(0, lastDollar)), true);
            if (ret != MISSING) {
                return ret;
            }
            lastDollar = name.lastIndexOf(36, lastDollar - 1);
        }
        return null;
    }

    public static boolean isVisible(int modifiers, ResolvedTypeX targetType, ResolvedTypeX fromType) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return targetType.getOutermostType().equals(fromType.getOutermostType());
        }
        if (Modifier.isProtected(modifiers)) {
            return ResolvedTypeX.samePackage(targetType, fromType) || targetType.isAssignableFrom(fromType);
        }
        return ResolvedTypeX.samePackage(targetType, fromType);
    }

    private static boolean samePackage(ResolvedTypeX targetType, ResolvedTypeX fromType) {
        String p1 = targetType.getPackageName();
        String p2 = fromType.getPackageName();
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    public void addInterTypeMunger(ConcreteTypeMunger munger) {
        ResolvedMember sig = munger.getSignature();
        if (sig == null || munger.getMunger() == null || munger.getMunger().getKind() == ResolvedTypeMunger.PrivilegedAccess) {
            this.interTypeMungers.add(munger);
            return;
        }
        if (sig.getKind() == Member.METHOD) {
            if (!this.compareToExistingMembers(munger, this.getMethods())) {
                return;
            }
            if (this.isInterface() && !this.compareToExistingMembers(munger, Arrays.asList(this.world.resolve(TypeX.OBJECT).getDeclaredMethods()).iterator())) {
                return;
            }
        } else if (sig.getKind() == Member.FIELD ? !this.compareToExistingMembers(munger, Arrays.asList(this.getDeclaredFields()).iterator()) : !this.compareToExistingMembers(munger, Arrays.asList(this.getDeclaredMethods()).iterator())) {
            return;
        }
        Iterator i = this.interTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger existingMunger = (ConcreteTypeMunger)i.next();
            if (!ResolvedTypeX.conflictingSignature(existingMunger.getSignature(), munger.getSignature()) || !ResolvedTypeX.isVisible(munger.getSignature().getModifiers(), munger.getAspectType(), existingMunger.getAspectType())) continue;
            int c = this.compareMemberPrecedence(sig, existingMunger.getSignature());
            if (c == 0) {
                c = this.getWorld().comparePrecedence(munger.getAspectType(), existingMunger.getAspectType());
            }
            if (c < 0) {
                this.checkLegalOverride(munger.getSignature(), existingMunger.getSignature());
                return;
            }
            if (c > 0) {
                this.checkLegalOverride(existingMunger.getSignature(), munger.getSignature());
                i.remove();
                break;
            }
            this.interTypeConflictError(munger, existingMunger);
            this.interTypeConflictError(existingMunger, munger);
            return;
        }
        this.interTypeMungers.add(munger);
    }

    private boolean compareToExistingMembers(ConcreteTypeMunger munger, Iterator existingMembers) {
        ResolvedMember sig = munger.getSignature();
        while (existingMembers.hasNext()) {
            ResolvedMember existingMember = (ResolvedMember)existingMembers.next();
            if (!ResolvedTypeX.conflictingSignature(existingMember, munger.getSignature()) || !ResolvedTypeX.isVisible(existingMember.getModifiers(), this, munger.getAspectType())) continue;
            int c = this.compareMemberPrecedence(sig, existingMember);
            if (c < 0) {
                this.checkLegalOverride(munger.getSignature(), existingMember);
                return false;
            }
            if (c > 0) {
                this.checkLegalOverride(existingMember, munger.getSignature());
                continue;
            }
            this.getWorld().getMessageHandler().handleMessage(MessageUtil.error("inter-type declaration from " + munger.getAspectType().getName() + " conflicts with existing member: " + existingMember, munger.getSourceLocation()));
        }
        return true;
    }

    public boolean checkLegalOverride(ResolvedMember parent, ResolvedMember child) {
        Object[] cTypes;
        Object[] pTypes;
        if (!parent.getReturnType().equals(child.getReturnType())) {
            this.world.showMessage(IMessage.ERROR, "can't override " + parent + " with " + child + " return types don't match", child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        if (parent.getKind() == Member.POINTCUT && !Arrays.equals(pTypes = parent.getParameterTypes(), cTypes = child.getParameterTypes())) {
            this.world.showMessage(IMessage.ERROR, "can't override " + parent + " with " + child + " parameter types don't match", child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        if (ResolvedTypeX.isMoreVisible(parent.getModifiers(), child.getModifiers())) {
            this.world.showMessage(IMessage.ERROR, "can't override " + parent + " with " + child + " visibility is reduced", child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        ResolvedTypeX[] childExceptions = this.world.resolve(child.getExceptions());
        ResolvedTypeX[] parentExceptions = this.world.resolve(parent.getExceptions());
        ResolvedTypeX runtimeException = this.world.resolve("java.lang.RuntimeException");
        ResolvedTypeX error = this.world.resolve("java.lang.Error");
        int leni = childExceptions.length;
        block0: for (int i = 0; i < leni; ++i) {
            if (runtimeException.isAssignableFrom(childExceptions[i]) || error.isAssignableFrom(childExceptions[i])) continue;
            int lenj = parentExceptions.length;
            for (int j = 0; j < lenj; ++j) {
                if (parentExceptions[j].isAssignableFrom(childExceptions[i])) continue block0;
            }
            this.world.showMessage(IMessage.ERROR, "overriden method doesn't throw " + childExceptions[i].getName(), child.getSourceLocation(), null);
            return false;
        }
        return true;
    }

    private int compareMemberPrecedence(ResolvedMember m1, ResolvedMember m2) {
        ResolvedTypeX t2;
        if (Modifier.isAbstract(m1.getModifiers())) {
            return -1;
        }
        if (Modifier.isAbstract(m2.getModifiers())) {
            return 1;
        }
        if (m1.getDeclaringType().equals(m2.getDeclaringType())) {
            return 0;
        }
        ResolvedTypeX t1 = m1.getDeclaringType().resolve(this.world);
        if (t1.isAssignableFrom(t2 = m2.getDeclaringType().resolve(this.world))) {
            return -1;
        }
        if (t2.isAssignableFrom(t1)) {
            return 1;
        }
        return 0;
    }

    public static boolean isMoreVisible(int m1, int m2) {
        if (Modifier.isPrivate(m1)) {
            return false;
        }
        if (ResolvedTypeX.isPackage(m1)) {
            return Modifier.isPrivate(m2);
        }
        if (Modifier.isProtected(m1)) {
            return Modifier.isPrivate(m2) || ResolvedTypeX.isPackage(m2);
        }
        if (Modifier.isPublic(m1)) {
            return !Modifier.isPublic(m2);
        }
        throw new RuntimeException("bad modifier: " + m1);
    }

    private static boolean isPackage(int i) {
        return 0 == (i & 7);
    }

    private void interTypeConflictError(ConcreteTypeMunger m1, ConcreteTypeMunger m2) {
        this.getWorld().showMessage(IMessage.ERROR, "intertype declaration from " + m1.getAspectType().getName() + " conflicts with intertype declaration: " + m2.getSignature() + " from " + m2.getAspectType().getName(), m2.getSourceLocation(), this.getSourceLocation());
    }

    public ResolvedMember lookupSyntheticMember(Member member) {
        Iterator i = this.interTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember ret = m.getMatchingSyntheticMember(member);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void clearInterTypeMungers() {
        this.interTypeMungers = new ArrayList();
    }

    public boolean isTopmostImplementor(ResolvedTypeX interfaceType) {
        if (this.isInterface()) {
            return false;
        }
        if (!interfaceType.isAssignableFrom(this)) {
            return false;
        }
        return !interfaceType.isAssignableFrom(this.getSuperclass());
    }

    public List getExposedPointcuts() {
        ArrayList ret = new ArrayList();
        if (this.getSuperclass() != null) {
            ret.addAll(this.getSuperclass().getExposedPointcuts());
        }
        Iterator<ResolvedTypeX> i = Arrays.asList(this.getDeclaredInterfaces()).iterator();
        while (i.hasNext()) {
            ResolvedTypeX t = i.next();
            this.addPointcutsResolvingConflicts(ret, Arrays.asList(t.getDeclaredPointcuts()), false);
        }
        this.addPointcutsResolvingConflicts(ret, Arrays.asList(this.getDeclaredPointcuts()), true);
        i = ret.iterator();
        while (i.hasNext()) {
            ResolvedPointcutDefinition inherited = (ResolvedPointcutDefinition)((Object)i.next());
            if (!inherited.isAbstract() || this.isAbstract()) continue;
            this.getWorld().showMessage(IMessage.ERROR, "inherited abstract " + inherited + " is not made concrete in " + this.getName(), inherited.getSourceLocation(), this.getSourceLocation());
        }
        return ret;
    }

    private void addPointcutsResolvingConflicts(List acc, List added, boolean isOverriding) {
        Iterator i = added.iterator();
        while (i.hasNext()) {
            ResolvedPointcutDefinition toAdd = (ResolvedPointcutDefinition)i.next();
            Iterator j = acc.iterator();
            while (j.hasNext()) {
                ResolvedPointcutDefinition existing = (ResolvedPointcutDefinition)j.next();
                if (existing == toAdd || !ResolvedTypeX.isVisible(existing.getModifiers(), existing.getDeclaringType().resolve(this.getWorld()), this) || !ResolvedTypeX.conflictingSignature(existing, toAdd)) continue;
                if (isOverriding) {
                    this.checkLegalOverride(existing, toAdd);
                    j.remove();
                    continue;
                }
                this.getWorld().showMessage(IMessage.ERROR, "conflicting inherited pointcuts in " + this.getName() + toAdd.getSignature(), existing.getSourceLocation(), toAdd.getSourceLocation());
                j.remove();
            }
            acc.add(toAdd);
        }
    }

    public ISourceLocation getSourceLocation() {
        return null;
    }

    public boolean isExposedToWeaver() {
        return false;
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    static class Missing
    extends ResolvedTypeX {
        Missing() {
            super("<missing>", null);
        }

        public final String getName() {
            return "<missing>";
        }

        public final ResolvedMember[] getDeclaredFields() {
            return ResolvedMember.NONE;
        }

        public final ResolvedMember[] getDeclaredMethods() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX[] getDeclaredInterfaces() {
            return NONE;
        }

        public final ResolvedMember[] getDeclaredPointcuts() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX getSuperclass() {
            return null;
        }

        public final int getModifiers() {
            return 0;
        }

        public final boolean isAssignableFrom(TypeX other) {
            return false;
        }

        public final boolean isCoerceableFrom(TypeX other) {
            return false;
        }

        public boolean needsNoConversionFrom(TypeX other) {
            return false;
        }

        public ISourceContext getSourceContext() {
            return null;
        }
    }

    static class Primitive
    extends ResolvedTypeX {
        private int size;
        private int index;
        private static final boolean[][] assignTable = new boolean[][]{{true, true, true, true, true, true, true, false, false}, {false, true, true, true, true, true, false, false, false}, {false, false, true, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false}, {false, false, true, true, true, true, false, false, false}, {false, false, true, true, false, true, false, false, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, true}};
        private static final boolean[][] noConvertTable = new boolean[][]{{true, true, false, false, true, false, true, false, false}, {false, true, false, false, true, false, false, false, false}, {false, false, true, false, false, false, false, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, true, false, false, false}, {false, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, true}};

        Primitive(String signature, int size, int index) {
            super(signature, null);
            this.size = size;
            this.index = index;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getModifiers() {
            return 17;
        }

        public final boolean isPrimitive() {
            return true;
        }

        public final boolean isAssignableFrom(TypeX other) {
            if (!other.isPrimitive()) {
                return false;
            }
            return assignTable[((Primitive)other).index][this.index];
        }

        public final boolean isCoerceableFrom(TypeX other) {
            if (this == other) {
                return true;
            }
            if (!other.isPrimitive()) {
                return false;
            }
            return this.index <= 6 && ((Primitive)other).index <= 6;
        }

        public final boolean needsNoConversionFrom(TypeX other) {
            if (!other.isPrimitive()) {
                return false;
            }
            return noConvertTable[((Primitive)other).index][this.index];
        }

        public final ResolvedMember[] getDeclaredFields() {
            return ResolvedMember.NONE;
        }

        public final ResolvedMember[] getDeclaredMethods() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX[] getDeclaredInterfaces() {
            return NONE;
        }

        public final ResolvedMember[] getDeclaredPointcuts() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX getSuperclass() {
            return null;
        }

        public ISourceContext getSourceContext() {
            return null;
        }
    }

    static class Array
    extends ResolvedTypeX {
        ResolvedTypeX componentType;

        Array(String s, World world, ResolvedTypeX componentType) {
            super(s, world);
            this.componentType = componentType;
        }

        public final ResolvedMember[] getDeclaredFields() {
            return ResolvedMember.NONE;
        }

        public final ResolvedMember[] getDeclaredMethods() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX[] getDeclaredInterfaces() {
            return new ResolvedTypeX[]{this.world.resolve(TypeX.CLONEABLE), this.world.resolve(TypeX.SERIALIZABLE)};
        }

        public final ResolvedMember[] getDeclaredPointcuts() {
            return ResolvedMember.NONE;
        }

        public final ResolvedTypeX getSuperclass() {
            return this.world.resolve(TypeX.OBJECT);
        }

        public final boolean isAssignableFrom(TypeX o) {
            if (!o.isArray()) {
                return false;
            }
            if (o.getComponentType().isPrimitive()) {
                return o.equals(this);
            }
            return this.getComponentType().isAssignableFrom(o.getComponentType(), this.world);
        }

        public final boolean isCoerceableFrom(TypeX o) {
            if (o.equals(TypeX.OBJECT) || o.equals(TypeX.SERIALIZABLE) || o.equals(TypeX.CLONEABLE)) {
                return true;
            }
            if (!o.isArray()) {
                return false;
            }
            if (o.getComponentType().isPrimitive()) {
                return o.equals(this);
            }
            return this.getComponentType().isCoerceableFrom(o.getComponentType(), this.world);
        }

        public final boolean needsNoConversionFrom(TypeX o) {
            return this.isAssignableFrom(o);
        }

        public final int getModifiers() {
            int mask = 7;
            return this.componentType.getModifiers() & mask | 0x10;
        }

        public TypeX getComponentType() {
            return this.componentType;
        }

        public ResolvedTypeX getResolvedComponentType() {
            return this.componentType;
        }

        public ISourceContext getSourceContext() {
            return this.getResolvedComponentType().getSourceContext();
        }
    }

    public static abstract class ConcreteName {
        protected boolean exposedToWeaver;
        protected Name resolvedTypeX;

        public ConcreteName(Name resolvedTypeX, boolean exposedToWeaver) {
            this.resolvedTypeX = resolvedTypeX;
            this.exposedToWeaver = exposedToWeaver;
        }

        public final boolean isClass() {
            return !this.isAspect() && !this.isInterface();
        }

        public abstract boolean isAspect();

        public abstract boolean isInterface();

        public abstract ResolvedMember[] getDeclaredFields();

        public abstract ResolvedTypeX[] getDeclaredInterfaces();

        public abstract ResolvedMember[] getDeclaredMethods();

        public abstract ResolvedMember[] getDeclaredPointcuts();

        public abstract PerClause getPerClause();

        protected abstract Collection getDeclares();

        protected abstract Collection getTypeMungers();

        protected abstract Collection getPrivilegedAccesses();

        public abstract int getModifiers();

        public abstract ResolvedTypeX getSuperclass();

        public abstract WeaverStateInfo getWeaverState();

        public boolean doesNotExposeShadowMungers() {
            return false;
        }

        public boolean isExposedToWeaver() {
            return this.exposedToWeaver;
        }

        public Name getResolvedTypeX() {
            return this.resolvedTypeX;
        }
    }

    public static class Name
    extends ResolvedTypeX {
        private ConcreteName delegate = null;
        private ISourceContext sourceContext = null;
        private int startPos = 0;
        private int endPos = 0;

        public Name(String signature, World world) {
            super(signature, world);
        }

        public final boolean isClass() {
            return this.delegate.isClass();
        }

        public boolean isAspect() {
            return this.delegate.isAspect();
        }

        public final boolean needsNoConversionFrom(TypeX o) {
            return this.isAssignableFrom(o);
        }

        public final boolean isAssignableFrom(TypeX o) {
            if (o.isPrimitive()) {
                return false;
            }
            ResolvedTypeX other = o.resolve(this.world);
            return this.isAssignableFrom(other);
        }

        public final boolean isCoerceableFrom(TypeX o) {
            ResolvedTypeX other = o.resolve(this.world);
            if (this.isAssignableFrom(other) || other.isAssignableFrom(this)) {
                return true;
            }
            if (!this.isInterface() && !other.isInterface()) {
                return false;
            }
            if (this.isFinal() || other.isFinal()) {
                return false;
            }
            ResolvedMember[] a = this.getDeclaredMethods();
            ResolvedMember[] b = ((Name)other).getDeclaredMethods();
            int alen = a.length;
            for (int ai = 0; ai < alen; ++ai) {
                int blen = b.length;
                for (int bi = 0; bi < blen; ++bi) {
                    if (b[bi].isCompatibleWith(a[ai])) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignableFrom(ResolvedTypeX other) {
            if (this == other) {
                return true;
            }
            Iterator i = other.getDirectSupertypes();
            while (i.hasNext()) {
                if (!this.isAssignableFrom((ResolvedTypeX)i.next())) continue;
                return true;
            }
            return false;
        }

        public ISourceContext getSourceContext() {
            return this.sourceContext;
        }

        public ISourceLocation getSourceLocation() {
            if (this.sourceContext == null) {
                return null;
            }
            return this.sourceContext.makeSourceLocation(new Position(this.startPos, this.endPos));
        }

        public boolean isExposedToWeaver() {
            return this.delegate == null || this.delegate.isExposedToWeaver();
        }

        public WeaverStateInfo getWeaverState() {
            return this.delegate.getWeaverState();
        }

        public ResolvedMember[] getDeclaredFields() {
            return this.delegate.getDeclaredFields();
        }

        public ResolvedTypeX[] getDeclaredInterfaces() {
            return this.delegate.getDeclaredInterfaces();
        }

        public ResolvedMember[] getDeclaredMethods() {
            return this.delegate.getDeclaredMethods();
        }

        public ResolvedMember[] getDeclaredPointcuts() {
            return this.delegate.getDeclaredPointcuts();
        }

        public PerClause getPerClause() {
            return this.delegate.getPerClause();
        }

        protected Collection getDeclares() {
            return this.delegate.getDeclares();
        }

        protected Collection getTypeMungers() {
            return this.delegate.getTypeMungers();
        }

        protected Collection getPrivilegedAccesses() {
            return this.delegate.getPrivilegedAccesses();
        }

        public int getModifiers() {
            return this.delegate.getModifiers();
        }

        public ResolvedTypeX getSuperclass() {
            return this.delegate.getSuperclass();
        }

        public ConcreteName getDelegate() {
            return this.delegate;
        }

        public void setDelegate(ConcreteName delegate) {
            this.delegate = delegate;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public void setEndPos(int endPos) {
            this.endPos = endPos;
        }

        public void setSourceContext(ISourceContext sourceContext) {
            this.sourceContext = sourceContext;
        }

        public void setStartPos(int startPos) {
            this.startPos = startPos;
        }

        public boolean doesNotExposeShadowMungers() {
            return this.delegate.doesNotExposeShadowMungers();
        }
    }
}

