/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ReferencePointcut
extends Pointcut {
    public TypeX onType;
    public TypePattern onTypeSymbolic;
    public String name;
    public TypePatternList arguments;
    private boolean concretizing = false;

    public ReferencePointcut(TypePattern onTypeSymbolic, String name, TypePatternList arguments) {
        this.onTypeSymbolic = onTypeSymbolic;
        this.name = name;
        this.arguments = arguments;
    }

    public ReferencePointcut(TypeX onType, String name, TypePatternList arguments) {
        this.onType = onType;
        this.name = name;
        this.arguments = arguments;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.NO;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.onType != null) {
            buf.append(this.onType);
            buf.append(".");
        }
        buf.append(this.name);
        buf.append(this.arguments.toString());
        return buf.toString();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        if (this.onType != null) {
            s.writeBoolean(true);
            this.onType.write(s);
        } else {
            s.writeBoolean(false);
        }
        s.writeUTF(this.name);
        this.arguments.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        TypeX onType = null;
        if (s.readBoolean()) {
            onType = TypeX.read(s);
        }
        ReferencePointcut ret = new ReferencePointcut(onType, s.readUTF(), TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        ResolvedTypeX[] parameterTypes;
        if (this.onTypeSymbolic != null) {
            this.onType = this.onTypeSymbolic.resolveExactType(scope, bindings);
            if (this.onType == ResolvedTypeX.MISSING) {
                return;
            }
        }
        ResolvedTypeX searchType = this.onType != null ? scope.getWorld().resolve(this.onType) : scope.getEnclosingType();
        this.arguments.resolveBindings(scope, bindings, true, true);
        ResolvedPointcutDefinition pointcutDef = searchType.findPointcut(this.name);
        if (pointcutDef == null && this.onType == null) {
            ResolvedTypeX declaringType;
            while ((declaringType = searchType.getDeclaringType()) != null) {
                searchType = ((TypeX)declaringType).resolve(scope.getWorld());
                pointcutDef = searchType.findPointcut(this.name);
                if (pointcutDef == null) continue;
                this.onType = searchType;
                break;
            }
        }
        if (pointcutDef == null) {
            scope.message(IMessage.ERROR, this, "can't find referenced pointcut");
            return;
        }
        if (!pointcutDef.isVisible(scope.getEnclosingType())) {
            scope.message(IMessage.ERROR, this, "pointcut declaration " + pointcutDef + " is not accessible");
            return;
        }
        if (Modifier.isAbstract(pointcutDef.getModifiers())) {
            if (this.onType != null) {
                scope.message(IMessage.ERROR, this, "can't make static reference to abstract pointcut");
                return;
            }
            if (!searchType.isAbstract()) {
                scope.message(IMessage.ERROR, this, "can't use abstract pointcut in concrete context");
                return;
            }
        }
        if ((parameterTypes = scope.getWorld().resolve(pointcutDef.getParameterTypes())).length != this.arguments.size()) {
            scope.message(IMessage.ERROR, this, "incompatible number of arguments to pointcut, expected " + parameterTypes.length + " found " + this.arguments.size());
            return;
        }
        int len = this.arguments.size();
        for (int i = 0; i < len; ++i) {
            TypePattern p = this.arguments.get(i);
            if (p == TypePattern.NO) {
                scope.message(IMessage.ERROR, this, "bad parameter to pointcut reference");
                return;
            }
            if (p.matchesSubtypes(parameterTypes[i]) || p.getExactType().equals(TypeX.OBJECT)) continue;
            scope.message(IMessage.ERROR, p, "incompatible type, expected " + parameterTypes[i].getName() + " found " + p);
            return;
        }
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.arguments.postRead(enclosingType);
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        throw new RuntimeException("shouldn't happen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut concretize1(ResolvedTypeX searchStart, IntMap bindings) {
        if (this.concretizing) {
            searchStart.getWorld().getMessageHandler().handleMessage(MessageUtil.error("circular pointcut declaration involving: " + this, this.getSourceLocation()));
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        try {
            this.concretizing = true;
            if (this.onType != null && (searchStart = this.onType.resolve(searchStart.getWorld())) == ResolvedTypeX.MISSING) {
                Pointcut pointcut = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                return pointcut;
            }
            ResolvedPointcutDefinition pointcutDec = searchStart.findPointcut(this.name);
            if (pointcutDec == null) {
                searchStart.getWorld().getMessageHandler().handleMessage(MessageUtil.error("can't find pointcut '" + this.name + "' on " + searchStart.getName(), this.getSourceLocation()));
                Pointcut pointcut = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                return pointcut;
            }
            if (pointcutDec.isAbstract()) {
                ShadowMunger enclosingAdvice = bindings.getEnclosingAdvice();
                searchStart.getWorld().showMessage(IMessage.ERROR, pointcutDec + " is abstract", this.getSourceLocation(), null == enclosingAdvice ? null : enclosingAdvice.getSourceLocation());
                Pointcut pointcut = Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
                return pointcut;
            }
            ResolvedTypeX[] parameterTypes = searchStart.getWorld().resolve(pointcutDec.getParameterTypes());
            TypePatternList arguments = this.arguments.resolveReferences(bindings);
            IntMap newBindings = new IntMap();
            int len = arguments.size();
            for (int i = 0; i < len; ++i) {
                TypePattern p = arguments.get(i);
                if (!p.matchesSubtypes(parameterTypes[i]) && !p.getExactType().equals(TypeX.OBJECT)) {
                    throw new BCException("illegal change to pointcut declaration: " + this);
                }
                if (!(p instanceof BindingTypePattern)) continue;
                newBindings.put(i, ((BindingTypePattern)p).getFormalIndex());
            }
            newBindings.copyContext(bindings);
            newBindings.pushEnclosingDefinition(pointcutDec);
            try {
                Pointcut pointcut = pointcutDec.getPointcut().concretize(searchStart, newBindings);
                newBindings.popEnclosingDefinitition();
                return pointcut;
            }
            catch (Throwable throwable) {
                newBindings.popEnclosingDefinitition();
                throw throwable;
            }
        }
        finally {
            this.concretizing = false;
        }
    }

    protected boolean shouldCopyLocationForConcretize() {
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReferencePointcut)) {
            return false;
        }
        ReferencePointcut o = (ReferencePointcut)other;
        return o.name.equals(this.name) && o.arguments.equals(this.arguments) && (o.onType == null ? this.onType == null : o.onType.equals(this.onType));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.onType == null ? 0 : this.onType.hashCode());
        result = 37 * result + this.arguments.hashCode();
        result = 37 * result + this.name.hashCode();
        return result;
    }
}

