/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.resources.IResourceChangeListener;

public class ResourceChangeListenerList {
    private int capacity;
    private int size;
    private ListenerEntry[] listeners = null;
    private int count1 = 0;
    private int count2 = 0;
    private int count4 = 0;
    private int count8 = 0;
    private int count16 = 0;
    private static final ListenerEntry[] EMPTY_ARRAY = new ListenerEntry[0];

    public ResourceChangeListenerList() {
        this(3);
    }

    public ResourceChangeListenerList(int capacity) {
        Assert.isTrue(capacity >= 1);
        this.capacity = capacity;
    }

    public void add(IResourceChangeListener listener, int mask) {
        Assert.isNotNull(listener);
        if (mask == 0) {
            this.remove(listener);
            return;
        }
        ListenerEntry entry = new ListenerEntry(listener, mask);
        if (this.size == 0) {
            this.listeners = new ListenerEntry[this.capacity];
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.listeners[i].listener == listener) {
                    this.removing(this.listeners[i].eventMask);
                    this.adding(mask);
                    this.listeners[i] = entry;
                    return;
                }
                ++i;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new ListenerEntry[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.adding(mask);
        this.listeners[this.size++] = entry;
    }

    private void adding(int mask) {
        if ((mask & 1) != 0) {
            ++this.count1;
        }
        if ((mask & 2) != 0) {
            ++this.count2;
        }
        if ((mask & 4) != 0) {
            ++this.count4;
        }
        if ((mask & 8) != 0) {
            ++this.count8;
        }
        if ((mask & 0x10) != 0) {
            ++this.count16;
        }
    }

    public ListenerEntry[] getListeners() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        ListenerEntry[] result = new ListenerEntry[this.size];
        System.arraycopy(this.listeners, 0, result, 0, this.size);
        return result;
    }

    public boolean hasListenerFor(int event) {
        if (event == 1) {
            return this.count1 > 0;
        }
        if (event == 2) {
            return this.count2 > 0;
        }
        if (event == 4) {
            return this.count4 > 0;
        }
        if (event == 8) {
            return this.count8 > 0;
        }
        if (event == 16) {
            return this.count16 > 0;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void recomputeCounts() {
        this.count1 = 0;
        this.count2 = 0;
        this.count4 = 0;
        this.count8 = 0;
        this.count16 = 0;
        int i = 0;
        while (i < this.listeners.length) {
            this.adding(this.listeners[i].eventMask);
            ++i;
        }
    }

    public void remove(IResourceChangeListener listener) {
        Assert.isNotNull(listener);
        int i = 0;
        while (i < this.size) {
            if (this.listeners[i].listener == listener) {
                this.removing(this.listeners[i].eventMask);
                if (this.size == 1) {
                    this.listeners = null;
                    this.size = 0;
                } else {
                    System.arraycopy(this.listeners, i + 1, this.listeners, i, --this.size - i);
                    this.listeners[this.size] = null;
                }
                return;
            }
            ++i;
        }
    }

    private void removing(int mask) {
        if ((mask & 1) != 0) {
            --this.count1;
        }
        if ((mask & 2) != 0) {
            --this.count2;
        }
        if ((mask & 4) != 0) {
            --this.count4;
        }
        if ((mask & 8) != 0) {
            --this.count8;
        }
        if ((mask & 0x10) != 0) {
            --this.count16;
        }
    }

    public int size() {
        return this.size;
    }

    static class ListenerEntry {
        IResourceChangeListener listener;
        int eventMask;

        ListenerEntry(IResourceChangeListener listener, int eventMask) {
            this.listener = listener;
            this.eventMask = eventMask;
        }
    }
}

