/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.internal.plugins.ComputeNodeOrder;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IShutdownHook;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PluginStopper
implements IShutdownHook {
    private static final String OPTION_DEBUG_PLUGIN_STOPPER = "org.eclipse.core.runtime/debug/pluginstopper";

    public void run() {
        Bundle pluginBundle;
        boolean debug = InternalPlatform.getDefault().getBooleanOption(OPTION_DEBUG_PLUGIN_STOPPER, false);
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        HashMap<ReferenceKey, Object[]> references = new HashMap<ReferenceKey, Object[]>();
        IPluginDescriptor[] plugins = Platform.getPluginRegistry().getPluginDescriptors();
        HashMap<String, Bundle> activeLegacyBundles = new HashMap<String, Bundle>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].isLegacy() && (pluginBundle = context.getBundle(plugins[i].getUniqueIdentifier())).getState() == 32) {
                activeLegacyBundles.put(pluginBundle.getGlobalName(), pluginBundle);
                if (debug) {
                    System.out.println("Active plugin bundle: " + pluginBundle.getGlobalName());
                }
            }
            ++i;
        }
        Iterator pluginBundlesIter = activeLegacyBundles.values().iterator();
        while (pluginBundlesIter.hasNext()) {
            pluginBundle = (Bundle)pluginBundlesIter.next();
            Dictionary headers = pluginBundle.getHeaders();
            String requireBundleNames = (String)headers.get("Require-Bundle");
            if (requireBundleNames == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(requireBundleNames, " ,\t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                String importedBundleName = tokenizer.nextToken();
                Bundle importedBundle = (Bundle)activeLegacyBundles.get(importedBundleName);
                if (importedBundle == null) continue;
                references.put(new ReferenceKey(pluginBundle.getBundleId(), importedBundle.getBundleId()), new Object[]{pluginBundle, importedBundle});
            }
        }
        Object[] orderedBundles = activeLegacyBundles.values().toArray(new Bundle[activeLegacyBundles.size()]);
        Object[][] cycles = ComputeNodeOrder.computeNodeOrder(orderedBundles, (Object[][])references.values().toArray((T[])new Object[references.size()][]));
        if (debug) {
            int i2 = 0;
            while (i2 < cycles.length) {
                StringBuffer sb = new StringBuffer("***Cycle: ");
                int j = 0;
                while (j < cycles[i2].length) {
                    sb.append('\n');
                    sb.append(((Bundle)cycles[i2][j]).getGlobalName());
                    ++j;
                }
                System.out.println(sb);
                ++i2;
            }
            Iterator iter = references.values().iterator();
            while (iter.hasNext()) {
                Object[] ref = (Object[])iter.next();
                System.out.println(String.valueOf(ref[0].toString()) + " -> " + ref[1]);
            }
        }
        int i3 = orderedBundles.length - 1;
        while (i3 >= 0) {
            try {
                if (Platform.getPluginRegistry().getPluginDescriptor(orderedBundles[i3].getGlobalName()).isLegacy() && orderedBundles[i3].getState() == 32) {
                    if (debug) {
                        System.out.println("Stopping: " + orderedBundles[i3].getGlobalName() + " (#" + orderedBundles[i3].getBundleId() + ")");
                    }
                    orderedBundles[i3].stop();
                }
            }
            catch (Exception be) {
                be.printStackTrace();
            }
            --i3;
        }
    }

    private class ReferenceKey {
        private long referrerId;
        private long referredId;

        public ReferenceKey(long referrerId, long referredId) {
            this.referrerId = referrerId;
            this.referredId = referredId;
        }

        public boolean equals(Object obj) {
            return this.referredId == ((ReferenceKey)obj).referredId && this.referrerId == ((ReferenceKey)obj).referrerId;
        }

        public int hashCode() {
            return (int)(this.referredId & 0xFFFFL) << 16 + (int)(this.referrerId & 0xFFFFL);
        }
    }
}

