/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MultiRule
implements ISchedulingRule {
    private final ISchedulingRule[] rules;

    public MultiRule(ISchedulingRule[] nestedRules) {
        this.rules = this.flatten(nestedRules);
    }

    private ISchedulingRule[] flatten(ISchedulingRule[] nestedRules) {
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>(nestedRules.length);
        int i = 0;
        while (i < nestedRules.length) {
            if (nestedRules[i] instanceof MultiRule) {
                ISchedulingRule[] children = ((MultiRule)nestedRules[i]).getChildren();
                int j = 0;
                while (j < children.length) {
                    myRules.add(children[j]);
                    ++j;
                }
            } else {
                myRules.add(nestedRules[i]);
            }
            ++i;
        }
        return myRules.toArray(new ISchedulingRule[myRules.size()]);
    }

    public ISchedulingRule[] getChildren() {
        return (ISchedulingRule[])this.rules.clone();
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            int other = 0;
            while (other < otherRules.length) {
                boolean found = false;
                int mine = 0;
                while (!found && mine < this.rules.length) {
                    found = this.rules[mine].contains(otherRules[other]);
                    ++mine;
                }
                if (!found) {
                    return false;
                }
                ++other;
            }
            return true;
        }
        int i = 0;
        while (i < this.rules.length) {
            if (this.rules[i].contains(rule)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            int j = 0;
            while (j < otherRules.length) {
                int i = 0;
                while (i < this.rules.length) {
                    if (this.rules[i].isConflicting(otherRules[j])) {
                        return true;
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < this.rules.length) {
                if (this.rules[i].isConflicting(rule)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        return "MultiRule" + this.rules;
    }
}

