/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public class CatchClause
extends ASTNode {
    private Block body = null;
    private SingleVariableDeclaration exceptionDecl = null;

    CatchClause(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 12;
    }

    ASTNode clone(AST target) {
        CatchClause result = new CatchClause(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setBody((Block)this.getBody().clone(target));
        result.setException((SingleVariableDeclaration)ASTNode.copySubtree(target, this.getException()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getException());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public SingleVariableDeclaration getException() {
        if (this.exceptionDecl == null) {
            long count = this.getAST().modificationCount();
            this.setException(new SingleVariableDeclaration(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.exceptionDecl;
    }

    public void setException(SingleVariableDeclaration exception) {
        if (exception == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.exceptionDecl, exception, true);
        this.exceptionDecl = exception;
    }

    public Block getBody() {
        if (this.body == null) {
            long count = this.getAST().modificationCount();
            this.setBody(new Block(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.body, body, true);
        this.body = body;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.exceptionDecl == null ? 0 : this.getException().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

