/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class SwitchCase
extends Statement {
    private Expression optionalExpression = null;
    private boolean expressionInitialized = false;

    SwitchCase(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 49;
    }

    ASTNode clone(AST target) {
        SwitchCase result = new SwitchCase(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (!this.expressionInitialized) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.optionalExpression;
    }

    public void setExpression(Expression expression) {
        this.replaceChild(this.optionalExpression, expression, true);
        this.optionalExpression = expression;
        this.expressionInitialized = true;
    }

    public boolean isDefault() {
        return this.getExpression() == null;
    }

    int memSize() {
        return super.memSize() + 8;
    }

    int treeSize() {
        return this.memSize() + (this.optionalExpression == null ? 0 : this.optionalExpression.treeSize());
    }
}

