/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;

public class JavaSearchParticipant
extends SearchParticipant {
    IndexSelector indexSelector;
    ICompilationUnit[] workingCopies;

    public JavaSearchParticipant(ICompilationUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    public void beginSearching() {
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
    }

    public String getDescription() {
        return "Java";
    }

    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, (SearchParticipant)this);
    }

    public void indexDocument(SearchDocument document, String indexPath) {
        String documentPath = document.getPath();
        if (Util.isJavaFileName(documentPath)) {
            new SourceIndexer(document, indexPath).indexDocument();
        } else if (Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document, indexPath).indexDocument();
        }
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        int remainingWorkingCopiesSize;
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, this.workingCopies, monitor == null ? null : new SubProgressMonitor(monitor, 95));
        HashMap workingCopyDocuments = this.workingCopiesThatCanSeeFocus(pattern.focus, pattern.isPolymorphicSearch());
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == this && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(matches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locatePackageDeclarations(this);
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
        }
        return this.indexSelector.getIndexKeys();
    }

    private HashMap workingCopiesThatCanSeeFocus(IJavaElement focus, boolean isPolymorphicSearch) {
        if (this.workingCopies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaProject) && !(focus instanceof JarPackageFragmentRoot)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = this.workingCopies.length;
        while (i < length) {
            ICompilationUnit workingCopy = this.workingCopies[i];
            IPath projectOrJar = IndexSelector.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy));
            }
            ++i;
        }
        return result;
    }

    public class WorkingCopyDocument
    extends JavaSearchDocument {
        public ICompilationUnit workingCopy;

        WorkingCopyDocument(ICompilationUnit workingCopy) {
            super(workingCopy.getPath().toString(), (SearchParticipant)JavaSearchParticipant.this);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }
}

