/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ConfigurableOption;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.formatter.impl.FormatterOptions;
import org.eclipse.jdt.internal.formatter.impl.SplitLine;

public class CodeFormatter
implements TerminalTokens,
ICodeFormatter {
    public FormatterOptions options;
    public static final int BLOCK = 74;
    public static final int NONINDENT_BLOCK = -100;
    StringBuffer formattedSource;
    StringBuffer currentLineBuffer;
    Scanner scanner = new Scanner(true, true, false, 0x2F0000L, null, null);
    private int[] constructions;
    private int constructionsCount;
    private int indentationLevel;
    private int initialIndentationLevel;
    Scanner splitScanner;
    int currentCommentOffset;
    int currentLineIndentationLevel;
    int maxLineSize = 30;
    private boolean containsOpenCloseBraces;
    private int indentationLevelForOpenCloseBraces;
    private int[] positionsToMap;
    private int[] mappedPositions;
    private int indexToMap;
    private int indexInMap;
    private int globalDelta;
    private int lineDelta;
    private int splitDelta;
    private int beginningOfLineIndex;
    private int multipleLineCommentCounter;
    static /* synthetic */ Class class$0;

    public CodeFormatter(ConfigurableOption[] settings) {
        this(CodeFormatter.convertConfigurableOptions(settings));
    }

    public CodeFormatter() {
        this((Map)null);
    }

    public CodeFormatter(Map settings) {
        this.scanner.recordLineSeparator = true;
        this.splitScanner = new Scanner(true, true, false, 0x2F0000L, null, null);
        this.options = new FormatterOptions(settings);
    }

    private static boolean breakLineBeforeOperator(int operator) {
        switch (operator) {
            case 23: 
            case 33: 
            case 100: {
                return false;
            }
        }
        return true;
    }

    private static Map convertConfigurableOptions(ConfigurableOption[] settings) {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        int i = 0;
        while (i < settings.length) {
            String string = settings[i].getComponentName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.internal.formatter.CodeFormatter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                String optionName = settings[i].getOptionName();
                int valueIndex = settings[i].getCurrentValueIndex();
                if (optionName.equals("newline.openingBrace")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.openingBrace", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.controlStatement")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.controlStatement", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.clearAll")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.clearAll", valueIndex == 0 ? "clear all" : "preserve one");
                } else if (optionName.equals("newline.elseIf")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.elseIf", valueIndex == 0 ? "do not insert" : "insert");
                } else if (optionName.equals("newline.emptyBlock")) {
                    options.put("org.eclipse.jdt.core.formatter.newline.emptyBlock", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("lineSplit")) {
                    options.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(valueIndex));
                } else if (optionName.equals("style.assignment")) {
                    options.put("org.eclipse.jdt.core.formatter.style.assignment", valueIndex == 0 ? "compact" : "normal");
                } else if (optionName.equals("tabulation.char")) {
                    options.put("org.eclipse.jdt.core.formatter.tabulation.char", valueIndex == 0 ? "tab" : "space");
                } else if (optionName.equals("tabulation.size")) {
                    options.put("org.eclipse.jdt.core.formatter.tabulation.size", String.valueOf(valueIndex));
                } else if (optionName.equals("space.castexpression")) {
                    options.put("org.eclipse.jdt.core.formatter.space.castexpression", valueIndex == 0 ? "insert" : "do not insert");
                }
            }
            ++i;
        }
        return options;
    }

    private final String copyRemainingSource() {
        char[] str = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        int length = str.length - startPosition;
        StringBuffer bufr = new StringBuffer(length);
        if (startPosition < str.length) {
            bufr.append(str, startPosition, length);
        }
        return bufr.toString();
    }

    private void dumpTab(int tabCount) {
        if (this.options.indentWithTab) {
            int j = 0;
            while (j < tabCount) {
                this.formattedSource.append('\t');
                this.increaseSplitDelta(1);
                ++j;
            }
        } else {
            int i = 0;
            int max = this.options.tabSize * tabCount;
            while (i < max) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
                ++i;
            }
        }
    }

    private void flushBuffer() {
        String currentString = this.currentLineBuffer.toString();
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentString, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentString, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int scannerSourceLength = this.scanner.source.length;
        if (scannerSourceLength > 2) {
            if (this.scanner.source[scannerSourceLength - 1] == '\n' && this.scanner.source[scannerSourceLength - 2] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\n') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            }
        }
        this.updateMappedPositions(this.scanner.startPosition);
        this.updateRemainingMappedPositions();
    }

    private void format() {
        this.reset();
        int token = 0;
        int previousToken = 0;
        int previousCompilableToken = 0;
        int indentationOffset = 0;
        int newLinesInWhitespace = 0;
        int pendingNewLines = 0;
        boolean expectingOpenBrace = false;
        boolean clearNonBlockIndents = false;
        boolean pendingSpace = true;
        boolean pendingNewlineAfterParen = false;
        boolean inAssignment = false;
        boolean inArrayAssignment = false;
        boolean inThrowsClause = false;
        boolean inClassOrInterfaceHeader = false;
        int openBracketCount = 0;
        int unarySignModifier = 0;
        int openParenthesisCount = 1;
        int[] openParenthesis = new int[10];
        int tokenBeforeColonCount = 0;
        int[] tokenBeforeColon = new int[10];
        this.constructionsCount = 0;
        int nlicsToken = 0;
        boolean specialElse = false;
        this.currentLineIndentationLevel += this.constructionsCount;
        try {
            while (true) {
                block102: {
                    block103: {
                        block104: {
                            boolean openAndCloseBrace;
                            block101: {
                                try {
                                    token = this.scanner.getNextToken();
                                    if (token != 1001) break block101;
                                    int length = this.scanner.currentPosition;
                                    int index = length - 1;
                                    while (index >= 0) {
                                        switch (this.scanner.source[index]) {
                                            case '\n': 
                                            case '\r': {
                                                --this.scanner.currentPosition;
                                                break;
                                            }
                                            default: {
                                                break block101;
                                            }
                                        }
                                        --index;
                                    }
                                }
                                catch (InvalidInputException e) {
                                    if (!this.handleInvalidToken(e)) {
                                        throw e;
                                    }
                                    token = 0;
                                }
                            }
                            if (token == 75) break;
                            if (clearNonBlockIndents && token != 1000) {
                                switch (token) {
                                    case 93: {
                                        if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 93) {
                                            pendingNewLines = 1;
                                            specialElse = true;
                                        }
                                        this.indentationLevel += this.popInclusiveUntil(83);
                                        break;
                                    }
                                    case 91: {
                                        this.indentationLevel += this.popInclusiveUntil(91);
                                        break;
                                    }
                                    case 94: {
                                        this.indentationLevel += this.popInclusiveUntil(91);
                                        break;
                                    }
                                    case 77: {
                                        if (nlicsToken == 81) {
                                            this.indentationLevel += this.pop(81);
                                            break;
                                        }
                                    }
                                    default: {
                                        this.indentationLevel += this.popExclusiveUntilBlockOrCase();
                                    }
                                }
                                clearNonBlockIndents = false;
                            }
                            if (token == 89 || token == 99) {
                                this.indentationLevel += this.pop(89);
                            }
                            if (token == 97) {
                                inThrowsClause = true;
                            }
                            if ((token == 92 || token == 98) && previousToken != 1) {
                                inClassOrInterfaceHeader = true;
                            }
                            if (pendingNewlineAfterParen && previousCompilableToken == 93 && token == 83 && this.options.compactElseIfMode) {
                                pendingNewlineAfterParen = false;
                                pendingNewLines = 0;
                                this.indentationLevel += this.pop(93);
                            }
                            boolean bl = pendingNewlineAfterParen = pendingNewlineAfterParen || previousCompilableToken == 29 && token == 74;
                            if (pendingNewlineAfterParen && token != 1000) {
                                pendingNewlineAfterParen = false;
                                if (!(token == 74 || CodeFormatter.isComment(token) || token == 1 || previousCompilableToken == 29 && token == 23)) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                } else if (token == 74 && this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] != 74 && this.constructions[this.constructionsCount - 1] != -100 ? this.indentationLevel - 1 : this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if (token == 74 && this.options.newLineBeforeOpeningBraceMode && this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 81) {
                                this.newLine(1);
                                this.currentLineIndentationLevel = this.indentationLevel - 1;
                                pendingNewLines = 0;
                                pendingSpace = false;
                            }
                            if (token == 74 && inThrowsClause) {
                                inThrowsClause = false;
                                if (this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if (token == 74 && inClassOrInterfaceHeader) {
                                inClassOrInterfaceHeader = false;
                                if (this.options.newLineBeforeOpeningBraceMode) {
                                    this.newLine(1);
                                    this.currentLineIndentationLevel = this.indentationLevel;
                                    pendingNewLines = 0;
                                    pendingSpace = false;
                                }
                            }
                            if ((pendingNewLines > 0 && !CodeFormatter.isComment(token) || newLinesInWhitespace > 0 && openParenthesisCount <= 1 && CodeFormatter.isComment(token) || previousCompilableToken == 74 && token == 48) && token != 1000) {
                                boolean commaAndCloseBrace;
                                boolean closeBraceAndCloseParen = previousToken == 48 && token == 29;
                                boolean nlicsOption = previousToken == 48 && !this.options.newlineInControlStatementMode && (token == 93 || token == 77 && nlicsToken == 81 || token == 91 || token == 94);
                                boolean semiColonAndCloseBrace = previousToken == 48 && token == 23;
                                boolean commentAndOpenBrace = previousToken == 1002 && token == 74;
                                boolean bl2 = commaAndCloseBrace = previousToken == 48 && token == 33;
                                if (specialElse || !commentAndOpenBrace && !closeBraceAndCloseParen && !nlicsOption && !semiColonAndCloseBrace && !commaAndCloseBrace) {
                                    if (!this.options.clearAllBlankLinesMode) {
                                        pendingNewLines = pendingNewLines < newLinesInWhitespace ? newLinesInWhitespace : pendingNewLines;
                                        int n = pendingNewLines = pendingNewLines > 2 ? 2 : pendingNewLines;
                                    }
                                    if (previousCompilableToken == 74 && token == 48) {
                                        this.containsOpenCloseBraces = true;
                                        this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
                                        if (CodeFormatter.isComment(previousToken)) {
                                            this.newLine(pendingNewLines);
                                        } else if (this.options.newLineInEmptyBlockMode) {
                                            if (inArrayAssignment) {
                                                this.newLine(1);
                                            } else {
                                                this.newLine(pendingNewLines);
                                            }
                                        }
                                    } else if (previousToken != 1002 && previousToken != 1003 || token != 23) {
                                        this.newLine(pendingNewLines);
                                    }
                                    if ((previousCompilableToken == 23 || previousCompilableToken == 74 || previousCompilableToken == 48 || CodeFormatter.isComment(previousToken)) && token == 48) {
                                        indentationOffset = -1;
                                        this.indentationLevel += this.popExclusiveUntilBlock();
                                    }
                                    this.currentLineIndentationLevel = previousToken == 1001 && inAssignment ? ++this.currentLineIndentationLevel : this.indentationLevel + indentationOffset;
                                    pendingSpace = false;
                                    indentationOffset = 0;
                                }
                                pendingNewLines = 0;
                                newLinesInWhitespace = 0;
                                specialElse = false;
                                if (nlicsToken == 81 && token == 77) {
                                    nlicsToken = 0;
                                }
                            }
                            switch (token) {
                                case 93: 
                                case 94: {
                                    expectingOpenBrace = true;
                                    pendingNewlineAfterParen = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    break;
                                }
                                case 89: 
                                case 99: {
                                    if (tokenBeforeColonCount == tokenBeforeColon.length) {
                                        int[] nArray = tokenBeforeColon;
                                        tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                                        System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                                    }
                                    tokenBeforeColon[tokenBeforeColonCount++] = 89;
                                    this.indentationLevel += this.pushControlStatement(89);
                                    break;
                                }
                                case 28: {
                                    if (tokenBeforeColonCount == tokenBeforeColon.length) {
                                        int[] nArray = tokenBeforeColon;
                                        tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                                        System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                                    }
                                    tokenBeforeColon[tokenBeforeColonCount++] = token;
                                    break;
                                }
                                case 77: 
                                case 82: 
                                case 83: 
                                case 85: {
                                    if (openParenthesisCount == openParenthesis.length) {
                                        int[] nArray = openParenthesis;
                                        openParenthesis = new int[openParenthesisCount * 2];
                                        System.arraycopy(nArray, 0, openParenthesis, 0, openParenthesisCount);
                                    }
                                    openParenthesis[openParenthesisCount++] = 0;
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    break;
                                }
                                case 87: {
                                    pendingNewlineAfterParen = true;
                                }
                                case 91: {
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(91);
                                    break;
                                }
                                case 81: {
                                    expectingOpenBrace = true;
                                    this.indentationLevel += this.pushControlStatement(token);
                                    nlicsToken = token;
                                    break;
                                }
                                case 47: {
                                    break;
                                }
                                case 21: {
                                    if (previousToken == 61) {
                                        this.indentationLevel += this.pushControlStatement(previousToken);
                                        break;
                                    }
                                    if (previousCompilableToken != 7 && previousToken != 24 && previousToken != 0 && previousToken != 72 && previousToken != 21 && previousToken != 76 && previousToken != 23 && previousToken != 74 && previousToken != 48 && previousToken != 49 && previousToken != 50) {
                                        this.space();
                                    }
                                    if (openParenthesisCount > 0) {
                                        int n = openParenthesisCount - 1;
                                        openParenthesis[n] = openParenthesis[n] + 1;
                                    } else {
                                        openParenthesis[0] = openParenthesis[0] + 1;
                                    }
                                    pendingSpace = false;
                                    break;
                                }
                                case 29: {
                                    if (openParenthesisCount > 1 && openParenthesis[openParenthesisCount - 1] > 0) {
                                        int n = openParenthesisCount - 1;
                                        openParenthesis[n] = openParenthesis[n] - 1;
                                        if (openParenthesis[openParenthesisCount - 1] <= 0) {
                                            pendingNewlineAfterParen = true;
                                            inAssignment = false;
                                            --openParenthesisCount;
                                        }
                                    } else {
                                        openParenthesis[0] = openParenthesis[0] - 1;
                                    }
                                    pendingSpace = false;
                                    break;
                                }
                                case 74: {
                                    if (previousCompilableToken == 73 || previousCompilableToken == 100) {
                                        inArrayAssignment = true;
                                        inAssignment = false;
                                    }
                                    if (inArrayAssignment) {
                                        this.indentationLevel += this.pushBlock();
                                        break;
                                    }
                                    pendingNewLines = 1;
                                    this.indentationLevel += this.pushBlock();
                                    break;
                                }
                                case 48: {
                                    if (previousCompilableToken == 29) {
                                        pendingSpace = false;
                                    }
                                    if (inArrayAssignment) {
                                        inArrayAssignment = false;
                                        pendingNewLines = 1;
                                        this.indentationLevel += this.popInclusiveUntilBlock();
                                        break;
                                    }
                                    pendingNewLines = 1;
                                    this.indentationLevel += this.popInclusiveUntilBlock();
                                    if (previousCompilableToken == 29) {
                                        this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                        this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                                    }
                                    if (this.constructionsCount <= 0) break;
                                    switch (this.constructions[this.constructionsCount - 1]) {
                                        case 61: 
                                        case 77: 
                                        case 81: 
                                        case 82: 
                                        case 83: 
                                        case 85: 
                                        case 87: 
                                        case 91: 
                                        case 93: 
                                        case 94: {
                                            clearNonBlockIndents = true;
                                        }
                                    }
                                    break;
                                }
                                case 7: {
                                    ++openBracketCount;
                                    pendingSpace = false;
                                    break;
                                }
                                case 73: {
                                    openBracketCount -= openBracketCount > 0 ? 1 : 0;
                                    pendingSpace = false;
                                    break;
                                }
                                case 1: 
                                case 33: {
                                    pendingSpace = false;
                                    break;
                                }
                                case 23: {
                                    if (openParenthesisCount <= 1) {
                                        pendingNewLines = 1;
                                        if (expectingOpenBrace) {
                                            clearNonBlockIndents = true;
                                            expectingOpenBrace = false;
                                        }
                                    }
                                    inAssignment = false;
                                    pendingSpace = false;
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    if (previousToken != 24 && previousToken != 73) break;
                                    pendingSpace = false;
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    if (CodeFormatter.isLiteralToken(previousToken) || previousToken == 24 || previousToken == 29 || previousToken == 73) break;
                                    unarySignModifier = 1;
                                    break;
                                }
                                case 51: {
                                    if (tokenBeforeColonCount <= 0) break;
                                    if (tokenBeforeColon[tokenBeforeColonCount - 1] == 89) {
                                        pendingNewLines = 1;
                                    }
                                    --tokenBeforeColonCount;
                                    break;
                                }
                                case 100: {
                                    inAssignment = true;
                                    break;
                                }
                                case 1001: {
                                    pendingNewLines = 1;
                                    if (!inAssignment) break;
                                    ++this.currentLineIndentationLevel;
                                    break;
                                }
                                case 1002: 
                                case 1003: {
                                    this.currentCommentOffset = this.getCurrentCommentOffset();
                                    pendingNewLines = 1;
                                    break;
                                }
                                case 1000: {
                                    char[] source = this.scanner.source;
                                    newLinesInWhitespace = 0;
                                    int i = this.scanner.startPosition;
                                    int max = this.scanner.currentPosition;
                                    while (i < max) {
                                        if (source[i] == '\r') {
                                            newLinesInWhitespace = i < max - 1 ? (source[++i] == '\n' ? ++newLinesInWhitespace : ++newLinesInWhitespace) : ++newLinesInWhitespace;
                                        } else if (source[i] == '\n') {
                                            ++newLinesInWhitespace;
                                        }
                                        ++i;
                                    }
                                    this.increaseLineDelta(this.scanner.startPosition - this.scanner.currentPosition);
                                    break;
                                }
                                default: {
                                    if (token != 24 && !CodeFormatter.isLiteralToken(token) && token != 49 && token != 50) break;
                                    if (previousToken == 8 || previousToken == 9 || previousToken == 2 && unarySignModifier > 0 || previousToken == 3 && unarySignModifier > 0) {
                                        pendingSpace = false;
                                    }
                                    unarySignModifier = 0;
                                }
                            }
                            if (token == 1000) break block102;
                            boolean bl3 = openAndCloseBrace = previousCompilableToken == 74 && token == 48;
                            if (!pendingSpace || !this.insertSpaceAfter(previousToken) || inAssignment && (previousToken == 74 || token == 48) || previousToken == 1001 || this.options.compactAssignmentMode && token == 100 || openAndCloseBrace) break block103;
                            if (previousCompilableToken != 29) break block104;
                            switch (token) {
                                case 24: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 47: 
                                case 49: 
                                case 50: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: {
                                    if (this.options.isAddindSpaceInCastExpression()) {
                                        this.space();
                                        break;
                                    }
                                    break block103;
                                }
                                default: {
                                    this.space();
                                    break;
                                }
                            }
                            break block103;
                        }
                        this.space();
                    }
                    this.outputCurrentToken(token);
                    if (token == 1001 && openParenthesisCount > 1) {
                        pendingNewLines = 0;
                        this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                        this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                    }
                    pendingSpace = true;
                }
                if (token == 1000) continue;
                previousToken = token;
                if (token == 1002 || token == 1001 || token == 1003) continue;
                previousCompilableToken = token;
            }
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
        catch (InvalidInputException e) {
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
    }

    public String formatSourceString(String sourceString) {
        char[] sourceChars = sourceString.toCharArray();
        this.formattedSource = new StringBuffer(sourceChars.length);
        this.scanner.setSource(sourceChars);
        this.format();
        return this.formattedSource.toString();
    }

    public String format(String string, int indentLevel) {
        return this.format(string, indentLevel, null);
    }

    public String format(String string, int indentLevel, int[] positions) {
        return this.format(string, indentLevel, positions, null);
    }

    public String format(String string, int indentLevel, int[] positions, String lineSeparator) {
        if (lineSeparator != null) {
            this.options.setLineSeparator(lineSeparator);
        }
        if (positions != null) {
            this.setPositionsToMap(positions);
            this.setInitialIndentationLevel(indentLevel);
            String formattedString = this.formatSourceString(string);
            System.arraycopy(this.mappedPositions, 0, positions, 0, positions.length);
            return formattedString;
        }
        this.setInitialIndentationLevel(indentLevel);
        return this.formatSourceString(string);
    }

    public String format(String string) {
        return this.format(string, 0, null);
    }

    public static String format(String sourceString, int initialIndentationLevel, ConfigurableOption[] options) {
        CodeFormatter formatter = new CodeFormatter(options);
        formatter.setInitialIndentationLevel(initialIndentationLevel);
        return formatter.formatSourceString(sourceString);
    }

    private int getCurrentCommentOffset() {
        int linePtr = this.scanner.linePtr;
        if (linePtr < 0) {
            return 0;
        }
        int offset = 0;
        int beginningOfLine = this.scanner.lineEnds[linePtr];
        int currentStartPosition = this.scanner.startPosition;
        char[] source = this.scanner.source;
        while (beginningOfLine > currentStartPosition) {
            if (linePtr > 0) {
                beginningOfLine = this.scanner.lineEnds[--linePtr];
                continue;
            }
            beginningOfLine = 0;
            break;
        }
        int i = currentStartPosition - 1;
        while (i >= beginningOfLine) {
            char currentCharacter = source[i];
            switch (currentCharacter) {
                case '\t': {
                    offset += this.options.tabSize;
                    break;
                }
                case ' ': {
                    ++offset;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    return offset;
                }
            }
            --i;
        }
        return offset;
    }

    public static ConfigurableOption[] getDefaultOptions(Locale locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.formatter.CodeFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String componentName = clazz.getName();
        FormatterOptions options = new FormatterOptions();
        return new ConfigurableOption[]{new ConfigurableOption(componentName, "newline.openingBrace", locale, options.newLineBeforeOpeningBraceMode ? 0 : 1), new ConfigurableOption(componentName, "newline.controlStatement", locale, options.newlineInControlStatementMode ? 0 : 1), new ConfigurableOption(componentName, "newline.clearAll", locale, options.clearAllBlankLinesMode ? 0 : 1), new ConfigurableOption(componentName, "newline.elseIf", locale, options.compactElseIfMode ? 0 : 1), new ConfigurableOption(componentName, "newline.emptyBlock", locale, options.newLineInEmptyBlockMode ? 0 : 1), new ConfigurableOption(componentName, "line.split", locale, options.maxLineLength), new ConfigurableOption(componentName, "style.compactAssignment", locale, options.compactAssignmentMode ? 0 : 1), new ConfigurableOption(componentName, "tabulation.char", locale, options.indentWithTab ? 0 : 1), new ConfigurableOption(componentName, "tabulation.size", locale, options.tabSize), new ConfigurableOption(componentName, "space.castexpression", locale, options.spaceInCastExpression ? 0 : 1)};
    }

    public int[] getMappedPositions() {
        return this.mappedPositions;
    }

    private static int getTokenPriority(int token) {
        switch (token) {
            case 95: 
            case 96: 
            case 97: {
                return 10;
            }
            case 23: {
                return 20;
            }
            case 33: {
                return 25;
            }
            case 100: {
                return 30;
            }
            case 26: 
            case 27: {
                return 40;
            }
            case 28: 
            case 51: {
                return 50;
            }
            case 18: 
            case 19: {
                return 60;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return 70;
            }
            case 2: 
            case 3: {
                return 80;
            }
            case 4: 
            case 5: 
            case 6: {
                return 90;
            }
            case 10: 
            case 11: 
            case 12: {
                return 100;
            }
            case 20: 
            case 22: 
            case 25: {
                return 110;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 120;
            }
            case 1: {
                return 130;
            }
        }
        return Integer.MAX_VALUE;
    }

    private boolean handleInvalidToken(Exception e) {
        return e.getMessage().equals("Invalid_Character_Constant") || e.getMessage().equals("Invalid_Char_In_String") || e.getMessage().equals("Invalid_Escape");
    }

    private final void increaseGlobalDelta(int offset) {
        this.globalDelta += offset;
    }

    private final void increaseLineDelta(int offset) {
        this.lineDelta += offset;
    }

    private final void increaseSplitDelta(int offset) {
        this.splitDelta += offset;
    }

    private boolean insertSpaceAfter(int token) {
        switch (token) {
            case 0: 
            case 1: 
            case 7: 
            case 21: 
            case 72: 
            case 76: 
            case 1001: {
                return false;
            }
        }
        return true;
    }

    private boolean insertSpaceBefore(int token) {
        switch (token) {
            case 100: {
                return !this.options.compactAssignmentMode;
            }
        }
        return false;
    }

    private static boolean isComment(int token) {
        boolean result = token == 1002 || token == 1001 || token == 1003;
        return result;
    }

    private static boolean isLiteralToken(int token) {
        boolean result = token == 55 || token == 56 || token == 57 || token == 58 || token == 59 || token == 60;
        return result;
    }

    private void newLine(int newLineCount) {
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        String currentLine = this.currentLineBuffer.toString();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentLine, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentLine, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int i = 0;
        while (i < newLineCount) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            ++i;
        }
        int currentLength = currentLine.length();
        this.currentLineBuffer = new StringBuffer(currentLength > this.maxLineSize ? (this.maxLineSize = currentLength) : this.maxLineSize);
        this.increaseGlobalDelta(this.splitDelta);
        this.increaseGlobalDelta(this.lineDelta);
        this.lineDelta = 0;
        this.currentLineIndentationLevel = this.initialIndentationLevel;
    }

    private String operatorString(int operator) {
        switch (operator) {
            case 95: {
                return "extends";
            }
            case 96: {
                return "implements";
            }
            case 97: {
                return "throws";
            }
            case 23: {
                return ";";
            }
            case 33: {
                return ",";
            }
            case 100: {
                return "=";
            }
            case 27: {
                return "&&";
            }
            case 26: {
                return "||";
            }
            case 28: {
                return "?";
            }
            case 51: {
                return ":";
            }
            case 18: {
                return "==";
            }
            case 19: {
                return "!=";
            }
            case 17: {
                return "<";
            }
            case 14: {
                return "<=";
            }
            case 16: {
                return ">";
            }
            case 15: {
                return ">=";
            }
            case 13: {
                return "instanceof";
            }
            case 2: {
                return "+";
            }
            case 3: {
                return "-";
            }
            case 4: {
                return "*";
            }
            case 6: {
                return "/";
            }
            case 5: {
                return "%";
            }
            case 12: {
                return "<<";
            }
            case 10: {
                return ">>";
            }
            case 11: {
                return ">>>";
            }
            case 20: {
                return "&";
            }
            case 25: {
                return "|";
            }
            case 22: {
                return "^";
            }
            case 103: {
                return "*=";
            }
            case 104: {
                return "/=";
            }
            case 108: {
                return "%=";
            }
            case 101: {
                return "+=";
            }
            case 102: {
                return "-=";
            }
            case 109: {
                return "<<=";
            }
            case 110: {
                return ">>=";
            }
            case 111: {
                return ">>>=";
            }
            case 105: {
                return "&=";
            }
            case 107: {
                return "^=";
            }
            case 106: {
                return "|=";
            }
            case 1: {
                return ".";
            }
        }
        return "";
    }

    private void output(String stringToOutput) {
        int i = 0;
        int max = stringToOutput.length();
        while (i < max) {
            char currentCharacter = stringToOutput.charAt(i);
            if (currentCharacter != '\t') {
                this.currentLineBuffer.append(currentCharacter);
            }
            ++i;
        }
    }

    private void outputCurrentToken(int token) {
        char[] source = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        switch (token) {
            case 1001: 
            case 1002: 
            case 1003: {
                boolean endOfLine = false;
                int commentOffset = this.getCurrentCommentOffset();
                int beginningOfLineSpaces = 0;
                endOfLine = false;
                commentOffset = this.getCurrentCommentOffset();
                beginningOfLineSpaces = 0;
                boolean pendingCarriageReturn = false;
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    switch (currentCharacter) {
                        case '\r': {
                            pendingCarriageReturn = true;
                            endOfLine = true;
                            break;
                        }
                        case '\n': {
                            if (pendingCarriageReturn) {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
                            } else {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                            }
                            pendingCarriageReturn = false;
                            this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                            beginningOfLineSpaces = 0;
                            endOfLine = true;
                            break;
                        }
                        case '\t': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if ((beginningOfLineSpaces += this.options.tabSize) > commentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        case ' ': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if (++beginningOfLineSpaces > commentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        default: {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                                break;
                            }
                            beginningOfLineSpaces = 0;
                            this.currentLineBuffer.append(currentCharacter);
                            endOfLine = false;
                        }
                    }
                    ++i;
                }
                this.updateMappedPositions(this.scanner.currentPosition - 1);
                ++this.multipleLineCommentCounter;
                break;
            }
            default: {
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    this.currentLineBuffer.append(currentCharacter);
                    ++i;
                }
                break block0;
            }
        }
    }

    private void outputLine(String currentString, boolean preIndented, int depth, int operator, int substringIndex, int[] startSubstringIndexes, int offsetInGlobalLine) {
        boolean placeOperatorAhead;
        boolean emptyFirstSubString = false;
        String operatorString = this.operatorString(operator);
        boolean placeOperatorBehind = !CodeFormatter.breakLineBeforeOperator(operator);
        boolean bl = placeOperatorAhead = !placeOperatorBehind;
        if (placeOperatorAhead) {
            if (!preIndented) {
                this.dumpTab(depth);
                preIndented = true;
            }
            if (operator != 0) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
                this.formattedSource.append(operatorString);
                this.increaseSplitDelta(operatorString.length());
                if (this.insertSpaceAfter(operator) && operator != 96 && operator != 95 && operator != 97) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
            }
        }
        SplitLine splitLine = null;
        if (this.options.maxLineLength == 0 || this.getLength(currentString, depth) < this.options.maxLineLength || (splitLine = this.split(currentString, offsetInGlobalLine)) == null) {
            if (operator == 95 || operator == 96 || operator == 97) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            if (placeOperatorBehind && !preIndented) {
                this.dumpTab(depth);
            }
            int max = currentString.length();
            if (this.multipleLineCommentCounter != 0) {
                try {
                    BufferedReader reader = new BufferedReader(new StringReader(currentString));
                    String line = reader.readLine();
                    while (line != null) {
                        this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + line.length() + this.options.lineSeparatorSequence.length);
                        this.formattedSource.append(line);
                        this.beginningOfLineIndex += line.length();
                        line = reader.readLine();
                        if (line == null) continue;
                        this.formattedSource.append(this.options.lineSeparatorSequence);
                        this.beginningOfLineIndex += this.options.lineSeparatorSequence.length;
                        this.dumpTab(this.currentLineIndentationLevel);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + max);
                int i = 0;
                while (i < max) {
                    char currentChar = currentString.charAt(i);
                    switch (currentChar) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            if (i == max - 1) break;
                            this.formattedSource.append(this.options.lineSeparatorSequence);
                            this.dumpTab(depth - 1);
                            break;
                        }
                        default: {
                            this.formattedSource.append(currentChar);
                        }
                    }
                    ++i;
                }
            }
            if (substringIndex != -1) {
                if (this.multipleLineCommentCounter == 0) {
                    int startPosition = this.beginningOfLineIndex + startSubstringIndexes[substringIndex];
                    this.updateMappedPositionsWhileSplitting(startPosition, startPosition + max);
                }
                if (substringIndex + 1 != startSubstringIndexes.length) {
                    this.increaseSplitDelta(startSubstringIndexes[substringIndex] + max - startSubstringIndexes[substringIndex + 1]);
                }
            }
            if (placeOperatorBehind) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    if (operator != 0) {
                        this.increaseSplitDelta(1);
                    }
                }
                this.formattedSource.append(operatorString);
                if (operator != 0) {
                    this.increaseSplitDelta(operatorString.length());
                }
            }
            return;
        }
        if (this.options.maxLineLength != 0 && splitLine != null && (operator == 95 || operator == 96 || operator == 97)) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            this.dumpTab(depth + 1);
        } else if (operator == 95 || operator == 96 || operator == 97) {
            this.formattedSource.append(' ');
            this.increaseSplitDelta(1);
        }
        String[] result = splitLine.substrings;
        int[] splitOperators = splitLine.operators;
        if (result[0].length() == 0) {
            --depth;
            emptyFirstSubString = true;
        }
        int i = 0;
        int max = result.length;
        while (i < max) {
            String currentResult = result[i];
            if (currentResult.length() != 0 || splitOperators[i] != 0) {
                int newDepth = currentResult.startsWith("/*") || currentResult.startsWith("//") ? this.indentationLevel - 1 : depth;
                this.outputLine(currentResult, i == 0 || i == 1 && emptyFirstSubString ? preIndented : false, i == 0 ? newDepth : newDepth + 1, splitOperators[i], i, splitLine.startSubstringsIndexes, currentString.indexOf(currentResult));
                if (i != max - 1) {
                    this.formattedSource.append(this.options.lineSeparatorSequence);
                    this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
                }
            }
            ++i;
        }
        if (result.length == splitOperators.length - 1) {
            int lastOperator = splitOperators[result.length];
            String lastOperatorString = this.operatorString(lastOperator);
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            if (CodeFormatter.breakLineBeforeOperator(lastOperator)) {
                this.dumpTab(depth + 1);
                if (lastOperator != 0) {
                    if (this.insertSpaceBefore(lastOperator)) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                    this.formattedSource.append(lastOperatorString);
                    this.increaseSplitDelta(lastOperatorString.length());
                    if (this.insertSpaceAfter(lastOperator) && lastOperator != 96 && lastOperator != 95 && lastOperator != 97) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                }
            }
        }
        if (placeOperatorBehind) {
            if (this.insertSpaceBefore(operator)) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            this.formattedSource.append(operatorString);
        }
    }

    private int pop(int token) {
        int delta = 0;
        if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == token) {
            --delta;
            --this.constructionsCount;
        }
        return delta;
    }

    private int popExclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 74 && this.constructions[i] != -100) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popExclusiveUntilBlockOrCase() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 74 && this.constructions[i] != -100 && this.constructions[i] != 89) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popInclusiveUntil(int token) {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != token) {
            if (this.constructions[i] != -100) {
                --delta;
            }
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] != -100) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int popInclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 74 && this.constructions[i] != -100) {
            --delta;
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] == 74) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int pushBlock() {
        int delta = 0;
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        if (this.constructionsCount == 0 || this.constructions[this.constructionsCount - 1] == 74 || this.constructions[this.constructionsCount - 1] == -100 || this.constructions[this.constructionsCount - 1] == 89) {
            ++delta;
            this.constructions[this.constructionsCount++] = 74;
        } else {
            this.constructions[this.constructionsCount++] = -100;
        }
        return delta;
    }

    private int pushControlStatement(int token) {
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        this.constructions[this.constructionsCount++] = token;
        return 1;
    }

    private void reset() {
        this.constructionsCount = 0;
        if (this.constructions == null) {
            this.constructions = new int[10];
        }
        this.currentLineIndentationLevel = this.indentationLevel = this.initialIndentationLevel;
        this.currentCommentOffset = -1;
        this.currentLineBuffer = new StringBuffer();
    }

    private static boolean separateFirstArgumentOn(int currentToken) {
        return currentToken != 83 && currentToken != 21 && currentToken != 72 && currentToken != 77 && currentToken != 82 && currentToken != 85;
    }

    public void setPositionsToMap(int[] positions) {
        this.positionsToMap = positions;
        this.lineDelta = 0;
        this.globalDelta = 0;
        this.mappedPositions = new int[positions.length];
    }

    private void space() {
        this.currentLineBuffer.append(' ');
        this.increaseLineDelta(1);
    }

    public SplitLine split(String stringToSplit) {
        return this.split(stringToSplit, 0);
    }

    public SplitLine split(String stringToSplit, int offsetInGlobalLine) {
        if (stringToSplit.indexOf("//$NON-NLS") != -1) {
            return null;
        }
        int currentToken = 0;
        int splitTokenType = 0;
        int splitTokenDepth = Integer.MAX_VALUE;
        int splitTokenPriority = Integer.MAX_VALUE;
        int[] substringsStartPositions = new int[10];
        int[] substringsEndPositions = new int[10];
        int substringsCount = 1;
        int[] splitOperators = new int[10];
        int splitOperatorsCount = 0;
        int[] openParenthesisPosition = new int[10];
        int openParenthesisPositionCount = 0;
        int position = 0;
        int lastOpenParenthesisPosition = -1;
        int lastCommentStartPosition = -1;
        int firstTokenOnLine = -1;
        int previousToken = -1;
        this.splitScanner.setSource(stringToSplit.toCharArray());
        try {
            while (true) {
                try {
                    if (currentToken != 1000) {
                        previousToken = currentToken;
                    }
                    currentToken = this.splitScanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    if (!this.handleInvalidToken(e)) {
                        throw e;
                    }
                    currentToken = 0;
                }
                if (currentToken != 75) {
                    if (firstTokenOnLine == -1) {
                        firstTokenOnLine = currentToken;
                    }
                    switch (currentToken) {
                        case 29: 
                        case 48: {
                            if (openParenthesisPositionCount <= 0) break;
                            if (openParenthesisPositionCount == 1 && lastOpenParenthesisPosition < openParenthesisPosition[0]) {
                                lastOpenParenthesisPosition = openParenthesisPosition[0];
                            } else if (splitTokenDepth == Integer.MAX_VALUE || splitTokenDepth > openParenthesisPositionCount && openParenthesisPositionCount == 1) {
                                splitTokenType = 0;
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenPriority = Integer.MAX_VALUE;
                                substringsStartPositions[0] = 0;
                                substringsCount = 1;
                                substringsEndPositions[0] = openParenthesisPosition[0];
                                position = openParenthesisPosition[0];
                                splitOperatorsCount = 1;
                                splitOperators[0] = 0;
                            }
                            --openParenthesisPositionCount;
                            break;
                        }
                        case 21: 
                        case 74: {
                            if (openParenthesisPositionCount == openParenthesisPosition.length) {
                                int[] nArray = openParenthesisPosition;
                                openParenthesisPosition = new int[openParenthesisPositionCount * 2];
                                System.arraycopy(nArray, 0, openParenthesisPosition, 0, openParenthesisPositionCount);
                            }
                            openParenthesisPosition[openParenthesisPositionCount++] = this.splitScanner.currentPosition;
                            if (currentToken != 21 || previousToken != 29) break;
                            openParenthesisPosition[openParenthesisPositionCount - 1] = this.splitScanner.startPosition;
                            break;
                        }
                        case 23: 
                        case 33: 
                        case 100: {
                            if (openParenthesisPositionCount < splitTokenDepth || openParenthesisPositionCount == splitTokenDepth && splitTokenPriority > CodeFormatter.getTokenPriority(currentToken)) {
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenType = currentToken;
                                splitTokenPriority = CodeFormatter.getTokenPriority(currentToken);
                                substringsStartPositions[0] = 0;
                                if (CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && openParenthesisPositionCount > 0) {
                                    substringsCount = 2;
                                    substringsEndPositions[0] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsStartPositions[1] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsEndPositions[1] = this.splitScanner.startPosition;
                                    splitOperatorsCount = 2;
                                    splitOperators[0] = 0;
                                    splitOperators[1] = currentToken;
                                    position = this.splitScanner.currentPosition;
                                    break;
                                }
                                substringsCount = 1;
                                substringsEndPositions[0] = this.splitScanner.startPosition;
                                position = this.splitScanner.currentPosition;
                                splitOperatorsCount = 1;
                                splitOperators[0] = currentToken;
                                break;
                            }
                            if (openParenthesisPositionCount != splitTokenDepth || splitTokenPriority != CodeFormatter.getTokenPriority(currentToken) || splitTokenType == 100 || currentToken == 100) break;
                            if (substringsCount == substringsStartPositions.length) {
                                int[] nArray = substringsStartPositions;
                                substringsStartPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                                int[] nArray2 = substringsEndPositions;
                                substringsEndPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray2, 0, substringsEndPositions, 0, substringsCount);
                            }
                            if (splitOperatorsCount == splitOperators.length) {
                                int[] nArray = splitOperators;
                                splitOperators = new int[splitOperatorsCount * 2];
                                System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
                            }
                            substringsStartPositions[substringsCount] = position;
                            substringsEndPositions[substringsCount++] = this.splitScanner.startPosition;
                            position = this.splitScanner.currentPosition;
                            splitOperators[splitOperatorsCount++] = currentToken;
                            break;
                        }
                        case 51: {
                            if (splitOperatorsCount == 0 || splitOperators[splitOperatorsCount - 1] != 28) break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 22: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: {
                            if ((openParenthesisPositionCount < splitTokenDepth || openParenthesisPositionCount == splitTokenDepth && splitTokenPriority > CodeFormatter.getTokenPriority(currentToken)) && (currentToken != 2 && currentToken != 3 || previousToken != 74 && previousToken != 7 && this.splitScanner.startPosition != 0)) {
                                splitTokenDepth = openParenthesisPositionCount;
                                splitTokenType = currentToken;
                                splitTokenPriority = CodeFormatter.getTokenPriority(currentToken);
                                substringsStartPositions[0] = 0;
                                if (CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && openParenthesisPositionCount > 0) {
                                    substringsCount = 2;
                                    substringsEndPositions[0] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsStartPositions[1] = openParenthesisPosition[splitTokenDepth - 1];
                                    substringsEndPositions[1] = this.splitScanner.startPosition;
                                    splitOperatorsCount = 3;
                                    splitOperators[0] = 0;
                                    splitOperators[1] = 0;
                                    splitOperators[2] = currentToken;
                                    position = this.splitScanner.currentPosition;
                                    break;
                                }
                                substringsCount = 1;
                                substringsEndPositions[0] = this.splitScanner.startPosition;
                                position = this.splitScanner.currentPosition;
                                splitOperatorsCount = 2;
                                splitOperators[0] = 0;
                                splitOperators[1] = currentToken;
                                break;
                            }
                            if (openParenthesisPositionCount != splitTokenDepth || splitTokenPriority != CodeFormatter.getTokenPriority(currentToken)) break;
                            if (substringsCount == substringsStartPositions.length) {
                                int[] nArray = substringsStartPositions;
                                substringsStartPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                                int[] nArray3 = substringsEndPositions;
                                substringsEndPositions = new int[substringsCount * 2];
                                System.arraycopy(nArray3, 0, substringsEndPositions, 0, substringsCount);
                            }
                            if (splitOperatorsCount == splitOperators.length) {
                                int[] nArray = splitOperators;
                                splitOperators = new int[splitOperatorsCount * 2];
                                System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
                            }
                            substringsStartPositions[substringsCount] = position;
                            substringsEndPositions[substringsCount++] = this.splitScanner.startPosition;
                            position = this.splitScanner.currentPosition;
                            splitOperators[splitOperatorsCount++] = currentToken;
                        }
                    }
                    if (CodeFormatter.isComment(currentToken)) {
                        lastCommentStartPosition = this.splitScanner.startPosition;
                        continue;
                    }
                    lastCommentStartPosition = -1;
                    continue;
                }
                break;
            }
        }
        catch (InvalidInputException e) {
            return null;
        }
        if (splitOperatorsCount == 0) {
            return null;
        }
        if ((splitOperatorsCount == 2 && splitOperators[1] == 1 && splitTokenDepth == 0 && lastOpenParenthesisPosition > -1 || splitOperatorsCount > 2 && splitOperators[1] == 1 && splitTokenDepth == 0 && lastOpenParenthesisPosition > -1 && lastOpenParenthesisPosition <= this.options.maxLineLength || CodeFormatter.separateFirstArgumentOn(firstTokenOnLine) && splitTokenDepth > 0 && lastOpenParenthesisPosition > -1) && lastOpenParenthesisPosition < this.splitScanner.source.length && this.splitScanner.source[lastOpenParenthesisPosition] != ')') {
            SplitLine sl = this.split(stringToSplit.substring(lastOpenParenthesisPosition), lastOpenParenthesisPosition);
            if (sl == null || sl.operators[0] != 33) {
                return new SplitLine(new int[2], new String[]{stringToSplit.substring(0, lastOpenParenthesisPosition).trim(), stringToSplit.substring(lastOpenParenthesisPosition)}, new int[]{offsetInGlobalLine, lastOpenParenthesisPosition + offsetInGlobalLine});
            }
            int startIndex = sl.substrings[0].length() == 0 ? 1 : 0;
            int subStringsLength = sl.substrings.length + 1 - startIndex;
            String[] result = new String[subStringsLength];
            int[] startIndexes = new int[subStringsLength];
            int operatorsLength = sl.operators.length + 1 - startIndex;
            int[] operators = new int[operatorsLength];
            result[0] = stringToSplit.substring(0, lastOpenParenthesisPosition);
            operators[0] = 0;
            System.arraycopy(sl.startSubstringsIndexes, startIndex, startIndexes, 1, subStringsLength - 1);
            int i = subStringsLength - 1;
            while (i >= 0) {
                int n = i--;
                startIndexes[n] = startIndexes[n] + offsetInGlobalLine;
            }
            System.arraycopy(sl.substrings, startIndex, result, 1, subStringsLength - 1);
            System.arraycopy(sl.operators, startIndex, operators, 1, operatorsLength - 1);
            return new SplitLine(operators, result, startIndexes);
        }
        if (lastCommentStartPosition > -1 && lastCommentStartPosition < this.options.maxLineLength && splitTokenPriority > 50) {
            int end = lastCommentStartPosition;
            int start = lastCommentStartPosition;
            if (stringToSplit.charAt(end - 1) == ' ') {
                --end;
            }
            if (start != end && stringToSplit.charAt(start) == ' ') {
                ++start;
            }
            int[] nArray = new int[2];
            nArray[1] = start;
            return new SplitLine(new int[2], new String[]{stringToSplit.substring(0, end), stringToSplit.substring(start)}, nArray);
        }
        if (position != stringToSplit.length()) {
            if (substringsCount == substringsStartPositions.length) {
                int[] nArray = substringsStartPositions;
                substringsStartPositions = new int[substringsCount * 2];
                System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
                int[] nArray4 = substringsEndPositions;
                substringsEndPositions = new int[substringsCount * 2];
                System.arraycopy(nArray4, 0, substringsEndPositions, 0, substringsCount);
            }
            substringsStartPositions[substringsCount] = position;
            substringsEndPositions[substringsCount++] = stringToSplit.length();
        }
        if (splitOperatorsCount == splitOperators.length) {
            int[] nArray = splitOperators;
            splitOperators = new int[splitOperatorsCount * 2];
            System.arraycopy(nArray, 0, splitOperators, 0, splitOperatorsCount);
        }
        splitOperators[splitOperatorsCount] = 0;
        String[] result = new String[substringsCount];
        int i = 0;
        while (i < substringsCount) {
            int start = substringsStartPositions[i];
            int end = substringsEndPositions[i];
            if (stringToSplit.charAt(start) == ' ') {
                ++start;
                int n = i;
                substringsStartPositions[n] = substringsStartPositions[n] + 1;
            }
            if (end != start && stringToSplit.charAt(end - 1) == ' ') {
                --end;
            }
            result[i] = stringToSplit.substring(start, end);
            int n = i++;
            substringsStartPositions[n] = substringsStartPositions[n] + offsetInGlobalLine;
        }
        if (splitOperatorsCount > substringsCount) {
            int[] nArray = substringsStartPositions;
            substringsStartPositions = new int[splitOperatorsCount];
            System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
            int[] nArray5 = substringsEndPositions;
            substringsEndPositions = new int[splitOperatorsCount];
            System.arraycopy(nArray5, 0, substringsEndPositions, 0, substringsCount);
            i = substringsCount;
            while (i < splitOperatorsCount) {
                substringsStartPositions[i] = position;
                substringsEndPositions[i] = position;
                ++i;
            }
            int[] nArray6 = splitOperators;
            splitOperators = new int[splitOperatorsCount];
            System.arraycopy(nArray6, 0, splitOperators, 0, splitOperatorsCount);
        } else {
            int[] nArray = substringsStartPositions;
            substringsStartPositions = new int[substringsCount];
            System.arraycopy(nArray, 0, substringsStartPositions, 0, substringsCount);
            int[] nArray7 = substringsEndPositions;
            substringsEndPositions = new int[substringsCount];
            System.arraycopy(nArray7, 0, substringsEndPositions, 0, substringsCount);
            int[] nArray8 = splitOperators;
            splitOperators = new int[substringsCount];
            System.arraycopy(nArray8, 0, splitOperators, 0, substringsCount);
        }
        SplitLine splitLine = new SplitLine(splitOperators, result, substringsStartPositions);
        return splitLine;
    }

    private void updateMappedPositions(int startPosition) {
        if (this.positionsToMap == null) {
            return;
        }
        char[] source = this.scanner.source;
        int sourceLength = source.length;
        while (this.indexToMap < this.positionsToMap.length && this.positionsToMap[this.indexToMap] <= startPosition) {
            int posToMap = this.positionsToMap[this.indexToMap];
            if (posToMap < 0 || posToMap >= sourceLength) {
                if (posToMap == sourceLength) {
                    this.mappedPositions[this.indexToMap] = this.formattedSource.length();
                }
                this.indexToMap = this.positionsToMap.length;
                return;
            }
            this.mappedPositions[this.indexToMap] = CharOperation.isWhitespace(source[posToMap]) ? startPosition + this.globalDelta + this.lineDelta : (posToMap == sourceLength - 1 ? startPosition + this.globalDelta + this.lineDelta : posToMap + this.globalDelta + this.lineDelta);
            ++this.indexToMap;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMappedPositionsWhileSplitting(int startPosition, int endPosition) {
        if (this.mappedPositions != null && this.mappedPositions.length != this.indexInMap) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            v0 = this.indexInMap++;
            this.mappedPositions[v0] = this.mappedPositions[v0] + this.splitDelta;
lbl5:
            // 2 sources

            ** while (this.indexInMap < this.mappedPositions.length && startPosition <= this.mappedPositions[this.indexInMap] && this.mappedPositions[this.indexInMap] < endPosition && this.indexInMap < this.indexToMap)
        }
lbl6:
        // 1 sources

    }

    private void updateRemainingMappedPositions() {
        if (this.positionsToMap == null) {
            return;
        }
        int sourceLength = this.formattedSource.length();
        while (this.indexToMap < this.positionsToMap.length) {
            this.mappedPositions[this.indexToMap] = sourceLength - 1;
            ++this.indexToMap;
        }
    }

    private int getLength(String s, int tabDepth) {
        int length = 0;
        int i = 0;
        while (i < tabDepth) {
            length += this.options.tabSize;
            ++i;
        }
        i = 0;
        int max = s.length();
        while (i < max) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case '\t': {
                    length += this.options.tabSize;
                    break;
                }
                default: {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    public void setInitialIndentationLevel(int newIndentationLevel) {
        this.currentLineIndentationLevel = this.indentationLevel = newIndentationLevel;
        this.initialIndentationLevel = this.indentationLevel;
    }
}

