/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.examples.AspectJExampleCreationWizardPage;
import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class AspectJExampleCreationOperation
implements IRunnableWithProgress {
    private IResource fElementToOpen = null;
    private AspectJExampleCreationWizardPage[] fPages;
    private IOverwriteQuery fOverwriteQuery;

    public AspectJExampleCreationOperation(AspectJExampleCreationWizardPage[] pages, IOverwriteQuery overwriteQuery) {
        this.fPages = pages;
        this.fOverwriteQuery = overwriteQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc"), this.fPages.length);
            IWorkspaceRoot root = AspectJExamplePlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < this.fPages.length) {
                this.createProject(root, this.fPages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        AJDTUtils.verifyWorkbenchConfiguration();
    }

    public IResource getElementToOpen() {
        return this.fElementToOpen;
    }

    private void createProject(IWorkspaceRoot root, AspectJExampleCreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String value;
        IResource fileToOpen;
        IConfigurationElement desc = page.getConfigurationElement();
        IConfigurationElement[] imports = desc.getChildren("import");
        IConfigurationElement[] natures = desc.getChildren("nature");
        IConfigurationElement[] references = desc.getChildren("references");
        int nImports = imports == null ? 0 : imports.length;
        int nNatures = natures == null ? 0 : natures.length;
        int nReferences = references == null ? 0 : references.length;
        monitor.beginTask(AspectJExampleMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), nImports + 1);
        String name = page.getName();
        String[] natureIds = new String[nNatures];
        int i = 0;
        while (i < nNatures) {
            natureIds[i] = natures[i].getAttribute("id");
            ++i;
        }
        IProject[] referencedProjects = new IProject[nReferences];
        int i2 = 0;
        while (i2 < nReferences) {
            referencedProjects[i2] = root.getProject(references[i2].getAttribute("id"));
            ++i2;
        }
        IProject proj = this.configNewProject(root, name, natureIds, referencedProjects, monitor);
        int i3 = 0;
        while (i3 < nImports) {
            this.doImports(proj, imports[i3], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i3;
        }
        this.setSrcFolder(proj);
        String open = desc.getAttribute("open");
        if (open != null && open.length() > 0 && (fileToOpen = proj.findMember((IPath)new Path(open))) != null) {
            this.fElementToOpen = fileToOpen;
        }
        if ((value = desc.getAttribute("build")) != null) {
            IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
            String propertyName = "org.eclipse.ajdt.ui." + proj.getName() + ".ajproperties";
            store.setValue(propertyName, value);
        }
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(proj);
        pbc.reInit();
        try {
            IFile f;
            BuildConfiguration bc;
            IResource[] files = proj.members(1);
            int buildfiles = 0;
            int i4 = 0;
            while (i4 < files.length) {
                if (files[i4].getType() != 2 && "ajproperties".equals(files[i4].getFileExtension()) && files[i4].exists()) {
                    ++buildfiles;
                }
                ++i4;
            }
            if (buildfiles > 1 && (bc = pbc.getBuildConfiguration(f = (IFile)proj.findMember("build.ajproperties"))) != null) {
                pbc.removeBuildConfiguration(bc);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IProject configNewProject(IWorkspaceRoot root, String name, String[] natureIds, IProject[] referencedProjects, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = root.getProject(name);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription desc = project.getDescription();
            desc.setLocation(null);
            desc.setNatureIds(natureIds);
            desc.setReferencedProjects(referencedProjects);
            project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            desc = project.getDescription();
            ICommand[] buildCommands = desc.getBuildSpec();
            if (this.contains(buildCommands, "org.eclipse.jdt.core.javabuilder")) {
                desc.setBuildSpec(this.remove(buildCommands, "org.eclipse.jdt.core.javabuilder"));
                project.setDescription(desc, null);
            }
            AJDTUtils.addAjrtToBuildPath((IProject)project);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] originalCP = javaProject.getRawClasspath();
                IClasspathEntry jreCP = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
                int originalCPLength = originalCP.length;
                IClasspathEntry[] newCP = new IClasspathEntry[originalCPLength + 1];
                System.arraycopy(originalCP, 0, newCP, 0, originalCPLength);
                newCP[originalCPLength] = jreCP;
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            return project;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private boolean contains(ICommand[] commands, String builderId) {
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    private ICommand[] remove(ICommand[] sourceCommands, String builderId) {
        ICommand[] newCommands = new ICommand[sourceCommands.length - 1];
        int newCommandIndex = 0;
        int i = 0;
        while (i < sourceCommands.length) {
            if (!sourceCommands[i].getBuilderName().equals(builderId)) {
                newCommands[newCommandIndex++] = sourceCommands[i];
            }
            ++i;
        }
        return newCommands;
    }

    private void doImports(IProject project, IConfigurationElement curr, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IPath destPath;
            String name = curr.getAttribute("dest");
            if (name == null || name.length() == 0) {
                destPath = project.getFullPath();
            } else {
                IFolder folder = project.getFolder(name);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                destPath = folder.getFullPath();
            }
            String importPath = curr.getAttribute("src");
            if (importPath == null) {
                importPath = "";
                AspectJExamplePlugin.log("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir(importPath);
            this.importFilesFromZip(zipFile, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void setSrcFolder(IProject project) {
        try {
            IResource srcFolder = project.findMember("src");
            if (srcFolder != null && srcFolder.getType() == 2) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] javaCP = javaProject.getRawClasspath();
                boolean done = false;
                int i = 0;
                while (!done && i < javaCP.length) {
                    if (javaCP[i].getEntryKind() == 3) {
                        javaCP[i] = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
                        javaProject.setRawClasspath(javaCP, (IProgressMonitor)new NullProgressMonitor());
                        done = true;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath) throws CoreException {
        try {
            URL starterURL = new URL(AspectJExamplePlugin.getDefault().getDescriptor().getInstallURL(), pluginRelativePath);
            return new ZipFile(Platform.asLocalURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, AspectJExamplePlugin.getPluginId(), 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.fOverwriteQuery);
        op.run(monitor);
    }
}

