/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.PropertyPageManager;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class BuildConfigurator
implements ISelectionListener {
    private HashMap projectConfigurators = new HashMap();
    private Vector changeListeners = new Vector();
    private IProject currentProj;
    private int notificationType = -1;
    private static BuildConfigurator buildConfigurator;
    private HashSet fileList;
    static /* synthetic */ Class class$0;

    private BuildConfigurator() {
    }

    public static synchronized BuildConfigurator getBuildConfigurator() {
        if (buildConfigurator == null) {
            buildConfigurator = new BuildConfigurator();
        }
        return buildConfigurator;
    }

    public void selectionChanged(IWorkbenchPart action, ISelection selection) {
        Object selectedProj;
        if (action instanceof IEditorPart) {
            IResource res;
            IEditorInput iEditorInput = ((IEditorPart)action).getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            selectedProj = (res = (IResource)iEditorInput.getAdapter((Class)clazz)) != null ? res.getProject() : null;
        } else {
            selectedProj = this.getProjectFromSelection(selection);
        }
        if (selectedProj != this.currentProj && selectedProj != null) {
            this.fileList = null;
            this.currentProj = selectedProj;
            if (this.canManage(this.currentProj)) {
                PropertyPageManager.unregisterJDTPropertyPage();
            } else if (this.currentProj.isOpen()) {
                PropertyPageManager.registerJDTPropertyPage();
            }
            this.notifyChangeListeners();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyChangeListeners() {
        if (this.notificationType != -1) return;
        try {
            this.notificationType = 0;
            ProjectBuildConfigurator pbc = this.getActiveProjectBuildConfigurator();
            Iterator iter = this.changeListeners.iterator();
            while (iter.hasNext()) {
                ((IBuildConfigurationChangedListener)iter.next()).buildConfigurationChanged(pbc);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.notificationType = -1;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.notificationType = -1;
            return;
        }
    }

    private IProject getProjectFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (first instanceof IJavaElement) {
                return ((IJavaElement)first).getJavaProject().getProject();
            }
            if (first instanceof IResource) {
                IResource myRes = (IResource)first;
                return myRes.getProject();
            }
            if (first instanceof ClassPathContainer) {
                return ((ClassPathContainer)first).getJavaProject().getProject();
            }
        }
        return null;
    }

    public ProjectBuildConfigurator getActiveProjectBuildConfigurator() {
        return this.getProjectBuildConfigurator(this.currentProj);
    }

    public Set getProjectBuildConfigurators() {
        return this.projectConfigurators.entrySet();
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IJavaProject proj) {
        if (proj != null && this.canManage(proj.getProject())) {
            ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getProject().getName());
            if (pbc != null) {
                return pbc;
            }
            return this.createPBC(proj);
        }
        return null;
    }

    private synchronized ProjectBuildConfigurator createPBC(IJavaProject proj) {
        ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getProject().getName());
        if (pbc != null) {
            return pbc;
        }
        pbc = new ProjectBuildConfigurator(proj);
        this.projectConfigurators.put(proj.getProject().getName(), pbc);
        return pbc;
    }

    public ProjectBuildConfigurator getProjectBuildConfigurator(IProject proj) {
        return this.getProjectBuildConfigurator(JavaCore.create((IProject)proj));
    }

    public boolean canManage(IProject proj) {
        if (proj == null || !proj.isOpen()) {
            return false;
        }
        try {
            if (proj.getProject().hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return true;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return false;
    }

    public void addProjectBuildConfigurator(ProjectBuildConfigurator pbc) {
        this.projectConfigurators.put(pbc.getJavaProject().getProject().getName(), pbc);
    }

    public void addBuildConfigurationChangedListener(IBuildConfigurationChangedListener bccl) {
        this.changeListeners.add(bccl);
    }

    public void closeProject(IProject proj) {
        this.fileList = null;
        ProjectBuildConfigurator pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(proj.getName());
        if (pbc != null) {
            if (proj == this.currentProj) {
                this.currentProj = null;
            }
            this.projectConfigurators.remove(proj.getName());
            this.notifyChangeListeners();
        }
    }

    public void checkNature(IProject project) {
        if (this.projectConfigurators.containsKey(project.getName())) {
            ProjectBuildConfigurator pbc;
            if (!this.canManage(project) && (pbc = (ProjectBuildConfigurator)this.projectConfigurators.get(project.getName())) != null) {
                this.closeProject(project);
            }
        } else if (this.canManage(project)) {
            this.currentProj = project;
            this.notifyChangeListeners();
        }
    }

    public void restoreJDTState(IProject project) {
        PropertyPageManager.registerJDTPropertyPage();
        this.checkNature(project);
    }

    public void setup(IProject project) {
        this.fileList = null;
        PropertyPageManager.unregisterJDTPropertyPage();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            if (this.haveExclusionPatterns(cpes)) {
                this.fileList = this.getFileSetFromCPE(cpes, jp);
                int i = 0;
                while (i < cpes.length) {
                    if (cpes[i].getEntryKind() == 3) {
                        cpes[i] = JavaCore.newSourceEntry((IPath)cpes[i].getPath());
                    }
                    ++i;
                }
                jp.setRawClasspath(cpes, null);
            }
        }
        catch (JavaModelException e) {
            AspectJPlugin.logException(e);
            this.fileList = null;
        }
    }

    HashSet getFileSetFromCPE(IClasspathEntry[] cpes, IJavaProject jp) {
        HashSet fileSet = new HashSet(30);
        int i = 0;
        while (i < cpes.length) {
            IResource res;
            if (cpes[i].getEntryKind() == 3 && (res = jp.getProject().getParent().findMember(cpes[i].getPath())) != null && (res.getType() == 2 || res.getType() == 4)) {
                this.addAllIncludedMembers(fileSet, (IContainer)res, jp);
            }
            ++i;
        }
        return fileSet;
    }

    boolean haveExclusionPatterns(IClasspathEntry[] cpes) {
        int i = 0;
        while (i < cpes.length) {
            if (cpes[i].getEntryKind() == 3 && (cpes[i].getExclusionPatterns().length > 0 || cpes[i].getInclusionPatterns().length > 0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    HashSet getInitialFileList() {
        return this.fileList;
    }

    private void addAllIncludedMembers(HashSet l, IContainer con, IJavaProject jp) {
        try {
            IResource[] reses = con.members();
            int i = 0;
            while (i < reses.length) {
                if (reses[i] instanceof IContainer) {
                    this.addAllIncludedMembers(l, (IContainer)reses[i], jp);
                } else if (jp.isOnClasspath(reses[i]) && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(reses[i].getName())) {
                    l.add(reses[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }
}

