/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners = new ArrayList(2);
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
    private DecoratorManager decman = WorkbenchPlugin.getDefault().getDecoratorManager();
    private ImageDescriptor halfFilledPackageID = AspectJImages.BC_HALF_FILLED_PACKAGE.getImageDescriptor();
    private ImageDescriptor activeConfigFileImage = AspectJImages.BC_SELECTED_FILE.getImageDescriptor();
    private BuildConfigurator buildConfor = BuildConfigurator.getBuildConfigurator();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image decorateImage(Image image, Object element) {
        if (this.preventRecursion) {
            return null;
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit comp = (ICompilationUnit)element;
            try {
                element = comp.getCorrespondingResource();
            }
            catch (JavaModelException e) {
                element = null;
            }
        }
        Image img = null;
        if (element instanceof IFile) {
            ProjectBuildConfigurator pbc;
            IFile file = (IFile)element;
            if (ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(file.getName())) {
                ProjectBuildConfigurator pbc2 = this.buildConfor.getProjectBuildConfigurator(file.getProject());
                if (pbc2 == null) {
                    return null;
                }
                if (pbc2.getActiveBuildConfiguration().isIncluded((IResource)file)) {
                    Rectangle rect = image.getBounds();
                    int flags = rect.height == 16 ? 2 : 0;
                    img = this.getImageLabel(this.getCUImageDescriptor(file, flags));
                } else {
                    Rectangle rect = image.getBounds();
                    int flags = rect.height == 16 ? 2 : 0;
                    img = this.getImageLabel(this.getCUResourceImageDescriptor(file, flags));
                }
            } else if ("ajproperties".equals(file.getFileExtension()) && (pbc = this.buildConfor.getProjectBuildConfigurator(file.getProject())) != null && file.equals((Object)pbc.getActiveBuildConfiguration().getFile())) {
                img = this.getImageLabel(this.activeConfigFileImage);
            }
        } else if (element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            ProjectBuildConfigurator pbc = this.buildConfor.getProjectBuildConfigurator(pack.getJavaProject());
            if (pbc == null) {
                return null;
            }
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            try {
                if (ImageDecorator.containsIncludedFiles(bc, pack)) {
                    if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                        img = this.getImageLabel(this.halfFilledPackageID);
                    } else if (!pack.containsJavaResources()) {
                        img = this.getImageLabel(JavaPluginImages.DESC_OBJS_PACKAGE);
                    }
                } else if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                    img = this.getImageLabel(JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE);
                }
            }
            catch (JavaModelException e) {}
        } else {
            return null;
        }
        if (img != null) {
            this.preventRecursion = true;
            img = this.problemsDecorator.decorateImage(img, element);
            img = this.decman.decorateImage(img, element);
            this.preventRecursion = false;
            return img;
        }
        return null;
    }

    public static boolean containsIncludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
            Object[] children = pack.getNonJavaResources();
            int i2 = 0;
            while (i2 < children.length) {
                IFile f;
                if (children[i2] instanceof IFile && "aj".equals((f = (IFile)children[i2]).getFileExtension()) && bc.isIncluded((IResource)f)) {
                    return true;
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public static boolean containsExcludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && !bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
            Object[] children = pack.getNonJavaResources();
            int i2 = 0;
            while (i2 < children.length) {
                IFile f;
                if (children[i2] instanceof IFile && "aj".equals((f = (IFile)children[i2]).getFileExtension()) && !bc.isIncluded((IResource)f)) {
                    return true;
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getCUImageDescriptor(IFile file, int flags) {
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT, 0, size);
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

