/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectBuildConfigurator {
    private HashMap buildconfigs;
    private IJavaProject javaProject;
    IFile activeBuildConfiguration;
    private BuildConfigurator buildConfigurator;
    private boolean initialized;
    private boolean fullbuildrequested;

    public ProjectBuildConfigurator(IJavaProject project) {
        this.javaProject = project;
        this.buildConfigurator = BuildConfigurator.getBuildConfigurator();
        this.buildconfigs = new HashMap();
    }

    public void reInit() {
        this.initialized = false;
    }

    private void init() {
        if (!this.initialized) {
            this.readBuildConfigurationsFromFileSystem();
            this.activeBuildConfiguration = this.getStoredBuildConfiguration();
            this.initialized = true;
        }
    }

    private IFile getStoredBuildConfiguration() {
        IProject project;
        String propertyName;
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        String configFile = store.getString(propertyName = "org.eclipse.ajdt.ui." + (project = this.javaProject.getProject()).getName() + ".ajproperties");
        if (configFile.length() == 0) {
            return null;
        }
        return project.getFile(configFile);
    }

    private void storeActiveBuildConfigurationName(String value) {
        IPreferenceStore store = AspectJPlugin.getDefault().getPreferenceStore();
        IProject project = this.javaProject.getProject();
        String propertyName = "org.eclipse.ajdt.ui." + project.getName() + ".ajproperties";
        store.setValue(propertyName, value);
    }

    private void readBuildConfigurationsFromFileSystem() {
        try {
            IResource[] files = this.javaProject.getProject().members(1);
            int i = 0;
            while (i < files.length) {
                if (files[i].getType() != 2 && "ajproperties".equals(files[i].getFileExtension()) && files[i].exists()) {
                    BuildConfiguration bc = new BuildConfiguration((IFile)files[i], this);
                    this.buildconfigs.put(files[i], bc);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    public BuildConfiguration getActiveBuildConfiguration() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return (BuildConfiguration)this.buildconfigs.get(this.activeBuildConfiguration);
    }

    public void setActiveBuildConfiguration(BuildConfiguration bc) {
        if (this.buildconfigs.containsKey(bc.getFile())) {
            IFile oldActive = this.activeBuildConfiguration;
            this.activeBuildConfiguration = bc.getFile();
            this.storeActiveBuildConfigurationName(bc.getFile().getName());
            bc.update(false);
            if (!this.activeBuildConfiguration.equals((Object)oldActive)) {
                try {
                    this.activeBuildConfiguration.touch(null);
                }
                catch (CoreException e) {
                    AspectJPlugin.logException(e);
                }
            }
        }
    }

    public BuildConfiguration getBuildConfiguration(IFile bcFile) {
        return (BuildConfiguration)this.buildconfigs.get(bcFile);
    }

    public void requestFullBuild(boolean temp) {
        this.fullbuildrequested = temp;
    }

    public boolean fullBuildRequested() {
        return this.fullbuildrequested;
    }

    public void configurationChanged(BuildConfiguration bc) {
        if (this.initialized) {
            if (!this.buildconfigs.containsKey(bc.getFile())) {
                this.buildconfigs.put(bc.getFile(), bc);
            }
            if (bc.getFile().equals((Object)this.activeBuildConfiguration)) {
                this.requestFullBuild(true);
                Runnable r = new Runnable(){

                    public void run() {
                        PackageExplorerPart pep = PackageExplorerPart.getFromActivePerspective();
                        if (pep != null) {
                            pep.getTreeViewer().refresh();
                        }
                    }
                };
                AspectJPlugin.getDefault().getDisplay().asyncExec(r);
            }
            this.buildConfigurator.notifyChangeListeners();
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setProject(IJavaProject project) {
        this.javaProject = project;
    }

    public IFile[] getConfigurationFiles() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        IFile[] z = new IFile[]{};
        return this.buildconfigs.keySet().toArray(z);
    }

    public Collection getBuildConfigurations() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return this.buildconfigs.values();
    }

    public void addBuildConfiguration(BuildConfiguration bc) {
        this.buildconfigs.put(bc.getFile(), bc);
        this.buildConfigurator.notifyChangeListeners();
    }

    private void makeSureThereIsAtLeastOneActiveConfiguration() {
        if (!this.initialized) {
            this.init();
        }
        if (this.buildconfigs.size() == 0) {
            BuildConfiguration nbc = new BuildConfiguration("build", this.javaProject, this);
            this.buildconfigs.put(nbc.getFile(), nbc);
        }
        if (this.activeBuildConfiguration == null || !this.buildconfigs.containsKey(this.activeBuildConfiguration)) {
            this.setActiveBuildConfiguration((BuildConfiguration)this.buildconfigs.values().iterator().next());
        }
    }

    public void removeBuildConfiguration(BuildConfiguration bc) {
        if (bc.getFile().equals((Object)this.activeBuildConfiguration)) {
            this.activeBuildConfiguration = null;
        }
        this.buildconfigs.remove(bc.getFile());
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        this.buildConfigurator.notifyChangeListeners();
    }

    public void setActiveBuildConfiguration(IFile buildFile) {
        BuildConfiguration bc = this.getBuildConfiguration(buildFile);
        if (bc == null) {
            bc = new BuildConfiguration(buildFile, this);
            this.addBuildConfiguration(bc);
        }
        this.setActiveBuildConfiguration(bc);
    }

    public void removeBuildConfiguration(IFile file) {
        BuildConfiguration bc = this.getBuildConfiguration(file);
        if (bc != null) {
            this.removeBuildConfiguration(bc);
        }
    }
}

