/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;

public class PropertyPageManager {
    private static RegistryPageContributor jdtProjectPropertyPage = null;
    private static RegistryPageContributor jdtJavaProjectPropertyPage = null;
    private static boolean jdtPropertyPageActive = true;
    static final String projectID = "org.eclipse.core.resources.IProject";
    static final String javaProjectID = "org.eclipse.jdt.core.IJavaProject";

    private PropertyPageManager() {
    }

    public static void unregisterJDTPropertyPage() {
        if (jdtProjectPropertyPage == null) {
            PropertyPageManager.extractJDTRegistryPageContributors();
        }
        if (PropertyPageManager.isJDTPropertyPageActive()) {
            PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
            ppcm.unregisterContributor((IObjectContributor)jdtProjectPropertyPage, projectID);
            ppcm.unregisterContributor((IObjectContributor)jdtJavaProjectPropertyPage, javaProjectID);
            jdtPropertyPageActive = false;
        }
    }

    public static void registerJDTPropertyPage() {
        if (jdtProjectPropertyPage == null) {
            PropertyPageManager.extractJDTRegistryPageContributors();
        }
        if (!PropertyPageManager.isJDTPropertyPageActive()) {
            PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
            ppcm.registerContributor((IObjectContributor)jdtProjectPropertyPage, projectID);
            ppcm.registerContributor((IObjectContributor)jdtJavaProjectPropertyPage, javaProjectID);
            jdtPropertyPageActive = true;
        }
    }

    private static void extractJDTRegistryPageContributors() {
        ArrayList<RegistryPageContributor> list = new ArrayList<RegistryPageContributor>(3);
        PropertyPageContributorManager ppcm = PropertyPageContributorManager.getManager();
        Iterator iter = ppcm.getContributors().iterator();
        while (iter.hasNext()) {
            Vector v = (Vector)iter.next();
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                RegistryPageContributor rpc = (RegistryPageContributor)iter2.next();
                if (!rpc.getPageId().equals("org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage")) continue;
                list.add(rpc);
            }
        }
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        jdtProjectPropertyPage = (RegistryPageContributor)list.get(0);
        jdtJavaProjectPropertyPage = (RegistryPageContributor)list.get(1);
        jdtPropertyPageActive = true;
    }

    public static boolean isJDTPropertyPageActive() {
        return jdtPropertyPageActive;
    }
}

