/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class UpdateJob
extends Job {
    public static final int BUILD_CONFIG_CHANGED = 1;
    public static final int BUILD_CONFIG_REMOVED = 2;
    public static final int CLASSPATH_CHANGED = 3;
    public static final int SOURCE_ADDED = 4;
    private int type;
    private IResource myRes;
    private final BuildConfigurator myBCor;

    public UpdateJob(BuildConfigurator myBCor, int type, IResource myRes) {
        super("Build configuration update");
        this.setRule((ISchedulingRule)myRes.getProject());
        this.setPriority(20);
        this.myBCor = myBCor;
        this.type = type;
        this.myRes = myRes;
    }

    protected IStatus run(IProgressMonitor monitor) {
        switch (this.type) {
            case 1: {
                this.buildConfigChanged();
                break;
            }
            case 2: {
                this.buildConfigRemoved();
                break;
            }
            case 3: {
                this.classpathChanged();
                break;
            }
            case 4: {
                this.sourceAdded();
            }
        }
        return Status.OK_STATUS;
    }

    private void sourceAdded() {
        BuildConfiguration bc;
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null && (bc = pbc.getActiveBuildConfiguration()) != null && !bc.isIncluded(this.myRes)) {
            bc.update(false);
        }
    }

    private void classpathChanged() {
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null) {
            try {
                IJavaProject jp = JavaCore.create((IProject)this.myRes.getProject());
                IClasspathEntry[] cpes = jp.getRawClasspath();
                ArrayList<IPath> sourcePathes = new ArrayList<IPath>();
                int i = 0;
                while (i < cpes.length) {
                    if (cpes[i].getEntryKind() == 3) {
                        sourcePathes.add(cpes[i].getPath().removeFirstSegments(1));
                    }
                    ++i;
                }
                Iterator iter = pbc.getBuildConfigurations().iterator();
                while (iter.hasNext()) {
                    ((BuildConfiguration)iter.next()).updateSourceFolders(sourcePathes);
                }
            }
            catch (JavaModelException e) {
                AspectJPlugin.logException(e);
            }
        }
    }

    private void buildConfigRemoved() {
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null) {
            pbc.removeBuildConfiguration((IFile)this.myRes);
        }
    }

    private void buildConfigChanged() {
        BuildConfiguration bc;
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null && (bc = pbc.getBuildConfiguration((IFile)this.myRes)) != null) {
            bc.update(true);
            pbc.configurationChanged(bc);
        }
    }
}

