/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.editor.BuildUtil;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class BuildContentsSection
extends TableSection
implements IModelChangedListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected CheckboxTreeViewer fTreeViewer;
    private boolean fDoRefresh = false;
    protected IProject fProject;
    protected IBuildModel fBuildModel;
    protected IResource fOriginalResource;
    protected IResource fParentResource;
    protected boolean isChecked;

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                BuildContentsSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.fTreeViewer.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.getPage().getPDEEditor().getContributor().getRevertAction());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        return (IBuildModel)context.getModel();
    }

    public BuildContentsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[0]);
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void createClient(final Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.fBuildModel = this.getBuildModel();
        if (this.fBuildModel.getUnderlyingResource() != null) {
            this.fProject = this.fBuildModel.getUnderlyingResource().getProject();
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        this.fTreeViewer = new CheckboxTreeViewer(toolkit.createTree(container, 32));
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTreeViewer.setAutoExpandLevel(0);
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                BusyIndicator.showWhile((Display)section.getDisplay(), (Runnable)new Runnable(this, element, event){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Object val$element;
                    private final /* synthetic */ CheckStateChangedEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                        this.val$event = checkStateChangedEvent;
                    }

                    public void run() {
                        if (this.val$element instanceof IFile) {
                            IFile file = (IFile)this.val$event.getElement();
                            2.access$0(this.this$1).handleCheckStateChanged((IResource)file, this.val$event.getChecked());
                        } else if (this.val$element instanceof IFolder) {
                            IFolder folder = (IFolder)this.val$event.getElement();
                            2.access$0(this.this$1).handleCheckStateChanged((IResource)folder, this.val$event.getChecked());
                        }
                    }
                });
            }

            static /* synthetic */ BuildContentsSection access$0(2 var0) {
                return var0.BuildContentsSection.this;
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 100;
        this.fTreeViewer.getTree().setLayoutData((Object)gd);
        this.initialize();
        this.initializeCheckState();
        toolkit.paintBordersFor(container);
        this.createViewerPartControl(container, 65536, 2, toolkit);
        section.setClient((Control)container);
    }

    public void enableSection(boolean enable) {
        this.fTreeViewer.getTree().setEnabled(enable);
    }

    protected void handleCheckStateChanged(IResource resource, boolean checked) {
        this.fOriginalResource = resource;
        this.isChecked = checked;
        boolean wasTopParentChecked = this.isIncluded((IResource)this.fOriginalResource.getParent());
        if (!this.isChecked) {
            resource = this.handleAllUnselected(resource, resource.getName());
        }
        this.fParentResource = resource;
        this.handleBuildCheckStateChange(wasTopParentChecked);
    }

    protected IResource handleAllUnselected(IResource resource, String name) {
        IContainer parent = resource.getParent();
        if (parent == resource.getProject()) {
            return resource;
        }
        try {
            boolean uncheck = true;
            IResource[] members = ((IFolder)parent).members();
            int i = 0;
            while (i < members.length) {
                if (this.isIncluded(members[i]) && !members[i].getName().equals(name)) {
                    uncheck = false;
                }
                ++i;
            }
            if (uncheck) {
                return this.handleAllUnselected((IResource)parent, parent.getName());
            }
            return resource;
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
            return null;
        }
    }

    protected void setChildrenGrayed(IResource folder, boolean isGray) {
        this.fTreeViewer.setGrayed((Object)folder, isGray);
        if (((TreeContentProvider)this.fTreeViewer.getContentProvider()).hasChildren(folder)) {
            Object[] members = ((TreeContentProvider)this.fTreeViewer.getContentProvider()).getFolderChildren(folder);
            int i = 0;
            while (i < members.length) {
                this.setChildrenGrayed((IResource)((IFolder)members[i]), isGray);
                ++i;
            }
        }
    }

    protected void setParentsChecked(IResource resource) {
        if (resource.getParent() != resource.getProject()) {
            this.fTreeViewer.setChecked((Object)resource.getParent(), true);
            this.setParentsChecked((IResource)resource.getParent());
        }
    }

    protected abstract void deleteFolderChildrenFromEntries(IFolder var1);

    protected void initializeCheckState() {
        this.uncheckAll();
    }

    protected void initializeCheckState(final IBuildEntry includes, final IBuildEntry excludes) {
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IResource[] members;
                if (BuildContentsSection.this.fTreeViewer.getTree().isDisposed()) {
                    return;
                }
                Vector<String> fileExt = new Vector<String>();
                String[] exclTokens = new String[]{};
                if (BuildContentsSection.this.fProject == null || includes == null) {
                    return;
                }
                String[] inclTokens = includes.getTokens();
                if (excludes != null) {
                    exclTokens = excludes.getTokens();
                }
                TreeSet<String> temp = new TreeSet<String>();
                int i = 0;
                while (i < inclTokens.length) {
                    temp.add(inclTokens[i]);
                    ++i;
                }
                i = 0;
                while (i < exclTokens.length) {
                    temp.add(exclTokens[i]);
                    ++i;
                }
                Iterator iter = temp.iterator();
                while (iter.hasNext()) {
                    String resource = iter.next().toString();
                    boolean isIncluded = includes.contains(resource);
                    if (resource.lastIndexOf(47) == resource.length() - 1) {
                        if (resource.length() == 1) {
                            try {
                                IResource[] members2 = BuildContentsSection.this.fProject.members();
                                int i2 = 0;
                                while (i2 < members2.length) {
                                    BuildContentsSection.this.fTreeViewer.setSubtreeChecked((Object)members2[i2], isIncluded);
                                    ++i2;
                                }
                            }
                            catch (CoreException e) {
                                AspectJPlugin.logException(e);
                            }
                            continue;
                        }
                        IFolder folder = BuildContentsSection.this.fProject.getFolder(resource);
                        BuildContentsSection.this.fTreeViewer.setSubtreeChecked((Object)folder, isIncluded);
                        BuildContentsSection.this.fTreeViewer.setParentsGrayed((Object)folder, true);
                        if (!isIncluded || !folder.exists()) continue;
                        BuildContentsSection.this.setParentsChecked((IResource)folder);
                        BuildContentsSection.this.fTreeViewer.setGrayed((Object)folder, false);
                        continue;
                    }
                    if (resource.startsWith("*.")) {
                        if (!isIncluded) continue;
                        fileExt.add(resource.substring(2));
                        continue;
                    }
                    IFile file = BuildContentsSection.this.fProject.getFile(resource);
                    BuildContentsSection.this.fTreeViewer.setChecked((Object)file, isIncluded);
                    BuildContentsSection.this.fTreeViewer.setParentsGrayed((Object)file, true);
                    if (!isIncluded || !file.exists()) continue;
                    BuildContentsSection.this.fTreeViewer.setGrayed((Object)file, false);
                    BuildContentsSection.this.setParentsChecked((IResource)file);
                }
                try {
                    members = BuildContentsSection.this.fProject.members();
                    int i3 = 0;
                    while (i3 < members.length) {
                        BuildContentsSection.this.fTreeViewer.setExpandedState((Object)members[i3], true);
                        ++i3;
                    }
                    Object[] exp = BuildContentsSection.this.fTreeViewer.getVisibleExpandedElements();
                    IContentProvider cp = BuildContentsSection.this.fTreeViewer.getContentProvider();
                    if (cp instanceof ITreeContentProvider && exp.length > 0) {
                        ITreeContentProvider tcp = (ITreeContentProvider)cp;
                        Object obj = exp[0];
                        while (tcp.hasChildren(obj)) {
                            obj = tcp.getChildren(obj)[0];
                            BuildContentsSection.this.fTreeViewer.setExpandedState(obj, true);
                        }
                    }
                }
                catch (CoreException e) {
                    AspectJPlugin.logException(e);
                }
                if (fileExt.size() == 0) {
                    return;
                }
                try {
                    members = BuildContentsSection.this.fProject.members();
                    int i4 = 0;
                    while (i4 < members.length) {
                        if (!(members[i4] instanceof IFolder) && fileExt.contains(members[i4].getFileExtension())) {
                            BuildContentsSection.this.fTreeViewer.setChecked((Object)members[i4], includes.contains("*." + members[i4].getFileExtension()));
                        }
                        ++i4;
                    }
                }
                catch (CoreException e) {
                    AspectJPlugin.logException(e);
                }
            }
        });
    }

    protected abstract void handleBuildCheckStateChange(boolean var1);

    protected void handleCheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource, boolean wasTopParentChecked, String PROPERTY_INCLUDES) {
        try {
            if (includes == null) {
                includes = this.fBuildModel.getFactory().createEntry(PROPERTY_INCLUDES);
                IBuild build = this.fBuildModel.getBuild();
                build.add(includes);
            }
            if (!wasTopParentChecked && !includes.contains(resourceName) || this.isValidIncludeEntry(includes, excludes, resource, resourceName)) {
                includes.addToken(resourceName);
            }
            if (excludes != null && excludes.contains(resourceName)) {
                excludes.removeToken(resourceName);
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    protected boolean isValidIncludeEntry(IBuildEntry includes, IBuildEntry excludes, IResource resource, String resourceName) {
        if (excludes == null) {
            return true;
        }
        IPath resPath = resource.getProjectRelativePath();
        while (resPath.segmentCount() > 1) {
            if (includes.contains(String.valueOf((resPath = resPath.removeLastSegments(1)).toString()) + '/')) {
                return false;
            }
            if (excludes == null || !excludes.contains(String.valueOf(resPath.toString()) + '/')) continue;
            return true;
        }
        return !excludes.contains(resourceName);
    }

    private boolean isIncluded(IResource res) {
        if (res.getType() == 4) {
            IJavaProject jp = JavaCore.create((IProject)((IProject)res));
            return jp.isOnClasspath(res);
        }
        if (this.fTreeViewer != null) {
            return this.fTreeViewer.getChecked((Object)res);
        }
        return false;
    }

    protected void handleUncheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource, String PROPERTY_EXCLUDES) {
        try {
            if (this.isIncluded((IResource)resource.getParent())) {
                if (excludes == null) {
                    excludes = this.fBuildModel.getFactory().createEntry(PROPERTY_EXCLUDES);
                    IBuild build = this.fBuildModel.getBuild();
                    build.add(excludes);
                }
                if (!(excludes.contains(resourceName) || includes != null && includes.contains(resourceName))) {
                    excludes.addToken(resourceName);
                }
            }
            if (includes != null) {
                if (includes.contains(resourceName)) {
                    includes.removeToken(resourceName);
                }
                if (includes.contains("*." + resource.getFileExtension())) {
                    IResource[] members = this.fProject.members();
                    int i = 0;
                    while (i < members.length) {
                        if (!(members[i] instanceof IFolder) && !members[i].getName().equals(resource.getName()) && resource.getFileExtension().equals(members[i].getFileExtension())) {
                            includes.addToken(members[i].getName());
                        }
                        IBuildEntry[] libraries = BuildUtil.getBuildLibraries(this.fBuildModel.getBuild().getBuildEntries());
                        if (resource.getFileExtension().equals("jar") && libraries.length != 0) {
                            int j = 0;
                            while (j < libraries.length) {
                                String libName = libraries[j].getName().substring(7);
                                IPath path = this.fProject.getFile(libName).getProjectRelativePath();
                                if (path.segmentCount() == 1 && !includes.contains(libName) && !libName.equals(resource.getName())) {
                                    includes.addToken(libName);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    includes.removeToken("*." + resource.getFileExtension());
                }
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    protected String getResourceFolderName(String resourceName) {
        return String.valueOf(resourceName) + '/';
    }

    protected String handleResourceFolder(IResource resource, String resourceName) {
        if (resource instanceof IFolder) {
            this.deleteFolderChildrenFromEntries((IFolder)resource);
            return this.getResourceFolderName(resourceName);
        }
        return resourceName;
    }

    public void initialize() {
        if (this.fTreeViewer.getInput() == null) {
            this.fTreeViewer.setUseHashlookup(true);
            this.fTreeViewer.setInput((Object)this.fProject);
        }
        this.fBuildModel.addModelChangedListener(this);
    }

    public void dispose() {
        this.fBuildModel.removeModelChangedListener(this);
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void deleteEmptyEntries() {
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry[] entries = new IBuildEntry[]{build.getEntry("bin.excludes"), build.getEntry("bin.includes"), build.getEntry("src.excludes"), build.getEntry("src.includes")};
        try {
            int i = 0;
            while (i < entries.length) {
                if (entries[i] != null && entries[i].getTokens().length == 0) {
                    build.remove(entries[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected ISelection getViewerSelection() {
        return this.getTreeViewer().getSelection();
    }

    public void refresh() {
        this.initializeCheckState();
        super.refresh();
    }

    public void uncheckAll() {
        this.fTreeViewer.setCheckedElements(new Object[0]);
    }

    protected void removeChildren(IBuildEntry entry, String parentFolder) {
        try {
            if (entry != null) {
                String[] tokens = entry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].indexOf(47) != -1 && tokens[i].startsWith(parentFolder) && !tokens[i].equals(parentFolder)) {
                        entry.removeToken(tokens[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fTreeViewer.getControl().isDisposed()) {
            return;
        }
        this.fDoRefresh = false;
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
            if (this.fDoRefresh) {
                this.asyncRefresh();
                this.fDoRefresh = false;
            }
        }
        catch (CoreException e) {
            AspectJPlugin.logException(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if ((resource instanceof IFile || resource instanceof IFolder) && resource.getProject().equals((Object)this.fBuildModel.getUnderlyingResource().getProject()) && (delta.getKind() == 1 || delta.getKind() == 2)) {
            this.fDoRefresh = true;
            return false;
        }
        return true;
    }

    private void asyncRefresh() {
        Control control = this.fTreeViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuildContentsSection.this.fTreeViewer.getControl().isDisposed()) {
                        BuildContentsSection.this.fTreeViewer.refresh(true);
                        BuildContentsSection.this.initializeCheckState();
                    }
                }
            });
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void modelChanged(IModelChangedEvent event) {
        Object changeObject;
        if (event.getChangeType() == 99) {
            this.markStale();
        }
        if (!((changeObject = event.getChangedObjects()[0]) instanceof IBuildEntry && (((IBuildEntry)changeObject).getName().equals("bin.excludes") || ((IBuildEntry)changeObject).getName().equals("bin.includes") || ((IBuildEntry)changeObject).getName().equals("src.excludes") || ((IBuildEntry)changeObject).getName().equals("src.includes")))) {
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource != null || this.fOriginalResource == null && this.fParentResource != null) {
            this.initializeCheckState();
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource == null || event.getChangedProperty() != null && event.getChangedProperty().equals("bin.includes")) {
            return;
        }
        this.fTreeViewer.setChecked((Object)this.fParentResource, this.isChecked);
        this.fTreeViewer.setGrayed((Object)this.fOriginalResource, false);
        this.fTreeViewer.setParentsGrayed((Object)this.fParentResource, true);
        this.setParentsChecked(this.fParentResource);
        this.fTreeViewer.setGrayed((Object)this.fParentResource, false);
        if (this.fParentResource instanceof IFolder) {
            this.fTreeViewer.setSubtreeChecked((Object)this.fParentResource, this.isChecked);
            this.setChildrenGrayed(this.fParentResource, false);
        }
        while (!this.fOriginalResource.equals((Object)this.fParentResource)) {
            this.fTreeViewer.setChecked((Object)this.fOriginalResource, this.isChecked);
            this.fOriginalResource = this.fOriginalResource.getParent();
        }
        this.fParentResource = null;
        this.fOriginalResource = null;
    }

    public class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getFilteredChildren(IContainer parent) {
            try {
                IResource[] res = parent.members();
                ArrayList<IResource> children = new ArrayList<IResource>();
                int i = 0;
                while (i < res.length) {
                    if (res[i] instanceof IFolder) {
                        IJavaProject jp = JavaCore.create((IProject)res[i].getProject());
                        if (jp != null) {
                            this.addElementsOnClasspath(children, jp, res[i]);
                        }
                    } else if (ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(res[i].getName())) {
                        children.add(res[i]);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                AspectJPlugin.logException(e);
                return new Object[0];
            }
        }

        private void addElementsOnClasspath(List list, IJavaProject jp, IResource res) {
            if (jp.isOnClasspath(res)) {
                list.add(res);
                return;
            }
            if (res.getType() == 2) {
                try {
                    IResource[] mems = ((IFolder)res).members();
                    int i = 0;
                    while (i < mems.length) {
                        if (mems[i].getType() == 2) {
                            this.addElementsOnClasspath(list, jp, mems[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    AspectJPlugin.logException(e);
                }
            }
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IContainer) {
                return this.getFilteredChildren((IContainer)parent);
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IContainer) {
                return this.getFilteredChildren((IContainer)parent);
            }
            return new Object[0];
        }

        public Object[] getFolderChildren(Object parent) {
            IResource[] members = null;
            try {
                if (!(parent instanceof IFolder)) {
                    return new Object[0];
                }
                members = ((IFolder)parent).members();
                ArrayList<IResource> results = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() == 2) {
                        results.add(members[i]);
                    }
                    ++i;
                }
                return results.toArray();
            }
            catch (CoreException e) {
                AspectJPlugin.logException(e);
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            if (element != null && element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }
}

