/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.popup.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BuildConfigurationChangeAction
implements IObjectActionDelegate,
IBuildConfigurationChangedListener {
    protected IAction myAction;
    protected IStructuredSelection strucSel;
    protected BuildConfigurator buildConfigurator = BuildConfigurator.getBuildConfigurator();
    protected String actionText;
    ArrayList changedBCs;

    public BuildConfigurationChangeAction() {
        this.buildConfigurator.addBuildConfigurationChangedListener(this);
    }

    public void run(IAction action) {
        this.changedBCs = new ArrayList();
        ProjectBuildConfigurator pbc = this.buildConfigurator.getActiveProjectBuildConfigurator();
        if (pbc != null) {
            Iterator mySelIter = this.strucSel.iterator();
            ArrayList<IResource> itemsToManipulate = new ArrayList<IResource>();
            while (mySelIter.hasNext()) {
                IResource res;
                ProjectBuildConfigurator resourcepbc;
                Object mySel = mySelIter.next();
                if (mySel instanceof IJavaElement) {
                    try {
                        mySel = ((IJavaElement)mySel).getCorrespondingResource();
                    }
                    catch (JavaModelException e) {
                        mySel = null;
                    }
                }
                if (!(mySel instanceof IResource) || pbc != (resourcepbc = this.buildConfigurator.getProjectBuildConfigurator((res = (IResource)mySel).getProject()))) continue;
                itemsToManipulate.add(res);
            }
            this.doMySpecificAction(pbc.getActiveBuildConfiguration(), itemsToManipulate);
        }
    }

    protected abstract Job getJob(BuildConfiguration var1, List var2);

    private void doMySpecificAction(BuildConfiguration bc, List fileList) {
        Job job = this.getJob(bc, fileList);
        job.setPriority(20);
        job.setRule((ISchedulingRule)bc.getFile().getProject());
        job.schedule();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void buildConfigurationChanged(final ProjectBuildConfigurator pbc) {
        if (pbc != null) {
            this.myAction.setEnabled(true);
            Job job = new Job("BuildConfiguration change action"){

                protected IStatus run(IProgressMonitor monitor) {
                    BuildConfiguration bc = pbc.getActiveBuildConfiguration();
                    BuildConfigurationChangeAction.this.myAction.setText(BuildConfigurationChangeAction.this.actionText.replaceAll("%bcname", bc.getName()));
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setRule((ISchedulingRule)pbc.getJavaProject().getProject());
            job.schedule();
        } else {
            this.myAction.setEnabled(false);
        }
    }

    abstract boolean isObjectApplicable(Object var1);

    protected boolean isApplicable(Object sel) {
        if (sel instanceof IPackageFragment) {
            try {
                IPackageFragment pack = (IPackageFragment)sel;
                Object[] children = pack.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.isApplicable(children[i])) {
                        return true;
                    }
                    ++i;
                }
                children = pack.getNonJavaResources();
                i = 0;
                while (i < children.length) {
                    if (this.isApplicable(children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                return false;
            }
        } else {
            return this.isObjectApplicable(sel);
        }
        return false;
    }

    protected boolean isApplicable(IStructuredSelection ssel) {
        Iterator mySelIter = ssel.iterator();
        while (mySelIter.hasNext()) {
            Object sel = mySelIter.next();
            if (!this.isApplicable(sel)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.myAction == null) {
            this.myAction = action;
            ProjectBuildConfigurator pbc = this.buildConfigurator.getActiveProjectBuildConfigurator();
            if (pbc != null) {
                this.myAction.setText(this.actionText.replaceAll("%bcname", pbc.getActiveBuildConfiguration().getName()));
            }
        }
        if (selection instanceof IStructuredSelection) {
            this.strucSel = (IStructuredSelection)selection;
            action.setEnabled(this.isApplicable(this.strucSel));
        } else {
            this.strucSel = null;
            action.setEnabled(false);
        }
    }
}

